/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class GetEffectivePrivilegesResponse
extends LDAPExtendedResponse {
    private int privileges;

    public GetEffectivePrivilegesResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        if (this.getResultCode() == 0) {
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Integer aSN1Integer = (ASN1Integer)lBERDecoder.decode(byArray);
            if (aSN1Integer == null) {
                throw new IOException("Decoding error");
            }
            this.privileges = aSN1Integer.intValue();
        } else {
            this.privileges = 0;
        }
    }

    public int getPrivileges() {
        return this.privileges;
    }
}

