/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.util.DSMLHandler;
import com.novell.ldap.util.LDAPReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DOMReader
implements LDAPReader {
    DSMLHandler handler;
    Element root;
    private int messageIndex = 0;

    public DOMReader(Document document) throws LDAPLocalException {
        this.root = (Element)document.getElementsByTagName("batchRequest").item(0);
        if (this.root == null) {
            this.root = (Element)document.getElementsByTagNameNS("*", "batchResponse").item(0);
        }
        if (this.root == null) {
            throw new IllegalArgumentException("DOMReader: could not locate a batchRequest or batchResponse");
        }
        this.handler = new DSMLHandler();
        this.processNodes(this.root.getParentNode());
    }

    public DOMReader(Element element) throws LDAPLocalException {
        this.root = element;
        String string = element.getLocalName();
        if (string == null) {
            string = element.getNodeName();
        }
        if (!string.equals("batchRequest") && !string.equals("batchResponse")) {
            throw new IllegalArgumentException("DOMReader: specified root element must be a batchRequest or a batchResponse");
        }
        this.handler = new DSMLHandler();
        this.processNodes(element.getParentNode());
    }

    private void processNodes(Node node) throws LDAPLocalException {
        DomAttributesWrapper domAttributesWrapper = new DomAttributesWrapper();
        try {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string = node2.getLocalName();
                if (string == null) {
                    string = node2.getNodeName();
                }
                if (node2 instanceof Element) {
                    domAttributesWrapper.setAttrs(node2.getAttributes());
                    this.handler.startElement("", string, string, domAttributesWrapper);
                } else if (node2 instanceof Text) {
                    String string2 = node2.getNodeValue();
                    this.handler.characters(string2.toCharArray(), 0, string2.length());
                }
                this.processNodes(node2);
                if (!(node2 instanceof Element)) continue;
                this.handler.endElement("", string, string);
            }
        }
        catch (SAXException sAXException) {
            throw new LDAPLocalException("DOMReader error while traversing DOM:", 82, sAXException);
        }
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean isRequest() {
        return this.root.getNodeName().equals("batchRequest");
    }

    public LDAPMessage readMessage() {
        if (this.messageIndex >= this.handler.getQueue().size()) {
            return null;
        }
        return (LDAPMessage)this.handler.getQueue().get(this.messageIndex++);
    }

    public String getBatchRequestID() {
        return this.handler.getBatchRequestID();
    }

    public boolean isParallelProcessing() {
        return this.handler.isParallelProcessing();
    }

    public boolean isResponseUnordered() {
        return this.handler.isResponseUnordered();
    }

    public boolean isResumeOnError() {
        return this.handler.isResumeOnError();
    }

    private static class DomAttributesWrapper
    implements Attributes {
        NamedNodeMap nnm;

        private DomAttributesWrapper() {
        }

        public void setAttrs(NamedNodeMap namedNodeMap) {
            this.nnm = namedNodeMap;
        }

        public int getLength() {
            return this.nnm.getLength();
        }

        public String getURI(int n) {
            return this.nnm.item(n).getNamespaceURI();
        }

        public String getLocalName(int n) {
            return this.nnm.item(n).getLocalName();
        }

        public String getQName(int n) {
            Node node = this.nnm.item(n);
            return node.getNamespaceURI() + "." + node.getLocalName();
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getValue(int n) {
            return this.nnm.item(n).getNodeValue();
        }

        public int getIndex(String string, String string2) {
            return -1;
        }

        public int getIndex(String string) {
            return -1;
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public String getValue(String string, String string2) {
            return this.nnm.getNamedItemNS(string, string2).getNodeValue();
        }

        public String getValue(String string) {
            Node node = this.nnm.getNamedItem(string);
            if (node == null) {
                return null;
            }
            String string2 = node.getNodeValue();
            return string2;
        }
    }
}

