/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.jwt.VerifierBuilderSupport;
import com.okta.jwt.impl.http.OkHttpClient;
import com.okta.jwt.impl.jjwt.RemoteJwkSigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;

abstract class BaseVerifierBuilderSupport<B extends VerifierBuilderSupport, R>
implements VerifierBuilderSupport<B, R> {
    private String issuer;
    private Duration leeway = Duration.ofMinutes(2L);
    private Duration connectionTimeout = Duration.ofSeconds(1L);
    private Duration readTimeout = Duration.ofSeconds(1L);

    BaseVerifierBuilderSupport() {
    }

    String getIssuer() {
        return this.issuer;
    }

    public B setIssuer(String issuer) {
        if (issuer != null) {
            this.issuer = issuer.trim().replaceAll("/$", "");
        }
        return this.self();
    }

    Duration getLeeway() {
        return this.leeway;
    }

    public B setLeeway(Duration leeway) {
        if (leeway == null || leeway.toMillis() < 0L) {
            throw new IllegalArgumentException("leeway must not be null or less than zero");
        }
        this.leeway = leeway;
        return this.self();
    }

    Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public B setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this.self();
    }

    Duration getReadTimeout() {
        return this.readTimeout;
    }

    public B setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this.self();
    }

    protected B self() {
        return (B)this;
    }

    protected void validate() {
        ConfigurationValidator.assertIssuer((String)this.issuer);
    }

    protected String resolveKeysEndpoint(String issuer) {
        return issuer.matches(".*/oauth2/.*") ? issuer + "/v1/keys" : issuer + "/oauth2/v1/keys";
    }

    protected SigningKeyResolver signingKeyResolver() {
        try {
            return new RemoteJwkSigningKeyResolver(new URL(this.resolveKeysEndpoint(this.getIssuer())), new OkHttpClient(this.getConnectionTimeout(), this.getReadTimeout()));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid issuer URL in configuration");
        }
    }
}

