/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.jwt.impl.http.HttpClient;
import com.okta.jwt.impl.jjwt.models.JwkKeys;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.SigningKeyResolver;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

final class RemoteJwkSigningKeyResolver
implements SigningKeyResolver {
    private final URL jwkUri;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, Key> keyMap = new HashMap<String, Key>();

    RemoteJwkSigningKeyResolver(URL jwkUri, HttpClient httpClient) {
        this.jwkUri = jwkUri;
        this.httpClient = httpClient;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return this.getKey(header.getKeyId());
    }

    private Key getKey(String keyId) {
        Key result = this.keyMap.get(keyId);
        if (result != null) {
            return result;
        }
        this.updateKeys();
        return this.keyMap.get(keyId);
    }

    private void updateKeys() {
        try {
            Map<String, Key> newKeys = ((JwkKeys)this.objectMapper.readValue(this.httpClient.get(this.jwkUri), JwkKeys.class)).getKeys().stream().filter(jwkKey -> "sig".equals(jwkKey.getPublicKeyUse())).filter(jwkKey -> "RSA".equals(jwkKey.getKeyType())).map(jwkKey -> {
                BigInteger modulus = this.base64ToBigInteger(jwkKey.getPublicKeyModulus());
                BigInteger exponent = this.base64ToBigInteger(jwkKey.getPublicKeyExponent());
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, exponent);
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
                    return new AbstractMap.SimpleEntry<String, PublicKey>(jwkKey.getKeyId(), publicKey);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalStateException("Failed to parse public key");
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.keyMap.clear();
            this.keyMap.putAll(newKeys);
        }
        catch (IOException e) {
            throw new JwtException("Failed to fetch keys from URL: " + this.jwkUri, (Throwable)e);
        }
    }

    private BigInteger base64ToBigInteger(String value) {
        return new BigInteger(1, Base64.getUrlDecoder().decode(value));
    }
}

