/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ElSqlConfig;
import com.opengamma.elsql.EmptySqlParams;
import com.opengamma.elsql.SpringSqlParams;
import com.opengamma.elsql.SqlFragments;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public final class ElSqlBundle {
    private final SqlFragments _fragments;

    public static ElSqlBundle of(ElSqlConfig config, Class<?> type) {
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        ClassPathResource baseResource = new ClassPathResource(type.getSimpleName() + ".elsql", type);
        ClassPathResource configResource = new ClassPathResource(type.getSimpleName() + "-" + config.getName() + ".elsql", type);
        return ElSqlBundle.parse(config, new Resource[]{baseResource, configResource});
    }

    public static ElSqlBundle parse(ElSqlConfig config, Resource ... resources) {
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        if (resources == null) {
            throw new IllegalArgumentException("Resources must not be null");
        }
        return ElSqlBundle.parseResource(resources, config);
    }

    private static ElSqlBundle parseResource(Resource[] resources, ElSqlConfig config) {
        ArrayList<List<String>> files = new ArrayList<List<String>>();
        boolean resourceFound = false;
        for (Resource resource : resources) {
            URL url;
            if (!resource.exists()) continue;
            resourceFound = true;
            try {
                url = resource.getURL();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            List<String> lines = SqlFragments.loadResource(url);
            files.add(lines);
        }
        if (!resourceFound) {
            throw new IllegalArgumentException("No matching resource was found");
        }
        return new ElSqlBundle(SqlFragments.parse(files, config));
    }

    private ElSqlBundle(SqlFragments fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException("Fragment map must not be null");
        }
        this._fragments = fragments;
    }

    public ElSqlConfig getConfig() {
        return this._fragments.getConfig();
    }

    public ElSqlBundle withConfig(ElSqlConfig config) {
        return new ElSqlBundle(this._fragments.withConfig(config));
    }

    public String getSql(String name) {
        return this._fragments.getSql(name, EmptySqlParams.INSTANCE);
    }

    public String getSql(String name, SqlParameterSource paramSource) {
        return this._fragments.getSql(name, new SpringSqlParams(paramSource));
    }
}

