/*
 * Copyright (C) 2014 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */

/**
 * Root package for common data structures used by Strata.
 * <p>
 * Each package focuses on a different data structure:
 * <ul>
 * <li>Array - wrapped arrays and matrices</li>
 * <li>Functions - additional Java SE 8 functional interfaces</li>
 * <li>IO - common file formats</li>
 * <li>Named - extended enums</li>
 * <li>Result - functional result model</li>
 * <li>Time-Series - a series of values over time</li>
 * <li>Tuple - pair and triple</li>
 * </ul>
 */
package com.opengamma.strata.collect;
