/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.java2d.Java2DFont;
import com.openhtmltopdf.java2d.api.Java2DRendererBuilder;
import com.openhtmltopdf.render.AbstractOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.swing.ImageReplacedElement;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;

public class Java2DOutputDevice
extends AbstractOutputDevice
implements OutputDevice {
    private Graphics2D _graphics;
    private Java2DFont _font;
    private Stack<AffineTransform> transformStack = new Stack();
    private Stack<Shape> clipStack = new Stack();

    public Java2DOutputDevice(Graphics2D layoutGraphics) {
        this._graphics = layoutGraphics;
    }

    @Deprecated
    public void drawSelection(RenderingContext c, InlineText inlineText) {
    }

    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        ReplacedElement replaced = box.getReplacedElement();
        if (replaced instanceof ImageReplacedElement) {
            Image image = ((ImageReplacedElement)replaced).getImage();
            Point location = replaced.getLocation();
            this._graphics.drawImage(image, (int)location.getX(), (int)location.getY(), null);
        } else if (replaced instanceof Java2DRendererBuilder.Graphics2DPaintingReplacedElement) {
            Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), (CssContext)c);
            ((Java2DRendererBuilder.Graphics2DPaintingReplacedElement)replaced).paint(this, c, contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
        }
    }

    public void setColor(FSColor color) {
        if (!(color instanceof FSRGBColor)) {
            throw new RuntimeException("internal error: unsupported color class " + color.getClass().getName());
        }
        FSRGBColor rgb = (FSRGBColor)color;
        this._graphics.setColor(new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this._graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this._graphics.fillRect(x, y, width, height);
    }

    public void setClip(Shape s) {
        this._graphics.setClip(s);
    }

    public Shape getClip() {
        return this._graphics.getClip();
    }

    public void clip(Shape s) {
        this._graphics.clip(s);
    }

    public void translate(double tx, double ty) {
        this._graphics.translate(tx, ty);
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public void drawOval(int x, int y, int width, int height) {
        this._graphics.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this._graphics.fillOval(x, y, width, height);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this._graphics.getRenderingHint(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        this._graphics.setRenderingHint(key, value);
    }

    public void setFont(FSFont font) {
        this._font = (Java2DFont)font;
        this._graphics.setFont(this._font.getAWTFonts().get(0));
    }

    public Java2DFont getFont() {
        return this._font;
    }

    public void setStroke(Stroke s) {
        this._graphics.setStroke(s);
    }

    public Stroke getStroke() {
        return this._graphics.getStroke();
    }

    public void fill(Shape s) {
        this._graphics.fill(s);
    }

    public void draw(Shape s) {
        this._graphics.draw(s);
    }

    public void drawImage(FSImage image, int x, int y, boolean interpolate) {
        Object oldInterpolation = this._graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (interpolate) {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        this._graphics.drawImage((Image)((AWTFSImage)image).getImage(), x, y, null);
        if (oldInterpolation != null) {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolation);
        }
    }

    public boolean isSupportsSelection() {
        return false;
    }

    public boolean isSupportsCMYKColors() {
        return false;
    }

    public void drawWithGraphics(float x, float y, float width, float height, OutputDeviceGraphicsDrawer renderer) {
        Graphics2D graphics = (Graphics2D)this._graphics.create((int)x, (int)y, (int)width, (int)height);
        renderer.render(graphics);
        graphics.dispose();
    }

    public void setPaint(Paint paint) {
        this._graphics.setPaint(paint);
    }

    public List<AffineTransform> pushTransforms(List<AffineTransform> transforms) {
        ArrayList<AffineTransform> inverse = new ArrayList<AffineTransform>(transforms.size());
        AffineTransform gfxTransform = this._graphics.getTransform();
        try {
            for (AffineTransform transform : transforms) {
                inverse.add(transform.createInverse());
                this.transformStack.push(transform);
                gfxTransform.concatenate(transform);
            }
        }
        catch (NoninvertibleTransformException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.RENDER_TRIED_TO_SET_NON_INVERTIBLE_CSS_TRANSFORM);
        }
        this._graphics.setTransform(gfxTransform);
        return inverse;
    }

    public void popTransforms(List<AffineTransform> inverse) {
        AffineTransform gfxTransform = this._graphics.getTransform();
        Collections.reverse(inverse);
        for (AffineTransform transform : inverse) {
            gfxTransform.concatenate(transform);
            this.transformStack.pop();
        }
        this._graphics.setTransform(gfxTransform);
    }

    public float getAbsoluteTransformOriginX() {
        return 0.0f;
    }

    public float getAbsoluteTransformOriginY() {
        return 0.0f;
    }

    public void setBidiReorderer(BidiReorderer _reorderer) {
    }

    public void setRenderingContext(RenderingContext result) {
    }

    public void setRoot(BlockBox _root) {
    }

    public void initializePage(Graphics2D pageGraphics) {
        this._graphics = pageGraphics;
    }

    public void finish(RenderingContext c, BlockBox _root) {
    }

    public void pushTransformLayer(AffineTransform transform) {
    }

    public void popTransformLayer() {
    }

    public void popClip() {
    }

    public void pushClip(Shape s) {
    }

    public boolean isFastRenderer() {
        return false;
    }

    public Object startStructure(StructureType type, Box box) {
        return null;
    }

    public void endStructure(Object token) {
    }
}

