/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import com.openhtmltopdf.pdfboxout.PDFontSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxRawPDFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.pdfboxout.fontstore.AbstractFontStore;
import com.openhtmltopdf.pdfboxout.fontstore.FallbackFontStore;
import com.openhtmltopdf.pdfboxout.fontstore.FontUtil;
import com.openhtmltopdf.pdfboxout.fontstore.MainFontStore;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class PdfBoxFontResolver
implements FontResolver {
    private final PDDocument _doc;
    private final MainFontStore _suppliedFonts;
    private final FallbackFontStore _preBuiltinFallbackFonts;
    private final AbstractFontStore _builtinFonts;
    private final FallbackFontStore _finalFallbackFonts;

    public PdfBoxFontResolver(SharedContext sharedContext, PDDocument doc, FSCacheEx<String, FSCacheValue> pdfMetricsCache, PdfRendererBuilder.PdfAConformance pdfAConformance, boolean pdfUaConform) {
        this._doc = doc;
        this._suppliedFonts = new MainFontStore(sharedContext, doc, pdfMetricsCache);
        this._preBuiltinFallbackFonts = new FallbackFontStore(sharedContext, doc, pdfMetricsCache);
        this._builtinFonts = pdfAConformance == PdfRendererBuilder.PdfAConformance.NONE && !pdfUaConform ? new AbstractFontStore.BuiltinFontStore(doc) : new AbstractFontStore.EmptyFontStore();
        this._finalFallbackFonts = new FallbackFontStore(sharedContext, doc, pdfMetricsCache);
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }

    public void close() {
        FontUtil.tryClose(this._suppliedFonts);
        FontUtil.tryClose(this._preBuiltinFallbackFonts);
        FontUtil.tryClose(this._finalFallbackFonts);
    }

    public void importFontFaces(List<FontFaceRule> fontFaces) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            boolean noSubset = style.isIdent(CSSName.FS_FONT_SUBSET, IdentValue.COMPLETE_FONT);
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (!rule.hasFontFamily()) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.CSS_PARSE_MUST_PROVIDE_AT_LEAST_A_FONT_FAMILY_AND_SRC_IN_FONT_FACE_RULE);
                continue;
            }
            fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            this._suppliedFonts.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), !noSubset);
        }
    }

    @Deprecated
    public void addFontDirectory(String dir, boolean embedded) throws IOException {
        this.addFontDirectory(dir, embedded, FontGroup.MAIN);
    }

    public void addFontDirectory(String dir, boolean embedded, FontGroup fontGroup) throws IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase(Locale.US);
                    return lower.endsWith(".ttf") || lower.endsWith(".ttc");
                }
            });
            assert (files != null);
            for (File file : files) {
                this.addFont(file, file.getName(), (Integer)400, IdentValue.NORMAL, embedded, fontGroup);
            }
        }
    }

    public void addFontCollection(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset, FontGroup fontGroup) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.supply();){
            TrueTypeCollection collection = new TrueTypeCollection(inputStream);
            if (fontGroup == FontGroup.MAIN) {
                this._suppliedFonts.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            } else {
                this.getFallbackFontStore(fontGroup).addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            }
        }
    }

    @Deprecated
    public void addFontCollection(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.supply();){
            TrueTypeCollection collection = new TrueTypeCollection(inputStream);
            this._suppliedFonts.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    public void addFontCollection(File file, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset, FontGroup fontGroup) throws IOException {
        TrueTypeCollection collection = new TrueTypeCollection(file);
        if (fontGroup == FontGroup.MAIN) {
            this._suppliedFonts.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        } else {
            this.getFallbackFontStore(fontGroup).addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    @Deprecated
    public void addFontCollection(File file, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        TrueTypeCollection collection = new TrueTypeCollection(file);
        this._suppliedFonts.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFont(File fontFile, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset, FontGroup fontGroup) throws IOException {
        if (fontFile.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
            this.addFontCollection(fontFile, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset, fontGroup);
        } else if (fontGroup == FontGroup.MAIN) {
            this._suppliedFonts.addFontLazy(new FilePDFontSupplier(fontFile, this._doc), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        } else {
            this.getFallbackFontStore(fontGroup).addFontLazy(new FilePDFontSupplier(fontFile, this._doc), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    private FallbackFontStore getFallbackFontStore(FontGroup fontGroup) {
        assert (fontGroup == FontGroup.PRE_BUILT_IN_FALLBACK || fontGroup == FontGroup.FINAL_FALLBACK);
        return fontGroup == FontGroup.PRE_BUILT_IN_FALLBACK ? this._preBuiltinFallbackFonts : this._finalFallbackFonts;
    }

    @Deprecated
    public void addFont(File fontFile, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        if (fontFile.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
            this.addFontCollection(fontFile, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            return;
        }
        this._suppliedFonts.addFontLazy(new FilePDFontSupplier(fontFile, this._doc), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset, FontGroup fontGroup) {
        if (fontGroup == FontGroup.MAIN) {
            this._suppliedFonts.addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        } else {
            this.getFallbackFontStore(fontGroup).addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    @Deprecated
    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        this._suppliedFonts.addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFont(PDFontSupplier supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset, FontGroup fontGroup) {
        if (fontGroup == FontGroup.MAIN) {
            this._suppliedFonts.addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        } else {
            this.getFallbackFontStore(fontGroup).addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    @Deprecated
    public void addFont(PDFontSupplier supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        this._suppliedFonts.addFont(supplier, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    private FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        ArrayList<FontDescription> fonts = new ArrayList<FontDescription>(3);
        if (families != null) {
            this.resolveFamilyFont(ctx, families, size, weight, style, variant, fonts, this._suppliedFonts);
        }
        fonts.addAll(this._preBuiltinFallbackFonts.resolveFonts(ctx, families, size, weight, style, variant));
        if (families != null) {
            this.resolveFamilyFont(ctx, families, size, weight, style, variant, fonts, this._builtinFonts);
            FontDescription serif = this._builtinFonts.resolveFont(ctx, "Serif", size, weight, style, variant);
            if (serif != null) {
                fonts.add(serif);
            }
        }
        fonts.addAll(this._finalFallbackFonts.resolveFonts(ctx, families, size, weight, style, variant));
        return new PdfBoxFSFont(fonts, size);
    }

    private void resolveFamilyFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant, List<FontDescription> fonts, AbstractFontStore store) {
        for (int i = 0; i < families.length; ++i) {
            FontDescription font = store.resolveFont(ctx, families[i], size, weight, style, variant);
            if (font == null) continue;
            fonts.add(font);
        }
    }

    public static class FontDescription
    implements MinimalFontDescription {
        private final IdentValue _style;
        private final int _weight;
        private final String _family;
        private final PDDocument _doc;
        private FSSupplier<InputStream> _supplier;
        private FSSupplier<PDFont> _fontSupplier;
        private PDFont _font;
        private final boolean _isFromFontFace;
        private final boolean _isSubset;
        private PdfBoxRawPDFontMetrics _metrics;
        private final FSCacheEx<String, FSCacheValue> _metricsCache;

        public String toString() {
            return String.format("FontDescription [_style=%s, _weight=%s, _family=%s, _isFromFontFace=%s, _isSubset=%s]", this._style, this._weight, this._family, this._isFromFontFace, this._isSubset);
        }

        public FontDescription(PDFont font, IdentValue style, int weight) {
            this(null, font, style, weight);
        }

        public FontDescription(PDDocument doc, FSSupplier<InputStream> supplier, int weight, IdentValue style, String family, boolean isFromFontFace, boolean isSubset, FSCacheEx<String, FSCacheValue> metricsCache) {
            this._supplier = supplier;
            this._weight = weight;
            this._style = style;
            this._doc = doc;
            this._family = family;
            this._isFromFontFace = isFromFontFace;
            this._isSubset = isSubset;
            this._metricsCache = metricsCache;
            this._metrics = this.getFontMetricsFromCache(family, weight, style);
        }

        private FontDescription(PDDocument doc, PDFont font, IdentValue style, int weight) {
            this._font = font;
            this._style = style;
            this._weight = weight;
            this._supplier = null;
            this._doc = doc;
            this._metricsCache = null;
            this._family = null;
            this._isFromFontFace = false;
            this._isSubset = false;
            PDFontDescriptor descriptor = font.getFontDescriptor();
            try {
                this._metrics = PdfBoxRawPDFontMetrics.fromPdfBox(font, descriptor);
            }
            catch (IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_COULD_NOT_LOAD_FONT_METRICS, (Throwable)e);
            }
        }

        public FontDescription(PDDocument doc, FSSupplier<PDFont> fontSupplier, IdentValue style, int weight, String family, boolean isFromFontFace, boolean isSubset, FSCacheEx<String, FSCacheValue> metricsCache) {
            this._fontSupplier = fontSupplier;
            this._style = style;
            this._weight = weight;
            this._supplier = null;
            this._doc = doc;
            this._family = family;
            this._isFromFontFace = isFromFontFace;
            this._isSubset = isSubset;
            this._metricsCache = metricsCache;
            this._metrics = this.getFontMetricsFromCache(family, weight, style);
        }

        public String getFamily() {
            return this._family;
        }

        private String createFontMetricsCacheKey(String family, int weight, IdentValue style) {
            return "font-metrics:" + family + ":" + weight + ":" + style.toString();
        }

        private PdfBoxRawPDFontMetrics getFontMetricsFromCache(String family, int weight, IdentValue style) {
            return (PdfBoxRawPDFontMetrics)this._metricsCache.get((Object)this.createFontMetricsCacheKey(family, weight, style));
        }

        private void putFontMetricsInCache(String family, int weight, IdentValue style, PdfBoxRawPDFontMetrics metrics) {
            this._metricsCache.put((Object)this.createFontMetricsCacheKey(family, weight, style), (Object)metrics);
        }

        private boolean loadMetrics() {
            try {
                PDFontDescriptor descriptor = this._font.getFontDescriptor();
                this._metrics = PdfBoxRawPDFontMetrics.fromPdfBox(this._font, descriptor);
                this.putFontMetricsInCache(this._family, this._weight, this._style, this._metrics);
                return true;
            }
            catch (IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_FONT, (Object)this._family);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean realizeFont() {
            if (this._font == null && this._fontSupplier != null) {
                XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.LOAD_LOADING_FONT_FROM_SUPPLIER, (Object)this._family, (Object)"PDFont");
                this._font = (PDFont)this._fontSupplier.supply();
                this._fontSupplier = null;
                if (!this.isMetricsAvailable()) {
                    return this.loadMetrics();
                }
            }
            if (this._font == null && this._supplier != null) {
                XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.LOAD_LOADING_FONT_FROM_SUPPLIER, (Object)this._family, (Object)"InputStream");
                InputStream is = (InputStream)this._supplier.supply();
                this._supplier = null;
                if (is == null) {
                    return false;
                }
                try {
                    this._font = PDType0Font.load((PDDocument)this._doc, (InputStream)is, (boolean)this._isSubset);
                    if (!this.isMetricsAvailable()) {
                        boolean bl = this.loadMetrics();
                        return bl;
                    }
                }
                catch (IOException e) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_FONT, (Object)this._family);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this._font != null;
        }

        public boolean isFontAvailable() {
            return this._font != null;
        }

        public PDFont getFont() {
            this.realizeFont();
            return this._font;
        }

        public int getWeight() {
            return this._weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        public boolean isFromFontFace() {
            return this._isFromFontFace;
        }

        public boolean isMetricsAvailable() {
            return this._metrics != null;
        }

        public PdfBoxRawPDFontMetrics getFontMetrics() {
            if (!this.isMetricsAvailable()) {
                this.realizeFont();
            }
            return this._metrics;
        }
    }

    private static class FilePDFontSupplier
    implements FSSupplier<PDFont> {
        private final File _fontFile;
        private final PDDocument _doc;

        FilePDFontSupplier(File fontFile, PDDocument doc) {
            this._fontFile = fontFile;
            this._doc = doc;
        }

        public PDFont supply() {
            try {
                return PDType0Font.load((PDDocument)this._doc, (File)this._fontFile);
            }
            catch (IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_FONT, (Object)this._fontFile.getAbsoluteFile(), (Throwable)e);
                return null;
            }
        }
    }

    public static enum FontGroup {
        MAIN,
        PRE_BUILT_IN_FALLBACK,
        FINAL_FALLBACK;

    }
}

