/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import java.util.Objects;
import org.testcontainers.containers.BindMode;

public final class BindMount {
    private final String localFile;
    private final String remoteFile;
    private final BindMode bindMode;

    public static BindMount of(String localFile, String remoteFile, BindMode bindMode) {
        return new BindMount(localFile, remoteFile, bindMode);
    }

    private BindMount(String localFile, String remoteFile, BindMode bindMode) {
        this.localFile = localFile;
        this.remoteFile = remoteFile;
        this.bindMode = bindMode == null ? BindMode.READ_ONLY : bindMode;
    }

    public BindMode getBindMode() {
        return this.bindMode;
    }

    public String getLocalFile() {
        return this.localFile;
    }

    public String getRemoteFile() {
        return this.remoteFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindMount bindMount = (BindMount)o;
        return Objects.equals(this.localFile, bindMount.localFile);
    }

    public int hashCode() {
        return Objects.hash(this.localFile);
    }

    public String toString() {
        return "BindMount{localFile='" + this.localFile + "', remoteFile='" + this.remoteFile + "', bindMode=" + this.bindMode + "}";
    }
}

