/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.Service;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.stp.services.ScopeConsoleLogger;
import com.opera.core.systems.scope.stp.services.ScopeCookieManager;
import com.opera.core.systems.scope.stp.services.ScopeCore;
import com.opera.core.systems.scope.stp.services.ScopeEcmascriptDebugger6;
import com.opera.core.systems.scope.stp.services.ScopeEcmascriptService;
import com.opera.core.systems.scope.stp.services.ScopeExec;
import com.opera.core.systems.scope.stp.services.ScopePrefs;
import com.opera.core.systems.scope.stp.services.ScopeSelftest;
import com.opera.core.systems.scope.stp.services.ScopeWindowManager;
import com.opera.core.systems.scope.stp.services.desktop.ScopeDesktopUtils;
import com.opera.core.systems.scope.stp.services.desktop.ScopeDesktopWindowManager;
import com.opera.core.systems.scope.stp.services.desktop.ScopeSystemInputManager;
import java.util.Map;

public enum ScopeService {
    CORE("core"),
    EXEC("exec"),
    WINDOW_MANAGER("window-manager"),
    CONSOLE_LOGGER("console-logger"),
    COOKIE_MANAGER("cookie-manager"),
    ECMASCRIPT_DEBUGGER("ecmascript-debugger"),
    ECMASCRIPT("ecmascript"),
    PREFS("prefs"),
    SELFTEST("selftest"),
    DESKTOP_UTILS("desktop-utils"),
    DESKTOP_WINDOW_MANAGER("desktop-window-manager"),
    SYSTEM_INPUT("system-input");

    private static final Map<String, ScopeService> lookup;
    private final String serviceName;

    private ScopeService(String stringRepresentation) {
        this.serviceName = stringRepresentation;
    }

    public Service newInstance(ScopeServices scope) {
        return ScopeService.newInstance(this, scope);
    }

    public String toOpera() {
        return this.serviceName;
    }

    public String toString() {
        return this.toOpera();
    }

    public static ScopeService get(String name) {
        return lookup.get(name);
    }

    private static Service newInstance(ScopeService service, ScopeServices scope) {
        switch (service) {
            case CONSOLE_LOGGER: {
                return new ScopeConsoleLogger(scope);
            }
            case COOKIE_MANAGER: {
                return new ScopeCookieManager(scope);
            }
            case CORE: {
                return new ScopeCore(scope);
            }
            case ECMASCRIPT_DEBUGGER: {
                return new ScopeEcmascriptDebugger6(scope);
            }
            case ECMASCRIPT: {
                return new ScopeEcmascriptService(scope);
            }
            case EXEC: {
                return new ScopeExec(scope);
            }
            case PREFS: {
                return new ScopePrefs(scope);
            }
            case SELFTEST: {
                return new ScopeSelftest(scope);
            }
            case WINDOW_MANAGER: {
                return new ScopeWindowManager(scope);
            }
            case DESKTOP_UTILS: {
                return new ScopeDesktopUtils(scope);
            }
            case DESKTOP_WINDOW_MANAGER: {
                return new ScopeDesktopWindowManager(scope);
            }
            case SYSTEM_INPUT: {
                return new ScopeSystemInputManager(scope);
            }
        }
        throw new ScopeException("Unknown service: " + (Object)((Object)service));
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])ScopeService.values()), (Function)new Function<ScopeService, String>(){

            public String apply(ScopeService service) {
                return service.toString();
            }
        });
    }
}

