/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.model.RuntimeNode;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.services.EcmascriptDebugger;
import com.opera.core.systems.scope.services.WindowManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.WebElement;

public abstract class AbstractEcmascriptService
extends AbstractService
implements EcmascriptDebugger {
    protected int retries;
    protected long sleepDuration;
    protected WindowManager windowManager;
    protected String currentFramePath;
    protected int activeWindowId;
    protected OperaDriver driver;
    protected RuntimeNode root;

    public AbstractEcmascriptService(ScopeServices services, String name) {
        this(services, name, null);
    }

    public AbstractEcmascriptService(ScopeServices services, String name, String requiredVersion) {
        super(services, name, requiredVersion);
        this.windowManager = services.getWindowManager();
        this.currentFramePath = "_top";
        this.resetCounters();
        services.setDebugger(this);
    }

    @Override
    public void setDriver(OperaDriver driver) {
        this.driver = driver;
    }

    protected void resetCounters() {
        this.retries = 0;
        this.sleepDuration = OperaIntervals.SCRIPT_RETRY_INTERVAL.getMs();
    }

    protected String buildEvalString(List<WebElement> elements, String script, Object ... params) {
        String toSend;
        if (params != null && params.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (Object object : params) {
                if (builder.toString().length() > 0) {
                    builder.append(',');
                }
                if (object instanceof Collection) {
                    builder.append('[');
                    Collection collection = (Collection)object;
                    for (Object argument : collection) {
                        this.processArgument(argument, builder, elements);
                        builder.append(',');
                    }
                    int lastCharIndex = builder.length() - 1;
                    if (builder.charAt(lastCharIndex) != '[') {
                        builder.deleteCharAt(lastCharIndex);
                    }
                    builder.append(']');
                    continue;
                }
                this.processArgument(object, builder, elements);
            }
            String arguments = builder.toString();
            toSend = String.format("(function(){%s})(%s)", script, arguments);
        } else {
            toSend = script;
        }
        return toSend;
    }

    protected void processArgument(Object object, StringBuilder builder, List<WebElement> elements) {
        if (object instanceof WebElement) {
            elements.add((WebElement)object);
            builder.append(String.valueOf(object));
        } else if (object instanceof String) {
            builder.append("'").append(this.escapeQuotes(String.valueOf(object))).append("'");
        } else if (object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double) {
            builder.append(String.valueOf(object));
        } else {
            throw new IllegalArgumentException("The argument type is not supported");
        }
    }

    private String escapeQuotes(String s) {
        return s.replace("'", "\\'");
    }

    @Override
    public String executeJavascript(String using) {
        return this.executeJavascript(using, true);
    }

    @Override
    public String executeJavascript(String using, boolean responseExpected) {
        Object result = this.executeScript(using, responseExpected);
        return result == null ? null : String.valueOf(result);
    }

    protected void recover() {
        this.windowManager.findDriverWindow();
        this.activeWindowId = this.windowManager.getActiveWindowId();
        this.updateRuntime();
    }

    protected Object parseNumber(String value) {
        try {
            Number number = NumberFormat.getInstance().parse(value);
            if (number instanceof Long) {
                return number.longValue();
            }
            return number.doubleValue();
        }
        catch (ParseException e) {
            throw new ScopeException("A number result from the script can not be parsed: " + e.getMessage());
        }
    }

    protected boolean isNumber(String name) {
        boolean canParse = true;
        try {
            Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            canParse = false;
        }
        return canParse;
    }

    @Override
    public void cleanUpRuntimes() {
        int windowId = this.windowManager.getActiveWindowId();
        this.cleanUpRuntimes(windowId);
    }

    @Override
    public boolean isScriptInjectable() {
        try {
            this.executeJavascript("return true", false);
        }
        catch (CommunicationException e) {
            return false;
        }
        return true;
    }
}

