/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET})
abstract class Accessor
extends GeneratedAccessor
implements Cloneable {
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int JSON = 119;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int PLSQL_BOOLEAN = 252;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int DML_RETURN_PARAM = 994;
    static final int XMLTYPE = 257;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    static final byte DATA_UNAUTHORIZED = 1;
    static final int NO_LOB_PREFETCH = -1;
    OracleStatement statement;
    boolean outBind;
    int internalType;
    boolean isStream;
    boolean isColumnNumberAware;
    short formOfUse;
    OracleType internalOtype;
    int externalType;
    String internalTypeName;
    String columnName;
    int describeType;
    int describeMaxLength;
    int describeMaxLengthChars;
    short describeFormOfUse;
    long contflag;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int total_elems;
    OracleType describeOtype;
    String describeTypeName;
    int definedColumnType;
    int definedColumnSize;
    int oacmxl;
    short udskpos;
    int lobPrefetchSizeForThisColumn;
    OracleResultSetMetaData.SecurityAttribute securityAttribute;
    protected boolean columnInvisible;
    protected boolean columnJSON;
    short[] rowSpaceIndicator;
    int columnDataOffset;
    int lengthIndex;
    int indicatorIndex;
    int byteLength;
    int charLength;
    int defineType;
    boolean isDMLReturnedParam;
    int lastRowProcessed;
    boolean isUseLess;
    int physicalColumnIndex;
    boolean isNullByDescribe;
    int lastCopyRow;
    long lastCopyRowOffset;
    int lastCopyRowLength;
    byte lastCopyRowMetaData;
    boolean lastCopyRowIsNull;
    static final byte[] NULL_DATA_BYTES;
    static final int ROW_METADATA_LENGTH = 1;
    final Representation representation;
    final int representationMaxLength;
    ByteArray rowData;
    long[] rowOffset;
    int[] rowLength;
    boolean[] rowNull;
    byte[] rowMetadata;
    Object driverSpecificData;
    int previousRowProcessed;
    final int[] escapeSequenceArr;
    final boolean[] readHeaderArr;
    final boolean[] readAsNonStreamArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;

    void setNoPrefetch() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, Accessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Accessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Accessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Accessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void setPrefetchLength(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, Accessor.class, $$$methodRef$$$1, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Accessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Accessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Accessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, Accessor.class, $$$methodRef$$$2, this, new Object[0]);
            }
            PlsqlIbtBindInfo plsqlIbtBindInfo = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Accessor.class, $$$methodRef$$$2, this, plsqlIbtBindInfo);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Accessor.class, $$$methodRef$$$2, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Accessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void unimpl(String string) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void methodName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, Accessor.class, $$$methodRef$$$3, this, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, (String)methodName + " not implemented for " + this.getClass()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Accessor.class, $$$methodRef$$$3, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Accessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long updateChecksum(long l2, int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void checksum;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, l2, n2);
            }
            if (this.isNull((int)currentRow)) {
                long l3 = CRC64.updateChecksum((long)checksum, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, l3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, null);
                }
                return l3;
            }
            long l4 = this.rowData.updateChecksum(this.getOffset((int)currentRow), this.getLength((int)currentRow), PhysicalConnection.CHECKSUM, (long)checksum);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, l4);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Accessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(OracleStatement oracleStatement, int n2, int n3, short s2, boolean bl) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void form;
            void database_type;
            void internal_type;
            void forBind;
            void stmt;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, Accessor.class, $$$methodRef$$$5, this, oracleStatement, n2, n3, s2, bl);
            }
            this.statement = stmt;
            this.outBind = forBind;
            this.internalType = internal_type;
            this.defineType = database_type;
            this.formOfUse = form;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, Accessor.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Accessor.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Accessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            int max_len;
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, Accessor.class, $$$methodRef$$$6, this, n2, n3, string);
            }
            if (external_type != false) {
                this.externalType = external_type;
            }
            this.byteLength = max_len > 0 && max_len < this.representationMaxLength ? max_len : this.representationMaxLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, Accessor.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Accessor.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Accessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void form;
            void maxLength;
            void type;
            void total_elems;
            void contflag;
            void flags;
            void scale;
            void precision;
            void nullable;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, Accessor.class, $$$methodRef$$$7, this, n2, n3, bl, n4, n5, n6, l2, n7, s2);
            }
            this.nullable = nullable;
            this.precision = precision;
            this.scale = scale;
            this.flags = flags;
            this.contflag = contflag;
            this.total_elems = total_elems;
            this.describeType = type;
            this.describeMaxLength = maxLength;
            this.describeFormOfUse = form;
            if (!this.statement.columnsDefinedByUser) {
                this.formOfUse = form;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, Accessor.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Accessor.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Accessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void form;
            void total_elems;
            void contflag;
            void scale;
            void precision;
            void flags;
            void nullable;
            void maxLength;
            void type;
            void typeName;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, Accessor.class, $$$methodRef$$$8, this, n2, n3, bl, n4, n5, n6, l2, n7, s2, string);
            }
            this.describeTypeName = typeName;
            this.describeOtype = null;
            this.initForDescribe((int)type, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)total_elems, (short)form);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, Accessor.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, Accessor.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, Accessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string, int n8) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void maxCodePointLength;
            void typeName;
            void form;
            void total_elems;
            void contflag;
            void scale;
            void precision;
            void flags;
            void nullable;
            void maxLength;
            void type;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, Accessor.class, $$$methodRef$$$9, this, n2, n3, bl, n4, n5, n6, l2, n7, s2, string, n8);
            }
            this.initForDescribe((int)type, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)total_elems, (short)form, (String)typeName);
            this.describeMaxLengthChars = maxCodePointLength;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, Accessor.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, Accessor.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, Accessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    OracleInputStream initForNewRow() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, Accessor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            this.unimpl("initForNewRow");
            OracleInputStream oracleInputStream = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, Accessor.class, $$$methodRef$$$10, this, oracleInputStream);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, Accessor.class, $$$methodRef$$$10, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, Accessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int useForDataAccessIfPossible(int n2, int n3, int n4, String string) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, Accessor.class, $$$methodRef$$$11, this, n2, n3, n4, string);
            }
            int result = 3;
            int oldByteLength = 0;
            int oldCharLength = 0;
            if (this.internalType != 0) {
                void internal_type;
                if (this.internalType != internal_type) {
                    result = 0;
                } else if (this.rowSpaceIndicator != null) {
                    oldByteLength = this.byteLength;
                    oldCharLength = this.charLength;
                }
            }
            if (result == 3) {
                void typeName;
                void max_len;
                void external_type;
                this.initForDataAccess((int)external_type, (int)max_len, (String)typeName);
                if (!this.outBind && oldByteLength >= this.byteLength && oldCharLength >= this.charLength) {
                    result = 2;
                }
            }
            int n5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, Accessor.class, $$$methodRef$$$11, this, n5);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, Accessor.class, $$$methodRef$$$11, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, Accessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean useForDescribeIfPossible(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void formOfUse;
            void total_elems;
            void contflag;
            void scale;
            void precision;
            void flags;
            void nullable;
            void maxLength;
            void type;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, n2, n3, bl, n4, n5, n6, l2, n7, s2, string);
            }
            if (!this.statement.columnsDefinedByUser && this.externalType == 0 && this.describeType == 0 && type != this.describeType) {
                boolean bl3 = false;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, null);
                }
                return false;
            }
            this.initForDescribe((int)type, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)total_elems, (short)formOfUse, (String)typeName);
            boolean bl4 = true;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, Accessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setFormOfUse(short s2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void form;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, Accessor.class, $$$methodRef$$$13, this, s2);
            }
            this.formOfUse = form;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, Accessor.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, Accessor.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, Accessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    void updateColumnNumber(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, Accessor.class, $$$methodRef$$$14, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, Accessor.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, Accessor.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, Accessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowData=" + this.rowData + ", rowOffset=" + this.rowOffset + ", rowLength=" + this.rowLength + ", rowNull=" + this.rowNull + ", rowMetadata=" + this.rowMetadata + ", driverSpecificData=" + this.driverSpecificData + ", describeMaxLengthChars=" + this.describeMaxLengthChars;
    }

    void fetchNextColumns() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, Accessor.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, Accessor.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, Accessor.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, Accessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    void calculateSizeTmpByteArray() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, Accessor.class, $$$methodRef$$$16, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, Accessor.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, Accessor.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, Accessor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, Accessor.class, $$$methodRef$$$17, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, Accessor.class, $$$methodRef$$$17, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, Accessor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    void copyRow() throws SQLException, IOException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, Accessor.class, $$$methodRef$$$18, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, Accessor.class, $$$methodRef$$$18, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, Accessor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, Accessor.class, $$$methodRef$$$19, this, byArray, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, Accessor.class, $$$methodRef$$$19, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, Accessor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    int getPreviousRowProcessed() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, Accessor.class, $$$methodRef$$$20, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, Accessor.class, $$$methodRef$$$20, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, Accessor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    void initMetadata() throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, Accessor.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, Accessor.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, Accessor.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, Accessor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    CompletionStage<Void> initMetadataAsync() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, Accessor.class, $$$methodRef$$$22, this, new Object[0]);
            }
            CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, Accessor.class, $$$methodRef$$$22, this, completableFuture);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, Accessor.class, $$$methodRef$$$22, this, null);
            }
            return completableFuture;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, Accessor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, Accessor.class, $$$methodRef$$$23, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.statement.getConnectionDuringExceptionHandling();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, Accessor.class, $$$methodRef$$$23, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, Accessor.class, $$$methodRef$$$23, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, Accessor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    protected Accessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean forBind) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, Accessor.class, $$$methodRef$$$65, null, _representation, _statement, _representationMaxLength, forBind);
            }
            this.isStream = false;
            this.isColumnNumberAware = false;
            this.formOfUse = (short)2;
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
            this.oacmxl = 0;
            this.udskpos = (short)-1;
            this.lobPrefetchSizeForThisColumn = -1;
            this.columnInvisible = false;
            this.columnJSON = false;
            this.rowSpaceIndicator = null;
            this.columnDataOffset = 0;
            this.lengthIndex = 0;
            this.indicatorIndex = 0;
            this.byteLength = 0;
            this.charLength = 0;
            this.isDMLReturnedParam = false;
            this.lastRowProcessed = 0;
            this.isUseLess = false;
            this.physicalColumnIndex = -2;
            this.isNullByDescribe = false;
            this.lastCopyRow = -1;
            this.lastCopyRowOffset = 0L;
            this.lastCopyRowLength = 0;
            this.lastCopyRowMetaData = 0;
            this.lastCopyRowIsNull = false;
            this.rowOffset = null;
            this.rowLength = null;
            this.rowNull = null;
            this.rowMetadata = null;
            this.previousRowProcessed = -1;
            this.escapeSequenceArr = new int[1];
            this.readHeaderArr = new boolean[1];
            this.readAsNonStreamArr = new boolean[1];
            this.representation = _representation;
            this.statement = _statement;
            this.representationMaxLength = _representationMaxLength;
            this.rowData = forBind ? this.statement.bindData : this.statement.rowData;
            this.statement.setDriverSpecificData(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, Accessor.class, $$$methodRef$$$65, null);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, Accessor.class, $$$methodRef$$$65, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, Accessor.class, $$$methodRef$$$65, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final long getOffset(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, Accessor.class, $$$methodRef$$$24, this, n2);
            }
            long l2 = this.rowOffset[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, Accessor.class, $$$methodRef$$$24, this, l2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, Accessor.class, $$$methodRef$$$24, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, Accessor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setOffset(int n2, long l2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, Accessor.class, $$$methodRef$$$25, this, n2, l2);
            }
            this.rowOffset[currentRow] = offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, Accessor.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, Accessor.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, Accessor.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setOffset(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, Accessor.class, $$$methodRef$$$26, this, n2);
            }
            long offset = this.rowData.getPosition();
            if (bl) {
                void currentRow;
                OracleLog.debug($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "currentRow: " + (int)currentRow + " offset: " + offset);
            }
            this.rowOffset[currentRow] = offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, Accessor.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, Accessor.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, Accessor.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int getLength(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, Accessor.class, $$$methodRef$$$27, this, n2);
            }
            int n3 = this.rowLength[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, Accessor.class, $$$methodRef$$$27, this, n3);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, Accessor.class, $$$methodRef$$$27, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, Accessor.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setLength(int n2, int n3) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, Accessor.class, $$$methodRef$$$28, this, n2, n3);
            }
            this.rowLength[currentRow] = length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, Accessor.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, Accessor.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, Accessor.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setLengthAndNull(int n2, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, Accessor.class, $$$methodRef$$$29, this, n2, n3);
            }
            if (length == false) {
                this.setNull((int)currentRow, true);
            } else {
                this.setNull((int)currentRow, false);
                this.setLength((int)currentRow, (int)length);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, Accessor.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, Accessor.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, Accessor.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final byte getRowMetadata(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, Accessor.class, $$$methodRef$$$30, this, n2);
            }
            byte by = this.rowMetadata[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, Accessor.class, $$$methodRef$$$30, this, by);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, Accessor.class, $$$methodRef$$$30, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, Accessor.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setRowMetadata(int n2, byte by) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void meta;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, Accessor.class, $$$methodRef$$$31, this, n2, by);
            }
            this.rowMetadata[currentRow] = meta;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, Accessor.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, Accessor.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, Accessor.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    boolean isNull(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, Accessor.class, $$$methodRef$$$32, this, n2);
            }
            if (this.rowNull == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, Accessor.class, $$$methodRef$$$32, this, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = this.rowNull[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, Accessor.class, $$$methodRef$$$32, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, Accessor.class, $$$methodRef$$$32, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, Accessor.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNull(int n2, boolean bl) throws SQLException {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, Accessor.class, $$$methodRef$$$33, this, n2, bl);
            }
            if (this.rowNull == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, Accessor.class, $$$methodRef$$$33, this, sQLException);
                }
                throw sQLException;
            }
            this.rowNull[currentRow] = value;
            if (value != false && this.statement.connection.protocolId != 3) {
                void currentRow;
                this.setOffset((int)currentRow, -1L);
                this.setLength((int)currentRow, -1);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, Accessor.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, Accessor.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, Accessor.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isNullByDescribe() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, Accessor.class, $$$methodRef$$$34, this, new Object[0]);
            }
            boolean bl2 = this.isNullByDescribe;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, Accessor.class, $$$methodRef$$$34, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, Accessor.class, $$$methodRef$$$34, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, Accessor.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isUseless() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, Accessor.class, $$$methodRef$$$35, this, new Object[0]);
            }
            boolean bl2 = this.isUseLess;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, Accessor.class, $$$methodRef$$$35, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, Accessor.class, $$$methodRef$$$35, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, Accessor.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isUnexpected() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, Accessor.class, $$$methodRef$$$36, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.rowNull == null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, Accessor.class, $$$methodRef$$$36, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, Accessor.class, $$$methodRef$$$36, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, Accessor.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setColumnInvisible(boolean bl) {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void columnInvisible;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, Accessor.class, $$$methodRef$$$37, this, bl);
            }
            this.columnInvisible = columnInvisible;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, Accessor.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, Accessor.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, Accessor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isColumnInvisible() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, Accessor.class, $$$methodRef$$$38, this, new Object[0]);
            }
            boolean bl2 = this.columnInvisible;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, Accessor.class, $$$methodRef$$$38, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, Accessor.class, $$$methodRef$$$38, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, Accessor.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setColumnJSON(boolean bl) {
        boolean bl2 = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void columnJSON;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, Accessor.class, $$$methodRef$$$39, this, bl);
            }
            this.columnJSON = columnJSON;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, Accessor.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, Accessor.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, Accessor.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isColumnJSON() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, Accessor.class, $$$methodRef$$$40, this, new Object[0]);
            }
            boolean bl2 = this.columnJSON;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, Accessor.class, $$$methodRef$$$40, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, Accessor.class, $$$methodRef$$$40, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, Accessor.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setCapacity(int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void capacity;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, Accessor.class, $$$methodRef$$$41, this, n2);
            }
            if (this.rowNull == null) {
                this.rowLength = new int[capacity];
                this.rowOffset = new long[capacity];
                this.rowNull = new boolean[capacity];
                this.rowMetadata = new byte[capacity];
            } else if (this.rowNull.length < capacity) {
                Object[] tmp = new int[capacity];
                System.arraycopy(this.rowLength, 0, tmp, 0, this.rowLength.length);
                this.rowLength = tmp;
                tmp = new long[capacity];
                System.arraycopy(this.rowOffset, 0, tmp, 0, this.rowOffset.length);
                this.rowOffset = tmp;
                tmp = new boolean[capacity];
                System.arraycopy(this.rowNull, 0, tmp, 0, this.rowNull.length);
                this.rowNull = (boolean[])tmp;
                tmp = new byte[capacity];
                System.arraycopy(this.rowMetadata, 0, tmp, 0, this.rowMetadata.length);
                this.rowMetadata = (byte[])tmp;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, Accessor.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, Accessor.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, Accessor.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void insertNull(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, Accessor.class, $$$methodRef$$$42, this, n2);
            }
            System.arraycopy(this.rowNull, (int)rowIndex, this.rowNull, (int)(rowIndex + true), this.rowNull.length - rowIndex - 1);
            System.arraycopy(this.rowLength, (int)rowIndex, this.rowLength, (int)(rowIndex + true), this.rowLength.length - rowIndex - 1);
            System.arraycopy(this.rowOffset, (int)rowIndex, this.rowOffset, (int)(rowIndex + true), this.rowOffset.length - rowIndex - 1);
            System.arraycopy(this.rowMetadata, (int)rowIndex, this.rowMetadata, (int)(rowIndex + true), this.rowMetadata.length - rowIndex - 1);
            this.setNull((int)rowIndex, true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, Accessor.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, Accessor.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, Accessor.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Accessor copyForDefine(OracleStatement oracleStatement) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, Accessor.class, $$$methodRef$$$43, this, oracleStatement);
            }
            Accessor acc = null;
            try {
                acc = (Accessor)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            acc.rowNull = null;
            acc.rowLength = null;
            acc.rowOffset = null;
            acc.rowMetadata = null;
            acc.statement = dest;
            acc.rowData = dest.rowData;
            dest.setDriverSpecificData(acc);
            Accessor accessor = acc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, Accessor.class, $$$methodRef$$$43, this, accessor);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, Accessor.class, $$$methodRef$$$43, this, null);
            }
            return accessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, Accessor.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte metaDataByte1;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, n2);
            }
            if (((metaDataByte1 = this.getRowMetadata((int)currentRow)) & 1) != 0) {
                OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, (Object)authorizationIndicator);
                    ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, null);
                }
                return authorizationIndicator;
            }
            if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
                OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.NONE;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, (Object)authorizationIndicator);
                    ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, null);
                }
                return authorizationIndicator;
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.UNKNOWN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, (Object)authorizationIndicator);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, null);
            }
            return authorizationIndicator;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, Accessor.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytesInternal(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, Accessor.class, $$$methodRef$$$45, this, n2);
            }
            if (!$assertionsDisabled && this.isNull((int)currentRow)) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, Accessor.class, $$$methodRef$$$45, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int len = this.getLength((int)currentRow);
            long off = this.getOffset((int)currentRow);
            byte[] byArray = this.rowData.get(off, len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, Accessor.class, $$$methodRef$$$45, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, Accessor.class, $$$methodRef$$$45, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, Accessor.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void getBytesInternal(int n2, byte[] byArray) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void data;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, Accessor.class, $$$methodRef$$$46, this, n2, byArray);
            }
            int len = this.getLength((int)currentRow);
            if (!$assertionsDisabled && ((void)data).length < len) {
                AssertionError assertionError = new AssertionError((Object)("data.length: " + ((void)data).length + " len: " + len));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$46, Level.FINEST, Accessor.class, $$$methodRef$$$46, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            long off = this.getOffset((int)currentRow);
            this.rowData.get(off, (byte[])data, 0, len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, Accessor.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, Accessor.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, Accessor.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, null);
                }
                return null;
            }
            byte[] byArray = this.getBytesInternal((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, Accessor.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, Accessor.class, $$$methodRef$$$48, this, n2);
            }
            String string = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, Accessor.class, $$$methodRef$$$48, this, string);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, Accessor.class, $$$methodRef$$$48, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, Accessor.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, Accessor.class, $$$methodRef$$$49, this, n2, clazz);
            }
            if (type == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 282).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, Accessor.class, $$$methodRef$$$49, this, sQLException);
                }
                throw sQLException;
            }
            Object t2 = this.representation.getObject(this, (int)currentRow, type);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, Accessor.class, $$$methodRef$$$49, this, t2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, Accessor.class, $$$methodRef$$$49, this, null);
            }
            return t2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, Accessor.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            void factory;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, Accessor.class, $$$methodRef$$$50, this, n2, oracleDataFactory);
            }
            if (factory == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$50, Level.FINEST, Accessor.class, $$$methodRef$$$50, this, sQLException);
                }
                throw sQLException;
            }
            Object jdbcObject = this.getObject((int)currentRow, (Map)null);
            OracleData oracleData = factory.create(jdbcObject, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, Accessor.class, $$$methodRef$$$50, this, oracleData);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, Accessor.class, $$$methodRef$$$50, this, null);
            }
            return oracleData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, Accessor.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            void factory;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, Accessor.class, $$$methodRef$$$51, this, n2, oRADataFactory);
            }
            if (factory == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$51, Level.FINEST, Accessor.class, $$$methodRef$$$51, this, sQLException);
                }
                throw sQLException;
            }
            Datum d2 = this.getOracleObject((int)currentRow);
            ORAData oRAData = factory.create(d2, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, Accessor.class, $$$methodRef$$$51, this, oRAData);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, Accessor.class, $$$methodRef$$$51, this, null);
            }
            return oRAData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, Accessor.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, Accessor.class, $$$methodRef$$$52, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Datum[] datumArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, Accessor.class, $$$methodRef$$$52, this, datumArray);
                    ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, Accessor.class, $$$methodRef$$$52, this, null);
                }
                return null;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOraclePlsqlIndexTable not implemented for " + this.getClass().getName()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$52, Level.FINEST, Accessor.class, $$$methodRef$$$52, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, Accessor.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    NClob getNClob(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, Accessor.class, $$$methodRef$$$53, this, n2);
            }
            if (this.formOfUse != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$53, Level.FINEST, Accessor.class, $$$methodRef$$$53, this, sQLException);
                }
                throw sQLException;
            }
            NClob nClob = (NClob)((Object)this.getCLOB((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, Accessor.class, $$$methodRef$$$53, this, nClob);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, Accessor.class, $$$methodRef$$$53, this, null);
            }
            return nClob;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, Accessor.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getNString(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, Accessor.class, $$$methodRef$$$54, this, n2);
            }
            String string = this.getString((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, Accessor.class, $$$methodRef$$$54, this, string);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, Accessor.class, $$$methodRef$$$54, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, Accessor.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Reader getNCharacterStream(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, Accessor.class, $$$methodRef$$$55, this, n2);
            }
            Reader reader = this.getCharacterStream((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, Accessor.class, $$$methodRef$$$55, this, reader);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, Accessor.class, $$$methodRef$$$55, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, Accessor.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, Accessor.class, $$$methodRef$$$56, this, n2, byArray, n3);
            }
            if (this.isNull((int)currentRow)) {
                int n4 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, Accessor.class, $$$methodRef$$$56, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, Accessor.class, $$$methodRef$$$56, this, null);
                }
                return 0;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes not implemented for class " + this.getClass().getName()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$56, Level.FINEST, Accessor.class, $$$methodRef$$$56, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, Accessor.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void copyFrom(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void destRow;
            void srcRow;
            void srcAcc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, accessor, n2, n3);
            }
            if (!$assertionsDisabled && this.getClass() != srcAcc.getClass()) {
                AssertionError assertionError = new AssertionError((Object)("srcAcc.class: " + srcAcc.getClass()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!($assertionsDisabled || false <= srcRow && srcRow < srcAcc.rowNull.length)) {
                AssertionError assertionError = new AssertionError((Object)("srcRow: " + (int)srcRow + " srcAcc.capacity: " + srcAcc.rowNull.length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!($assertionsDisabled || false <= destRow && destRow < this.rowNull.length)) {
                AssertionError assertionError = new AssertionError((Object)("destRow: " + (int)destRow + " capacity: " + this.rowNull.length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (srcAcc.isNull((int)srcRow)) {
                this.setNull((int)destRow, true);
            } else {
                this.copyFromInternal((Accessor)srcAcc, (int)srcRow, (int)destRow);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, Accessor.class, $$$methodRef$$$57, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void srcRow;
            void srcAcc;
            void destRow;
            boolean rowCopy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, Accessor.class, $$$methodRef$$$58, this, accessor, n2, n3);
            }
            boolean bl2 = rowCopy = destRow > 0 && this.getOffset((int)(destRow - true)) == this.getOffset((int)destRow) || destRow + true < this.statement.storedRowCount && this.getOffset((int)(destRow + true)) == this.getOffset((int)destRow);
            if (rowCopy && this.getLength((int)destRow) == srcAcc.getLength((int)srcRow) && this.rowData.equalBytes(this.getOffset((int)destRow), this.getLength((int)destRow), srcAcc.rowData, srcAcc.getOffset((int)srcRow))) {
                this.setRowMetadata((int)destRow, srcAcc.getRowMetadata((int)srcRow));
            } else {
                boolean saveLastCopyRow;
                boolean bl3 = saveLastCopyRow = destRow + true == this.statement.storedRowCount;
                if (rowCopy || srcAcc.getLength((int)srcRow) > this.getLength((int)destRow) || saveLastCopyRow) {
                    if (saveLastCopyRow) {
                        this.lastCopyRow = destRow;
                        this.lastCopyRowOffset = this.getOffset((int)destRow);
                        this.lastCopyRowLength = this.getLength((int)destRow);
                        this.lastCopyRowMetaData = this.getRowMetadata((int)destRow);
                        this.lastCopyRowIsNull = this.isNull((int)destRow);
                    }
                    this.statement.locationToPutBytes(this, (int)destRow, srcAcc.getLength((int)srcRow));
                }
                this.rowData.put(this.getOffset((int)destRow), srcAcc.rowData, srcAcc.getOffset((int)srcRow), srcAcc.getLength((int)srcRow));
                this.setLength((int)destRow, srcAcc.getLength((int)srcRow));
                this.setRowMetadata((int)destRow, srcAcc.getRowMetadata((int)srcRow));
            }
            this.setNull((int)destRow, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, Accessor.class, $$$methodRef$$$58, this);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, Accessor.class, $$$methodRef$$$58, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, Accessor.class, $$$methodRef$$$58, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void deleteRow(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, Accessor.class, $$$methodRef$$$59, this, n2);
            }
            this.rowData.freeSpace(this.getOffset((int)row), this.getLength((int)row));
            this.delete(this.rowNull, (int)row);
            this.delete(this.rowOffset, (int)row);
            this.delete(this.rowLength, (int)row);
            this.delete(this.rowMetadata, (int)row);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, Accessor.class, $$$methodRef$$$59, this);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, Accessor.class, $$$methodRef$$$59, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, Accessor.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void delete(Object object, int n2) {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            void array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, Accessor.class, $$$methodRef$$$60, this, object, n2);
            }
            int len = Array.getLength(array);
            if (!($assertionsDisabled || row >= 0 && row < len)) {
                AssertionError assertionError = new AssertionError((Object)("row: " + (int)row + " len: " + len));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$60, Level.FINEST, Accessor.class, $$$methodRef$$$60, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            System.arraycopy(array, (int)(row + true), array, (int)row, len - row - 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, Accessor.class, $$$methodRef$$$60, this);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, Accessor.class, $$$methodRef$$$60, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, Accessor.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    AccessorPrototype newPrototype(int n2) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, Accessor.class, $$$methodRef$$$61, this, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "newPrototype not overridden in " + this.getClass().getName()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$61, Level.FINEST, Accessor.class, $$$methodRef$$$61, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, Accessor.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, Accessor.class, $$$methodRef$$$62, this, byteArray, oracleStatement);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "reinitForResultSetCache not overridden in " + this.getClass().getName()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$62, Level.FINEST, Accessor.class, $$$methodRef$$$62, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, Accessor.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    long previousOffset() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                long l2 = 0L;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, l2);
                    ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, null);
                }
                return 0L;
            }
            long l3 = this.getOffset(this.previousRowProcessed);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, l3);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, Accessor.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isLengthSemanticChar() {
        boolean bl = (4L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, Accessor.class, $$$methodRef$$$64, this, new Object[0]);
            }
            boolean bl3 = bl2 = 0L != (0x1000L & this.contflag);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, Accessor.class, $$$methodRef$$$64, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, Accessor.class, $$$methodRef$$$64, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, Accessor.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$65 = Accessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = Accessor.class.getDeclaredMethod("isLengthSemanticChar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = Accessor.class.getDeclaredMethod("previousOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = Accessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = Accessor.class.getDeclaredMethod("newPrototype", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = Accessor.class.getDeclaredMethod("delete", Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = Accessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = Accessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = Accessor.class.getDeclaredMethod("copyFrom", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = Accessor.class.getDeclaredMethod("getBytes", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = Accessor.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = Accessor.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = Accessor.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = Accessor.class.getDeclaredMethod("getOraclePlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = Accessor.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = Accessor.class.getDeclaredMethod("getObject", Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = Accessor.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = Accessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = Accessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = Accessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = Accessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = Accessor.class.getDeclaredMethod("getAuthorizationIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = Accessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = Accessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = Accessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = Accessor.class.getDeclaredMethod("isColumnJSON", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = Accessor.class.getDeclaredMethod("setColumnJSON", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = Accessor.class.getDeclaredMethod("isColumnInvisible", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = Accessor.class.getDeclaredMethod("setColumnInvisible", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = Accessor.class.getDeclaredMethod("isUnexpected", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = Accessor.class.getDeclaredMethod("isUseless", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = Accessor.class.getDeclaredMethod("isNullByDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = Accessor.class.getDeclaredMethod("setNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = Accessor.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = Accessor.class.getDeclaredMethod("setRowMetadata", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = Accessor.class.getDeclaredMethod("getRowMetadata", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = Accessor.class.getDeclaredMethod("setLengthAndNull", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = Accessor.class.getDeclaredMethod("setLength", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = Accessor.class.getDeclaredMethod("getLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = Accessor.class.getDeclaredMethod("setOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = Accessor.class.getDeclaredMethod("setOffset", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = Accessor.class.getDeclaredMethod("getOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = Accessor.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = Accessor.class.getDeclaredMethod("initMetadataAsync", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = Accessor.class.getDeclaredMethod("initMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = Accessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = Accessor.class.getDeclaredMethod("readStream", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = Accessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = Accessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = Accessor.class.getDeclaredMethod("calculateSizeTmpByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = Accessor.class.getDeclaredMethod("fetchNextColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = Accessor.class.getDeclaredMethod("updateColumnNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = Accessor.class.getDeclaredMethod("setFormOfUse", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = Accessor.class.getDeclaredMethod("useForDescribeIfPossible", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = Accessor.class.getDeclaredMethod("useForDataAccessIfPossible", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = Accessor.class.getDeclaredMethod("initForNewRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Accessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Accessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Accessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Accessor.class.getDeclaredMethod("unimpl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Accessor.class.getDeclaredMethod("plsqlIndexTableBindInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Accessor.class.getDeclaredMethod("setPrefetchLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Accessor.class.getDeclaredMethod("setNoPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NULL_DATA_BYTES = new byte[]{2, 3, 5, 7, 11, 13, 17, 19};
    }
}

