/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.babelfish.BabelfishCallableStatement;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.babelfish.BabelfishPreparedStatement;
import oracle.jdbc.babelfish.BabelfishStatement;
import oracle.jdbc.babelfish.TranslationManager;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleDiagnosabilityMBean;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EZConnectResolver;
import oracle.security.pki.OraclePKIProvider;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONNECT})
public class OracleDriver
implements Driver,
Monitor {
    public static final String oracle_string = "oracle";
    public static final String jdbc_string = "jdbc";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    @Deprecated
    public static final String access_string = "access";
    @Deprecated
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    @Deprecated
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    private final String SIMPLE_URL_FORMAT = "jdbc:oracle:(thin|oci|oci8|kprb|sharding):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions;
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames;
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static final Monitor DEFAULT_CONN_MONITOR;
    private static OracleDriver defaultDriver;
    public static final Map<String, Class<?>> systemTypeMap;
    private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
    protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
    private static ExecutorService threadPool;
    private static final String SERVER_SIDE_DEFAULT_URL_PREFIX = "jdbc:default:connection";
    private static final int SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH;
    private static ObjectName diagnosticMBeanObjectName;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public OracleDriver() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleDriver.class, $$$methodRef$$$32, null, new Object[0]);
            }
            this.SIMPLE_URL_FORMAT = "jdbc:oracle:(thin|oci|oci8|kprb|sharding):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+";
            this.driverExtensions = new OracleDriverExtension[4];
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleDriver.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDriver.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDriver.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static void registerMBeans() {
        block14: {
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (NoClassDefFoundError ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (ClassNotFoundException ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    ClassLoader loader = OracleDriver.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    while (true) {
                        String name = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + name);
                        try {
                            mbs.registerMBean(new OracleDiagnosabilityMBean(), diagnosticMBeanObjectName);
                            break block14;
                        }
                        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
        }
    }

    @Supports(value={Feature.PLATFORM})
    public static void unRegisterMBeans() {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDriver.class, $$$methodRef$$$0, null, new Object[0]);
            }
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (Throwable ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    try {
                        ClassLoader loader = OracleDriver.class.getClassLoader();
                        String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                        int count = 0;
                        String name = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + name);
                        mbs.unregisterMBean(diagnosticMBeanObjectName);
                    }
                    catch (Throwable ex) {
                        Logger.getLogger("oracle.jdbc").log(Level.INFO, "Unabled to unregister Oracle JDBC Diagnosability MBean: " + ex.getMessage());
                    }
                } else {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer to unregister Oracle JDBC Diagnosability MBean.");
                }
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while unregistering Oracle JDBC Diagnosability MBean.", ex);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDriver.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDriver.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDriver.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.PLATFORM})
    private static void deregister() {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDriver.class, $$$methodRef$$$1, null, new Object[0]);
            }
            OracleDriver.unRegisterMBeans();
            OracleTimeoutThreadPerVM.stopWatchdog();
            BlockSource.ThreadedCachingBlockSource.stopBlockReleaserThread();
            TimeoutInterruptHandler.stopTimer();
            if (threadPool != null) {
                threadPool.shutdownNow();
            }
            HAManager.shutdownAll();
            OracleDataSource.cleanup();
            TxnFailoverManagerImpl.cleanup();
            TcpMultiplexer.stop();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDriver.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDriver.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDriver.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection connect(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDriver.class, $$$methodRef$$$2, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Connection connection = this.connect((String)url, (Properties)info, AbstractConnectionBuilder.unconfigured());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDriver.class, $$$methodRef$$$2, this, connection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDriver.class, $$$methodRef$$$2, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDriver.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public Connection connect(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            Properties info;
            int extensionType;
            AbstractConnectionBuilder builder;
            String url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            if (url == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (url.startsWith(SERVER_SIDE_DEFAULT_URL_PREFIX)) {
                url = OracleDriver.convertServerSideDefaultURL(url);
            }
            if (builder == null) {
                builder = AbstractConnectionBuilder.unconfigured();
            }
            if ((extensionType = OracleDriver.parseExtensionType(url)) == -2) {
                Connection connection = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, connection);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            if (builder.getGSSCredential() != null) {
                OracleDriver.ensureGSSCredentialSupport(extensionType);
            }
            OracleDriverExtension driverExtension = this.getDriverExtension(extensionType);
            if (info == null) {
                info = new Properties();
            }
            if (!url.matches("jdbc:oracle:(thin|oci|oci8|kprb|sharding):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+")) {
                url = OracleDriver.resolveNonSimpleURL(url, info);
            }
            OracleDriver.ensureSingleRegisteredDriver();
            String translationProfile = OracleDriver.getTranslationProfile(extensionType, info);
            if (translationProfile != null) {
                conn = this.babelfishConnect(info, translationProfile, url, driverExtension, extensionType);
            } else {
                conn = driverExtension.getConnection(url, info, builder);
                OracleDriver.setConnectionProtocolID(conn, extensionType);
            }
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, connection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDriver.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final CompletionStage<Connection> _INTERNAL_ORACLE_connectAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Properties info;
            void builder;
            int extensionType;
            String url;
            block18: {
                CompletionStage<Object> completionStage;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
                    }
                    if (url == null) {
                        CompletionStage<Connection> completionStage2 = CompletionStageUtil.failedStage(DatabaseError.createSqlException(296).fillInStackTrace());
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage2);
                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
                        }
                        return completionStage2;
                    }
                    if (url.startsWith(SERVER_SIDE_DEFAULT_URL_PREFIX)) {
                        CompletionStage<Connection> completionStage3 = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections are not supported by the server-side internal driver"));
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage3);
                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
                        }
                        return completionStage3;
                    }
                    try {
                        extensionType = OracleDriver.parseExtensionType(url);
                        if (extensionType != -2) break block18;
                        completionStage = CompletionStageUtil.completedStage(null);
                        if (!bl) break block19;
                    }
                    catch (SQLException preConnectFailure) {
                        CompletionStage<Connection> completionStage4 = CompletionStageUtil.failedStage(preConnectFailure);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage4);
                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
                        }
                        return completionStage4;
                    }
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
                }
                return completionStage;
            }
            if (builder != null && builder.getGSSCredential() != null) {
                OracleDriver.ensureGSSCredentialSupport(extensionType);
            }
            OracleDriverExtension driverExtension = this.getDriverExtension(extensionType);
            if (info == null) {
                info = new Properties();
            }
            if (!url.matches("jdbc:oracle:(thin|oci|oci8|kprb|sharding):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+")) {
                url = OracleDriver.resolveNonSimpleURL(url, info);
            }
            OracleDriver.ensureSingleRegisteredDriver();
            if (null != OracleDriver.getTranslationProfile(extensionType, info)) {
                CompletionStage<Connection> completionStage = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections do not support SQL translation."));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
                }
                return completionStage;
            }
            CompletionStage<Connection> completionStage = driverExtension.getConnectionAsync(url, info, (AbstractConnectionBuilder<?, ?>)builder).thenApply(connection -> {
                boolean bl = (8L & TraceControllerImpl.feature) != 0L;
                try {
                    int extensionType;
                    void conn;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleDriver.class, $$$methodRef$$$31, null, extensionType, connection);
                    }
                    OracleDriver.setConnectionProtocolID((Connection)conn, extensionType);
                    void var3_3 = conn;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleDriver.class, $$$methodRef$$$31, null, var3_3);
                        ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDriver.class, $$$methodRef$$$31, null, null);
                    }
                    return var3_3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDriver.class, $$$methodRef$$$31, null, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDriver.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    private static final String convertServerSideDefaultURL(String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String serverSideDefaultURL;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, string);
            }
            if (serverSideDefaultURL.length() > SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH) {
                String string2 = "jdbc:oracle:kprb".concat(serverSideDefaultURL.substring(SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, string2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, null);
                }
                return string2;
            }
            String string3 = "jdbc:oracle:kprb".concat(":");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, string3);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDriver.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final int parseExtensionType(String string) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String url;
            int extensionType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleDriver.class, $$$methodRef$$$6, null, string);
            }
            if ((extensionType = OracleDriver.oracleDriverExtensionTypeFromURL(url)) == -3) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleDriver.class, $$$methodRef$$$6, null, sQLException);
                }
                throw sQLException;
            }
            int n2 = extensionType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDriver.class, $$$methodRef$$$6, null, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDriver.class, $$$methodRef$$$6, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDriver.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final void ensureGSSCredentialSupport(int n2) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            int extensionType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleDriver.class, $$$methodRef$$$7, null, n2);
            }
            if (!OracleDriver.isType4ExtensionType(extensionType)) {
                SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleDriver.class, $$$methodRef$$$7, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleDriver.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDriver.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDriver.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final boolean isType4ExtensionType(int n2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            int extensionType;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleDriver.class, $$$methodRef$$$8, null, n2);
            }
            boolean bl3 = bl2 = extensionType == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDriver.class, $$$methodRef$$$8, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDriver.class, $$$methodRef$$$8, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDriver.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OracleDriverExtension getDriverExtension(int n2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void extensionType;
            OracleDriverExtension driverExtension;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleDriver.class, $$$methodRef$$$9, this, n2);
            }
            if ((driverExtension = this.driverExtensions[extensionType]) == null) {
                try {
                    Monitor.CloseableLock lock = this.acquireCloseableLock();
                    try {
                        if (driverExtension == null) {
                            this.driverExtensions[extensionType] = driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[extensionType]).newInstance();
                        } else {
                            driverExtension = this.driverExtensions[extensionType];
                        }
                        if (lock != null) {
                            lock.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleDriver.class, $$$methodRef$$$9, this, throwable3);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            OracleDriverExtension oracleDriverExtension = driverExtension;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDriver.class, $$$methodRef$$$9, this, oracleDriverExtension);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDriver.class, $$$methodRef$$$9, this, null);
            }
            return oracleDriverExtension;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDriver.class, $$$methodRef$$$9, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String resolveNonSimpleURL(String string, @Blind(value=PropertiesBlinder.class) Properties properties) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String string2;
            void connectionProperties;
            String nonSimpleURL;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleDriver.class, $$$methodRef$$$10, null, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            EZConnectResolver resolver = EZConnectResolver.newInstance(nonSimpleURL);
            connectionProperties.putAll((Map<?, ?>)resolver.getProperties());
            String resolvedURL = resolver.getResolvedUrl();
            String string3 = string2 = resolvedURL == null ? nonSimpleURL : resolvedURL;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleDriver.class, $$$methodRef$$$10, null, string2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDriver.class, $$$methodRef$$$10, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDriver.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final void ensureSingleRegisteredDriver() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Driver driverobj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleDriver.class, $$$methodRef$$$11, null, new Object[0]);
            }
            Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
            while (enumdrivers.hasMoreElements() && !((driverobj = enumdrivers.nextElement()) instanceof OracleDriver)) {
            }
            while (enumdrivers.hasMoreElements()) {
                driverobj = enumdrivers.nextElement();
                if (!(driverobj instanceof OracleDriver)) continue;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public Object run() throws SQLException {
                            DriverManager.deregisterDriver(driverobj);
                            return null;
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Driver.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    SQLException sQLException = (SQLException)ex.getException();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleDriver.class, $$$methodRef$$$11, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleDriver.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDriver.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDriver.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String getTranslationProfile(int n2, @Blind(value=PropertiesBlinder.class) Properties properties) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            void connectionProperties;
            int extensionType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, n2, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (extensionType == 2 && connectionProperties.containsKey("connection_pool") && connectionProperties.getProperty("connection_pool").equals("connection_pool")) {
                String string2 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, string2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            String string3 = string = connectionProperties != null ? connectionProperties.getProperty("oracle.jdbc.sqlTranslationProfile", PhysicalConnection.getSystemPropertySqlTranslationProfile()) : PhysicalConnection.getSystemPropertySqlTranslationProfile();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDriver.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void setConnectionProtocolID(Connection connection, int n2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleDriver.class, $$$methodRef$$$13, null, connection, n2);
            }
            if (conn instanceof PhysicalConnection) {
                void extensionType;
                ((PhysicalConnection)conn).protocolId = extensionType;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleDriver.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDriver.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDriver.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Supports(value={Feature.SQL_TRANSLATION})
    private Connection babelfishConnect(@Blind(value=PropertiesBlinder.class) Properties properties, String string, String string2, OracleDriverExtension oracleDriverExtension, int n2) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection connection;
            block13: {
                void url;
                String tempval;
                void info;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleDriver.class, $$$methodRef$$$14, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), string, string2, oracleDriverExtension, n2);
                }
                info.put("oracle.jdbc.sqlTranslationProfile", tempval);
                tempval = null;
                if (info != null) {
                    tempval = info.getProperty("oracle.jdbc.sqlErrorTranslationFile");
                }
                if (tempval == null) {
                    tempval = System.getProperty("oracle.jdbc.sqlErrorTranslationFile", null);
                }
                if (tempval != null) {
                    info.put("oracle.jdbc.sqlErrorTranslationFile", tempval);
                }
                tempval = null;
                if (info != null && (tempval = info.getProperty(user_string)) == null) {
                    tempval = info.getProperty("oracle.jdbc.user");
                }
                if (tempval == null) {
                    tempval = System.getProperty("oracle.jdbc.user", null);
                }
                if (tempval == null) {
                    Hashtable<String, String> url_props = PhysicalConnection.parseUrl((String)url);
                    tempval = url_props.get(user_string);
                }
                info.put(user_string, tempval);
                ProxyFactory proxyFactory = ProxyFactory.createJDBCProxyFactory(BabelfishGenericProxy.class, BabelfishConnection.class, BabelfishStatement.class, BabelfishPreparedStatement.class, BabelfishCallableStatement.class);
                Translator trnsltr = TranslationManager.getTranslator((String)url, info.getProperty(user_string), info.getProperty("oracle.jdbc.sqlTranslationProfile"), info.getProperty("oracle.jdbc.sqlErrorTranslationFile"));
                try {
                    void extensionType;
                    void driverExtension;
                    PhysicalConnection conn = (PhysicalConnection)driverExtension.getConnection((String)url, (Properties)info);
                    conn.protocolId = extensionType;
                    Connection babelfishConnection = proxyFactory.proxyFor(conn);
                    ((BabelfishConnection)((Object)babelfishConnection)).setTranslator(trnsltr);
                    trnsltr.activateServerTranslation(conn);
                    connection = babelfishConnection;
                    if (!bl) break block13;
                }
                catch (SQLException ex) {
                    SQLException sQLException = trnsltr.translateError(ex);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleDriver.class, $$$methodRef$$$14, this, sQLException);
                    }
                    throw sQLException;
                }
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleDriver.class, $$$methodRef$$$14, this, connection);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDriver.class, $$$methodRef$$$14, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDriver.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public Connection defaultConnection() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleDriver.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (defaultConn == null || defaultConn.isClosed()) {
                Monitor.CloseableLock lock = DEFAULT_CONN_MONITOR.acquireCloseableLock();
                try {
                    if (defaultConn == null || defaultConn.isClosed()) {
                        defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
                    }
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleDriver.class, $$$methodRef$$$15, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            Connection connection = defaultConn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleDriver.class, $$$methodRef$$$15, this, connection);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDriver.class, $$$methodRef$$$15, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDriver.class, $$$methodRef$$$15, this, throwable4);
            }
            throw throwable;
        }
    }

    static final int oracleDriverExtensionTypeFromURL(String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            int second_colon;
            String url;
            int first_colon;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, string);
            }
            if ((first_colon = url.indexOf(58)) == -1) {
                int n2 = -2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n2);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return -2;
            }
            if (!url.regionMatches(true, 0, jdbc_string, 0, first_colon)) {
                int n3 = -2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n3);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return -2;
            }
            if ((second_colon = url.indexOf(58, ++first_colon)) == -1) {
                int n4 = -2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n4);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return -2;
            }
            if (!url.regionMatches(true, first_colon, oracle_string, 0, second_colon - first_colon)) {
                int n5 = -2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n5);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return -2;
            }
            int third_colon = url.indexOf(58, ++second_colon);
            String sub_name = null;
            if (third_colon == -1) {
                int n6 = -3;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n6);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return -3;
            }
            sub_name = url.substring(second_colon, third_colon);
            if (sub_name.equals("thin")) {
                int n7 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n7);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return 0;
            }
            if (sub_name.equals("oci8") || sub_name.equals("oci")) {
                int n8 = 2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n8);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
                }
                return 2;
            }
            int n9 = -3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, n9);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, null);
            }
            return -3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDriver.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Supports(value={Feature.PLATFORM})
    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, string);
            }
            if (url == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, sQLException);
                }
                throw sQLException;
            }
            if (url.startsWith("jdbc:oracle:")) {
                boolean bl2;
                boolean bl3 = bl2 = OracleDriver.oracleDriverExtensionTypeFromURL((String)url) > -2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, null);
                }
                return bl3;
            }
            boolean bl4 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDriver.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Supports(value={Feature.METADATA})
    public DriverPropertyInfo[] getPropertyInfo(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleDriver.class, $$$methodRef$$$18, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Class<?> oracleConnectionClass = null;
            try {
                oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            int offset = 0;
            String[] propertyNames = new String[150];
            String[] propertyValues = new String[150];
            Field[] publicPropertiesFields = oracleConnectionClass.getFields();
            for (int i2 = 0; i2 < publicPropertiesFields.length; ++i2) {
                if (!publicPropertiesFields[i2].getName().startsWith("CONNECTION_PROPERTY_") || publicPropertiesFields[i2].getName().endsWith("_DEFAULT") || publicPropertiesFields[i2].getName().endsWith("_ACCESSMODE")) continue;
                try {
                    String propertyName = (String)publicPropertiesFields[i2].get(null);
                    Field propertyDefaultField = oracleConnectionClass.getField(publicPropertiesFields[i2].getName() + "_DEFAULT");
                    String propertyValue = (String)propertyDefaultField.get(null);
                    if (offset == propertyNames.length) {
                        String[] propertyNames2 = new String[propertyNames.length * 2];
                        String[] propertyValues2 = new String[propertyNames.length * 2];
                        System.arraycopy(propertyNames, 0, propertyNames2, 0, propertyNames.length);
                        System.arraycopy(propertyValues, 0, propertyValues2, 0, propertyNames.length);
                        propertyNames = propertyNames2;
                        propertyValues = propertyValues2;
                    }
                    propertyNames[offset] = propertyName;
                    propertyValues[offset] = propertyValue;
                    ++offset;
                    continue;
                }
                catch (IllegalAccessException propertyName) {
                    continue;
                }
                catch (NoSuchFieldException propertyName) {
                    // empty catch block
                }
            }
            Hashtable<String, String> parsedInfo = PhysicalConnection.parseUrl((String)url);
            DriverPropertyInfo[] ret = new DriverPropertyInfo[offset];
            for (int i3 = 0; i3 < offset; ++i3) {
                String key = propertyNames[i3];
                ret[i3] = parsedInfo.containsKey(key) ? new DriverPropertyInfo(key, parsedInfo.get(key)) : new DriverPropertyInfo(propertyNames[i3], propertyValues[i3]);
            }
            DriverPropertyInfo[] driverPropertyInfoArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleDriver.class, $$$methodRef$$$18, this, driverPropertyInfoArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDriver.class, $$$methodRef$$$18, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDriver.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Supports(value={Feature.METADATA})
    public int getMajorVersion() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleDriver.class, $$$methodRef$$$19, this, new Object[0]);
            }
            int n2 = OracleDatabaseMetaData.getDriverMajorVersionInfo();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleDriver.class, $$$methodRef$$$19, this, n2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDriver.class, $$$methodRef$$$19, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDriver.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Supports(value={Feature.METADATA})
    public int getMinorVersion() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleDriver.class, $$$methodRef$$$20, this, new Object[0]);
            }
            int n2 = OracleDatabaseMetaData.getDriverMinorVersionInfo();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleDriver.class, $$$methodRef$$$20, this, n2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDriver.class, $$$methodRef$$$20, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDriver.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Supports(value={Feature.METADATA})
    public boolean jdbcCompliant() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleDriver.class, $$$methodRef$$$21, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleDriver.class, $$$methodRef$$$21, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDriver.class, $$$methodRef$$$21, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDriver.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Supports(value={Feature.PLATFORM})
    public String processSqlEscapes(String string) throws SQLException {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlString;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleDriver.class, $$$methodRef$$$22, this, string);
            }
            OracleSql sql = new OracleSql(null);
            sql.initialize((String)sqlString);
            String string2 = sql.parse((String)sqlString);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleDriver.class, $$$methodRef$$$22, this, string2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDriver.class, $$$methodRef$$$22, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDriver.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.METADATA})
    public static String getCompileTime() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleDriver.class, $$$methodRef$$$23, null, new Object[0]);
            }
            String string = BuildInfo.getBuildDate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleDriver.class, $$$methodRef$$$23, null, string);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDriver.class, $$$methodRef$$$23, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDriver.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.METADATA})
    public static String getSystemPropertyFastConnectionFailover(String string) {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            String defaultValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleDriver.class, $$$methodRef$$$24, null, string);
            }
            String string2 = PhysicalConnection.getSystemPropertyFastConnectionFailover(defaultValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleDriver.class, $$$methodRef$$$24, null, string2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDriver.class, $$$methodRef$$$24, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDriver.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.METADATA})
    public static boolean getSystemPropertyDateZeroTime() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleDriver.class, $$$methodRef$$$25, null, new Object[0]);
            }
            String sVal = PhysicalConnection.getSystemPropertyDateZeroTime("false");
            boolean bl2 = sVal.equalsIgnoreCase("true");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleDriver.class, $$$methodRef$$$25, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDriver.class, $$$methodRef$$$25, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDriver.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.METADATA})
    public static boolean getSystemPropertyDateZeroTimeExtra() {
        boolean bl = (0x20L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleDriver.class, $$$methodRef$$$26, null, new Object[0]);
            }
            String sVal = PhysicalConnection.getSystemPropertyDateZeroTimeExtra("false");
            boolean bl2 = sVal.equalsIgnoreCase("true");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleDriver.class, $$$methodRef$$$26, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDriver.class, $$$methodRef$$$26, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDriver.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.PLATFORM})
    public static ExecutorService getExecutorService() throws SQLException {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleDriver.class, $$$methodRef$$$27, null, new Object[0]);
            }
            ExecutorService executorService = threadPool;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleDriver.class, $$$methodRef$$$27, null, executorService);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDriver.class, $$$methodRef$$$27, null, null);
            }
            return executorService;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDriver.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    @Supports(value={Feature.PLATFORM})
    public static void setExecutorService(ExecutorService executorService) throws SQLException {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            ExecutorService pool;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleDriver.class, $$$methodRef$$$28, null, executorService);
            }
            if (threadPool != null) {
                threadPool.shutdownNow();
            }
            threadPool = pool;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleDriver.class, $$$methodRef$$$28, null);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDriver.class, $$$methodRef$$$28, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDriver.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Supports(value={Feature.PLATFORM})
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleDriver.class, $$$methodRef$$$29, this, new Object[0]);
            }
            Logger logger = Logger.getLogger(oracle_string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleDriver.class, $$$methodRef$$$29, this, logger);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDriver.class, $$$methodRef$$$29, this, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDriver.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleDriver.class, $$$methodRef$$$30, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleDriver.class, $$$methodRef$$$30, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDriver.class, $$$methodRef$$$30, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDriver.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$32 = OracleDriver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleDriver.class.getDeclaredMethod("lambda$_INTERNAL_ORACLE_connectAsync$0", Integer.TYPE, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleDriver.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleDriver.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleDriver.class.getDeclaredMethod("setExecutorService", ExecutorService.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleDriver.class.getDeclaredMethod("getExecutorService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleDriver.class.getDeclaredMethod("getSystemPropertyDateZeroTimeExtra", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleDriver.class.getDeclaredMethod("getSystemPropertyDateZeroTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleDriver.class.getDeclaredMethod("getSystemPropertyFastConnectionFailover", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleDriver.class.getDeclaredMethod("getCompileTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleDriver.class.getDeclaredMethod("processSqlEscapes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleDriver.class.getDeclaredMethod("jdbcCompliant", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleDriver.class.getDeclaredMethod("getMinorVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleDriver.class.getDeclaredMethod("getMajorVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleDriver.class.getDeclaredMethod("getPropertyInfo", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleDriver.class.getDeclaredMethod("acceptsURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleDriver.class.getDeclaredMethod("oracleDriverExtensionTypeFromURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleDriver.class.getDeclaredMethod("defaultConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleDriver.class.getDeclaredMethod("babelfishConnect", Properties.class, String.class, String.class, OracleDriverExtension.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleDriver.class.getDeclaredMethod("setConnectionProtocolID", Connection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleDriver.class.getDeclaredMethod("getTranslationProfile", Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleDriver.class.getDeclaredMethod("ensureSingleRegisteredDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleDriver.class.getDeclaredMethod("resolveNonSimpleURL", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleDriver.class.getDeclaredMethod("getDriverExtension", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleDriver.class.getDeclaredMethod("isType4ExtensionType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDriver.class.getDeclaredMethod("ensureGSSCredentialSupport", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDriver.class.getDeclaredMethod("parseExtensionType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDriver.class.getDeclaredMethod("convertServerSideDefaultURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDriver.class.getDeclaredMethod("_INTERNAL_ORACLE_connectAsync", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDriver.class.getDeclaredMethod("connect", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDriver.class.getDeclaredMethod("connect", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDriver.class.getDeclaredMethod("deregister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDriver.class.getDeclaredMethod("unRegisterMBeans", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
        defaultConn = null;
        DEFAULT_CONN_MONITOR = Monitor.newInstance();
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver, OracleDriver::deregister);
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            Timestamp timestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (SQLException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", ex);
        }
        catch (RuntimeException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", ex);
        }
        try {
            OraclePKIProvider ex = new OraclePKIProvider();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        systemTypeMap = new Hashtable(2);
        try {
            systemTypeMap.put("SYS.ANYDATA", Class.forName("oracle.sql.AnyDataFactory"));
            systemTypeMap.put("SYS.ANYTYPE", Class.forName("oracle.sql.TypeDescriptorFactory"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        DEFAULT_CONNECTION_PROPERTIES = new Properties();
        try {
            InputStream in = PhysicalConnection.class.getResourceAsStream(DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME);
            if (in != null) {
                DEFAULT_CONNECTION_PROPERTIES.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
            private static final String THREAD_NAME_PREFIX = "OJDBC-WORKER-THREAD-";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable r2) {
                Thread newT = new Thread(null, r2, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                newT.setPriority(5);
                newT.setDaemon(true);
                return newT;
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH = SERVER_SIDE_DEFAULT_URL_PREFIX.length();
        diagnosticMBeanObjectName = null;
    }
}

