/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.ExecutionContext;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.CancelLock;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.GeneratedStatement;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlBooleanAccessor;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.ReadOnlyByteArray;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.driver.Wrappable;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;

@Supports(value={Feature.SQL_EXECUTION, Feature.COLUMN_GET, Feature.RESULT_FETCH})
@DefaultLogger(value="oracle.jdbc")
abstract class OracleStatement
extends GeneratedStatement
implements oracle.jdbc.internal.OracleStatement,
Wrappable<OracleStatementWrapper> {
    private static final int DEFAULT_ROW_PREFETCH_SIZE;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    int[] returnParamMeta;
    byte[] shardingKeyRpnTokens;
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final int METADATALENGTH = 1;
    static final int VALID_ROWS_UNINIT = -999;
    static final long VALID_ROWS_STREAM = -2L;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
    static final String SYS_ODCIVARCHAR2LIST = "SYS.ODCIVARCHAR2LIST";
    static final OracleResultSet.ResultSetType DEFAULT_RESULT_SET_TYPE;
    boolean closed;
    protected boolean isAllFetched;
    int cursorId;
    int refCursorRowNumber;
    ByteArray rowData;
    ByteArray bindData;
    boolean bindUseDBA;
    long[] bindDataOffsets;
    int[] bindDataLengths;
    long beyondBindData;
    int[] parameterMaxLength;
    int numberOfDefinePositions;
    int definesBatchSize;
    boolean described;
    boolean describedWithNames;
    boolean executeDoneForDefines;
    protected FetchMode fetchMode;
    protected long indexOfFirstRow;
    long rowsProcessed;
    protected long validRows;
    protected int storedRowCount;
    protected int currentCapacity;
    private int numberOfUserColumns;
    boolean isStreaming;
    boolean isFetchStreams;
    OracleStatement children;
    OracleStatement parent;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    int bindDBAOffset;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    Object[][] userStream;
    int firstRowInBatch;
    boolean hasIbtBind;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    OracleInputStream nextStream;
    OracleResultSet currentResultSet;
    ArrayDeque<OracleStatement> implicitResultSetStatements;
    ArrayDeque<OracleResultSet> openImplicitResultSets;
    Iterator<OracleStatement> implicitResultSetIterator;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int maxFieldSize;
    long maxRows;
    int batch;
    boolean batchWasExecuted;
    int numberOfExecutedElementsInBatch;
    int[] indexOfFailedElementsInBatch;
    int currentRank;
    boolean bsendBatchInProgress;
    long[] batchRowsUpdatedArray;
    int rowPrefetch;
    int rowPrefetchInLastFetch;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    int defaultLobPrefetchSize;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    boolean gotLastBatch;
    boolean clearParameters;
    OracleStatement.SqlKind sqlKind;
    byte sqlKindByte;
    boolean serverCursor;
    boolean fixedString;
    boolean noMoreUpdateCounts;
    protected CancelLock cancelLock;
    OracleStatementWrapper wrapper;
    byte executionType;
    OracleResultSet.ResultSetType userRsetType;
    OracleResultSet.ResultSetType realRsetType;
    boolean isRowidPrepended;
    SQLWarning sqlWarning;
    int cacheState;
    int creationState;
    boolean isOpen;
    int statementType;
    boolean columnSetNull;
    boolean isDmlReturning;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone;
    String defaultTimeZoneName;
    Calendar defaultCalendar;
    Calendar gmtCalendar;
    long inScn;
    OraclePreparedStatement refreshStatement;
    protected ResultSetCacheEntry cachedQueryResult;
    boolean resultFromCache;
    protected QueryCacheState queryCacheState;
    private static int COLUMN_NAME_CACHE_INITIAL_SIZE;
    private IdentityHashMap<String, Integer> columnNameCache;
    static int GLOBAL_STATEMENT_NUMBER;
    DMSFactory.DMSState dmsSqlText;
    DMSFactory.DMSPhase dmsExecute;
    DMSFactory.DMSPhase dmsFetch;
    ByteBuffer[] nioBuffers;
    Object[] lobPrefetchMetaData;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch;
    int[] definedColumnType;
    int[] definedColumnSize;
    int[] definedColumnFormOfUse;
    T4CTTIoac[] oacdefSent;
    int[] nbPostPonedColumns;
    int[][] indexOfPostPonedColumn;
    boolean aFetchWasDoneDuringDescribe;
    boolean implicitDefineForLobPrefetchDone;
    long checkSum;
    boolean checkSumComputationFailure;
    Vector<String> m_batchItems;
    ArrayList<CLOB> tempStmtClobsToFree;
    ArrayList<BLOB> tempStmtBlobsToFree;
    ArrayList<CLOB> oldTempClobsToFree;
    ArrayList<BLOB> oldTempBlobsToFree;
    ArrayList<CLOB> tempRowClobsToFree;
    ArrayList<BLOB> tempRowBlobsToFree;
    NTFDCNRegistration registration;
    String[] dcnTableName;
    long dcnQueryId;
    long localCheckSum;
    OracleStatement.BindChecksumListener bindChecksumListener;
    boolean isCloseOnCompletion;
    protected Object acProxy;
    private byte[] querycacheCompileKey;
    private long queryId;
    byte[] runtimeKey;
    MessageDigest md;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;
    private static Executable $$$methodRef$$$147;
    private static Logger $$$loggerRef$$$147;
    private static Executable $$$methodRef$$$148;
    private static Logger $$$loggerRef$$$148;
    private static Executable $$$methodRef$$$149;
    private static Logger $$$loggerRef$$$149;
    private static Executable $$$methodRef$$$150;
    private static Logger $$$loggerRef$$$150;
    private static Executable $$$methodRef$$$151;
    private static Logger $$$loggerRef$$$151;
    private static Executable $$$methodRef$$$152;
    private static Logger $$$loggerRef$$$152;
    private static Executable $$$methodRef$$$153;
    private static Logger $$$loggerRef$$$153;
    private static Executable $$$methodRef$$$154;
    private static Logger $$$loggerRef$$$154;
    private static Executable $$$methodRef$$$155;
    private static Logger $$$loggerRef$$$155;
    private static Executable $$$methodRef$$$156;
    private static Logger $$$loggerRef$$$156;
    private static Executable $$$methodRef$$$157;
    private static Logger $$$loggerRef$$$157;
    private static Executable $$$methodRef$$$158;
    private static Logger $$$loggerRef$$$158;
    private static Executable $$$methodRef$$$159;
    private static Logger $$$loggerRef$$$159;
    private static Executable $$$methodRef$$$160;
    private static Logger $$$loggerRef$$$160;
    private static Executable $$$methodRef$$$161;
    private static Logger $$$loggerRef$$$161;
    private static Executable $$$methodRef$$$162;
    private static Logger $$$loggerRef$$$162;
    private static Executable $$$methodRef$$$163;
    private static Logger $$$loggerRef$$$163;
    private static Executable $$$methodRef$$$164;
    private static Logger $$$loggerRef$$$164;
    private static Executable $$$methodRef$$$165;
    private static Logger $$$loggerRef$$$165;
    private static Executable $$$methodRef$$$166;
    private static Logger $$$loggerRef$$$166;
    private static Executable $$$methodRef$$$167;
    private static Logger $$$loggerRef$$$167;
    private static Executable $$$methodRef$$$168;
    private static Logger $$$loggerRef$$$168;
    private static Executable $$$methodRef$$$169;
    private static Logger $$$loggerRef$$$169;
    private static Executable $$$methodRef$$$170;
    private static Logger $$$loggerRef$$$170;
    private static Executable $$$methodRef$$$171;
    private static Logger $$$loggerRef$$$171;
    private static Executable $$$methodRef$$$172;
    private static Logger $$$loggerRef$$$172;
    private static Executable $$$methodRef$$$173;
    private static Logger $$$loggerRef$$$173;
    private static Executable $$$methodRef$$$174;
    private static Logger $$$loggerRef$$$174;
    private static Executable $$$methodRef$$$175;
    private static Logger $$$loggerRef$$$175;
    private static Executable $$$methodRef$$$176;
    private static Logger $$$loggerRef$$$176;
    private static Executable $$$methodRef$$$177;
    private static Logger $$$loggerRef$$$177;
    private static Executable $$$methodRef$$$178;
    private static Logger $$$loggerRef$$$178;
    private static Executable $$$methodRef$$$179;
    private static Logger $$$loggerRef$$$179;
    private static Executable $$$methodRef$$$180;
    private static Logger $$$loggerRef$$$180;
    private static Executable $$$methodRef$$$181;
    private static Logger $$$loggerRef$$$181;
    private static Executable $$$methodRef$$$182;
    private static Logger $$$loggerRef$$$182;
    private static Executable $$$methodRef$$$183;
    private static Logger $$$loggerRef$$$183;
    private static Executable $$$methodRef$$$184;
    private static Logger $$$loggerRef$$$184;
    private static Executable $$$methodRef$$$185;
    private static Logger $$$loggerRef$$$185;
    private static Executable $$$methodRef$$$186;
    private static Logger $$$loggerRef$$$186;
    private static Executable $$$methodRef$$$187;
    private static Logger $$$loggerRef$$$187;
    private static Executable $$$methodRef$$$188;
    private static Logger $$$loggerRef$$$188;
    private static Executable $$$methodRef$$$189;
    private static Logger $$$loggerRef$$$189;
    private static Executable $$$methodRef$$$190;
    private static Logger $$$loggerRef$$$190;
    private static Executable $$$methodRef$$$191;
    private static Logger $$$loggerRef$$$191;
    private static Executable $$$methodRef$$$192;
    private static Logger $$$loggerRef$$$192;
    private static Executable $$$methodRef$$$193;
    private static Logger $$$loggerRef$$$193;
    private static Executable $$$methodRef$$$194;
    private static Logger $$$loggerRef$$$194;
    private static Executable $$$methodRef$$$195;
    private static Logger $$$loggerRef$$$195;
    private static Executable $$$methodRef$$$196;
    private static Logger $$$loggerRef$$$196;
    private static Executable $$$methodRef$$$197;
    private static Logger $$$loggerRef$$$197;
    private static Executable $$$methodRef$$$198;
    private static Logger $$$loggerRef$$$198;
    private static Executable $$$methodRef$$$199;
    private static Logger $$$loggerRef$$$199;
    private static Executable $$$methodRef$$$200;
    private static Logger $$$loggerRef$$$200;
    private static Executable $$$methodRef$$$201;
    private static Logger $$$loggerRef$$$201;
    private static Executable $$$methodRef$$$202;
    private static Logger $$$loggerRef$$$202;
    private static Executable $$$methodRef$$$203;
    private static Logger $$$loggerRef$$$203;
    private static Executable $$$methodRef$$$204;
    private static Logger $$$loggerRef$$$204;
    private static Executable $$$methodRef$$$205;
    private static Logger $$$loggerRef$$$205;
    private static Executable $$$methodRef$$$206;
    private static Logger $$$loggerRef$$$206;
    private static Executable $$$methodRef$$$207;
    private static Logger $$$loggerRef$$$207;
    private static Executable $$$methodRef$$$208;
    private static Logger $$$loggerRef$$$208;
    private static Executable $$$methodRef$$$209;
    private static Logger $$$loggerRef$$$209;
    private static Executable $$$methodRef$$$210;
    private static Logger $$$loggerRef$$$210;
    private static Executable $$$methodRef$$$211;
    private static Logger $$$loggerRef$$$211;
    private static Executable $$$methodRef$$$212;
    private static Logger $$$loggerRef$$$212;
    private static Executable $$$methodRef$$$213;
    private static Logger $$$loggerRef$$$213;
    private static Executable $$$methodRef$$$214;
    private static Logger $$$loggerRef$$$214;
    private static Executable $$$methodRef$$$215;
    private static Logger $$$loggerRef$$$215;
    private static Executable $$$methodRef$$$216;
    private static Logger $$$loggerRef$$$216;
    private static Executable $$$methodRef$$$217;
    private static Logger $$$loggerRef$$$217;
    private static Executable $$$methodRef$$$218;
    private static Logger $$$loggerRef$$$218;
    private static Executable $$$methodRef$$$219;
    private static Logger $$$loggerRef$$$219;
    private static Executable $$$methodRef$$$220;
    private static Logger $$$loggerRef$$$220;
    private static Executable $$$methodRef$$$221;
    private static Logger $$$loggerRef$$$221;
    private static Executable $$$methodRef$$$222;
    private static Logger $$$loggerRef$$$222;
    private static Executable $$$methodRef$$$223;
    private static Logger $$$loggerRef$$$223;
    private static Executable $$$methodRef$$$224;
    private static Logger $$$loggerRef$$$224;
    private static Executable $$$methodRef$$$225;
    private static Logger $$$loggerRef$$$225;
    private static Executable $$$methodRef$$$226;
    private static Logger $$$loggerRef$$$226;
    private static Executable $$$methodRef$$$227;
    private static Logger $$$loggerRef$$$227;
    private static Executable $$$methodRef$$$228;
    private static Logger $$$loggerRef$$$228;
    private static Executable $$$methodRef$$$229;
    private static Logger $$$loggerRef$$$229;
    private static Executable $$$methodRef$$$230;
    private static Logger $$$loggerRef$$$230;
    private static Executable $$$methodRef$$$231;
    private static Logger $$$loggerRef$$$231;
    private static Executable $$$methodRef$$$232;
    private static Logger $$$loggerRef$$$232;
    private static Executable $$$methodRef$$$233;
    private static Logger $$$loggerRef$$$233;
    private static Executable $$$methodRef$$$234;
    private static Logger $$$loggerRef$$$234;
    private static Executable $$$methodRef$$$235;
    private static Logger $$$loggerRef$$$235;
    private static Executable $$$methodRef$$$236;
    private static Logger $$$loggerRef$$$236;
    private static Executable $$$methodRef$$$237;
    private static Logger $$$loggerRef$$$237;
    private static Executable $$$methodRef$$$238;
    private static Logger $$$loggerRef$$$238;
    private static Executable $$$methodRef$$$239;
    private static Logger $$$loggerRef$$$239;
    private static Executable $$$methodRef$$$240;
    private static Logger $$$loggerRef$$$240;
    private static Executable $$$methodRef$$$241;
    private static Logger $$$loggerRef$$$241;
    private static Executable $$$methodRef$$$242;
    private static Logger $$$loggerRef$$$242;
    private static Executable $$$methodRef$$$243;
    private static Logger $$$loggerRef$$$243;
    private static Executable $$$methodRef$$$244;
    private static Logger $$$loggerRef$$$244;
    private static Executable $$$methodRef$$$245;
    private static Logger $$$loggerRef$$$245;
    private static Executable $$$methodRef$$$246;
    private static Logger $$$loggerRef$$$246;
    private static Executable $$$methodRef$$$247;
    private static Logger $$$loggerRef$$$247;
    private static Executable $$$methodRef$$$248;
    private static Logger $$$loggerRef$$$248;
    private static Executable $$$methodRef$$$249;
    private static Logger $$$loggerRef$$$249;
    private static Executable $$$methodRef$$$250;
    private static Logger $$$loggerRef$$$250;
    private static Executable $$$methodRef$$$251;
    private static Logger $$$loggerRef$$$251;
    private static Executable $$$methodRef$$$252;
    private static Logger $$$loggerRef$$$252;
    private static Executable $$$methodRef$$$253;
    private static Logger $$$loggerRef$$$253;
    private static Executable $$$methodRef$$$254;
    private static Logger $$$loggerRef$$$254;
    private static Executable $$$methodRef$$$255;
    private static Logger $$$loggerRef$$$255;
    private static Executable $$$methodRef$$$256;
    private static Logger $$$loggerRef$$$256;
    private static Executable $$$methodRef$$$257;
    private static Logger $$$loggerRef$$$257;
    private static Executable $$$methodRef$$$258;
    private static Logger $$$loggerRef$$$258;
    private static Executable $$$methodRef$$$259;
    private static Logger $$$loggerRef$$$259;
    private static Executable $$$methodRef$$$260;
    private static Logger $$$loggerRef$$$260;
    private static Executable $$$methodRef$$$261;
    private static Logger $$$loggerRef$$$261;
    private static Executable $$$methodRef$$$262;
    private static Logger $$$loggerRef$$$262;
    private static Executable $$$methodRef$$$263;
    private static Logger $$$loggerRef$$$263;
    private static Executable $$$methodRef$$$264;
    private static Logger $$$loggerRef$$$264;
    private static Executable $$$methodRef$$$265;
    private static Logger $$$loggerRef$$$265;
    private static Executable $$$methodRef$$$266;
    private static Logger $$$loggerRef$$$266;
    private static Executable $$$methodRef$$$267;
    private static Logger $$$loggerRef$$$267;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForDescribeAsync(Consumer<Throwable> var1);

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void executeForRowsAsync(boolean var1, Consumer<Throwable> var2);

    protected abstract void fetch(int var1, boolean var2) throws SQLException;

    protected abstract void fetchAsync(int var1, boolean var2, Consumer<Throwable> var3);

    abstract boolean isFetchAsyncSupported();

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    public int cursorIfRefCursor() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleStatement.class, $$$methodRef$$$0, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleStatement.class, $$$methodRef$$$0, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleStatement.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void continueReadRow(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleStatement.class, $$$methodRef$$$1, this, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleStatement.class, $$$methodRef$$$1, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleStatement.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    void closeCursorOnPlainStatement() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleStatement.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleStatement.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleStatement.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleStatement.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind sqlKind) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleStatement.SqlKind kind;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleStatement.class, $$$methodRef$$$3, null, new Object[]{sqlKind});
            }
            byte by = kind.getKind();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleStatement.class, $$$methodRef$$$3, null, by);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleStatement.class, $$$methodRef$$$3, null, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleStatement.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte by) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            byte kind;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleStatement.class, $$$methodRef$$$4, null, by);
            }
            OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.valueOf(kind);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleStatement.class, $$$methodRef$$$4, null, (Object)sqlKind);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleStatement.class, $$$methodRef$$$4, null, null);
            }
            return sqlKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleStatement.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleStatement(PhysicalConnection conn, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, batchValue, rowPrefetchValue, -1, -1);
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$265, Level.FINEST, OracleStatement.class, $$$methodRef$$$265, null, conn, batchValue, rowPrefetchValue);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$265, Level.FINEST, OracleStatement.class, $$$methodRef$$$265, null);
                ClioSupport.exiting($$$loggerRef$$$265, Level.FINEST, OracleStatement.class, $$$methodRef$$$265, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$265, Level.FINEST, OracleStatement.class, $$$methodRef$$$265, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleStatement(PhysicalConnection conn, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn);
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$266, Level.FINEST, OracleStatement.class, $$$methodRef$$$266, null, conn, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
            }
            this.rowData = null;
            this.bindData = null;
            this.bindUseDBA = false;
            this.bindDataOffsets = null;
            this.bindDataLengths = null;
            this.beyondBindData = 0L;
            this.parameterMaxLength = null;
            this.described = false;
            this.describedWithNames = false;
            this.executeDoneForDefines = false;
            this.fetchMode = FetchMode.OVERWRITE;
            this.indexOfFirstRow = 0L;
            this.currentCapacity = -1;
            this.numberOfUserColumns = -1;
            this.children = null;
            this.parent = null;
            this.nextChild = null;
            this.hasIbtBind = false;
            this.implicitResultSetStatements = null;
            this.openImplicitResultSets = null;
            this.implicitResultSetIterator = null;
            this.batchWasExecuted = false;
            this.numberOfExecutedElementsInBatch = -1;
            this.indexOfFailedElementsInBatch = null;
            this.bsendBatchInProgress = false;
            this.rowPrefetchInLastFetch = -1;
            this.sqlKind = OracleStatement.SqlKind.SELECT;
            this.sqlKindByte = 1;
            this.fixedString = false;
            this.noMoreUpdateCounts = false;
            this.cancelLock = new CancelLock(this);
            this.executionType = (byte)-1;
            this.isRowidPrepended = false;
            this.cacheState = 3;
            this.creationState = 0;
            this.isOpen = false;
            this.statementType = 0;
            this.columnSetNull = false;
            this.isDmlReturning = false;
            this.defaultTimeZone = null;
            this.defaultTimeZoneName = null;
            this.defaultCalendar = null;
            this.gmtCalendar = null;
            this.inScn = 0L;
            this.refreshStatement = null;
            this.cachedQueryResult = null;
            this.resultFromCache = false;
            this.queryCacheState = QueryCacheState.UNKNOWN;
            this.columnNameCache = new IdentityHashMap(COLUMN_NAME_CACHE_INITIAL_SIZE);
            this.dmsSqlText = null;
            this.dmsExecute = null;
            this.dmsFetch = null;
            this.nioBuffers = null;
            this.lobPrefetchMetaData = null;
            this.sizeTmpByteArray = 0;
            this.needToSendOalToFetch = false;
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            this.oacdefSent = null;
            this.nbPostPonedColumns = null;
            this.indexOfPostPonedColumn = null;
            this.aFetchWasDoneDuringDescribe = false;
            this.implicitDefineForLobPrefetchDone = false;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.m_batchItems = null;
            this.tempStmtClobsToFree = null;
            this.tempStmtBlobsToFree = null;
            this.oldTempClobsToFree = null;
            this.oldTempBlobsToFree = null;
            this.tempRowClobsToFree = new ArrayList();
            this.tempRowBlobsToFree = new ArrayList();
            this.registration = null;
            this.dcnTableName = null;
            this.dcnQueryId = -1L;
            this.localCheckSum = 0L;
            this.isCloseOnCompletion = false;
            this.runtimeKey = null;
            this.md = null;
            this.initStatement(batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur, conn.useFetchSizeWithLongColumn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$266, Level.FINEST, OracleStatement.class, $$$methodRef$$$266, null);
                ClioSupport.exiting($$$loggerRef$$$266, Level.FINEST, OracleStatement.class, $$$methodRef$$$266, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$266, Level.FINEST, OracleStatement.class, $$$methodRef$$$266, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleStatement(PhysicalConnection conn, @Blind(value=PropertiesBlinder.class) Properties stmtProps) throws SQLException {
        super(conn);
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$267, Level.FINEST, OracleStatement.class, $$$methodRef$$$267, null, conn, TraceControllerImpl.blind(PropertiesBlinder.class, stmtProps));
            }
            this.rowData = null;
            this.bindData = null;
            this.bindUseDBA = false;
            this.bindDataOffsets = null;
            this.bindDataLengths = null;
            this.beyondBindData = 0L;
            this.parameterMaxLength = null;
            this.described = false;
            this.describedWithNames = false;
            this.executeDoneForDefines = false;
            this.fetchMode = FetchMode.OVERWRITE;
            this.indexOfFirstRow = 0L;
            this.currentCapacity = -1;
            this.numberOfUserColumns = -1;
            this.children = null;
            this.parent = null;
            this.nextChild = null;
            this.hasIbtBind = false;
            this.implicitResultSetStatements = null;
            this.openImplicitResultSets = null;
            this.implicitResultSetIterator = null;
            this.batchWasExecuted = false;
            this.numberOfExecutedElementsInBatch = -1;
            this.indexOfFailedElementsInBatch = null;
            this.bsendBatchInProgress = false;
            this.rowPrefetchInLastFetch = -1;
            this.sqlKind = OracleStatement.SqlKind.SELECT;
            this.sqlKindByte = 1;
            this.fixedString = false;
            this.noMoreUpdateCounts = false;
            this.cancelLock = new CancelLock(this);
            this.executionType = (byte)-1;
            this.isRowidPrepended = false;
            this.cacheState = 3;
            this.creationState = 0;
            this.isOpen = false;
            this.statementType = 0;
            this.columnSetNull = false;
            this.isDmlReturning = false;
            this.defaultTimeZone = null;
            this.defaultTimeZoneName = null;
            this.defaultCalendar = null;
            this.gmtCalendar = null;
            this.inScn = 0L;
            this.refreshStatement = null;
            this.cachedQueryResult = null;
            this.resultFromCache = false;
            this.queryCacheState = QueryCacheState.UNKNOWN;
            this.columnNameCache = new IdentityHashMap(COLUMN_NAME_CACHE_INITIAL_SIZE);
            this.dmsSqlText = null;
            this.dmsExecute = null;
            this.dmsFetch = null;
            this.nioBuffers = null;
            this.lobPrefetchMetaData = null;
            this.sizeTmpByteArray = 0;
            this.needToSendOalToFetch = false;
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            this.oacdefSent = null;
            this.nbPostPonedColumns = null;
            this.indexOfPostPonedColumn = null;
            this.aFetchWasDoneDuringDescribe = false;
            this.implicitDefineForLobPrefetchDone = false;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.m_batchItems = null;
            this.tempStmtClobsToFree = null;
            this.tempStmtBlobsToFree = null;
            this.oldTempClobsToFree = null;
            this.oldTempBlobsToFree = null;
            this.tempRowClobsToFree = new ArrayList();
            this.tempRowBlobsToFree = new ArrayList();
            this.registration = null;
            this.dcnTableName = null;
            this.dcnQueryId = -1L;
            this.localCheckSum = 0L;
            this.isCloseOnCompletion = false;
            this.runtimeKey = null;
            this.md = null;
            int batch_value = conn.defaultExecuteBatch;
            int row_prefetch_value = conn.defaultRowPrefetch;
            boolean useFetchLong = conn.useFetchSizeWithLongColumn;
            int UserResultSetType = -1;
            int UserResultSetConcur = -1;
            if (stmtProps != null) {
                String tProp = stmtProps.getProperty("result_set_type");
                if (tProp != null) {
                    UserResultSetType = Integer.parseInt(tProp);
                }
                if ((tProp = stmtProps.getProperty("result_set_concurrency")) != null) {
                    UserResultSetConcur = Integer.parseInt(tProp);
                }
                if ((tProp = stmtProps.getProperty("use_long_fetch")) != null) {
                    boolean bl2 = useFetchLong = tProp.compareToIgnoreCase("true") == 0;
                }
                if ((tProp = stmtProps.getProperty("execute_batch")) != null) {
                    batch_value = Integer.parseInt(tProp);
                }
                if ((tProp = stmtProps.getProperty("row_prefetch")) != null) {
                    row_prefetch_value = Integer.parseInt(tProp);
                }
            }
            this.initStatement(batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur, useFetchLong);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$267, Level.FINEST, OracleStatement.class, $$$methodRef$$$267, null);
                ClioSupport.exiting($$$loggerRef$$$267, Level.FINEST, OracleStatement.class, $$$methodRef$$$267, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$267, Level.FINEST, OracleStatement.class, $$$methodRef$$$267, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initStatement(int n2, int n3, int n4, int n5, boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void useFetchLong;
            void UserResultSetConcur;
            void UserResultSetType;
            void batch_value;
            void row_prefetch_value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleStatement.class, $$$methodRef$$$5, this, n2, n3, n4, n5, bl);
            }
            this.connection.needLine();
            this.sqlObject = new OracleSql(this.connection.conversion);
            this.processEscapes = this.connection.processEscapes;
            this.convertNcharLiterals = this.connection.convertNcharLiterals;
            this.gotLastBatch = false;
            this.closed = false;
            this.clearParameters = true;
            this.serverCursor = this.connection.getCreateStatementAsRefCursor();
            this.fixedString = this.connection.getDefaultFixedString();
            this.rowPrefetchChanged = false;
            this.currentCapacity = this.rowPrefetch = row_prefetch_value;
            this.defaultRowPrefetch = row_prefetch_value;
            this.batch = batch_value;
            this.userRsetType = OracleResultSet.ResultSetType.typeFor((int)UserResultSetType, (int)UserResultSetConcur);
            if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
                this.userRsetType = DEFAULT_RESULT_SET_TYPE;
                this.realRsetType = DEFAULT_RESULT_SET_TYPE;
            } else {
                this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
            }
            this.isFetchStreams = useFetchLong != false || this.userRsetType != DEFAULT_RESULT_SET_TYPE;
            this.defaultLobPrefetchSize = this.connection.getVersionNumber() >= 11000 ? this.connection.defaultLobPrefetchSize : -1;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            this.configureRowData();
            this.connection.addStatement(this);
            this.createDMSSensors();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleStatement.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleStatement.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleStatement.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWrapper(OracleStatementWrapper oracleStatementWrapper) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void w2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleStatement.class, $$$methodRef$$$6, this, oracleStatementWrapper);
            }
            this.wrapper = w2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleStatement.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleStatement.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleStatement.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSnapshotSCN(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void scn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleStatement.class, $$$methodRef$$$7, this, l2);
            }
            this.connection.isResultSetCacheEnabled = false;
            this.doSetSnapshotSCN((long)scn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleStatement.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleStatement.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleStatement.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    void doSetSnapshotSCN(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleStatement.class, $$$methodRef$$$8, this, l2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doSetSnapshotSCN").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleStatement.class, $$$methodRef$$$8, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleStatement.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    void createDMSSensors() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleStatement.class, $$$methodRef$$$9, this, new Object[0]);
            }
            this.dmsSqlText = this.connection.commonDmsSqlText;
            if (this.connection.dmsUpdateSqlText()) {
                this.dmsSqlText.update(this.sqlObject.toString());
            }
            this.dmsExecute = this.connection.commonDmsExecute;
            this.dmsFetch = this.connection.commonDmsFetch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleStatement.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleStatement.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleStatement.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    void destroyDMSSensors() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleStatement.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.dmsSqlText != null && this.dmsSqlText != this.connection.commonDmsSqlText) {
                this.dmsSqlText.destroy();
                this.dmsSqlText = null;
            }
            if (this.dmsExecute != null && this.dmsExecute != this.connection.commonDmsExecute) {
                this.dmsExecute.destroy();
                this.dmsExecute = null;
            }
            if (this.dmsFetch != null && this.dmsFetch != this.connection.commonDmsFetch) {
                this.dmsFetch.destroy();
                this.dmsFetch = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleStatement.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleStatement.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleStatement.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    protected abstract void configureRowData();

    void prepareAccessors() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int preFetchSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.accessors == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this, sQLException);
                }
                throw sQLException;
            }
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                switch (accessor.internalType) {
                    case 8: 
                    case 24: {
                        this.hasStream = true;
                    }
                }
            }
            if (this.streamList != null && !this.isFetchStreams) {
                this.rowPrefetch = 1;
            }
            this.definesBatchSize = preFetchSize = this.rowPrefetch;
            for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                Accessor accessor = this.accessors[i3];
                accessor.setCapacity(preFetchSize);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "return rowPrefetch = " + this.rowPrefetch + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleStatement.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean checkAccessorsUsable() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if ((len = this.accessors.length) < this.numberOfDefinePositions) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, null);
                }
                return false;
            }
            boolean allHaveExternalType = true;
            boolean anyHaveExternalType = false;
            boolean result = false;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null || accessor.externalType == 0) {
                    allHaveExternalType = false;
                    continue;
                }
                anyHaveExternalType = true;
            }
            if (allHaveExternalType) {
                result = true;
            } else {
                if (anyHaveExternalType) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, sQLException);
                    }
                    throw sQLException;
                }
                this.columnsDefinedByUser = false;
            }
            boolean bl3 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleStatement.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    void executeMaybeDescribe() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$13, Level.FINEST, this.getClass(), $$$methodRef$$$13, "rowPrefetchChanged = " + this.rowPrefetchChanged + ", needToParse = " + this.needToParse + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + ", columnsDefinedByUser = " + this.columnsDefinedByUser);
            }
            boolean needExplicitFetch = true;
            this.needToPrepareDefineBuffer = !this.isDefineBufferPreparedForExecute();
            this.rowPrefetchChanged = false;
            try {
                this.cancelLock.enterExecuting();
                if (this.needToPrepareDefineBuffer) {
                    this.prepareDefineBufferAndExecute();
                } else {
                    this.markDanglingAccessors();
                    this.executeForRows(false);
                }
                this.handleExecuteMaybeDescribeCompletion();
                this.cancelLock.exitExecuting();
            }
            catch (SQLException ea) {
                try {
                    this.needToParse = true;
                    SQLException sQLException = ea;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    this.cancelLock.exitExecuting();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$13, Level.FINEST, this.getClass(), $$$methodRef$$$13, "validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + " ");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleStatement.class, $$$methodRef$$$13, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeMaybeDescribeAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this, consumer);
            }
            try {
                this.needToPrepareDefineBuffer = !this.isDefineBufferPreparedForExecute();
                this.rowPrefetchChanged = false;
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this, null);
                }
                return;
            }
            Consumer<Throwable> executeCallback = arg_0 -> this.lambda$executeMaybeDescribeAsync$0((Consumer)callback, arg_0);
            this.cancelLock.enterExecuting();
            if (this.needToPrepareDefineBuffer) {
                this.prepareDefineBufferAndExecuteAsync(executeCallback);
            } else {
                this.markDanglingAccessors();
                this.executeForRowsAsync(false, executeCallback);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleStatement.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    private final boolean isDefineBufferPreparedForExecute() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (this.needToPrepareDefineBuffer) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, null);
                }
                return false;
            }
            if (this.rowPrefetchChanged && this.streamList == null && this.rowPrefetch > this.definesBatchSize) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, null);
                }
                return false;
            }
            if (this.accessors == null) {
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, null);
                }
                return false;
            }
            if (this.columnsDefinedByUser) {
                boolean bl5 = this.checkAccessorsUsable();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, bl5);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, null);
                }
                return bl5;
            }
            boolean bl6 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, bl6);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleStatement.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void prepareDefineBufferAndExecute() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleStatement.class, $$$methodRef$$$16, this, new Object[0]);
            }
            boolean executed_for_describe = false;
            boolean needExplicitFetch = true;
            if (!this.columnsDefinedByUser) {
                this.executeForDescribe();
                executed_for_describe = true;
                boolean bl2 = needExplicitFetch = !this.aFetchWasDoneDuringDescribe;
            }
            if (this.needToPrepareDefineBuffer) {
                this.prepareAccessors();
            }
            this.markDanglingAccessors();
            if (needExplicitFetch) {
                this.executeForRows(executed_for_describe);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleStatement.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleStatement.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleStatement.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareDefineBufferAndExecuteAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleStatement.class, $$$methodRef$$$17, this, consumer);
            }
            boolean executedForDescribe = !this.columnsDefinedByUser;
            Consumer<Throwable> describeCallback = arg_0 -> this.lambda$prepareDefineBufferAndExecuteAsync$1(executedForDescribe, (Consumer)callback, arg_0);
            if (executedForDescribe) {
                this.executeForDescribeAsync(describeCallback);
            } else {
                describeCallback.accept(null);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleStatement.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleStatement.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleStatement.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void markDanglingAccessors() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleStatement.class, $$$methodRef$$$18, this, new Object[0]);
            }
            int len = this.accessors.length;
            for (int i2 = this.numberOfDefinePositions; i2 < len; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleStatement.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleStatement.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleStatement.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void handleExecuteMaybeDescribeCompletion() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleStatement.class, $$$methodRef$$$19, this, new Object[0]);
            }
            this.currentCapacity = this.rowPrefetch;
            this.storedRowCount = this.validRows == -2L ? 1 : (int)this.validRows;
            this.indexOfFirstRow = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleStatement.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleStatement.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleStatement.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    void adjustGotLastBatch() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleStatement.class, $$$methodRef$$$20, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$20, Level.FINEST, this.getClass(), $$$methodRef$$$20, "do nothing");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleStatement.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleStatement.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleStatement.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract void locationToPutBytes(Accessor var1, int var2, int var3) throws SQLException;

    protected boolean isQueryResultCached() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleStatement.class, $$$methodRef$$$21, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleStatement.class, $$$methodRef$$$21, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleStatement.class, $$$methodRef$$$21, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleStatement.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void cacheQueryResultIfAppropriate() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleStatement.class, $$$methodRef$$$22, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleStatement.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleStatement.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleStatement.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void useCachedQueryResult() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleStatement.class, $$$methodRef$$$23, this, new Object[0]);
            }
            this.rowData.free();
            this.rowData = this.cachedQueryResult.getRowData();
            this.accessors = this.cachedQueryResult.newAccessors(this);
            this.storedRowCount = this.cachedQueryResult.getNumberOfRows();
            this.validRows = this.cachedQueryResult.getNumberOfRows();
            this.cachedQueryResult = null;
            this.isAllFetched = true;
            this.resultFromCache = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleStatement.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleStatement.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleStatement.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    private void logSQL(Logger logger, String sql) {
        if (logger == null || sql == null) {
            return;
        }
        logger.log(Level.CONFIG, Integer.toHexString(this.hashCode()).toUpperCase() + " SQL: " + this.sqlObject.getOriginalSql());
    }

    void doExecuteWithTimeout() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this, new Object[0]);
            }
            this.prepareForExecuteWithTimeout();
            long startToken = this.prepareDmsForExecution();
            try {
                this.prepareDmsSystemForExecution();
                this.cleanOldTempLobs();
                this.rowsProcessed = 0L;
                if (this.sqlKind.isSELECT()) {
                    this.executeSQLSelect();
                } else {
                    this.executeSQLStatement();
                }
                this.updateDmsSystemAfterExecution();
                this.updateDmsAfterExecution(startToken);
            }
            catch (SQLException ea) {
                try {
                    this.connection.resetSystemContext();
                    this.resetOnExceptionDuringExecute();
                    SQLException sQLException = ea;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    this.updateDmsAfterExecution(startToken);
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$24, Level.FINEST, this.getClass(), $$$methodRef$$$24, "validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleStatement.class, $$$methodRef$$$24, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void doExecuteWithTimeoutAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this, consumer);
            }
            try {
                this.prepareForExecuteWithTimeout();
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this, null);
                }
                return;
            }
            long startToken = this.prepareDmsForExecution();
            try {
                this.prepareDmsSystemForExecution();
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this, null);
                }
                return;
            }
            this.cleanOldTempLobs();
            this.rowsProcessed = 0L;
            Consumer<Throwable> executeCallback = arg_0 -> this.lambda$doExecuteWithTimeoutAsync$2(startToken, (Consumer)callback, arg_0);
            if (this.sqlKind.isSELECT()) {
                this.executeSQLSelectAsync(executeCallback);
            } else {
                this.executeSQLStatementAsync(executeCallback);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleStatement.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void prepareForExecuteWithTimeout() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleStatement.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
            }
            if (bl) {
                this.logSQL($$$loggerRef$$$26, this.sqlObject.getOriginalSql());
            }
            if (this.sqlObject.isConnectionValidationSql()) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "========= Connection-validation SQL or PL/SQL, check whether to clean up conn: " + this.connection);
                }
                this.connection.checkAndDrain();
            }
            if (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
                this.realRsetType = this.userRsetType;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleStatement.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleStatement.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleStatement.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    private final long prepareDmsForExecution() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (this.dmsExecute != null) {
                long l2 = this.dmsExecute.start();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, l2);
                    ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, null);
                }
                return l2;
            }
            long l3 = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, l3);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, null);
            }
            return 0L;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleStatement.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDmsAfterExecution(long l2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleStatement.class, $$$methodRef$$$28, this, l2);
            }
            if (this.dmsExecute != null) {
                void startToken;
                this.dmsExecute.stop((long)startToken);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleStatement.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleStatement.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleStatement.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    private void prepareDmsSystemForExecution() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleStatement.class, $$$methodRef$$$29, this, new Object[0]);
            }
            this.connection.updateSystemContext();
            if (this.connection.dmsUpdateSqlText()) {
                this.dmsSqlText.update(this.sqlObject.toString());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleStatement.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleStatement.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleStatement.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    private void updateDmsSystemAfterExecution() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleStatement.class, $$$methodRef$$$30, this, new Object[0]);
            }
            if (this.connection.dmsVersion.equals((Object)DMSFactory.DMSVersion.v10G)) {
                ExecutionContext.get().setECIDSequenceNumber((int)this.connection.endToEndECIDSequenceNumber);
            } else if (this.connection.dmsVersion.equals((Object)DMSFactory.DMSVersion.v11)) {
                DMSFactory.Context.getECForJDBC().finished();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleStatement.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleStatement.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleStatement.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void executeSQLSelect() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            block12: {
                block11: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleStatement.class, $$$methodRef$$$31, this, new Object[0]);
                    }
                    if (this.connection.j2ee13Compliant) {
                        this.ensureJ2EE13ComplianceForSelectSQL();
                    }
                    if (!this.isQueryResultCached()) break block11;
                    this.useCachedQueryResult();
                    break block12;
                }
                if (this.rowData instanceof ReadOnlyByteArray) {
                    this.restoreRowDataFromBindData();
                }
                try {
                    this.prepareConnectionForExecution();
                    this.executeMaybeDescribe();
                }
                catch (Throwable throwable) {
                    this.resetConnectionAfterExecution();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, OracleStatement.class, $$$methodRef$$$31, this, throwable2);
                    }
                    throw throwable2;
                }
                this.resetConnectionAfterExecution();
                this.handleExecuteSQLSelectCompletion();
            }
            if (this.serverCursor) {
                this.adjustGotLastBatch();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleStatement.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleStatement.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleStatement.class, $$$methodRef$$$31, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeSQLSelectAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            block15: {
                block16: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, consumer);
                    }
                    try {
                        if (this.connection.j2ee13Compliant) {
                            this.ensureJ2EE13ComplianceForSelectSQL();
                        }
                        if (!this.isQueryResultCached()) break block15;
                        this.useCachedQueryResult();
                        if (this.serverCursor) {
                            this.adjustGotLastBatch();
                        }
                        callback.accept(null);
                        if (!bl) break block16;
                    }
                    catch (SQLException preExecutionFailure) {
                        callback.accept(preExecutionFailure);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, null);
                        }
                        return;
                    }
                    ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this);
                    ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, null);
                }
                return;
            }
            if (this.rowData instanceof ReadOnlyByteArray) {
                this.restoreRowDataFromBindData();
            }
            try {
                this.prepareConnectionForExecution();
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this);
                    ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, null);
                }
                return;
            }
            this.executeMaybeDescribeAsync(arg_0 -> this.lambda$executeSQLSelectAsync$3((Consumer)callback, arg_0));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleStatement.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void ensureJ2EE13ComplianceForSelectSQL() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleStatement.class, $$$methodRef$$$33, this, new Object[0]);
            }
            if (this.executionType == 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, OracleStatement.class, $$$methodRef$$$33, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleStatement.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleStatement.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleStatement.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void restoreRowDataFromBindData() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this, new Object[0]);
            }
            this.rowData = this.bindData;
            if (this.accessors == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this);
                    ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this, null);
                }
                return;
            }
            for (Accessor a2 : this.accessors) {
                if (a2 == null) continue;
                a2.reinitForResultSetCache(this.rowData, this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleStatement.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void prepareConnectionForExecution() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleStatement.class, $$$methodRef$$$35, this, new Object[0]);
            }
            this.connection.needLine();
            if (!this.isOpen) {
                this.connection.open(this);
                this.isOpen = true;
            }
            if (this.queryTimeout != 0) {
                this.connection.getTimeout().setTimeout((long)this.queryTimeout * 1000L, this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleStatement.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleStatement.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleStatement.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void resetConnectionAfterExecution() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleStatement.class, $$$methodRef$$$36, this, new Object[0]);
            }
            if (this.queryTimeout != 0) {
                this.connection.getTimeout().cancelTimeout();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleStatement.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleStatement.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleStatement.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void handleExecuteSQLSelectCompletion() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleStatement.class, $$$methodRef$$$37, this, new Object[0]);
            }
            this.cacheQueryResultIfAppropriate();
            this.checkValidRowsStatus();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleStatement.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleStatement.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleStatement.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void executeSQLStatement() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this, new Object[0]);
            }
            if (this.connection.j2ee13Compliant) {
                this.ensureJ2EE13ComplianceForNonSelectSQL();
            }
            ++this.currentRank;
            if (this.currentRank >= this.batch) {
                try {
                    this.cancelLock.enterExecuting();
                    this.prepareConnectionForExecution();
                    this.executeForRows(false);
                    this.cancelLock.exitExecuting();
                }
                catch (SQLException ea) {
                    try {
                        this.handleExecuteSQLStatementFailure(ea);
                        SQLException sQLException = ea;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this, sQLException);
                        }
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        this.cancelLock.exitExecuting();
                        this.handleExecuteSQLStatementCompletionAlways();
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                this.handleExecuteSQLStatementCompletionAlways();
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$38, Level.FINEST, this.getClass(), $$$methodRef$$$38, "currentRank=" + this.currentRank + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleStatement.class, $$$methodRef$$$38, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeSQLStatementAsync(Consumer<Throwable> consumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, consumer);
            }
            try {
                if (this.connection.j2ee13Compliant) {
                    this.ensureJ2EE13ComplianceForNonSelectSQL();
                }
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, null);
                }
                return;
            }
            ++this.currentRank;
            if (this.currentRank < this.batch) {
                callback.accept(null);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, null);
                }
                return;
            }
            this.cancelLock.enterExecuting();
            try {
                this.prepareConnectionForExecution();
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, null);
                }
                return;
            }
            this.executeForRowsAsync(false, arg_0 -> this.lambda$executeSQLStatementAsync$4((Consumer)callback, arg_0));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleStatement.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void ensureJ2EE13ComplianceForNonSelectSQL() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleStatement.class, $$$methodRef$$$40, this, new Object[0]);
            }
            if (!this.sqlKind.isPlsqlOrCall() && this.executionType == 1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$40, Level.FINEST, OracleStatement.class, $$$methodRef$$$40, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleStatement.class, $$$methodRef$$$40, this);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleStatement.class, $$$methodRef$$$40, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleStatement.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleExecuteSQLStatementFailure(SQLException sQLException) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleStatement.class, $$$methodRef$$$41, this, sQLException);
            }
            this.needToParse = true;
            if (this.batch > 1) {
                void sqlException;
                this.clearBatchCritical();
                BatchUpdateException batchUpdateException = this.createBatchUpdateException((SQLException)sqlException);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, OracleStatement.class, $$$methodRef$$$41, this, batchUpdateException);
                }
                throw batchUpdateException;
            }
            this.resetCurrentRowBinders();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleStatement.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleStatement.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleStatement.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void handleExecuteSQLStatementCompletionAlways() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleStatement.class, $$$methodRef$$$42, this, new Object[0]);
            }
            this.resetConnectionAfterExecution();
            this.currentRank = 0;
            this.checkValidRowsStatus();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleStatement.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleStatement.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleStatement.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BatchUpdateException createBatchUpdateException(SQLException sQLException) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void ea;
            int i2;
            int[] ret_array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleStatement.class, $$$methodRef$$$43, this, sQLException);
            }
            if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                ret_array = new int[this.numberOfExecutedElementsInBatch];
                for (i2 = 0; i2 < ret_array.length; ++i2) {
                    ret_array[i2] = -2;
                }
            } else {
                ret_array = new int[this.batch];
                for (i2 = 0; i2 < ret_array.length; ++i2) {
                    ret_array[i2] = -3;
                }
            }
            BatchUpdateException buEx = DatabaseError.createBatchUpdateException((SQLException)ea, ret_array.length, ret_array);
            buEx.fillInStackTrace();
            BatchUpdateException batchUpdateException = buEx;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleStatement.class, $$$methodRef$$$43, this, batchUpdateException);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleStatement.class, $$$methodRef$$$43, this, null);
            }
            return batchUpdateException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleStatement.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetOnExceptionDuringExecute() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OracleStatement.class, $$$methodRef$$$44, this, new Object[0]);
            }
            this.needToParse = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OracleStatement.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleStatement.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleStatement.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetCurrentRowBinders() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OracleStatement.class, $$$methodRef$$$45, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OracleStatement.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleStatement.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleStatement.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    void open() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OracleStatement.class, $$$methodRef$$$46, this, new Object[0]);
            }
            if (!this.isOpen) {
                this.connection.needLine();
                this.connection.open(this);
                this.isOpen = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleStatement.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleStatement.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleStatement.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleResultSet oracleResultSet;
            block25: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, string);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.cleanUpBeforeExecute();
                    OracleResultSet result = null;
                    this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
                    try {
                        void sql;
                        this.executionType = 1;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$47, Level.FINEST, this.getClass(), $$$methodRef$$$47, "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                        }
                        this.noMoreUpdateCounts = false;
                        this.ensureOpen();
                        this.checkIfBatchExists();
                        this.sendBatch();
                        this.hasStream = false;
                        this.sqlObject.initialize((String)sql);
                        this.sqlKind = this.sqlObject.getSqlKind();
                        this.needToParse = true;
                        this.prepareForNewResults(true, true, true);
                        if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                            this.doExecuteWithTimeout();
                            if (this.implicitResultSetStatements == null) {
                                if (this.sqlKind.isPlsqlOrCall()) {
                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, sQLException);
                                    }
                                    throw sQLException;
                                }
                                if (this.validRows < 1L && this.validRows != -2L) {
                                    this.isAllFetched = true;
                                }
                                result = this.currentResultSet = this.createResultSet();
                            }
                        } else {
                            result = this.doScrollStmtExecuteQuery();
                            if (result == null && this.implicitResultSetStatements == null) {
                                if (this.sqlKind.isPlsqlOrCall()) {
                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, sQLException);
                                    }
                                    throw sQLException;
                                }
                                if (this.validRows < 1L && this.validRows != -2L) {
                                    this.isAllFetched = true;
                                }
                                result = this.currentResultSet = this.createResultSet();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.executionType = (byte)-1;
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, throwable2);
                        }
                        throw throwable2;
                    }
                    this.executionType = (byte)-1;
                    OracleResultSet oracleResultSet2 = result;
                    if (lock != null) {
                        lock.close();
                    }
                    oracleResultSet = oracleResultSet2;
                    if (!bl) break block25;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    Throwable throwable4 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, throwable4);
                    }
                    throw throwable4;
                }
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable5 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleStatement.class, $$$methodRef$$$47, this, throwable5);
            }
            throw throwable;
        }
    }

    @Override
    public void closeWithKey(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OracleStatement.class, $$$methodRef$$$48, this, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeWithKey").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$48, Level.FINEST, OracleStatement.class, $$$methodRef$$$48, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleStatement.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OracleStatement.class, $$$methodRef$$$49, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                this.closeOrCache(null);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, OracleStatement.class, $$$methodRef$$$49, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleStatement.class, $$$methodRef$$$49, this);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleStatement.class, $$$methodRef$$$49, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleStatement.class, $$$methodRef$$$49, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void closeWrapper(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OracleStatement.class, $$$methodRef$$$50, this, bl);
            }
            if (this.wrapper != null) {
                void isConnClosed;
                this.wrapper.beClosed((boolean)isConnClosed);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleStatement.class, $$$methodRef$$$50, this);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleStatement.class, $$$methodRef$$$50, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleStatement.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeOrCache(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this, string);
            }
            if (this.closed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this);
                    ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this, null);
                }
                return;
            }
            if (this.connection.lifecycle == 2) {
                this.connection.needLineUnchecked();
            } else {
                this.connection.needLine();
            }
            if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
                void key;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$51, Level.FINEST, this.getClass(), $$$methodRef$$$51, "caching stmt = " + this);
                }
                if (key == null) {
                    if (this.connection.getImplicitCachingEnabled()) {
                        this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                    } else {
                        this.cacheState = 0;
                        this.hardClose();
                    }
                } else if (this.connection.getExplicitCachingEnabled()) {
                    this.connection.cacheExplicitStatement((OraclePreparedStatement)this, (String)key);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$51, Level.FINEST, this.getClass(), $$$methodRef$$$51, "closing stmt " + this);
                }
                this.hardClose();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleStatement.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void hardClose() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, OracleStatement.class, $$$methodRef$$$52, this, new Object[0]);
            }
            this.hardClose(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleStatement.class, $$$methodRef$$$52, this);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleStatement.class, $$$methodRef$$$52, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleStatement.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void hardClose(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void closeCursor;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, OracleStatement.class, $$$methodRef$$$53, this, bl);
            }
            this.alwaysOnClose();
            this.describedWithNames = false;
            this.described = false;
            this.connection.removeStatement(this);
            this.clearDefines();
            if (this.isOpen && closeCursor != false && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
                this.doClose();
                this.isOpen = false;
                if (this.refreshStatement != null) {
                    this.refreshStatement.close();
                }
            }
            this.sqlObject = null;
            this.destroyDMSSensors();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, OracleStatement.class, $$$methodRef$$$53, this);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleStatement.class, $$$methodRef$$$53, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleStatement.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void alwaysOnClose() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, OracleStatement.class, $$$methodRef$$$54, this, new Object[0]);
            }
            if (this.implicitResultSetStatements != null) {
                for (OracleStatement s2 : this.implicitResultSetStatements) {
                    s2.close();
                }
                if (this.openImplicitResultSets != null) {
                    for (OracleResultSet rs : this.openImplicitResultSets) {
                        rs.close();
                    }
                }
            }
            OracleStatement child = this.children;
            while (child != null) {
                OracleStatement n2 = child.nextChild;
                child.close();
                child = n2;
            }
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            this.closed = true;
            if (this.connection != null && (this.connection.lifecycle == 1 || this.connection.lifecycle == 2 || this.connection.lifecycle == 8) && this.currentResultSet != null) {
                this.currentResultSet.doneFetchingRows(false);
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            this.sqlWarning = null;
            this.m_batchItems = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleStatement.class, $$$methodRef$$$54, this);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleStatement.class, $$$methodRef$$$54, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleStatement.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    void closeLeaveCursorOpen() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            Monitor.CloseableLock lock;
            block15: {
                block16: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this, new Object[0]);
                    }
                    lock = this.connection.acquireCloseableLock();
                    try {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$55, Level.FINEST, this.getClass(), $$$methodRef$$$55, "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                        }
                        if (!this.closed) break block15;
                        if (lock != null) {
                            lock.close();
                        }
                        if (!bl) break block16;
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this, throwable3);
                        }
                        throw throwable3;
                    }
                    ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this);
                    ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this, null);
                }
                return;
            }
            this.hardClose(false);
            if (lock != null) {
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleStatement.class, $$$methodRef$$$55, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, OracleStatement.class, $$$methodRef$$$56, this, string);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void sql;
                    int n3 = (int)this.executeLargeUpdate((String)sql);
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$56, Level.FINEST, OracleStatement.class, $$$methodRef$$$56, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, OracleStatement.class, $$$methodRef$$$56, this, n2);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleStatement.class, $$$methodRef$$$56, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleStatement.class, $$$methodRef$$$56, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, OracleStatement.class, $$$methodRef$$$57, this, string);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void sql;
                    this.cleanUpBeforeExecute();
                    long l3 = this.executeUpdateInternal((String)sql);
                    if (lock != null) {
                        lock.close();
                    }
                    l2 = l3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, OracleStatement.class, $$$methodRef$$$57, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, OracleStatement.class, $$$methodRef$$$57, this, l2);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleStatement.class, $$$methodRef$$$57, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleStatement.class, $$$methodRef$$$57, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    long executeUpdateInternal(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, OracleStatement.class, $$$methodRef$$$58, this, string);
            }
            try {
                void sql;
                if (this.executionType == -1) {
                    this.executionType = (byte)2;
                }
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize((String)sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true, true);
                if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                l2 = this.validRows;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, OracleStatement.class, $$$methodRef$$$58, this, throwable2);
                }
                throw throwable2;
            }
            this.executionType = (byte)-1;
            long l3 = l2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, OracleStatement.class, $$$methodRef$$$58, this, l3);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleStatement.class, $$$methodRef$$$58, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleStatement.class, $$$methodRef$$$58, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, OracleStatement.class, $$$methodRef$$$59, this, string);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void sql;
                    this.cleanUpBeforeExecute();
                    boolean bl3 = this.executeInternal((String)sql);
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, OracleStatement.class, $$$methodRef$$$59, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, OracleStatement.class, $$$methodRef$$$59, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleStatement.class, $$$methodRef$$$59, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleStatement.class, $$$methodRef$$$59, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean executeInternal(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, OracleStatement.class, $$$methodRef$$$60, this, string);
            }
            try {
                void sql;
                this.executionType = (byte)3;
                this.checkSum = 0L;
                this.checkSumComputationFailure = false;
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize((String)sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true, true);
                if (this.isCloseOnCompletion) {
                    this.ensureOpen();
                }
                this.runtimeKey = null;
                if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                bl2 = this.sqlKind.isSELECT() || this.implicitResultSetStatements != null;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$60, Level.FINEST, OracleStatement.class, $$$methodRef$$$60, this, throwable2);
                }
                throw throwable2;
            }
            this.executionType = (byte)-1;
            boolean bl3 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, OracleStatement.class, $$$methodRef$$$60, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleStatement.class, $$$methodRef$$$60, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleStatement.class, $$$methodRef$$$60, this, throwable3);
            }
            throw throwable;
        }
    }

    OracleResultSet createResultSet() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, new Object[0]);
            }
            if (this.sqlKind.isSELECT() && this.batchWasExecuted) {
                OracleResultSet oracleResultSet = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, oracleResultSet);
                    ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, null);
                }
                return null;
            }
            this.computeOffsetOfFirstUserColumn();
            this.computeNumberOfUserColumns();
            OracleResultSet oracleResultSet = OracleResultSet.createResultSet(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleStatement.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    final int getNumberOfUserColumns() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, OracleStatement.class, $$$methodRef$$$62, this, new Object[0]);
            }
            int n2 = this.numberOfUserColumns;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, OracleStatement.class, $$$methodRef$$$62, this, n2);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleStatement.class, $$$methodRef$$$62, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleStatement.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    protected final void computeNumberOfUserColumns() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, OracleStatement.class, $$$methodRef$$$63, this, new Object[0]);
            }
            if (this.serverCursor) {
                this.numberOfUserColumns = this.accessors == null ? 0 : this.accessors.length;
            } else if (this.sqlKind.isSELECT()) {
                this.ensureOpen();
                if (!this.described) {
                    Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                    try {
                        this.doDescribe(false);
                        this.described = true;
                        if (lock != null) {
                            lock.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$63, Level.FINEST, OracleStatement.class, $$$methodRef$$$63, this, throwable3);
                        }
                        throw throwable3;
                    }
                }
                this.numberOfUserColumns = this.numberOfDefinePositions - (1 + this.offsetOfFirstUserColumn);
            } else {
                this.numberOfUserColumns = this.numReturnParams;
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$63, Level.FINEST, this.getClass(), $$$methodRef$$$63, "numberOfUserColumsns:\t" + this.numberOfUserColumns);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, OracleStatement.class, $$$methodRef$$$63, this);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleStatement.class, $$$methodRef$$$63, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleStatement.class, $$$methodRef$$$63, this, throwable4);
            }
            throw throwable;
        }
    }

    Accessor[] getDescription() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, OracleStatement.class, $$$methodRef$$$64, this, new Object[0]);
            }
            this.ensureOpen();
            if (!this.described) {
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.doDescribe(false);
                    this.described = true;
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$64, Level.FINEST, OracleStatement.class, $$$methodRef$$$64, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            Accessor[] accessorArray = this.accessors;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, OracleStatement.class, $$$methodRef$$$64, this, accessorArray);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleStatement.class, $$$methodRef$$$64, this, null);
            }
            return this.accessors;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleStatement.class, $$$methodRef$$$64, this, throwable4);
            }
            throw throwable;
        }
    }

    Accessor[] getDescriptionWithNames() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, OracleStatement.class, $$$methodRef$$$65, this, new Object[0]);
            }
            this.ensureOpen();
            if (!this.describedWithNames) {
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$65, Level.FINEST, OracleStatement.class, $$$methodRef$$$65, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            Accessor[] accessorArray = this.accessors;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, OracleStatement.class, $$$methodRef$$$65, this, accessorArray);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleStatement.class, $$$methodRef$$$65, this, null);
            }
            return this.accessors;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleStatement.class, $$$methodRef$$$65, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, OracleStatement.class, $$$methodRef$$$66, this, new Object[0]);
            }
            OracleStatement.SqlKind sqlKind = this.sqlObject.getSqlKind();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, OracleStatement.class, $$$methodRef$$$66, this, (Object)sqlKind);
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleStatement.class, $$$methodRef$$$66, this, null);
            }
            return sqlKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleStatement.class, $$$methodRef$$$66, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearDefines() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, OracleStatement.class, $$$methodRef$$$67, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                this.freeLine();
                this.streamList = null;
                this.columnsDefinedByUser = false;
                this.needToPrepareDefineBuffer = true;
                this.numberOfDefinePositions = 0;
                this.definesBatchSize = 0;
                this.described = false;
                this.describedWithNames = false;
                this.cleanupDefines();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$67, Level.FINEST, OracleStatement.class, $$$methodRef$$$67, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$67, Level.FINEST, OracleStatement.class, $$$methodRef$$$67, this);
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleStatement.class, $$$methodRef$$$67, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleStatement.class, $$$methodRef$$$67, this, throwable4);
            }
            throw throwable;
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, OracleStatement.class, $$$methodRef$$$68, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$68, Level.FINEST, this.getClass(), $$$methodRef$$$68, "do nothing");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$68, Level.FINEST, OracleStatement.class, $$$methodRef$$$68, this);
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleStatement.class, $$$methodRef$$$68, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleStatement.class, $$$methodRef$$$68, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void defineColumnTypeInternal(int n2, int n3, int n4, boolean bl, String string) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void sizeNotGiven;
            void size;
            void type;
            void column_index;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$69, Level.FINEST, OracleStatement.class, $$$methodRef$$$69, this, n2, n3, n4, bl, string);
            }
            this.defineColumnTypeInternal((int)column_index, (int)type, (int)size, (short)1, (boolean)sizeNotGiven, (String)typeName);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$69, Level.FINEST, OracleStatement.class, $$$methodRef$$$69, this);
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleStatement.class, $$$methodRef$$$69, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleStatement.class, $$$methodRef$$$69, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            String typeName;
            short form;
            void sizeNotGiven;
            int max_len;
            void type;
            void column_index;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, n2, n3, n4, s2, bl, string);
            }
            if (this.connection.disableDefinecolumntype) {
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this);
                    ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, null);
                }
                return;
            }
            if (column_index < true) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, sQLException);
                }
                throw sQLException;
            }
            if (type == false) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, sQLException);
                }
                throw sQLException;
            }
            void idx = column_index - true;
            int n5 = max_len = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
            if (sizeNotGiven == false) {
                void size;
                if (size < 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53).fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, sQLException);
                    }
                    throw sQLException;
                }
                if (type == 2005 || type == 2004) {
                    if (max_len == -1 && size > 0 || max_len > 0 && size < max_len) {
                        max_len = size;
                    }
                } else {
                    max_len = -1;
                }
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.columnsDefinedByUser) {
                this.clearDefines();
                this.columnsDefinedByUser = true;
            }
            if (this.numberOfDefinePositions < column_index) {
                if (this.accessors == null || this.accessors.length < column_index) {
                    Accessor[] na = new Accessor[column_index << 1];
                    if (this.accessors != null) {
                        System.arraycopy(this.accessors, 0, na, 0, this.numberOfDefinePositions);
                    }
                    this.accessors = na;
                }
                this.numberOfDefinePositions = column_index;
            }
            switch (type) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = 2;
                    break;
                }
                case 2009: {
                    typeName = "SYS.XMLTYPE";
                    break;
                }
            }
            int internal_type = this.getInternalType((int)type);
            if (!(internal_type != 109 && internal_type != 111 || typeName != null && !typeName.equals(""))) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, sQLException);
                }
                throw sQLException;
            }
            Accessor accessor = this.accessors[idx];
            boolean need_to_prepare = true;
            if (accessor != null) {
                int reusability = accessor.useForDataAccessIfPossible(internal_type, (int)type, max_len, typeName);
                if (reusability == 0) {
                    form = accessor.formOfUse;
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 1) {
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 2) {
                    need_to_prepare = false;
                }
            }
            if (need_to_prepare) {
                this.needToPrepareDefineBuffer = true;
            }
            if (accessor == null) {
                this.accessors[idx] = this.allocateAccessor(internal_type, (int)type, (int)column_index, max_len, form, typeName, false);
                this.described = false;
                this.describedWithNames = false;
            }
            this.executeDoneForDefines = false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this);
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleStatement.class, $$$methodRef$$$70, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void internal_type;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, n2, n3, n4, n5, s2, string, bl);
            }
            switch (internal_type) {
                case 96: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    CharAccessor charAccessor = new CharAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, charAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return charAccessor;
                }
                case 8: {
                    void col_index;
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (forBind == false) {
                        LongAccessor longAccessor = new LongAccessor(this, (int)col_index, max_len, (short)form, (int)external_type);
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, longAccessor);
                            ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                        }
                        return longAccessor;
                    }
                }
                case 1: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    VarcharAccessor varcharAccessor = new VarcharAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, varcharAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return varcharAccessor;
                }
                case 2: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    NumberAccessor numberAccessor = new NumberAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, numberAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return numberAccessor;
                }
                case 252: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    PlsqlBooleanAccessor plsqlBooleanAccessor = new PlsqlBooleanAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, plsqlBooleanAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return plsqlBooleanAccessor;
                }
                case 6: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    VarnumAccessor varnumAccessor = new VarnumAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, varnumAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return varnumAccessor;
                }
                case 24: {
                    void col_index;
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (forBind == false) {
                        LongRawAccessor longRawAccessor = new LongRawAccessor(this, (int)col_index, max_len, (short)form, (int)external_type);
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, longRawAccessor);
                            ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                        }
                        return longRawAccessor;
                    }
                }
                case 23: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (forBind != false) {
                        OutRawAccessor outRawAccessor = new OutRawAccessor(this, max_len, (short)form, (int)external_type);
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, outRawAccessor);
                            ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                        }
                        return outRawAccessor;
                    }
                    RawAccessor rawAccessor = new RawAccessor(this, max_len, (short)form, (int)external_type, false);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, rawAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return rawAccessor;
                }
                case 100: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    BinaryFloatAccessor binaryFloatAccessor = new BinaryFloatAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, binaryFloatAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return binaryFloatAccessor;
                }
                case 101: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    BinaryDoubleAccessor binaryDoubleAccessor = new BinaryDoubleAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, binaryDoubleAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return binaryDoubleAccessor;
                }
                case 104: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                        max_len = 18;
                        VarcharAccessor result = new VarcharAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                        result.definedColumnType = -8;
                        VarcharAccessor varcharAccessor = result;
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, varcharAccessor);
                            ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                        }
                        return varcharAccessor;
                    }
                    RowidAccessor rowidAccessor = new RowidAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, rowidAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return rowidAccessor;
                }
                case 102: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    ResultSetAccessor resultSetAccessor = new ResultSetAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, resultSetAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return resultSetAccessor;
                }
                case 12: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    DateAccessor dateAccessor = new DateAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, dateAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return dateAccessor;
                }
                case 113: {
                    BlobAccessor result;
                    void form;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    BlobAccessor blobAccessor = result = new BlobAccessor(this, -1, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, blobAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return blobAccessor;
                }
                case 112: {
                    ClobAccessor result;
                    void form;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    ClobAccessor clobAccessor = result = new ClobAccessor(this, -1, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, clobAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return clobAccessor;
                }
                case 114: {
                    BfileAccessor result;
                    void form;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    BfileAccessor bfileAccessor = result = new BfileAccessor(this, -1, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, bfileAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return bfileAccessor;
                }
                case 109: {
                    void form;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (typeName == null) {
                        if (forBind != false) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                            }
                            throw sQLException;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    NamedTypeAccessor result = new NamedTypeAccessor(this, (String)typeName, (short)form, (int)external_type, (boolean)forBind);
                    ((Accessor)result).initMetadata();
                    NamedTypeAccessor namedTypeAccessor = result;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, namedTypeAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return namedTypeAccessor;
                }
                case 111: {
                    void form;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (typeName == null) {
                        if (forBind != false) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                            }
                            throw sQLException;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    RefTypeAccessor result = new RefTypeAccessor(this, (String)typeName, (short)form, (int)external_type, (boolean)forBind);
                    ((Accessor)result).initMetadata();
                    RefTypeAccessor refTypeAccessor = result;
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, refTypeAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return refTypeAccessor;
                }
                case 180: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    TimestampAccessor timestampAccessor = new TimestampAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, timestampAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return timestampAccessor;
                }
                case 181: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    TimestamptzAccessor timestamptzAccessor = new TimestamptzAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, timestamptzAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return timestamptzAccessor;
                }
                case 231: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    TimestampltzAccessor timestampltzAccessor = new TimestampltzAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, timestampltzAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return timestampltzAccessor;
                }
                case 182: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    IntervalymAccessor intervalymAccessor = new IntervalymAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, intervalymAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return intervalymAccessor;
                }
                case 183: {
                    void form;
                    int max_len;
                    void external_type;
                    void typeName;
                    void forBind;
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                        }
                        throw sQLException;
                    }
                    IntervaldsAccessor intervaldsAccessor = new IntervaldsAccessor(this, max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, intervaldsAccessor);
                        ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, null);
                    }
                    return intervaldsAccessor;
                }
                case 995: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89).fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl2) {
                ClioSupport.throwing($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleStatement.class, $$$methodRef$$$71, this, throwable2);
            }
            throw throwable;
        }
    }

    void setDriverSpecificData(Accessor accessor) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$72, Level.FINEST, OracleStatement.class, $$$methodRef$$$72, this, accessor);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$72, Level.FINEST, OracleStatement.class, $$$methodRef$$$72, this);
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleStatement.class, $$$methodRef$$$72, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleStatement.class, $$$methodRef$$$72, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void defineColumnType(int n2, int n3) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$73, Level.FINEST, OracleStatement.class, $$$methodRef$$$73, this, n2, n3);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void type;
                void column_index;
                this.defineColumnTypeInternal((int)column_index, (int)type, -1, true, null);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$73, Level.FINEST, OracleStatement.class, $$$methodRef$$$73, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, OracleStatement.class, $$$methodRef$$$73, this);
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleStatement.class, $$$methodRef$$$73, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleStatement.class, $$$methodRef$$$73, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void defineColumnType(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void max_size;
            void type;
            void column_index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$74, Level.FINEST, OracleStatement.class, $$$methodRef$$$74, this, n2, n3, n4);
            }
            this.defineColumnTypeInternal((int)column_index, (int)type, (int)max_size, false, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$74, Level.FINEST, OracleStatement.class, $$$methodRef$$$74, this);
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, OracleStatement.class, $$$methodRef$$$74, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, OracleStatement.class, $$$methodRef$$$74, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void defineColumnType(int n2, int n3, int n4, short s2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void form_of_use;
            void max_size;
            void type;
            void column_index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$75, Level.FINEST, OracleStatement.class, $$$methodRef$$$75, this, n2, n3, n4, s2);
            }
            this.defineColumnTypeInternal((int)column_index, (int)type, (int)max_size, (short)form_of_use, false, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, OracleStatement.class, $$$methodRef$$$75, this);
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleStatement.class, $$$methodRef$$$75, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleStatement.class, $$$methodRef$$$75, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public void defineColumnTypeBytes(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$76, Level.FINEST, OracleStatement.class, $$$methodRef$$$76, this, n2, n3, n4);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void max_size;
                void type;
                void column_index;
                if (bl) {
                    OracleLog.warning($$$loggerRef$$$76, this.getClass(), $$$methodRef$$$76, "call to defineColumnTypeBytes which is deprecated and may not behave as expected");
                }
                this.defineColumnTypeInternal((int)column_index, (int)type, (int)max_size, false, null);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$76, Level.FINEST, OracleStatement.class, $$$methodRef$$$76, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$76, Level.FINEST, OracleStatement.class, $$$methodRef$$$76, this);
                ClioSupport.exiting($$$loggerRef$$$76, Level.FINEST, OracleStatement.class, $$$methodRef$$$76, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$76, Level.FINEST, OracleStatement.class, $$$methodRef$$$76, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public void defineColumnTypeChars(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void max_size;
            void type;
            void column_index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$77, Level.FINEST, OracleStatement.class, $$$methodRef$$$77, this, n2, n3, n4);
            }
            this.defineColumnTypeInternal((int)column_index, (int)type, (int)max_size, false, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$77, Level.FINEST, OracleStatement.class, $$$methodRef$$$77, this);
                ClioSupport.exiting($$$loggerRef$$$77, Level.FINEST, OracleStatement.class, $$$methodRef$$$77, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$77, Level.FINEST, OracleStatement.class, $$$methodRef$$$77, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void defineColumnType(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$78, Level.FINEST, OracleStatement.class, $$$methodRef$$$78, this, n2, n3, string);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void typeName;
                void typeCode;
                void column_index;
                this.defineColumnTypeInternal((int)column_index, (int)typeCode, -1, true, (String)typeName);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$78, Level.FINEST, OracleStatement.class, $$$methodRef$$$78, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$78, Level.FINEST, OracleStatement.class, $$$methodRef$$$78, this);
                ClioSupport.exiting($$$loggerRef$$$78, Level.FINEST, OracleStatement.class, $$$methodRef$$$78, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$78, Level.FINEST, OracleStatement.class, $$$methodRef$$$78, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setCursorId(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void id;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$79, Level.FINEST, OracleStatement.class, $$$methodRef$$$79, this, n2);
            }
            this.cursorId = id;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$79, Level.FINEST, OracleStatement.class, $$$methodRef$$$79, this);
                ClioSupport.exiting($$$loggerRef$$$79, Level.FINEST, OracleStatement.class, $$$methodRef$$$79, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$79, Level.FINEST, OracleStatement.class, $$$methodRef$$$79, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setPrefetchInternal(int n2, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void statement;
            int new_value;
            void setRowPrefetch;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this, n2, bl, bl2);
            }
            if (setRowPrefetch != false) {
                if (new_value <= 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20).fillInStackTrace();
                    if (bl3) {
                        ClioSupport.throwing($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this, sQLException);
                    }
                    throw sQLException;
                }
            } else {
                if (new_value < 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize").fillInStackTrace();
                    if (bl3) {
                        ClioSupport.throwing($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this, sQLException);
                    }
                    throw sQLException;
                }
                if (new_value == 0) {
                    new_value = this.connection.getDefaultRowPrefetch();
                }
            }
            if (statement != false) {
                if (new_value != this.defaultRowPrefetch) {
                    this.defaultRowPrefetch = new_value;
                    if (this.currentResultSet == null || this.currentResultSet.closed) {
                        this.rowPrefetchChanged = true;
                    }
                }
            } else if (new_value != this.rowPrefetch && (this.streamList == null || this.isFetchStreams)) {
                this.rowPrefetch = new_value;
                this.rowPrefetchChanged = true;
            }
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this);
                ClioSupport.exiting($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$80, Level.FINEST, OracleStatement.class, $$$methodRef$$$80, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRowPrefetch(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$81, Level.FINEST, OracleStatement.class, $$$methodRef$$$81, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void value;
                this.setPrefetchInternal((int)value, true, true);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$81, Level.FINEST, OracleStatement.class, $$$methodRef$$$81, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$81, Level.FINEST, OracleStatement.class, $$$methodRef$$$81, this);
                ClioSupport.exiting($$$loggerRef$$$81, Level.FINEST, OracleStatement.class, $$$methodRef$$$81, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$81, Level.FINEST, OracleStatement.class, $$$methodRef$$$81, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLobPrefetchSize(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void value;
                if (value < -1) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this, sQLException);
                    }
                    throw sQLException;
                }
                this.defaultLobPrefetchSize = value;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this);
                ClioSupport.exiting($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$82, Level.FINEST, OracleStatement.class, $$$methodRef$$$82, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getLobPrefetchSize() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$83, Level.FINEST, OracleStatement.class, $$$methodRef$$$83, this, new Object[0]);
            }
            int n2 = this.defaultLobPrefetchSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$83, Level.FINEST, OracleStatement.class, $$$methodRef$$$83, this, n2);
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, OracleStatement.class, $$$methodRef$$$83, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, OracleStatement.class, $$$methodRef$$$83, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getPrefetchInternal(boolean bl) {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void statement;
            int ret_val;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$84, Level.FINEST, OracleStatement.class, $$$methodRef$$$84, this, bl);
            }
            int n2 = ret_val = statement != false ? this.defaultRowPrefetch : this.rowPrefetch;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$84, Level.FINEST, OracleStatement.class, $$$methodRef$$$84, this, n2);
                ClioSupport.exiting($$$loggerRef$$$84, Level.FINEST, OracleStatement.class, $$$methodRef$$$84, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$84, Level.FINEST, OracleStatement.class, $$$methodRef$$$84, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getRowPrefetch() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$85, Level.FINEST, OracleStatement.class, $$$methodRef$$$85, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    int n3 = this.getPrefetchInternal(true);
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$85, Level.FINEST, OracleStatement.class, $$$methodRef$$$85, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$85, Level.FINEST, OracleStatement.class, $$$methodRef$$$85, this, n2);
                ClioSupport.exiting($$$loggerRef$$$85, Level.FINEST, OracleStatement.class, $$$methodRef$$$85, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$85, Level.FINEST, OracleStatement.class, $$$methodRef$$$85, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFixedString(boolean bl) {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void fixedString_value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$86, Level.FINEST, OracleStatement.class, $$$methodRef$$$86, this, bl);
            }
            this.fixedString = fixedString_value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$86, Level.FINEST, OracleStatement.class, $$$methodRef$$$86, this);
                ClioSupport.exiting($$$loggerRef$$$86, Level.FINEST, OracleStatement.class, $$$methodRef$$$86, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$86, Level.FINEST, OracleStatement.class, $$$methodRef$$$86, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getFixedString() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$87, Level.FINEST, OracleStatement.class, $$$methodRef$$$87, this, new Object[0]);
            }
            boolean bl2 = this.fixedString;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$87, Level.FINEST, OracleStatement.class, $$$methodRef$$$87, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$87, Level.FINEST, OracleStatement.class, $$$methodRef$$$87, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$87, Level.FINEST, OracleStatement.class, $$$methodRef$$$87, this, throwable2);
            }
            throw throwable;
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$88, Level.FINEST, OracleStatement.class, $$$methodRef$$$88, this, new Object[0]);
            }
            if (this.rowPrefetchChanged) {
                if (this.streamList == null) {
                    this.prepareAccessors();
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$88, Level.FINEST, OracleStatement.class, $$$methodRef$$$88, this);
                ClioSupport.exiting($$$loggerRef$$$88, Level.FINEST, OracleStatement.class, $$$methodRef$$$88, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$88, Level.FINEST, OracleStatement.class, $$$methodRef$$$88, this, throwable2);
            }
            throw throwable;
        }
    }

    void setDefinesInitialized(boolean bl) {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$89, Level.FINEST, OracleStatement.class, $$$methodRef$$$89, this, bl);
            }
            if (bl2) {
                OracleLog.debug($$$loggerRef$$$89, Level.FINEST, this.getClass(), $$$methodRef$$$89, "no implemetation for kprb and thin, implemented only in OCI");
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$89, Level.FINEST, OracleStatement.class, $$$methodRef$$$89, this);
                ClioSupport.exiting($$$loggerRef$$$89, Level.FINEST, OracleStatement.class, $$$methodRef$$$89, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$89, Level.FINEST, OracleStatement.class, $$$methodRef$$$89, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void printState(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$90, Level.FINEST, OracleStatement.class, $$$methodRef$$$90, this, string);
            }
            if (bl) {
                void message;
                OracleLog.debug($$$loggerRef$$$90, Level.FINEST, this.getClass(), $$$methodRef$$$90, (String)message + ":  sqlObject=" + this.sqlObject + "  rowPrefetch=" + this.rowPrefetch + "  defaultRowPrefetch=" + this.defaultRowPrefetch + "  rowPrefetchChanged=" + this.rowPrefetchChanged + "  batch=" + this.batch + "  currentRank=" + this.currentRank + "  validRows=" + this.validRows + "  serverCursor=" + this.serverCursor + "  currentResultSet=" + this.currentResultSet + "  processEscapes=" + this.processEscapes + "  convertNcharLiterals=" + this.convertNcharLiterals + "  queryTimeout=" + this.queryTimeout + "  needToParse=" + this.needToParse + "  needToPrepareDefineBuffer=" + this.needToPrepareDefineBuffer + "  columnsDefinedByUser=" + this.columnsDefinedByUser);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$90, Level.FINEST, OracleStatement.class, $$$methodRef$$$90, this);
                ClioSupport.exiting($$$loggerRef$$$90, Level.FINEST, OracleStatement.class, $$$methodRef$$$90, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$90, Level.FINEST, OracleStatement.class, $$$methodRef$$$90, this, throwable2);
            }
            throw throwable;
        }
    }

    void checkValidRowsStatus() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$91, Level.FINEST, OracleStatement.class, $$$methodRef$$$91, this, new Object[0]);
            }
            if (this.validRows == -2L) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$91, Level.FINEST, this.getClass(), $$$methodRef$$$91, "nextStream = " + this.nextStream);
                }
                this.validRows = 1L;
                this.connection.holdLine(this);
                OracleInputStream is = this.streamList;
                while (is != null) {
                    if (is.hasBeenOpen) {
                        is = is.accessor.initForNewRow();
                    }
                    is.closed = false;
                    is.hasBeenOpen = true;
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$91, Level.FINEST, this.getClass(), $$$methodRef$$$91, "opens " + is);
                    }
                    is = is.nextStream;
                }
                this.nextStream = this.streamList;
            } else if (this.sqlKind.isSELECT()) {
                if (this.validRows < (long)this.rowPrefetch) {
                    this.gotLastBatch = true;
                    this.initializeCacheEntryIfApplicable();
                }
            } else if (!this.sqlKind.isPlsqlOrCall()) {
                this.rowsProcessed = this.validRows;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$91, Level.FINEST, OracleStatement.class, $$$methodRef$$$91, this);
                ClioSupport.exiting($$$loggerRef$$$91, Level.FINEST, OracleStatement.class, $$$methodRef$$$91, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$91, Level.FINEST, OracleStatement.class, $$$methodRef$$$91, this, throwable2);
            }
            throw throwable;
        }
    }

    void initializeCacheEntryIfApplicable() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$92, Level.FINEST, OracleStatement.class, $$$methodRef$$$92, this, new Object[0]);
            }
            int fetchedRowCount = this.storedRowCount + (int)this.validRows;
            if (this.cachedQueryResult != null) {
                long sizeInMemory = this.rowData.length();
                for (Accessor accessor : this.accessors) {
                    if (accessor == null) continue;
                    sizeInMemory += (long)(24 + fetchedRowCount * 14);
                }
                ResultSetCache resultSetCache = this.connection.getResultSetCacheInternal();
                long sizeRemaining = resultSetCache.getMaxCacheSize() - resultSetCache.getCurrentCacheSize();
                if (sizeInMemory <= sizeRemaining) {
                    ByteArray newRowData;
                    this.rowData = newRowData = this.rowData.compact();
                    this.rowData = ReadOnlyByteArray.newReadOnlyByteArray(this.rowData);
                    this.cachedQueryResult.initialize(fetchedRowCount, this.rowData, this.accessors, sizeInMemory);
                    resultSetCache.updateCurrentCacheSize(sizeInMemory);
                    this.cachedQueryResult = null;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$92, Level.FINEST, OracleStatement.class, $$$methodRef$$$92, this);
                ClioSupport.exiting($$$loggerRef$$$92, Level.FINEST, OracleStatement.class, $$$methodRef$$$92, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$92, Level.FINEST, OracleStatement.class, $$$methodRef$$$92, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanupDefines() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$93, Level.FINEST, OracleStatement.class, $$$methodRef$$$93, this, new Object[0]);
            }
            this.accessors = null;
            if (this.columnNameCache.size() > 0) {
                this.columnNameCache = new IdentityHashMap(COLUMN_NAME_CACHE_INITIAL_SIZE);
            }
            if (this.rowData != null) {
                this.rowData.free();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$93, Level.FINEST, OracleStatement.class, $$$methodRef$$$93, this);
                ClioSupport.exiting($$$loggerRef$$$93, Level.FINEST, OracleStatement.class, $$$methodRef$$$93, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$93, Level.FINEST, OracleStatement.class, $$$methodRef$$$93, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$94, Level.FINEST, OracleStatement.class, $$$methodRef$$$94, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.ensureOpen();
                    int n3 = this.maxFieldSize;
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$94, Level.FINEST, OracleStatement.class, $$$methodRef$$$94, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$94, Level.FINEST, OracleStatement.class, $$$methodRef$$$94, this, n2);
                ClioSupport.exiting($$$loggerRef$$$94, Level.FINEST, OracleStatement.class, $$$methodRef$$$94, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$94, Level.FINEST, OracleStatement.class, $$$methodRef$$$94, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxFieldSize(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void max;
                this.ensureOpen();
                if (max < 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this, sQLException);
                    }
                    throw sQLException;
                }
                this.maxFieldSize = max;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this);
                ClioSupport.exiting($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$95, Level.FINEST, OracleStatement.class, $$$methodRef$$$95, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$96, Level.FINEST, OracleStatement.class, $$$methodRef$$$96, this, new Object[0]);
            }
            int n2 = (int)this.getLargeMaxRows();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$96, Level.FINEST, OracleStatement.class, $$$methodRef$$$96, this, n2);
                ClioSupport.exiting($$$loggerRef$$$96, Level.FINEST, OracleStatement.class, $$$methodRef$$$96, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$96, Level.FINEST, OracleStatement.class, $$$methodRef$$$96, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$97, Level.FINEST, OracleStatement.class, $$$methodRef$$$97, this, new Object[0]);
            }
            this.ensureOpen();
            long l2 = this.maxRows;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$97, Level.FINEST, OracleStatement.class, $$$methodRef$$$97, this, l2);
                ClioSupport.exiting($$$loggerRef$$$97, Level.FINEST, OracleStatement.class, $$$methodRef$$$97, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$97, Level.FINEST, OracleStatement.class, $$$methodRef$$$97, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxRows(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void max;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$98, Level.FINEST, OracleStatement.class, $$$methodRef$$$98, this, n2);
            }
            this.setLargeMaxRows((long)max);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$98, Level.FINEST, OracleStatement.class, $$$methodRef$$$98, this);
                ClioSupport.exiting($$$loggerRef$$$98, Level.FINEST, OracleStatement.class, $$$methodRef$$$98, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$98, Level.FINEST, OracleStatement.class, $$$methodRef$$$98, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLargeMaxRows(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this, l2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void max;
                this.ensureOpen();
                if (max < 0L) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this, sQLException);
                    }
                    throw sQLException;
                }
                this.maxRows = max;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this);
                ClioSupport.exiting($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$99, Level.FINEST, OracleStatement.class, $$$methodRef$$$99, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$100, Level.FINEST, OracleStatement.class, $$$methodRef$$$100, this, bl);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void enable;
                this.processEscapes = enable;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$100, Level.FINEST, OracleStatement.class, $$$methodRef$$$100, this, throwable3);
                }
                throw throwable3;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$100, Level.FINEST, OracleStatement.class, $$$methodRef$$$100, this);
                ClioSupport.exiting($$$loggerRef$$$100, Level.FINEST, OracleStatement.class, $$$methodRef$$$100, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$100, Level.FINEST, OracleStatement.class, $$$methodRef$$$100, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$101, Level.FINEST, OracleStatement.class, $$$methodRef$$$101, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.ensureOpen();
                    int n3 = this.queryTimeout;
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$101, Level.FINEST, OracleStatement.class, $$$methodRef$$$101, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$101, Level.FINEST, OracleStatement.class, $$$methodRef$$$101, this, n2);
                ClioSupport.exiting($$$loggerRef$$$101, Level.FINEST, OracleStatement.class, $$$methodRef$$$101, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$101, Level.FINEST, OracleStatement.class, $$$methodRef$$$101, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setQueryTimeout(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void max;
                this.ensureOpen();
                if (max < 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this, sQLException);
                    }
                    throw sQLException;
                }
                this.queryTimeout = max;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this);
                ClioSupport.exiting($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$102, Level.FINEST, OracleStatement.class, $$$methodRef$$$102, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void cancel() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$103, Level.FINEST, OracleStatement.class, $$$methodRef$$$103, this, new Object[0]);
            }
            this.ensureOpen();
            this.doCancel();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$103, Level.FINEST, OracleStatement.class, $$$methodRef$$$103, this);
                ClioSupport.exiting($$$loggerRef$$$103, Level.FINEST, OracleStatement.class, $$$methodRef$$$103, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$103, Level.FINEST, OracleStatement.class, $$$methodRef$$$103, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean doCancel() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, new Object[0]);
            }
            boolean connectionHasBeenCancelled = false;
            if (this.closed) {
                boolean bl2 = connectionHasBeenCancelled;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, null);
                }
                return bl2;
            }
            if (this.connection.statementHoldingLine != null) {
                this.freeLine();
            } else if (this.cancelLock.enterCanceling()) {
                try {
                    connectionHasBeenCancelled = true;
                    this.connection.cancelOperationOnServer(true);
                    this.cancelLock.exitCanceling();
                }
                catch (Throwable throwable) {
                    this.cancelLock.exitCanceling();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, throwable2);
                    }
                    throw throwable2;
                }
            } else {
                boolean bl3 = connectionHasBeenCancelled;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, null);
                }
                return bl3;
            }
            OracleStatement s2 = this.children;
            while (s2 != null) {
                connectionHasBeenCancelled = connectionHasBeenCancelled || s2.doCancel();
                s2 = s2.nextChild;
            }
            this.connection.releaseLineForCancel();
            boolean bl4 = connectionHasBeenCancelled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$104, Level.FINEST, OracleStatement.class, $$$methodRef$$$104, this, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$105, Level.FINEST, OracleStatement.class, $$$methodRef$$$105, this, new Object[0]);
            }
            this.ensureOpen();
            SQLWarning sQLWarning = this.sqlWarning;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$105, Level.FINEST, OracleStatement.class, $$$methodRef$$$105, this, sQLWarning);
                ClioSupport.exiting($$$loggerRef$$$105, Level.FINEST, OracleStatement.class, $$$methodRef$$$105, this, null);
            }
            return sQLWarning;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$105, Level.FINEST, OracleStatement.class, $$$methodRef$$$105, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$106, Level.FINEST, OracleStatement.class, $$$methodRef$$$106, this, new Object[0]);
            }
            this.ensureOpen();
            this.sqlWarning = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$106, Level.FINEST, OracleStatement.class, $$$methodRef$$$106, this);
                ClioSupport.exiting($$$loggerRef$$$106, Level.FINEST, OracleStatement.class, $$$methodRef$$$106, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$106, Level.FINEST, OracleStatement.class, $$$methodRef$$$106, this, throwable2);
            }
            throw throwable;
        }
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$107, Level.FINEST, OracleStatement.class, $$$methodRef$$$107, this, new Object[0]);
            }
            SQLWarning w2 = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
            if (this.sqlWarning != null) {
                this.sqlWarning.setNextWarning(w2);
                if (bl) {
                    OracleLog.warning($$$loggerRef$$$107, this.getClass(), $$$methodRef$$$107, "found Plsql compile warning");
                }
            } else {
                this.sqlWarning = w2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$107, Level.FINEST, OracleStatement.class, $$$methodRef$$$107, this);
                ClioSupport.exiting($$$loggerRef$$$107, Level.FINEST, OracleStatement.class, $$$methodRef$$$107, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$107, Level.FINEST, OracleStatement.class, $$$methodRef$$$107, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$108, Level.FINEST, OracleStatement.class, $$$methodRef$$$108, this, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setCursorName").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$108, Level.FINEST, OracleStatement.class, $$$methodRef$$$108, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$108, Level.FINEST, OracleStatement.class, $$$methodRef$$$108, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        var4_1 = (16900L & TraceControllerImpl.feature) != 0L;
        try {
            block21: {
                block19: {
                    block20: {
                        block17: {
                            block18: {
                                if (var4_1) {
                                    ClioSupport.entering(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, new Object[0]);
                                }
                                lock = this.connection.acquireCloseableLock();
                                try {
                                    this.ensureOpen();
                                    if (this.implicitResultSetStatements == null) ** GOTO lbl36
                                    if (this.currentResultSet == null) break block17;
                                    var2_3 = this.currentResultSet;
                                    if (lock != null) {
                                        lock.close();
                                    }
                                    var5_7 = var2_3;
                                    if (!var4_1) break block18;
                                }
                                catch (Throwable var2_6) {
                                    if (lock != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable var3_13) {
                                            var2_6.addSuppressed(var3_13);
                                        }
                                    }
                                    var6_11 = var2_6;
                                    if (var4_1) {
                                        ClioSupport.throwing(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var6_11);
                                    }
                                    throw var6_11;
                                }
                                ClioSupport.returning(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var5_7);
                                ClioSupport.exiting(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, null);
                            }
                            return var5_7;
                        }
                        var6_10 = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 283).fillInStackTrace();
                        if (var4_1) {
                            ClioSupport.throwing(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var6_10);
                        }
                        throw var6_10;
lbl36:
                        // 1 sources

                        if (!this.sqlKind.isSELECT()) break block19;
                        if (this.currentResultSet == null) {
                            this.currentResultSet = this.createResultSet();
                        }
                        var2_4 = this.currentResultSet;
                        if (lock != null) {
                            lock.close();
                        }
                        var5_8 = var2_4;
                        if (!var4_1) break block20;
                        ClioSupport.returning(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var5_8);
                        ClioSupport.exiting(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, null);
                    }
                    return var5_8;
                }
                var2_5 = null;
                if (lock != null) {
                    lock.close();
                }
                var5_9 = var2_5;
                if (!var4_1) break block21;
                ClioSupport.returning(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var5_9);
                ClioSupport.exiting(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, null);
            }
            return var5_9;
        }
        catch (Throwable v0) {
            var6_12 = v0;
            if (var4_1) {
                ClioSupport.exiting(OracleStatement.$$$loggerRef$$$109, Level.FINEST, OracleStatement.class, OracleStatement.$$$methodRef$$$109, this, var6_12);
            }
            throw v0;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$110, Level.FINEST, OracleStatement.class, $$$methodRef$$$110, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    int n3 = (int)this.getLargeUpdateCount();
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$110, Level.FINEST, OracleStatement.class, $$$methodRef$$$110, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$110, Level.FINEST, OracleStatement.class, $$$methodRef$$$110, this, n2);
                ClioSupport.exiting($$$loggerRef$$$110, Level.FINEST, OracleStatement.class, $$$methodRef$$$110, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$110, Level.FINEST, OracleStatement.class, $$$methodRef$$$110, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block17: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$111, Level.FINEST, OracleStatement.class, $$$methodRef$$$111, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.ensureOpen();
                    long updateCount = 0L;
                    switch (this.sqlKind) {
                        case UNINITIALIZED: 
                        case SELECT_FOR_UPDATE: 
                        case SELECT: {
                            updateCount = -1L;
                            break;
                        }
                        case ALTER_SESSION: 
                        case OTHER: {
                            updateCount = !this.noMoreUpdateCounts ? this.rowsProcessed : -1L;
                            this.noMoreUpdateCounts = true;
                            break;
                        }
                        case PLSQL_BLOCK: 
                        case CALL_BLOCK: {
                            updateCount = -1L;
                            this.noMoreUpdateCounts = true;
                            break;
                        }
                        case DELETE: 
                        case INSERT: 
                        case MERGE: 
                        case UPDATE: {
                            updateCount = !this.noMoreUpdateCounts ? this.rowsProcessed : -1L;
                            this.noMoreUpdateCounts = true;
                        }
                    }
                    long l3 = updateCount;
                    if (lock != null) {
                        lock.close();
                    }
                    l2 = l3;
                    if (!bl) break block17;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$111, Level.FINEST, OracleStatement.class, $$$methodRef$$$111, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$111, Level.FINEST, OracleStatement.class, $$$methodRef$$$111, this, l2);
                ClioSupport.exiting($$$loggerRef$$$111, Level.FINEST, OracleStatement.class, $$$methodRef$$$111, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$111, Level.FINEST, OracleStatement.class, $$$methodRef$$$111, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$112, Level.FINEST, OracleStatement.class, $$$methodRef$$$112, this, new Object[0]);
            }
            this.ensureOpen();
            boolean bl2 = this.getMoreResults(1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$112, Level.FINEST, OracleStatement.class, $$$methodRef$$$112, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$112, Level.FINEST, OracleStatement.class, $$$methodRef$$$112, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$112, Level.FINEST, OracleStatement.class, $$$methodRef$$$112, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int sendBatch() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$113, Level.FINEST, OracleStatement.class, $$$methodRef$$$113, this, new Object[0]);
            }
            int n2 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$113, Level.FINEST, OracleStatement.class, $$$methodRef$$$113, this, n2);
                ClioSupport.exiting($$$loggerRef$$$113, Level.FINEST, OracleStatement.class, $$$methodRef$$$113, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$113, Level.FINEST, OracleStatement.class, $$$methodRef$$$113, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void increaseCapacity(int n2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void numberOfRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$114, Level.FINEST, OracleStatement.class, $$$methodRef$$$114, this, n2);
            }
            if (this.storedRowCount + numberOfRows > this.currentCapacity) {
                if (this.currentCapacity < 1024) {
                    int n3 = this.currentCapacity * 4;
                }
                int newCapacity = this.currentCapacity < 16384 ? (int)((double)this.currentCapacity * 1.5) : (int)((double)this.currentCapacity * 1.2);
                newCapacity = Math.max(this.storedRowCount + numberOfRows, newCapacity);
                newCapacity = (newCapacity / this.rowPrefetch + 1) * this.rowPrefetch;
                for (Accessor a2 : this.accessors) {
                    if (a2 == null) continue;
                    a2.setCapacity(newCapacity);
                }
                this.currentCapacity = newCapacity;
            }
            if (!$assertionsDisabled && this.currentCapacity < this.storedRowCount + numberOfRows) {
                AssertionError assertionError = new AssertionError((Object)("currentCapacity: " + this.currentCapacity + " storedRowCount: " + this.storedRowCount + ", numberOfRows: " + (int)numberOfRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$114, Level.FINEST, OracleStatement.class, $$$methodRef$$$114, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$114, Level.FINEST, OracleStatement.class, $$$methodRef$$$114, this);
                ClioSupport.exiting($$$loggerRef$$$114, Level.FINEST, OracleStatement.class, $$$methodRef$$$114, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$114, Level.FINEST, OracleStatement.class, $$$methodRef$$$114, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void drainStreams() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$115, Level.FINEST, OracleStatement.class, $$$methodRef$$$115, this, new Object[0]);
            }
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$115, Level.FINEST, OracleStatement.class, $$$methodRef$$$115, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$115, Level.FINEST, OracleStatement.class, $$$methodRef$$$115, this);
                ClioSupport.exiting($$$loggerRef$$$115, Level.FINEST, OracleStatement.class, $$$methodRef$$$115, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$115, Level.FINEST, OracleStatement.class, $$$methodRef$$$115, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int physicalRowIndex(long l2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void logicalRowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$116, Level.FINEST, OracleStatement.class, $$$methodRef$$$116, this, l2);
            }
            int n2 = (int)(logicalRowIndex - this.indexOfFirstRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$116, Level.FINEST, OracleStatement.class, $$$methodRef$$$116, this, n2);
                ClioSupport.exiting($$$loggerRef$$$116, Level.FINEST, OracleStatement.class, $$$methodRef$$$116, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$116, Level.FINEST, OracleStatement.class, $$$methodRef$$$116, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    long fetchMoreRows(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l3;
            block27: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, l2);
                }
                if (!$assertionsDisabled && this.isAllFetched) {
                    AssertionError assertionError = new AssertionError((Object)("isAllFetched: " + this.isAllFetched));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.cleanTempLobsBeforeFetchMoreRows();
                long startToken = 0L;
                if (this.dmsFetch != null) {
                    startToken = this.dmsFetch.start();
                }
                try {
                    void firstRow;
                    this.connection.updateSystemContext();
                    if (!$assertionsDisabled && this.fetchMode == FetchMode.APPEND && firstRow > Integer.MAX_VALUE) {
                        AssertionError assertionError = new AssertionError((Object)("firstRow:" + (long)firstRow));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    this.prepareAccessorsBeforeFetchMoreRows();
                    this.drainStreams();
                    this.connection.needLine();
                    try {
                        this.cancelLock.enterExecuting();
                        boolean isScrollable = this.fetchMode == FetchMode.APPEND;
                        int firstRowStorageOffset = isScrollable ? (int)firstRow : 0;
                        this.fetch(firstRowStorageOffset, isScrollable);
                        if (!$assertionsDisabled && this.validRows == -2L && this.rowPrefetch != 1) {
                            AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch));
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                            }
                            throw assertionError;
                        }
                        this.cancelLock.exitExecuting();
                    }
                    catch (Throwable throwable) {
                        this.cancelLock.exitExecuting();
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, throwable2);
                        }
                        throw throwable2;
                    }
                    this.checkValidRowsStatus();
                    this.updateRowStorageCountAfterFetchMoreRows();
                    this.updateIsAllFetchedAfterFetchMoreRows();
                    if (!$assertionsDisabled && this.physicalRowIndex((long)firstRow) < 0) {
                        AssertionError assertionError = new AssertionError((Object)("firstRow: " + (long)firstRow + " indexOfFirstRow: " + this.indexOfFirstRow));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.physicalRowIndex((long)firstRow) >= this.currentCapacity) {
                        AssertionError assertionError = new AssertionError((Object)("firstRow: " + (long)firstRow + " indexOfFirstRow: " + this.indexOfFirstRow + " currentCapacity: " + this.currentCapacity));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.validRows < 0L) {
                        AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.validRows <= 0L && !this.isAllFetched) {
                        AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows + ", isAllFetched: " + this.isAllFetched));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    long l4 = this.validRows;
                    if (this.dmsFetch != null) {
                        this.dmsFetch.stop(startToken);
                    }
                    l3 = l4;
                    if (!bl) break block27;
                }
                catch (Throwable throwable) {
                    if (this.dmsFetch != null) {
                        this.dmsFetch.stop(startToken);
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, l3);
                ClioSupport.exiting($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$117, Level.FINEST, OracleStatement.class, $$$methodRef$$$117, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void fetchMoreRowsAsync(long l2, BiConsumer<Long, Throwable> biConsumer) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void firstRow;
            void callback;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, l2, biConsumer);
            }
            try {
                this.cleanTempLobsBeforeFetchMoreRows();
            }
            catch (SQLException preExecutionFailure) {
                callback.accept(null, preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this);
                    ClioSupport.exiting($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, null);
                }
                return;
            }
            long startToken = this.dmsFetch != null ? this.dmsFetch.start() : 0L;
            try {
                if (!$assertionsDisabled && this.fetchMode == FetchMode.APPEND && firstRow > Integer.MAX_VALUE) {
                    AssertionError assertionError = new AssertionError((Object)("firstRow:" + (long)firstRow));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.prepareAccessorsBeforeFetchMoreRows();
                this.drainStreams();
                this.connection.needLine();
            }
            catch (SQLException preExecutionFailure) {
                if (this.dmsFetch != null) {
                    this.dmsFetch.stop(startToken);
                }
                callback.accept(null, preExecutionFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this);
                    ClioSupport.exiting($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, null);
                }
                return;
            }
            this.cancelLock.enterExecuting();
            boolean isScrollable = this.fetchMode == FetchMode.APPEND;
            int firstRowStorageOffset = isScrollable ? (int)firstRow : 0;
            this.fetchAsync(firstRowStorageOffset, isScrollable, arg_0 -> this.lambda$fetchMoreRowsAsync$5((long)firstRow, startToken, (BiConsumer)callback, arg_0));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this);
                ClioSupport.exiting($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$118, Level.FINEST, OracleStatement.class, $$$methodRef$$$118, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void cleanTempLobsBeforeFetchMoreRows() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$119, Level.FINEST, OracleStatement.class, $$$methodRef$$$119, this, new Object[0]);
            }
            if (this.currentResultSet != null && this.currentResultSet.getType() == 1003) {
                if (!this.tempRowClobsToFree.isEmpty()) {
                    this.cleanTempClobs(this.tempRowClobsToFree);
                    this.tempRowClobsToFree.clear();
                }
                if (!this.tempRowBlobsToFree.isEmpty()) {
                    this.cleanTempBlobs(this.tempRowBlobsToFree);
                    this.tempRowBlobsToFree.clear();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$119, Level.FINEST, OracleStatement.class, $$$methodRef$$$119, this);
                ClioSupport.exiting($$$loggerRef$$$119, Level.FINEST, OracleStatement.class, $$$methodRef$$$119, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$119, Level.FINEST, OracleStatement.class, $$$methodRef$$$119, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void prepareAccessorsBeforeFetchMoreRows() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$120, Level.FINEST, OracleStatement.class, $$$methodRef$$$120, this, new Object[0]);
            }
            if (this.fetchMode == FetchMode.APPEND) {
                this.increaseCapacity(this.rowPrefetch);
            }
            this.check_row_prefetch_changed();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$120, Level.FINEST, OracleStatement.class, $$$methodRef$$$120, this);
                ClioSupport.exiting($$$loggerRef$$$120, Level.FINEST, OracleStatement.class, $$$methodRef$$$120, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$120, Level.FINEST, OracleStatement.class, $$$methodRef$$$120, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void updateRowStorageCountAfterFetchMoreRows() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$121, Level.FINEST, OracleStatement.class, $$$methodRef$$$121, this, new Object[0]);
            }
            if (this.fetchMode == FetchMode.APPEND) {
                this.storedRowCount += (int)this.validRows;
            } else {
                this.indexOfFirstRow += (long)this.storedRowCount;
                this.storedRowCount = (int)this.validRows;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$121, Level.FINEST, OracleStatement.class, $$$methodRef$$$121, this);
                ClioSupport.exiting($$$loggerRef$$$121, Level.FINEST, OracleStatement.class, $$$methodRef$$$121, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$121, Level.FINEST, OracleStatement.class, $$$methodRef$$$121, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void updateIsAllFetchedAfterFetchMoreRows() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$122, Level.FINEST, OracleStatement.class, $$$methodRef$$$122, this, new Object[0]);
            }
            if (this.maxRows > 0L && this.indexOfFirstRow + (long)this.storedRowCount >= this.maxRows) {
                this.isAllFetched = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$122, Level.FINEST, OracleStatement.class, $$$methodRef$$$122, this);
                ClioSupport.exiting($$$loggerRef$$$122, Level.FINEST, OracleStatement.class, $$$methodRef$$$122, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$122, Level.FINEST, OracleStatement.class, $$$methodRef$$$122, this, throwable2);
            }
            throw throwable;
        }
    }

    int storedRowCount() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$123, Level.FINEST, OracleStatement.class, $$$methodRef$$$123, this, new Object[0]);
            }
            int n2 = this.storedRowCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$123, Level.FINEST, OracleStatement.class, $$$methodRef$$$123, this, n2);
                ClioSupport.exiting($$$loggerRef$$$123, Level.FINEST, OracleStatement.class, $$$methodRef$$$123, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$123, Level.FINEST, OracleStatement.class, $$$methodRef$$$123, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int refreshRows(long l2, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void numberOfRows;
            void firstRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$124, Level.FINEST, OracleStatement.class, $$$methodRef$$$124, this, l2, n2);
            }
            ARRAY keys = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, this.getRowKeys(this.physicalRowIndex((long)firstRow), (int)numberOfRows));
            int n3 = this.refreshRowsInternal(keys, this.physicalRowIndex((long)firstRow), (int)numberOfRows);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$124, Level.FINEST, OracleStatement.class, $$$methodRef$$$124, this, n3);
                ClioSupport.exiting($$$loggerRef$$$124, Level.FINEST, OracleStatement.class, $$$methodRef$$$124, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$124, Level.FINEST, OracleStatement.class, $$$methodRef$$$124, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void insertRow(long l2, RowId rowId) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            void rowId2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$125, Level.FINEST, OracleStatement.class, $$$methodRef$$$125, this, l2, rowId);
            }
            if (this.currentCapacity < this.storedRowCount + 1) {
                this.increaseCapacity(this.storedRowCount + 1);
            }
            RowId[] keyArray = new RowId[]{rowId2};
            ARRAY keys = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, keyArray);
            for (Accessor a2 : this.accessors) {
                if (a2 == null) continue;
                a2.insertNull(this.physicalRowIndex((long)row));
            }
            int count = this.refreshRowsInternal(keys, this.physicalRowIndex((long)row), 1);
            if (!$assertionsDisabled && count != 1) {
                AssertionError assertionError = new AssertionError((Object)("count: " + count));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$125, Level.FINEST, OracleStatement.class, $$$methodRef$$$125, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.storedRowCount += count;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$125, Level.FINEST, OracleStatement.class, $$$methodRef$$$125, this);
                ClioSupport.exiting($$$loggerRef$$$125, Level.FINEST, OracleStatement.class, $$$methodRef$$$125, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$125, Level.FINEST, OracleStatement.class, $$$methodRef$$$125, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    protected int refreshRowsInternal(Array array, int n2, int n3) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n4;
            block29: {
                void keys;
                void numberOfRows;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, array, n2, n3);
                }
                if (this.refreshStatement == null) {
                    this.refreshStatement = this.connection.prepareStatementInternal(this.sqlObject.getRefetchSql(), 1003, 1007);
                    this.refreshStatement.isRowidPrepended = true;
                    this.refreshStatement.isFetchStreams = true;
                    this.refreshStatement.copyDefines(this, (int)numberOfRows);
                    this.copyBinds(this.refreshStatement, 1);
                }
                this.refreshStatement.setArray(1, (Array)keys);
                this.refreshStatement.setFetchSize((int)numberOfRows);
                ResultSet rs = null;
                try {
                    rs = this.refreshStatement.executeQuery();
                    int count = 0;
                    int row = 0;
                    while (rs.next()) {
                        void destRow;
                        if (this.accessors[0].getROWID((int)(destRow + row)) == null || this.accessors[0].getROWID((int)(destRow + row)).equals(this.refreshStatement.accessors[0].getROWID(row))) {
                            int first = this.accessors[0].getROWID((int)(destRow + row)) == null ? 0 : 1;
                            ++count;
                            for (int col = first; col < this.accessors.length; ++col) {
                                if (this.accessors[col] == null) continue;
                                this.accessors[col].copyFrom(this.refreshStatement.accessors[col], row, (int)(destRow + row));
                            }
                        }
                        ++row;
                    }
                    n4 = count;
                    if (rs == null) break block29;
                }
                catch (Throwable throwable) {
                    block30: {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.refreshStatement != null) {
                            try {
                                this.refreshStatement.drainStreams();
                                this.refreshStatement.close();
                                this.refreshStatement = null;
                            }
                            catch (Exception exception) {
                                this.refreshStatement = null;
                                break block30;
                                catch (Throwable throwable2) {
                                    this.refreshStatement = null;
                                    Throwable throwable3 = throwable2;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, throwable3);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    Throwable throwable4 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, throwable4);
                    }
                    throw throwable4;
                }
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.refreshStatement != null) {
                try {
                    this.refreshStatement.drainStreams();
                    this.refreshStatement.close();
                    this.refreshStatement = null;
                }
                catch (Exception exception) {
                    this.refreshStatement = null;
                    catch (Throwable throwable) {
                        this.refreshStatement = null;
                        Throwable throwable5 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, throwable5);
                        }
                        throw throwable5;
                    }
                }
            }
            int n5 = n4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, n5);
                ClioSupport.exiting($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable6 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$126, Level.FINEST, OracleStatement.class, $$$methodRef$$$126, this, throwable6);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String[] getRowKeys(int n2, int n3) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void firstRow;
            void numberOfRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$127, Level.FINEST, OracleStatement.class, $$$methodRef$$$127, this, n2, n3);
            }
            ArrayList<String> a2 = new ArrayList<String>((int)numberOfRows);
            int stop = Math.min((int)numberOfRows, this.storedRowCount - firstRow);
            for (int i2 = 0; i2 < stop; ++i2) {
                a2.add(this.accessors[0].getString((int)(firstRow + i2)));
            }
            String[] stringArray = a2.toArray(new String[0]);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$127, Level.FINEST, OracleStatement.class, $$$methodRef$$$127, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$127, Level.FINEST, OracleStatement.class, $$$methodRef$$$127, this, null);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$127, Level.FINEST, OracleStatement.class, $$$methodRef$$$127, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void removeRowFromCache(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$128, Level.FINEST, OracleStatement.class, $$$methodRef$$$128, this, l2);
            }
            if (row < this.indexOfFirstRow) {
                --this.indexOfFirstRow;
            } else if (row >= this.indexOfFirstRow) {
                if (!$assertionsDisabled && row >= this.indexOfFirstRow + (long)this.storedRowCount) {
                    AssertionError assertionError = new AssertionError((Object)("row: " + (long)row + " indexOfFirstRow: " + this.indexOfFirstRow + " storedRowCount: " + this.storedRowCount));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$128, Level.FINEST, OracleStatement.class, $$$methodRef$$$128, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                for (Accessor a2 : this.accessors) {
                    if (a2 == null) continue;
                    this.deleteRow(a2, this.physicalRowIndex((long)row));
                }
                --this.storedRowCount;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$128, Level.FINEST, OracleStatement.class, $$$methodRef$$$128, this);
                ClioSupport.exiting($$$loggerRef$$$128, Level.FINEST, OracleStatement.class, $$$methodRef$$$128, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$128, Level.FINEST, OracleStatement.class, $$$methodRef$$$128, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void deleteRow(Accessor accessor, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            void accessor2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$129, Level.FINEST, OracleStatement.class, $$$methodRef$$$129, this, accessor, n2);
            }
            accessor2.deleteRow((int)row);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$129, Level.FINEST, OracleStatement.class, $$$methodRef$$$129, this);
                ClioSupport.exiting($$$loggerRef$$$129, Level.FINEST, OracleStatement.class, $$$methodRef$$$129, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$129, Level.FINEST, OracleStatement.class, $$$methodRef$$$129, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void prepareForNewResults(boolean bl, boolean bl2, boolean bl3) throws SQLException {
        boolean bl4 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void resetPrefetch;
            void clearStreamList;
            void clearImplicitResults;
            if (bl4) {
                ClioSupport.entering($$$loggerRef$$$130, Level.FINEST, OracleStatement.class, $$$methodRef$$$130, this, bl, bl2, bl3);
            }
            if (!this.closed) {
                this.clearWarnings();
            }
            if (clearImplicitResults != false && this.implicitResultSetStatements != null) {
                for (OracleStatement s2 : this.implicitResultSetStatements) {
                    s2.close();
                }
                this.implicitResultSetStatements = null;
                this.implicitResultSetIterator = null;
                if (this.openImplicitResultSets != null) {
                    for (OracleResultSet rs : this.openImplicitResultSets) {
                        rs.close();
                    }
                    this.openImplicitResultSets = null;
                }
            }
            this.closeAllStreams((boolean)clearStreamList);
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            if (this.bindUseDBA) {
                this.resetBindData();
            } else {
                this.rowData.reset();
            }
            this.storedRowCount = 0;
            this.indexOfFirstRow = 0L;
            this.isAllFetched = false;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.validRows = 0L;
            this.batchRowsUpdatedArray = null;
            this.gotLastBatch = false;
            if (resetPrefetch != false) {
                this.offsetOfFirstUserColumn = -1;
                this.numberOfUserColumns = -1;
            }
            if (this.needToParse && !this.columnsDefinedByUser) {
                if (clearStreamList != false && this.numberOfDefinePositions != 0) {
                    this.numberOfDefinePositions = 0;
                }
                this.needToPrepareDefineBuffer = true;
            }
            if (resetPrefetch != false && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
                this.rowPrefetch = this.defaultRowPrefetch;
                this.rowPrefetchChanged = true;
            }
            if (bl4) {
                ClioSupport.returning($$$loggerRef$$$130, Level.FINEST, OracleStatement.class, $$$methodRef$$$130, this);
                ClioSupport.exiting($$$loggerRef$$$130, Level.FINEST, OracleStatement.class, $$$methodRef$$$130, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl4) {
                ClioSupport.exiting($$$loggerRef$$$130, Level.FINEST, OracleStatement.class, $$$methodRef$$$130, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetBindData() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$131, Level.FINEST, OracleStatement.class, $$$methodRef$$$131, this, new Object[0]);
            }
            this.rowData.setPosition(this.beyondBindData);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$131, Level.FINEST, OracleStatement.class, $$$methodRef$$$131, this);
                ClioSupport.exiting($$$loggerRef$$$131, Level.FINEST, OracleStatement.class, $$$methodRef$$$131, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$131, Level.FINEST, OracleStatement.class, $$$methodRef$$$131, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void closeAllStreams(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void clearStreamList;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$132, Level.FINEST, OracleStatement.class, $$$methodRef$$$132, this, bl);
            }
            this.drainStreams();
            if (clearStreamList != false) {
                OracleInputStream s2 = this.streamList;
                OracleInputStream prev = null;
                this.streamList = null;
                while (s2 != null) {
                    if (!s2.hasBeenOpen) {
                        if (prev == null) {
                            this.streamList = s2;
                        } else {
                            prev.nextStream = s2;
                        }
                        prev = s2;
                    }
                    s2 = s2.nextStream;
                }
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$132, Level.FINEST, OracleStatement.class, $$$methodRef$$$132, this);
                ClioSupport.exiting($$$loggerRef$$$132, Level.FINEST, OracleStatement.class, $$$methodRef$$$132, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$132, Level.FINEST, OracleStatement.class, $$$methodRef$$$132, this, throwable2);
            }
            throw throwable;
        }
    }

    void reopenStreams() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$133, Level.FINEST, OracleStatement.class, $$$methodRef$$$133, this, new Object[0]);
            }
            OracleInputStream is = this.streamList;
            while (is != null) {
                if (is.hasBeenOpen) {
                    is = is.accessor.initForNewRow();
                }
                is.closed = false;
                is.hasBeenOpen = true;
                is = is.nextStream;
            }
            this.nextStream = this.streamList;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$133, Level.FINEST, OracleStatement.class, $$$methodRef$$$133, this);
                ClioSupport.exiting($$$loggerRef$$$133, Level.FINEST, OracleStatement.class, $$$methodRef$$$133, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$133, Level.FINEST, OracleStatement.class, $$$methodRef$$$133, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void endOfResultSet(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void dont_call_prepare_for_new_result;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$134, Level.FINEST, OracleStatement.class, $$$methodRef$$$134, this, bl);
            }
            if (dont_call_prepare_for_new_result == false) {
                this.prepareForNewResults(false, false, false);
            }
            this.clearDefines();
            this.rowPrefetchInLastFetch = -1;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$134, Level.FINEST, OracleStatement.class, $$$methodRef$$$134, this);
                ClioSupport.exiting($$$loggerRef$$$134, Level.FINEST, OracleStatement.class, $$$methodRef$$$134, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$134, Level.FINEST, OracleStatement.class, $$$methodRef$$$134, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean wasNullValue(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, l2);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, sQLException);
                }
                throw sQLException;
            }
            if (this.lastIndex < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = this.isNull((long)row, this.lastIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$135, Level.FINEST, OracleStatement.class, $$$methodRef$$$135, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isNull(long l2, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, l2, n2);
            }
            if (this.sqlKind.isSELECT() || this.isDmlReturning) {
                boolean bl2 = this.accessors[columnIndex + this.offsetOfFirstUserColumn].isNull(this.physicalRowIndex((long)rowIndex));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, null);
                }
                return bl2;
            }
            if (!$assertionsDisabled && rowIndex != (long)this.currentRank) {
                AssertionError assertionError = new AssertionError((Object)("rowIndex: " + (long)rowIndex + " currentRank: " + this.currentRank));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            boolean bl3 = this.outBindAccessors[columnIndex - true].isNull(this.currentRank);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$136, Level.FINEST, OracleStatement.class, $$$methodRef$$$136, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getColumnIndex(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void columnName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$137, Level.FINEST, OracleStatement.class, $$$methodRef$$$137, this, string);
            }
            this.ensureOpen();
            Integer index = this.columnNameCache.get(columnName);
            if (index == null) {
                String localColName = columnName;
                if (localColName != null) {
                    localColName = this.enquoteIdentifier(localColName, true);
                    localColName = localColName.substring(1, localColName.length() - 1);
                }
                index = this.getColumnIndexPrimitive(localColName);
                if (this.columnNameCache.size() <= this.accessors.length) {
                    this.columnNameCache.put((String)columnName, index);
                }
            }
            int n2 = index;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$137, Level.FINEST, OracleStatement.class, $$$methodRef$$$137, this, n2);
                ClioSupport.exiting($$$loggerRef$$$137, Level.FINEST, OracleStatement.class, $$$methodRef$$$137, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$137, Level.FINEST, OracleStatement.class, $$$methodRef$$$137, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getColumnIndexPrimitive(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, string);
            }
            if (!this.describedWithNames) {
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            for (int index = 1 + this.offsetOfFirstUserColumn; index < this.numberOfDefinePositions; ++index) {
                void columnName;
                if (!this.accessors[index].columnName.equalsIgnoreCase((String)columnName)) continue;
                int n2 = index - this.offsetOfFirstUserColumn;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, null);
                }
                return n2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$138, Level.FINEST, OracleStatement.class, $$$methodRef$$$138, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getJDBCType(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void internalType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$139, Level.FINEST, OracleStatement.class, $$$methodRef$$$139, this, n2);
            }
            int result = 0;
            switch (internalType) {
                case 6: {
                    result = 2;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case 999: {
                    result = 999;
                    break;
                }
                case 96: {
                    result = 1;
                    break;
                }
                case 1: {
                    result = 12;
                    break;
                }
                case 8: {
                    result = -1;
                    break;
                }
                case 12: {
                    result = 91;
                    break;
                }
                case 180: {
                    result = 93;
                    break;
                }
                case 181: {
                    result = -101;
                    break;
                }
                case 231: {
                    result = -102;
                    break;
                }
                case 182: {
                    result = -103;
                    break;
                }
                case 183: {
                    result = -104;
                    break;
                }
                case 23: {
                    result = -2;
                    break;
                }
                case 24: {
                    result = -4;
                    break;
                }
                case 104: {
                    result = -8;
                    break;
                }
                case 113: {
                    result = 2004;
                    break;
                }
                case 119: {
                    result = 2016;
                    break;
                }
                case 112: {
                    result = 2005;
                    break;
                }
                case 114: {
                    result = -13;
                    break;
                }
                case 102: {
                    result = -10;
                    break;
                }
                case 109: {
                    result = 2002;
                    break;
                }
                case 111: {
                    result = 2006;
                    break;
                }
                case 998: {
                    result = -14;
                    break;
                }
                case 995: {
                    result = 0;
                    break;
                }
                default: {
                    result = internalType;
                }
            }
            int n3 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$139, Level.FINEST, OracleStatement.class, $$$methodRef$$$139, this, n3);
                ClioSupport.exiting($$$loggerRef$$$139, Level.FINEST, OracleStatement.class, $$$methodRef$$$139, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$139, Level.FINEST, OracleStatement.class, $$$methodRef$$$139, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getInternalType(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void externalType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$140, Level.FINEST, OracleStatement.class, $$$methodRef$$$140, this, n2);
            }
            int result = 0;
            switch (externalType) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    result = 6;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case 252: {
                    result = 252;
                    break;
                }
                case 999: {
                    result = 999;
                    break;
                }
                case 1: {
                    result = 96;
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    result = 1;
                    break;
                }
                case -16: 
                case -1: {
                    result = 8;
                    break;
                }
                case 91: 
                case 92: {
                    result = 12;
                    break;
                }
                case -100: 
                case 93: {
                    result = 180;
                    break;
                }
                case -101: 
                case 2013: 
                case 2014: {
                    result = 181;
                    break;
                }
                case -102: {
                    result = 231;
                    break;
                }
                case -103: {
                    result = 182;
                    break;
                }
                case -104: {
                    result = 183;
                    break;
                }
                case -3: 
                case -2: {
                    result = 23;
                    break;
                }
                case -4: {
                    result = 24;
                    break;
                }
                case -8: {
                    result = 104;
                    break;
                }
                case 2004: {
                    result = 113;
                    break;
                }
                case 2016: {
                    result = 119;
                    break;
                }
                case 2005: 
                case 2011: {
                    result = 112;
                    break;
                }
                case -13: {
                    result = 114;
                    break;
                }
                case -10: 
                case 2012: {
                    result = 102;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: 
                case 2009: {
                    result = 109;
                    break;
                }
                case 2006: {
                    result = 111;
                    break;
                }
                case -14: {
                    result = 998;
                    break;
                }
                case 70: {
                    result = 1;
                    break;
                }
                case 0: {
                    result = 995;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString((int)externalType)).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$140, Level.FINEST, OracleStatement.class, $$$methodRef$$$140, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n3 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$140, Level.FINEST, OracleStatement.class, $$$methodRef$$$140, this, n3);
                ClioSupport.exiting($$$loggerRef$$$140, Level.FINEST, OracleStatement.class, $$$methodRef$$$140, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$140, Level.FINEST, OracleStatement.class, $$$methodRef$$$140, this, throwable2);
            }
            throw throwable;
        }
    }

    ResultSetMetaData getResultSetMetaData() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$141, Level.FINEST, OracleStatement.class, $$$methodRef$$$141, this, new Object[0]);
            }
            OracleResultSetMetaData oracleResultSetMetaData = new OracleResultSetMetaData(this.connection, this, this.offsetOfFirstUserColumn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$141, Level.FINEST, OracleStatement.class, $$$methodRef$$$141, this, oracleResultSetMetaData);
                ClioSupport.exiting($$$loggerRef$$$141, Level.FINEST, OracleStatement.class, $$$methodRef$$$141, this, null);
            }
            return oracleResultSetMetaData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$141, Level.FINEST, OracleStatement.class, $$$methodRef$$$141, this, throwable2);
            }
            throw throwable;
        }
    }

    void describe() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$142, Level.FINEST, OracleStatement.class, $$$methodRef$$$142, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                this.ensureOpen();
                if (!this.described) {
                    this.doDescribe(false);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$142, Level.FINEST, OracleStatement.class, $$$methodRef$$$142, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$142, Level.FINEST, OracleStatement.class, $$$methodRef$$$142, this);
                ClioSupport.exiting($$$loggerRef$$$142, Level.FINEST, OracleStatement.class, $$$methodRef$$$142, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$142, Level.FINEST, OracleStatement.class, $$$methodRef$$$142, this, throwable4);
            }
            throw throwable;
        }
    }

    void freeLine() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$143, Level.FINEST, OracleStatement.class, $$$methodRef$$$143, this, new Object[0]);
            }
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$143, Level.FINEST, OracleStatement.class, $$$methodRef$$$143, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$143, Level.FINEST, OracleStatement.class, $$$methodRef$$$143, this);
                ClioSupport.exiting($$$loggerRef$$$143, Level.FINEST, OracleStatement.class, $$$methodRef$$$143, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$143, Level.FINEST, OracleStatement.class, $$$methodRef$$$143, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void closeUsedStreams(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$144, Level.FINEST, OracleStatement.class, $$$methodRef$$$144, this, n2);
            }
            while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
                try {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$144, Level.FINEST, this.getClass(), $$$methodRef$$$144, "closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                    }
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$144, Level.FINEST, OracleStatement.class, $$$methodRef$$$144, this, sQLException);
                    }
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$144, Level.FINEST, OracleStatement.class, $$$methodRef$$$144, this);
                ClioSupport.exiting($$$loggerRef$$$144, Level.FINEST, OracleStatement.class, $$$methodRef$$$144, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$144, Level.FINEST, OracleStatement.class, $$$methodRef$$$144, this, throwable2);
            }
            throw throwable;
        }
    }

    final void ensureOpen() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this, new Object[0]);
            }
            if (this.connection.lifecycle != 1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this, sQLException);
                }
                throw sQLException;
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this);
                ClioSupport.exiting($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$145, Level.FINEST, OracleStatement.class, $$$methodRef$$$145, this, throwable2);
            }
            throw throwable;
        }
    }

    void allocateTmpByteArray() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$146, Level.FINEST, OracleStatement.class, $$$methodRef$$$146, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$146, Level.FINEST, this.getClass(), $$$methodRef$$$146, "for Thin only");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$146, Level.FINEST, OracleStatement.class, $$$methodRef$$$146, this);
                ClioSupport.exiting($$$loggerRef$$$146, Level.FINEST, OracleStatement.class, $$$methodRef$$$146, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$146, Level.FINEST, OracleStatement.class, $$$methodRef$$$146, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void direction;
                this.ensureOpen();
                if (direction != 1000) {
                    if (direction == 1001 || direction == 1002) {
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this);
                ClioSupport.exiting($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$147, Level.FINEST, OracleStatement.class, $$$methodRef$$$147, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$148, Level.FINEST, OracleStatement.class, $$$methodRef$$$148, this, new Object[0]);
            }
            this.ensureOpen();
            int n2 = 1000;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$148, Level.FINEST, OracleStatement.class, $$$methodRef$$$148, this, n2);
                ClioSupport.exiting($$$loggerRef$$$148, Level.FINEST, OracleStatement.class, $$$methodRef$$$148, this, null);
            }
            return 1000;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$148, Level.FINEST, OracleStatement.class, $$$methodRef$$$148, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$149, Level.FINEST, OracleStatement.class, $$$methodRef$$$149, this, n2);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void rows;
                this.ensureOpen();
                this.setPrefetchInternal((int)rows, false, true);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$149, Level.FINEST, OracleStatement.class, $$$methodRef$$$149, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$149, Level.FINEST, OracleStatement.class, $$$methodRef$$$149, this);
                ClioSupport.exiting($$$loggerRef$$$149, Level.FINEST, OracleStatement.class, $$$methodRef$$$149, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$149, Level.FINEST, OracleStatement.class, $$$methodRef$$$149, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$150, Level.FINEST, OracleStatement.class, $$$methodRef$$$150, this, new Object[0]);
            }
            this.ensureOpen();
            int n2 = this.getPrefetchInternal(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$150, Level.FINEST, OracleStatement.class, $$$methodRef$$$150, this, n2);
                ClioSupport.exiting($$$loggerRef$$$150, Level.FINEST, OracleStatement.class, $$$methodRef$$$150, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$150, Level.FINEST, OracleStatement.class, $$$methodRef$$$150, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$151, Level.FINEST, OracleStatement.class, $$$methodRef$$$151, this, new Object[0]);
            }
            this.ensureOpen();
            int n2 = this.userRsetType.getConcur();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$151, Level.FINEST, OracleStatement.class, $$$methodRef$$$151, this, n2);
                ClioSupport.exiting($$$loggerRef$$$151, Level.FINEST, OracleStatement.class, $$$methodRef$$$151, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$151, Level.FINEST, OracleStatement.class, $$$methodRef$$$151, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$152, Level.FINEST, OracleStatement.class, $$$methodRef$$$152, this, new Object[0]);
            }
            this.ensureOpen();
            int n2 = this.userRsetType.getType();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$152, Level.FINEST, OracleStatement.class, $$$methodRef$$$152, this, n2);
                ClioSupport.exiting($$$loggerRef$$$152, Level.FINEST, OracleStatement.class, $$$methodRef$$$152, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$152, Level.FINEST, OracleStatement.class, $$$methodRef$$$152, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$153, Level.FINEST, OracleStatement.class, $$$methodRef$$$153, this, new Object[0]);
            }
            this.ensureOpen();
            OracleConnection oracleConnection = this.connection.getWrapper();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$153, Level.FINEST, OracleStatement.class, $$$methodRef$$$153, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$153, Level.FINEST, OracleStatement.class, $$$methodRef$$$153, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$153, Level.FINEST, OracleStatement.class, $$$methodRef$$$153, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isOracleBatchStyle() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$154, Level.FINEST, OracleStatement.class, $$$methodRef$$$154, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$154, Level.FINEST, OracleStatement.class, $$$methodRef$$$154, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$154, Level.FINEST, OracleStatement.class, $$$methodRef$$$154, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$154, Level.FINEST, OracleStatement.class, $$$methodRef$$$154, this, throwable2);
            }
            throw throwable;
        }
    }

    void initBatch() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$155, Level.FINEST, OracleStatement.class, $$$methodRef$$$155, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$155, Level.FINEST, this.getClass(), $$$methodRef$$$155, "do nothing");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$155, Level.FINEST, OracleStatement.class, $$$methodRef$$$155, this);
                ClioSupport.exiting($$$loggerRef$$$155, Level.FINEST, OracleStatement.class, $$$methodRef$$$155, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$155, Level.FINEST, OracleStatement.class, $$$methodRef$$$155, this, throwable2);
            }
            throw throwable;
        }
    }

    int getBatchSize() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, new Object[0]);
            }
            if (this.m_batchItems == null) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, null);
                }
                return 0;
            }
            int n3 = this.m_batchItems.size();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, n3);
                ClioSupport.exiting($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$156, Level.FINEST, OracleStatement.class, $$$methodRef$$$156, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addBatchItem(String string) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$157, Level.FINEST, OracleStatement.class, $$$methodRef$$$157, this, string);
            }
            if (this.m_batchItems == null) {
                this.m_batchItems = new Vector();
            }
            this.m_batchItems.addElement((String)sql);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$157, Level.FINEST, OracleStatement.class, $$$methodRef$$$157, this);
                ClioSupport.exiting($$$loggerRef$$$157, Level.FINEST, OracleStatement.class, $$$methodRef$$$157, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$157, Level.FINEST, OracleStatement.class, $$$methodRef$$$157, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getBatchItem(int n2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, n2);
            }
            if (this.m_batchItems == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, string);
                    ClioSupport.exiting($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, null);
                }
                return null;
            }
            String string = this.m_batchItems.elementAt((int)index);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, string);
                ClioSupport.exiting($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$158, Level.FINEST, OracleStatement.class, $$$methodRef$$$158, this, throwable2);
            }
            throw throwable;
        }
    }

    void clearBatchItems() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$159, Level.FINEST, OracleStatement.class, $$$methodRef$$$159, this, new Object[0]);
            }
            if (this.m_batchItems != null) {
                this.m_batchItems.removeAllElements();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$159, Level.FINEST, OracleStatement.class, $$$methodRef$$$159, this);
                ClioSupport.exiting($$$loggerRef$$$159, Level.FINEST, OracleStatement.class, $$$methodRef$$$159, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$159, Level.FINEST, OracleStatement.class, $$$methodRef$$$159, this, throwable2);
            }
            throw throwable;
        }
    }

    void checkIfBatchExists() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$160, Level.FINEST, OracleStatement.class, $$$methodRef$$$160, this, new Object[0]);
            }
            if (this.getBatchSize() > 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$160, Level.FINEST, OracleStatement.class, $$$methodRef$$$160, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$160, Level.FINEST, OracleStatement.class, $$$methodRef$$$160, this);
                ClioSupport.exiting($$$loggerRef$$$160, Level.FINEST, OracleStatement.class, $$$methodRef$$$160, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$160, Level.FINEST, OracleStatement.class, $$$methodRef$$$160, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addBatch(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$161, Level.FINEST, OracleStatement.class, $$$methodRef$$$161, this, string);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void sql;
                this.ensureOpen();
                this.addBatchItem((String)sql);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$161, Level.FINEST, OracleStatement.class, $$$methodRef$$$161, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$161, Level.FINEST, OracleStatement.class, $$$methodRef$$$161, this);
                ClioSupport.exiting($$$loggerRef$$$161, Level.FINEST, OracleStatement.class, $$$methodRef$$$161, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$161, Level.FINEST, OracleStatement.class, $$$methodRef$$$161, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$162, Level.FINEST, OracleStatement.class, $$$methodRef$$$162, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                this.clearBatchCritical();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$162, Level.FINEST, OracleStatement.class, $$$methodRef$$$162, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$162, Level.FINEST, OracleStatement.class, $$$methodRef$$$162, this);
                ClioSupport.exiting($$$loggerRef$$$162, Level.FINEST, OracleStatement.class, $$$methodRef$$$162, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$162, Level.FINEST, OracleStatement.class, $$$methodRef$$$162, this, throwable4);
            }
            throw throwable;
        }
    }

    void clearBatchCritical() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$163, Level.FINEST, OracleStatement.class, $$$methodRef$$$163, this, new Object[0]);
            }
            this.ensureOpen();
            this.clearBatchItems();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$163, Level.FINEST, OracleStatement.class, $$$methodRef$$$163, this);
                ClioSupport.exiting($$$loggerRef$$$163, Level.FINEST, OracleStatement.class, $$$methodRef$$$163, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$163, Level.FINEST, OracleStatement.class, $$$methodRef$$$163, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int[] toIntArray(long[] lArray) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void la;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$164, Level.FINEST, OracleStatement.class, $$$methodRef$$$164, this, new Object[]{lArray});
            }
            int[] ia = new int[((void)la).length];
            for (int i2 = 0; i2 < ((void)la).length; ++i2) {
                ia[i2] = (int)la[i2];
            }
            int[] nArray = ia;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$164, Level.FINEST, OracleStatement.class, $$$methodRef$$$164, this, nArray);
                ClioSupport.exiting($$$loggerRef$$$164, Level.FINEST, OracleStatement.class, $$$methodRef$$$164, this, null);
            }
            return ia;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$164, Level.FINEST, OracleStatement.class, $$$methodRef$$$164, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int[] nArray;
            block11: {
                int[] nArray2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$165, Level.FINEST, OracleStatement.class, $$$methodRef$$$165, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    nArray = this.toIntArray(this.executeLargeBatch());
                    if (lock != null) {
                        lock.close();
                    }
                    nArray2 = nArray;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$165, Level.FINEST, OracleStatement.class, $$$methodRef$$$165, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$165, Level.FINEST, OracleStatement.class, $$$methodRef$$$165, this, nArray2);
                ClioSupport.exiting($$$loggerRef$$$165, Level.FINEST, OracleStatement.class, $$$methodRef$$$165, this, null);
            }
            return nArray;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$165, Level.FINEST, OracleStatement.class, $$$methodRef$$$165, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long[] lArray;
            block48: {
                long[] lArray2;
                int numberOfBatches;
                int i2;
                Monitor.CloseableLock lock;
                block43: {
                    long[] lArray3;
                    block44: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        this.ensureOpen();
                        this.cleanUpBeforeExecute();
                        this.cleanOldTempLobs();
                        i2 = 0;
                        numberOfBatches = this.getBatchSize();
                        this.checkSum = 0L;
                        this.checkSumComputationFailure = false;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$166, Level.FINEST, this.getClass(), $$$methodRef$$$166, "batch size is " + numberOfBatches);
                        }
                        if (numberOfBatches > 0) break block43;
                        lArray3 = new long[]{};
                        if (lock != null) {
                            lock.close();
                        }
                        long[] lArray4 = lArray3;
                        if (!bl) break block44;
                        ClioSupport.returning($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, lArray4);
                        ClioSupport.exiting($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, null);
                    }
                    return lArray3;
                }
                try {
                    long[] result;
                    block47: {
                        result = new long[numberOfBatches];
                        long startToken = 0L;
                        if (this.dmsExecute != null) {
                            startToken = this.dmsExecute.start();
                        }
                        try {
                            block46: {
                                this.connection.updateSystemContext();
                                this.ensureOpen();
                                this.prepareForNewResults(true, true, true);
                                int number_of_define_positions_saved = this.numberOfDefinePositions;
                                String savedSql = this.sqlObject.getOriginalSql();
                                OracleStatement.SqlKind savedSqlKind = this.sqlKind;
                                this.noMoreUpdateCounts = false;
                                int saveValidRows = 0;
                                try {
                                    this.connection.needLine();
                                    for (i2 = 0; i2 < numberOfBatches; ++i2) {
                                        long rowCount;
                                        block49: {
                                            block45: {
                                                this.sqlObject.initialize(this.getBatchItem(i2));
                                                this.sqlKind = this.sqlObject.getSqlKind();
                                                if (this.connection.dmsUpdateSqlText()) {
                                                    this.dmsSqlText.update(this.sqlObject.toString());
                                                }
                                                this.needToParse = true;
                                                this.numberOfDefinePositions = 0;
                                                this.rowsProcessed = 0L;
                                                this.currentRank = 1;
                                                if (this.sqlKind.isSELECT()) {
                                                    SQLException sQLException = (SQLException)DatabaseError.createBatchUpdateException(80, (Object)("invalid SELECT batch command " + i2), i2, result).fillInStackTrace();
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, sQLException);
                                                    }
                                                    throw sQLException;
                                                }
                                                if (!this.isOpen) {
                                                    this.connection.open(this);
                                                    this.isOpen = true;
                                                }
                                                rowCount = -1L;
                                                try {
                                                    this.cancelLock.enterExecuting();
                                                    if (this.queryTimeout != 0) {
                                                        this.connection.getTimeout().setTimeout((long)this.queryTimeout * 1000L, this);
                                                    }
                                                    this.executeForRows(false);
                                                    if (this.validRows > 0L) {
                                                        saveValidRows = (int)((long)saveValidRows + this.validRows);
                                                    }
                                                    rowCount = this.validRows;
                                                    this.cancelLock.exitExecuting();
                                                    if (this.queryTimeout == 0) break block45;
                                                }
                                                catch (SQLException ea) {
                                                    try {
                                                        this.needToParse = true;
                                                        this.resetCurrentRowBinders();
                                                        SQLException sQLException = ea;
                                                        if (bl) {
                                                            ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, sQLException);
                                                        }
                                                        throw sQLException;
                                                    }
                                                    catch (Throwable throwable) {
                                                        this.cancelLock.exitExecuting();
                                                        if (this.queryTimeout != 0) {
                                                            this.connection.getTimeout().cancelTimeout();
                                                        }
                                                        this.validRows = saveValidRows;
                                                        this.checkValidRowsStatus();
                                                        Throwable throwable2 = throwable;
                                                        if (bl) {
                                                            ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, throwable2);
                                                        }
                                                        throw throwable2;
                                                    }
                                                }
                                                this.connection.getTimeout().cancelTimeout();
                                            }
                                            this.validRows = saveValidRows;
                                            this.checkValidRowsStatus();
                                            if (!bl) break block49;
                                            OracleLog.debug($$$loggerRef$$$166, Level.FINEST, this.getClass(), $$$methodRef$$$166, "batch item " + i2 + ": return=" + rowCount);
                                        }
                                        result[i2] = rowCount;
                                        if (result[i2] >= 0L) continue;
                                        SQLException sQLException = (SQLException)DatabaseError.createBatchUpdateException(81, (Object)("command return value " + result[i2]), i2, result).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    this.clearBatchItems();
                                    this.numberOfDefinePositions = number_of_define_positions_saved;
                                    if (savedSql == null) break block46;
                                }
                                catch (SQLException e1) {
                                    try {
                                        if (e1 instanceof BatchUpdateException) {
                                            SQLException sQLException = e1;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, sQLException);
                                            }
                                            throw sQLException;
                                        }
                                        SQLException sQLException = (SQLException)DatabaseError.createBatchUpdateException(81, (Object)e1.getMessage(), i2, result).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    catch (Throwable throwable) {
                                        this.clearBatchItems();
                                        this.numberOfDefinePositions = number_of_define_positions_saved;
                                        if (savedSql != null) {
                                            this.sqlObject.initialize(savedSql);
                                            this.sqlKind = savedSqlKind;
                                        }
                                        this.currentRank = 0;
                                        this.batchWasExecuted = true;
                                        Throwable throwable3 = throwable;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, throwable3);
                                        }
                                        throw throwable3;
                                    }
                                }
                                this.sqlObject.initialize(savedSql);
                                this.sqlKind = savedSqlKind;
                            }
                            this.currentRank = 0;
                            this.batchWasExecuted = true;
                            if (this.dmsExecute == null) break block47;
                            this.dmsExecute.stop(startToken);
                        }
                        catch (Throwable throwable) {
                            if (this.dmsExecute != null) {
                                this.dmsExecute.stop(startToken);
                            }
                            Throwable throwable4 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, throwable4);
                            }
                            throw throwable4;
                        }
                    }
                    lArray = result;
                    if (lock != null) {
                        lock.close();
                    }
                    lArray2 = lArray;
                    if (!bl) break block48;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    }
                    Throwable throwable6 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, throwable6);
                    }
                    throw throwable6;
                }
                ClioSupport.returning($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, lArray2);
                ClioSupport.exiting($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, null);
            }
            return lArray;
        }
        catch (Throwable throwable) {
            Throwable throwable7 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$166, Level.FINEST, OracleStatement.class, $$$methodRef$$$166, this, throwable7);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void copyDefines(OracleStatement oracleStatement, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void src;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$167, Level.FINEST, OracleStatement.class, $$$methodRef$$$167, this, oracleStatement, n2);
            }
            if (src.columnsDefinedByUser) {
                Accessor[] srcAcc = src.accessors;
                this.accessors = new Accessor[srcAcc.length];
                for (int i2 = 0; i2 < srcAcc.length; ++i2) {
                    void numRows;
                    if (srcAcc[i2] == null) continue;
                    this.accessors[i2] = srcAcc[i2].copyForDefine(this);
                    this.accessors[i2].setCapacity((int)numRows);
                }
                this.numberOfDefinePositions = src.numberOfDefinePositions;
                this.definedColumnType = src.definedColumnType;
                this.definedColumnSize = src.definedColumnSize;
                this.definedColumnFormOfUse = src.definedColumnFormOfUse;
                this.columnsDefinedByUser = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$167, Level.FINEST, OracleStatement.class, $$$methodRef$$$167, this);
                ClioSupport.exiting($$$loggerRef$$$167, Level.FINEST, OracleStatement.class, $$$methodRef$$$167, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$167, Level.FINEST, OracleStatement.class, $$$methodRef$$$167, this, throwable2);
            }
            throw throwable;
        }
    }

    int copyBinds(Statement statement, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$168, Level.FINEST, OracleStatement.class, $$$methodRef$$$168, this, statement, n2);
            }
            int n3 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$168, Level.FINEST, OracleStatement.class, $$$methodRef$$$168, this, n3);
                ClioSupport.exiting($$$loggerRef$$$168, Level.FINEST, OracleStatement.class, $$$methodRef$$$168, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$168, Level.FINEST, OracleStatement.class, $$$methodRef$$$168, this, throwable2);
            }
            throw throwable;
        }
    }

    public void notifyCloseRset() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$169, Level.FINEST, OracleStatement.class, $$$methodRef$$$169, this, new Object[0]);
            }
            this.endOfResultSet(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$169, Level.FINEST, OracleStatement.class, $$$methodRef$$$169, this);
                ClioSupport.exiting($$$loggerRef$$$169, Level.FINEST, OracleStatement.class, $$$methodRef$$$169, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$169, Level.FINEST, OracleStatement.class, $$$methodRef$$$169, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getOriginalSql() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$170, Level.FINEST, OracleStatement.class, $$$methodRef$$$170, this, new Object[0]);
            }
            String string = this.sqlObject.getOriginalSql();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$170, Level.FINEST, OracleStatement.class, $$$methodRef$$$170, this, string);
                ClioSupport.exiting($$$loggerRef$$$170, Level.FINEST, OracleStatement.class, $$$methodRef$$$170, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$170, Level.FINEST, OracleStatement.class, $$$methodRef$$$170, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isRowidPrepended() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$171, Level.FINEST, OracleStatement.class, $$$methodRef$$$171, this, new Object[0]);
            }
            boolean bl2 = this.isRowidPrepended;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$171, Level.FINEST, OracleStatement.class, $$$methodRef$$$171, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$171, Level.FINEST, OracleStatement.class, $$$methodRef$$$171, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$171, Level.FINEST, OracleStatement.class, $$$methodRef$$$171, this, throwable2);
            }
            throw throwable;
        }
    }

    void computeOffsetOfFirstUserColumn() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$172, Level.FINEST, OracleStatement.class, $$$methodRef$$$172, this, new Object[0]);
            }
            this.offsetOfFirstUserColumn = -1;
            if (this.sqlKind.isSELECT()) {
                if (this.isRowidPrepended) {
                    ++this.offsetOfFirstUserColumn;
                }
            } else if (this.numReturnParams > 0) {
                this.offsetOfFirstUserColumn = this.numberOfBindPositions - this.numReturnParams - 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$172, Level.FINEST, OracleStatement.class, $$$methodRef$$$172, this);
                ClioSupport.exiting($$$loggerRef$$$172, Level.FINEST, OracleStatement.class, $$$methodRef$$$172, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$172, Level.FINEST, OracleStatement.class, $$$methodRef$$$172, this, throwable2);
            }
            throw throwable;
        }
    }

    void doScrollExecuteCommon() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this, new Object[0]);
            }
            if (!this.sqlKind.isSELECT()) {
                this.doExecuteWithTimeout();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this);
                    ClioSupport.exiting($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this, null);
                }
                return;
            }
            boolean needRowId = (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN ? this.userRsetType : this.realRsetType).isIdentifierRequired();
            if (!needRowId) {
                this.doExecuteWithTimeout();
                this.currentResultSet = this.createResultSet();
                this.realRsetType = this.userRsetType;
                if (this.realRsetType.isScrollable()) {
                    this.fetchMode = FetchMode.APPEND;
                }
            } else {
                try {
                    this.sqlObject.setIncludeRowid(true);
                    this.isRowidPrepended = true;
                    this.needToParse = true;
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$173, Level.FINEST, this.getClass(), $$$methodRef$$$173, "revised SQL:<" + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals) + ">");
                    }
                    this.prepareForNewResults(true, false, true);
                    if (this.columnsDefinedByUser) {
                        Accessor[] oldaccs = this.accessors;
                        if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                            this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                        }
                        if (oldaccs != null) {
                            for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                                Accessor accessor;
                                this.accessors[i2] = accessor = oldaccs[i2 - 1];
                                if (!accessor.isColumnNumberAware) continue;
                                accessor.updateColumnNumber(i2);
                            }
                        }
                        this.allocateRowidAccessor();
                        ++this.numberOfDefinePositions;
                    }
                    this.doExecuteWithTimeout();
                    this.currentResultSet = this.createResultSet();
                    this.realRsetType = this.userRsetType;
                    if (this.realRsetType.isScrollable()) {
                        this.fetchMode = FetchMode.APPEND;
                    }
                }
                catch (SQLException e2) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$173, Level.INFO, this.getClass(), $$$methodRef$$$173, "Downgrading ResultSet type/concurrence due to \n" + e2.getMessage(), e2);
                    }
                    this.realRsetType = this.userRsetType.downgrade();
                    this.fetchMode = this.cachedQueryResult != null ? FetchMode.APPEND : (this.realRsetType.isScrollable() ? FetchMode.APPEND : FetchMode.OVERWRITE);
                    this.isRowidPrepended = this.realRsetType.isIdentifierRequired();
                    this.sqlObject.setIncludeRowid(this.isRowidPrepended);
                    this.needToParse = true;
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$173, Level.FINEST, this.getClass(), $$$methodRef$$$173, "Trying type " + this.realRsetType + "...");
                    }
                    this.prepareForNewResults(true, false, true);
                    if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = true;
                        --this.numberOfDefinePositions;
                        System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                        this.accessors[this.numberOfDefinePositions] = null;
                        for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                            Accessor accessor = this.accessors[i3];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i3);
                        }
                    }
                    this.moveAllTempLobsToFree();
                    this.doExecuteWithTimeout();
                    this.currentResultSet = this.createResultSet();
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, e2.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this);
                ClioSupport.exiting($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$173, Level.FINEST, OracleStatement.class, $$$methodRef$$$173, this, throwable2);
            }
            throw throwable;
        }
    }

    void allocateRowidAccessor() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$174, Level.FINEST, OracleStatement.class, $$$methodRef$$$174, this, new Object[0]);
            }
            this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$174, Level.FINEST, OracleStatement.class, $$$methodRef$$$174, this);
                ClioSupport.exiting($$$loggerRef$$$174, Level.FINEST, OracleStatement.class, $$$methodRef$$$174, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$174, Level.FINEST, OracleStatement.class, $$$methodRef$$$174, this, throwable2);
            }
            throw throwable;
        }
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$175, Level.FINEST, OracleStatement.class, $$$methodRef$$$175, this, new Object[0]);
            }
            this.doScrollExecuteCommon();
            OracleResultSet oracleResultSet = this.currentResultSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$175, Level.FINEST, OracleStatement.class, $$$methodRef$$$175, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$175, Level.FINEST, OracleStatement.class, $$$methodRef$$$175, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$175, Level.FINEST, OracleStatement.class, $$$methodRef$$$175, this, throwable2);
            }
            throw throwable;
        }
    }

    void processDmlReturningBind() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$176, Level.FINEST, OracleStatement.class, $$$methodRef$$$176, this, new Object[0]);
            }
            this.returnParamsFetched = false;
            int count = 0;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                if (this.accessors[i2] == null) continue;
                ++count;
            }
            if (this.isAutoGeneratedKey) {
                this.numReturnParams = count;
            } else {
                if (this.numReturnParams <= 0) {
                    this.numReturnParams = this.sqlObject.getReturnParameterCount();
                }
                if (this.numReturnParams != count) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$176, Level.FINEST, OracleStatement.class, $$$methodRef$$$176, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            this.returnParamMeta[0] = this.numReturnParams;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$176, Level.FINEST, OracleStatement.class, $$$methodRef$$$176, this);
                ClioSupport.exiting($$$loggerRef$$$176, Level.FINEST, OracleStatement.class, $$$methodRef$$$176, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$176, Level.FINEST, OracleStatement.class, $$$methodRef$$$176, this, throwable2);
            }
            throw throwable;
        }
    }

    void allocateDmlReturnStorage() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$177, Level.FINEST, OracleStatement.class, $$$methodRef$$$177, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$177, Level.FINEST, OracleStatement.class, $$$methodRef$$$177, this);
                ClioSupport.exiting($$$loggerRef$$$177, Level.FINEST, OracleStatement.class, $$$methodRef$$$177, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$177, Level.FINEST, OracleStatement.class, $$$methodRef$$$177, this, throwable2);
            }
            throw throwable;
        }
    }

    void fetchDmlReturnParams() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$178, Level.FINEST, OracleStatement.class, $$$methodRef$$$178, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("fetchDmlReturnParams").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$178, Level.FINEST, OracleStatement.class, $$$methodRef$$$178, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$178, Level.FINEST, OracleStatement.class, $$$methodRef$$$178, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void registerReturnParameterInternal(int n2, int n3, int n4, int n5, short s2, String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void maxSize;
            void index;
            void internalType;
            String typeName;
            int form;
            void externalType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$179, Level.FINEST, OracleStatement.class, $$$methodRef$$$179, this, n2, n3, n4, n5, s2, string);
            }
            this.isDmlReturning = true;
            if (this.accessors == null) {
                this.accessors = new Accessor[this.numberOfBindPositions];
            }
            if (this.returnParamMeta == null) {
                this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
            }
            switch (externalType) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = 2;
                    break;
                }
                case 2009: {
                    typeName = "SYS.XMLTYPE";
                    break;
                }
            }
            Accessor accessor = this.allocateAccessor((int)internalType, (int)externalType, (int)(index + true), (int)maxSize, (short)form, typeName, true);
            accessor.isDMLReturnedParam = true;
            accessor.setCapacity(this.currentCapacity);
            this.accessors[index] = accessor;
            boolean isCharType = accessor.charLength > 0;
            this.returnParamMeta[3 + index * 4 + 0] = accessor.defineType;
            this.returnParamMeta[3 + index * 4 + 1] = isCharType ? 1 : 0;
            this.returnParamMeta[3 + index * 4 + 2] = isCharType ? accessor.charLength : accessor.byteLength;
            this.returnParamMeta[3 + index * 4 + 3] = form;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$179, Level.FINEST, OracleStatement.class, $$$methodRef$$$179, this);
                ClioSupport.exiting($$$loggerRef$$$179, Level.FINEST, OracleStatement.class, $$$methodRef$$$179, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$179, Level.FINEST, OracleStatement.class, $$$methodRef$$$179, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public int creationState() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$180, Level.FINEST, OracleStatement.class, $$$methodRef$$$180, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    int n3 = this.creationState;
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$180, Level.FINEST, OracleStatement.class, $$$methodRef$$$180, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$180, Level.FINEST, OracleStatement.class, $$$methodRef$$$180, this, n2);
                ClioSupport.exiting($$$loggerRef$$$180, Level.FINEST, OracleStatement.class, $$$methodRef$$$180, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$180, Level.FINEST, OracleStatement.class, $$$methodRef$$$180, this, throwable4);
            }
            throw throwable;
        }
    }

    public boolean isColumnSetNull(int n2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$181, Level.FINEST, OracleStatement.class, $$$methodRef$$$181, this, n2);
            }
            boolean bl2 = this.columnSetNull;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$181, Level.FINEST, OracleStatement.class, $$$methodRef$$$181, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$181, Level.FINEST, OracleStatement.class, $$$methodRef$$$181, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$181, Level.FINEST, OracleStatement.class, $$$methodRef$$$181, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isNCHAR(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean result;
            void columnIndex;
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$182, Level.FINEST, OracleStatement.class, $$$methodRef$$$182, this, n2);
            }
            if (!this.described) {
                this.describe();
            }
            if ((index = columnIndex - true) < 0 || index >= this.numberOfDefinePositions) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$182, Level.FINEST, OracleStatement.class, $$$methodRef$$$182, this, sQLException);
                }
                throw sQLException;
            }
            boolean bl2 = result = this.accessors[index].formOfUse == 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$182, Level.FINEST, OracleStatement.class, $$$methodRef$$$182, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$182, Level.FINEST, OracleStatement.class, $$$methodRef$$$182, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$182, Level.FINEST, OracleStatement.class, $$$methodRef$$$182, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addChild(OracleStatement oracleStatement) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void child;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$183, Level.FINEST, OracleStatement.class, $$$methodRef$$$183, this, oracleStatement);
            }
            child.nextChild = this.children;
            this.children = child;
            child.parent = this;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$183, Level.FINEST, OracleStatement.class, $$$methodRef$$$183, this);
                ClioSupport.exiting($$$loggerRef$$$183, Level.FINEST, OracleStatement.class, $$$methodRef$$$183, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$183, Level.FINEST, OracleStatement.class, $$$methodRef$$$183, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addImplicitResultSetStmt(OracleStatement oracleStatement) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void child;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$184, Level.FINEST, OracleStatement.class, $$$methodRef$$$184, this, oracleStatement);
            }
            this.implicitResultSetStatements.add((OracleStatement)child);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$184, Level.FINEST, OracleStatement.class, $$$methodRef$$$184, this);
                ClioSupport.exiting($$$loggerRef$$$184, Level.FINEST, OracleStatement.class, $$$methodRef$$$184, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$184, Level.FINEST, OracleStatement.class, $$$methodRef$$$184, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void removeChild(OracleStatement oracleStatement) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void child;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$185, Level.FINEST, OracleStatement.class, $$$methodRef$$$185, this, oracleStatement);
            }
            if (child == this.children) {
                this.children = child.nextChild;
            } else {
                OracleStatement c2 = this.children;
                while (c2.nextChild != child) {
                    c2 = c2.nextChild;
                }
                c2.nextChild = child.nextChild;
            }
            child.parent = null;
            child.nextChild = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$185, Level.FINEST, OracleStatement.class, $$$methodRef$$$185, this);
                ClioSupport.exiting($$$loggerRef$$$185, Level.FINEST, OracleStatement.class, $$$methodRef$$$185, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$185, Level.FINEST, OracleStatement.class, $$$methodRef$$$185, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleStatement stmt;
            void current;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, n2);
            }
            this.ensureOpen();
            switch (current) {
                case 1: {
                    if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                    this.currentResultSet.close();
                    break;
                }
                case 2: {
                    if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                    if (this.openImplicitResultSets == null) {
                        this.openImplicitResultSets = new ArrayDeque(this.implicitResultSetStatements == null ? 1 : this.implicitResultSetStatements.size());
                    }
                    this.openImplicitResultSets.add(this.currentResultSet);
                    this.currentResultSet = null;
                    break;
                }
                case 3: {
                    while (this.openImplicitResultSets != null && this.openImplicitResultSets.size() != 0) {
                        OracleResultSet rs = this.openImplicitResultSets.remove();
                        rs.close();
                    }
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getMoreResults").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (this.implicitResultSetIterator != null && this.implicitResultSetIterator.hasNext() && (stmt = this.implicitResultSetIterator.next()) != null) {
                this.currentResultSet = stmt.createResultSet();
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$186, Level.FINEST, OracleStatement.class, $$$methodRef$$$186, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleResultSet oracleResultSet;
            block20: {
                Monitor.CloseableLock lock;
                block18: {
                    ArrayDataResultSet arrayDataResultSet;
                    block19: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            ArrayDataResultSet emptyRS;
                            if (this.closed) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, sQLException);
                                }
                                throw sQLException;
                            }
                            if (this.isAutoGeneratedKey) break block18;
                            ArrayDataResultSet arrayDataResultSet2 = emptyRS = new ArrayDataResultSet(this.connection, null, null);
                            if (lock != null) {
                                lock.close();
                            }
                            arrayDataResultSet = arrayDataResultSet2;
                            if (!bl) break block19;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, arrayDataResultSet);
                        ClioSupport.exiting($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, null);
                    }
                    return arrayDataResultSet;
                }
                if (this.accessors == null || this.numReturnParams == 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, sQLException);
                    }
                    throw sQLException;
                }
                if (this.currentResultSet == null) {
                    this.isAllFetched = true;
                    this.currentResultSet = new OracleReturnResultSet(this.connection, this);
                    this.computeOffsetOfFirstUserColumn();
                    this.computeNumberOfUserColumns();
                }
                OracleResultSet oracleResultSet2 = this.currentResultSet;
                if (lock != null) {
                    lock.close();
                }
                oracleResultSet = oracleResultSet2;
                if (!bl) break block20;
                ClioSupport.returning($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$187, Level.FINEST, OracleStatement.class, $$$methodRef$$$187, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$188, Level.FINEST, OracleStatement.class, $$$methodRef$$$188, this, string, n2);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void autoGeneratedKeys;
                    void sql;
                    int n4 = (int)this.executeLargeUpdate((String)sql, (int)autoGeneratedKeys);
                    if (lock != null) {
                        lock.close();
                    }
                    n3 = n4;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$188, Level.FINEST, OracleStatement.class, $$$methodRef$$$188, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$188, Level.FINEST, OracleStatement.class, $$$methodRef$$$188, this, n3);
                ClioSupport.exiting($$$loggerRef$$$188, Level.FINEST, OracleStatement.class, $$$methodRef$$$188, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$188, Level.FINEST, OracleStatement.class, $$$methodRef$$$188, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long executeLargeUpdate(String string, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block17: {
                void autoGeneratedKeys;
                Monitor.CloseableLock lock;
                block15: {
                    long l3;
                    block16: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, string, n2);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            void sql;
                            this.cleanUpBeforeExecute();
                            this.autoKeyInfo = new AutoKeyInfo((String)sql);
                            if (autoGeneratedKeys != 2 && this.autoKeyInfo.isInsertOrUpdateSqlStmt()) break block15;
                            this.autoKeyInfo = null;
                            long l4 = this.executeLargeUpdate((String)sql);
                            if (lock != null) {
                                lock.close();
                            }
                            l3 = l4;
                            if (!bl) break block16;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, l3);
                        ClioSupport.exiting($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, null);
                    }
                    return l3;
                }
                if (autoGeneratedKeys != true) {
                    this.autoKeyInfo = null;
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, sQLException);
                    }
                    throw sQLException;
                }
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo.initialize(this.connection);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                long l5 = this.executeUpdateInternal(newSql);
                if (lock != null) {
                    lock.close();
                }
                l2 = l5;
                if (!bl) break block17;
                ClioSupport.returning($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, l2);
                ClioSupport.exiting($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$189, Level.FINEST, OracleStatement.class, $$$methodRef$$$189, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$190, Level.FINEST, OracleStatement.class, $$$methodRef$$$190, this, string, nArray);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void columnIndexes;
                    void sql;
                    int n3 = (int)this.executeLargeUpdate((String)sql, (int[])columnIndexes);
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$190, Level.FINEST, OracleStatement.class, $$$methodRef$$$190, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$190, Level.FINEST, OracleStatement.class, $$$methodRef$$$190, this, n2);
                ClioSupport.exiting($$$loggerRef$$$190, Level.FINEST, OracleStatement.class, $$$methodRef$$$190, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$190, Level.FINEST, OracleStatement.class, $$$methodRef$$$190, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block17: {
                void columnIndexes;
                Monitor.CloseableLock lock;
                block15: {
                    long l3;
                    block16: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, string, nArray);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            void sql;
                            this.cleanUpBeforeExecute();
                            if (columnIndexes == null || ((void)columnIndexes).length == 0) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, sQLException);
                                }
                                throw sQLException;
                            }
                            this.autoKeyInfo = new AutoKeyInfo((String)sql, (int[])columnIndexes);
                            if (this.autoKeyInfo.isInsertOrUpdateSqlStmt()) break block15;
                            this.autoKeyInfo = null;
                            long l4 = this.executeLargeUpdate((String)sql);
                            if (lock != null) {
                                lock.close();
                            }
                            l3 = l4;
                            if (!bl) break block16;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, l3);
                        ClioSupport.exiting($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, null);
                    }
                    return l3;
                }
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo.initialize(this.connection);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = ((void)columnIndexes).length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                long l5 = this.executeUpdateInternal(newSql);
                if (lock != null) {
                    lock.close();
                }
                l2 = l5;
                if (!bl) break block17;
                ClioSupport.returning($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, l2);
                ClioSupport.exiting($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$191, Level.FINEST, OracleStatement.class, $$$methodRef$$$191, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$192, Level.FINEST, OracleStatement.class, $$$methodRef$$$192, this, string, stringArray);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void columnNames;
                    void sql;
                    int n3 = (int)this.executeLargeUpdate((String)sql, (String[])columnNames);
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$192, Level.FINEST, OracleStatement.class, $$$methodRef$$$192, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$192, Level.FINEST, OracleStatement.class, $$$methodRef$$$192, this, n2);
                ClioSupport.exiting($$$loggerRef$$$192, Level.FINEST, OracleStatement.class, $$$methodRef$$$192, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$192, Level.FINEST, OracleStatement.class, $$$methodRef$$$192, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block17: {
                void columnNames;
                Monitor.CloseableLock lock;
                block15: {
                    long l3;
                    block16: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, string, stringArray);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            void sql;
                            this.cleanUpBeforeExecute();
                            if (columnNames == null || ((void)columnNames).length == 0) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, sQLException);
                                }
                                throw sQLException;
                            }
                            this.autoKeyInfo = new AutoKeyInfo((String)sql, (String[])columnNames);
                            if (this.autoKeyInfo.isInsertOrUpdateSqlStmt()) break block15;
                            this.autoKeyInfo = null;
                            long l4 = this.executeLargeUpdate((String)sql);
                            if (lock != null) {
                                lock.close();
                            }
                            l3 = l4;
                            if (!bl) break block16;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, l3);
                        ClioSupport.exiting($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, null);
                    }
                    return l3;
                }
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo.initialize(this.connection);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = ((void)columnNames).length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                long l5 = this.executeUpdateInternal(newSql);
                if (lock != null) {
                    lock.close();
                }
                l2 = l5;
                if (!bl) break block17;
                ClioSupport.returning($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, l2);
                ClioSupport.exiting($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$193, Level.FINEST, OracleStatement.class, $$$methodRef$$$193, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(String string, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                void autoGeneratedKeys;
                void sql;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, string, n2);
                }
                this.autoKeyInfo = new AutoKeyInfo((String)sql);
                if (autoGeneratedKeys == 2 || !this.autoKeyInfo.isInsertOrUpdateSqlStmt()) {
                    this.autoKeyInfo = null;
                    boolean bl3 = this.execute((String)sql);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, null);
                    }
                    return bl3;
                }
                if (autoGeneratedKeys != true) {
                    this.autoKeyInfo = null;
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, sQLException);
                    }
                    throw sQLException;
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.cleanUpBeforeExecute();
                    this.isAutoGeneratedKey = true;
                    this.autoKeyInfo.initialize(this.connection);
                    String newSql = this.autoKeyInfo.getNewSql();
                    this.numberOfBindPositions = 1;
                    this.autoKeyRegisterReturnParams();
                    this.processDmlReturningBind();
                    boolean bl4 = this.executeInternal(newSql);
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl4;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$194, Level.FINEST, OracleStatement.class, $$$methodRef$$$194, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                void sql;
                void columnIndexes;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, string, nArray);
                }
                if (columnIndexes == null || ((void)columnIndexes).length == 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, sQLException);
                    }
                    throw sQLException;
                }
                this.autoKeyInfo = new AutoKeyInfo((String)sql, (int[])columnIndexes);
                if (!this.autoKeyInfo.isInsertOrUpdateSqlStmt()) {
                    this.autoKeyInfo = null;
                    boolean bl3 = this.execute((String)sql);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, null);
                    }
                    return bl3;
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.cleanUpBeforeExecute();
                    this.isAutoGeneratedKey = true;
                    this.autoKeyInfo.initialize(this.connection);
                    String newSql = this.autoKeyInfo.getNewSql();
                    this.numberOfBindPositions = ((void)columnIndexes).length;
                    this.autoKeyRegisterReturnParams();
                    this.processDmlReturningBind();
                    boolean bl4 = this.executeInternal(newSql);
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl4;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$195, Level.FINEST, OracleStatement.class, $$$methodRef$$$195, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                void sql;
                void columnNames;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, string, stringArray);
                }
                if (columnNames == null || ((void)columnNames).length == 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, sQLException);
                    }
                    throw sQLException;
                }
                this.autoKeyInfo = new AutoKeyInfo((String)sql, (String[])columnNames);
                if (!this.autoKeyInfo.isInsertOrUpdateSqlStmt()) {
                    this.autoKeyInfo = null;
                    boolean bl3 = this.execute((String)sql);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, null);
                    }
                    return bl3;
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.cleanUpBeforeExecute();
                    this.isAutoGeneratedKey = true;
                    this.autoKeyInfo.initialize(this.connection);
                    String newSql = this.autoKeyInfo.getNewSql();
                    this.numberOfBindPositions = ((void)columnNames).length;
                    this.autoKeyRegisterReturnParams();
                    this.processDmlReturningBind();
                    boolean bl4 = this.executeInternal(newSql);
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl4;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$196, Level.FINEST, OracleStatement.class, $$$methodRef$$$196, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$197, Level.FINEST, OracleStatement.class, $$$methodRef$$$197, this, new Object[0]);
            }
            this.ensureOpen();
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$197, Level.FINEST, OracleStatement.class, $$$methodRef$$$197, this, n2);
                ClioSupport.exiting($$$loggerRef$$$197, Level.FINEST, OracleStatement.class, $$$methodRef$$$197, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$197, Level.FINEST, OracleStatement.class, $$$methodRef$$$197, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getcacheState() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$198, Level.FINEST, OracleStatement.class, $$$methodRef$$$198, this, new Object[0]);
            }
            int n2 = this.cacheState;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$198, Level.FINEST, OracleStatement.class, $$$methodRef$$$198, this, n2);
                ClioSupport.exiting($$$loggerRef$$$198, Level.FINEST, OracleStatement.class, $$$methodRef$$$198, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$198, Level.FINEST, OracleStatement.class, $$$methodRef$$$198, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getstatementType() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$199, Level.FINEST, OracleStatement.class, $$$methodRef$$$199, this, new Object[0]);
            }
            int n2 = this.statementType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$199, Level.FINEST, OracleStatement.class, $$$methodRef$$$199, this, n2);
                ClioSupport.exiting($$$loggerRef$$$199, Level.FINEST, OracleStatement.class, $$$methodRef$$$199, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$199, Level.FINEST, OracleStatement.class, $$$methodRef$$$199, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getserverCursor() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$200, Level.FINEST, OracleStatement.class, $$$methodRef$$$200, this, new Object[0]);
            }
            boolean bl2 = this.serverCursor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$200, Level.FINEST, OracleStatement.class, $$$methodRef$$$200, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$200, Level.FINEST, OracleStatement.class, $$$methodRef$$$200, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$200, Level.FINEST, OracleStatement.class, $$$methodRef$$$200, this, throwable2);
            }
            throw throwable;
        }
    }

    void initializeIndicatorSubRange() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$201, Level.FINEST, OracleStatement.class, $$$methodRef$$$201, this, new Object[0]);
            }
            this.bindIndicatorSubRange = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$201, Level.FINEST, OracleStatement.class, $$$methodRef$$$201, this);
                ClioSupport.exiting($$$loggerRef$$$201, Level.FINEST, OracleStatement.class, $$$methodRef$$$201, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$201, Level.FINEST, OracleStatement.class, $$$methodRef$$$201, this, throwable2);
            }
            throw throwable;
        }
    }

    private void autoKeyRegisterReturnParams() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$202, Level.FINEST, OracleStatement.class, $$$methodRef$$$202, this, new Object[0]);
            }
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
            }
            this.initializeIndicatorSubRange();
            int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
            int indicatorSize = preambleSize + 2 * this.numberOfBindPositions;
            this.bindIndicators = new short[indicatorSize];
            int metadataOffset = this.bindIndicatorSubRange;
            this.bindIndicators[metadataOffset + 0] = (short)this.numberOfBindPositions;
            this.bindIndicators[metadataOffset + 1] = 0;
            this.bindIndicators[metadataOffset + 2] = 1;
            this.bindIndicators[metadataOffset + 3] = 0;
            this.bindIndicators[metadataOffset + 4] = 1;
            metadataOffset += 5;
            short[] formOfUses = this.autoKeyInfo.tableFormOfUses;
            int[] columnIndexes = this.autoKeyInfo.columnIndexes;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                short form;
                this.bindIndicators[metadataOffset + 0] = 994;
                short s2 = form = this.connection.defaultnchar ? (short)2 : 1;
                if (formOfUses != null && columnIndexes != null && formOfUses[columnIndexes[i2] - 1] == 2) {
                    this.bindIndicators[metadataOffset + 9] = form = 2;
                }
                metadataOffset += 10;
                this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
                String typeName = null;
                if (this.autoKeyInfo.returnTypes[i2] == 111) {
                    typeName = this.autoKeyInfo.tableTypeNames[columnIndexes[i2] - 1];
                }
                this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, form, typeName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$202, Level.FINEST, OracleStatement.class, $$$methodRef$$$202, this);
                ClioSupport.exiting($$$loggerRef$$$202, Level.FINEST, OracleStatement.class, $$$methodRef$$$202, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$202, Level.FINEST, OracleStatement.class, $$$methodRef$$$202, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void cleanUpBeforeExecute() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$203, Level.FINEST, OracleStatement.class, $$$methodRef$$$203, this, new Object[0]);
            }
            this.awaitResultSetPublishing();
            if (this.currentResultSet != null && this.isCloseOnCompletion) {
                this.currentResultSet.close();
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$203, Level.FINEST, OracleStatement.class, $$$methodRef$$$203, this, sQLException);
                }
                throw sQLException;
            }
            this.isAutoGeneratedKey = false;
            this.numberOfBindPositions = 0;
            this.bindIndicators = null;
            this.returnParamMeta = null;
            if (this.executeDoneForDefines) {
                this.clearDefines();
            } else {
                this.executeDoneForDefines = true;
            }
            this.batchWasExecuted = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$203, Level.FINEST, OracleStatement.class, $$$methodRef$$$203, this);
                ClioSupport.exiting($$$loggerRef$$$203, Level.FINEST, OracleStatement.class, $$$methodRef$$$203, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$203, Level.FINEST, OracleStatement.class, $$$methodRef$$$203, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void checkTypeForAutoKey(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$204, Level.FINEST, OracleStatement.class, $$$methodRef$$$204, this, n2);
            }
            if (type == 109) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$204, Level.FINEST, OracleStatement.class, $$$methodRef$$$204, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$204, Level.FINEST, OracleStatement.class, $$$methodRef$$$204, this);
                ClioSupport.exiting($$$loggerRef$$$204, Level.FINEST, OracleStatement.class, $$$methodRef$$$204, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$204, Level.FINEST, OracleStatement.class, $$$methodRef$$$204, this, throwable2);
            }
            throw throwable;
        }
    }

    void moveAllTempLobsToFree() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$205, Level.FINEST, OracleStatement.class, $$$methodRef$$$205, this, new Object[0]);
            }
            if (this.oldTempClobsToFree != null) {
                if (this.tempStmtClobsToFree == null) {
                    this.tempStmtClobsToFree = this.oldTempClobsToFree;
                } else {
                    this.tempStmtClobsToFree.addAll(this.oldTempClobsToFree);
                }
                this.oldTempClobsToFree = null;
            }
            if (this.oldTempBlobsToFree != null) {
                if (this.tempStmtBlobsToFree == null) {
                    this.tempStmtBlobsToFree = this.oldTempBlobsToFree;
                } else {
                    this.tempStmtBlobsToFree.addAll(this.oldTempBlobsToFree);
                }
                this.oldTempBlobsToFree = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$205, Level.FINEST, OracleStatement.class, $$$methodRef$$$205, this);
                ClioSupport.exiting($$$loggerRef$$$205, Level.FINEST, OracleStatement.class, $$$methodRef$$$205, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$205, Level.FINEST, OracleStatement.class, $$$methodRef$$$205, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void moveTempLobsToFree(CLOB cLOB) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void tclob;
            int index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$206, Level.FINEST, OracleStatement.class, $$$methodRef$$$206, this, cLOB);
            }
            if (this.oldTempClobsToFree != null && (index = this.oldTempClobsToFree.indexOf(tclob)) != -1) {
                this.addToTempLobsToFree((CLOB)tclob);
                this.oldTempClobsToFree.remove(index);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$206, Level.FINEST, OracleStatement.class, $$$methodRef$$$206, this);
                ClioSupport.exiting($$$loggerRef$$$206, Level.FINEST, OracleStatement.class, $$$methodRef$$$206, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$206, Level.FINEST, OracleStatement.class, $$$methodRef$$$206, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void moveTempLobsToFree(BLOB bLOB) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void tblob;
            int index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$207, Level.FINEST, OracleStatement.class, $$$methodRef$$$207, this, bLOB);
            }
            if (this.oldTempBlobsToFree != null && (index = this.oldTempBlobsToFree.indexOf(tblob)) != -1) {
                this.addToTempLobsToFree((BLOB)tblob);
                this.oldTempBlobsToFree.remove(index);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$207, Level.FINEST, OracleStatement.class, $$$methodRef$$$207, this);
                ClioSupport.exiting($$$loggerRef$$$207, Level.FINEST, OracleStatement.class, $$$methodRef$$$207, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$207, Level.FINEST, OracleStatement.class, $$$methodRef$$$207, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addToTempLobsToFree(CLOB cLOB) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            block10: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$208, Level.FINEST, OracleStatement.class, $$$methodRef$$$208, this, cLOB);
                }
                try {
                    void tclob;
                    if (this.currentResultSet != null && this.currentResultSet.getType() == 1003 && !this.sqlKind.isPlsqlOrCall()) {
                        this.tempRowClobsToFree.add((CLOB)tclob);
                    } else {
                        if (this.tempStmtClobsToFree == null) {
                            this.tempStmtClobsToFree = new ArrayList();
                        }
                        this.tempStmtClobsToFree.add((CLOB)tclob);
                    }
                }
                catch (SQLException ea) {
                    if (!bl) break block10;
                    OracleLog.warning($$$loggerRef$$$208, this.getClass(), $$$methodRef$$$208, " exception XXXXX " + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$208, Level.FINEST, OracleStatement.class, $$$methodRef$$$208, this);
                ClioSupport.exiting($$$loggerRef$$$208, Level.FINEST, OracleStatement.class, $$$methodRef$$$208, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$208, Level.FINEST, OracleStatement.class, $$$methodRef$$$208, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addToTempLobsToFree(BLOB bLOB) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            block10: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$209, Level.FINEST, OracleStatement.class, $$$methodRef$$$209, this, bLOB);
                }
                try {
                    void tblob;
                    if (this.currentResultSet != null && this.currentResultSet.getType() == 1003 && !this.sqlKind.isPlsqlOrCall()) {
                        this.tempRowBlobsToFree.add((BLOB)tblob);
                    } else {
                        if (this.tempStmtBlobsToFree == null) {
                            this.tempStmtBlobsToFree = new ArrayList();
                        }
                        this.tempStmtBlobsToFree.add((BLOB)tblob);
                    }
                }
                catch (SQLException ea) {
                    if (!bl) break block10;
                    OracleLog.warning($$$loggerRef$$$209, this.getClass(), $$$methodRef$$$209, " exception XXXXX " + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$209, Level.FINEST, OracleStatement.class, $$$methodRef$$$209, this);
                ClioSupport.exiting($$$loggerRef$$$209, Level.FINEST, OracleStatement.class, $$$methodRef$$$209, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$209, Level.FINEST, OracleStatement.class, $$$methodRef$$$209, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanAllTempLobs() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$210, Level.FINEST, OracleStatement.class, $$$methodRef$$$210, this, new Object[0]);
            }
            this.cleanTempClobs(this.tempStmtClobsToFree);
            this.tempStmtClobsToFree = null;
            this.cleanTempBlobs(this.tempStmtBlobsToFree);
            this.tempStmtBlobsToFree = null;
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.oldTempClobsToFree = null;
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempBlobsToFree = null;
            this.cleanAllRowLobs();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$210, Level.FINEST, OracleStatement.class, $$$methodRef$$$210, this);
                ClioSupport.exiting($$$loggerRef$$$210, Level.FINEST, OracleStatement.class, $$$methodRef$$$210, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$210, Level.FINEST, OracleStatement.class, $$$methodRef$$$210, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanAllRowLobs() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$211, Level.FINEST, OracleStatement.class, $$$methodRef$$$211, this, new Object[0]);
            }
            if (!this.tempRowClobsToFree.isEmpty()) {
                this.cleanTempClobs(this.tempRowClobsToFree);
                this.tempRowClobsToFree.clear();
            }
            if (!this.tempRowBlobsToFree.isEmpty()) {
                this.cleanTempBlobs(this.tempRowBlobsToFree);
                this.tempRowBlobsToFree.clear();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$211, Level.FINEST, OracleStatement.class, $$$methodRef$$$211, this);
                ClioSupport.exiting($$$loggerRef$$$211, Level.FINEST, OracleStatement.class, $$$methodRef$$$211, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$211, Level.FINEST, OracleStatement.class, $$$methodRef$$$211, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanOldTempLobs() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$212, Level.FINEST, OracleStatement.class, $$$methodRef$$$212, this, new Object[0]);
            }
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempClobsToFree = this.tempStmtClobsToFree;
            this.tempStmtClobsToFree = null;
            this.oldTempBlobsToFree = this.tempStmtBlobsToFree;
            this.tempStmtBlobsToFree = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$212, Level.FINEST, OracleStatement.class, $$$methodRef$$$212, this);
                ClioSupport.exiting($$$loggerRef$$$212, Level.FINEST, OracleStatement.class, $$$methodRef$$$212, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$212, Level.FINEST, OracleStatement.class, $$$methodRef$$$212, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void cleanTempClobs(ArrayList<CLOB> arrayList) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$213, Level.FINEST, OracleStatement.class, $$$methodRef$$$213, this, arrayList);
            }
            if (x2 != null) {
                Iterator iter = x2.iterator();
                while (iter.hasNext()) {
                    try {
                        ((CLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!bl) continue;
                        OracleLog.warning($$$loggerRef$$$213, this.getClass(), $$$methodRef$$$213, " exception " + e2.getMessage());
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$213, Level.FINEST, OracleStatement.class, $$$methodRef$$$213, this);
                ClioSupport.exiting($$$loggerRef$$$213, Level.FINEST, OracleStatement.class, $$$methodRef$$$213, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$213, Level.FINEST, OracleStatement.class, $$$methodRef$$$213, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void cleanTempBlobs(ArrayList<BLOB> arrayList) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$214, Level.FINEST, OracleStatement.class, $$$methodRef$$$214, this, arrayList);
            }
            if (x2 != null) {
                Iterator iter = x2.iterator();
                while (iter.hasNext()) {
                    try {
                        ((BLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!bl) continue;
                        OracleLog.warning($$$loggerRef$$$214, this.getClass(), $$$methodRef$$$214, " exception " + e2.getMessage());
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$214, Level.FINEST, OracleStatement.class, $$$methodRef$$$214, this);
                ClioSupport.exiting($$$loggerRef$$$214, Level.FINEST, OracleStatement.class, $$$methodRef$$$214, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$214, Level.FINEST, OracleStatement.class, $$$methodRef$$$214, this, throwable2);
            }
            throw throwable;
        }
    }

    TimeZone getDefaultTimeZone() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$215, Level.FINEST, OracleStatement.class, $$$methodRef$$$215, this, new Object[0]);
            }
            TimeZone timeZone = this.getDefaultTimeZone(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$215, Level.FINEST, OracleStatement.class, $$$methodRef$$$215, this, timeZone);
                ClioSupport.exiting($$$loggerRef$$$215, Level.FINEST, OracleStatement.class, $$$methodRef$$$215, this, null);
            }
            return timeZone;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$215, Level.FINEST, OracleStatement.class, $$$methodRef$$$215, this, throwable2);
            }
            throw throwable;
        }
    }

    TimeZone getDefaultTimeZone(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$216, Level.FINEST, OracleStatement.class, $$$methodRef$$$216, this, bl);
            }
            if (this.defaultTimeZone == null) {
                block9: {
                    try {
                        this.defaultTimeZone = this.connection.getDefaultTimeZone();
                    }
                    catch (SQLException ea) {
                        if (!bl2) break block9;
                        OracleLog.warning($$$loggerRef$$$216, this.getClass(), $$$methodRef$$$216, " exception XXXXX " + ea.getMessage());
                    }
                }
                if (this.defaultTimeZone == null) {
                    this.defaultTimeZone = TimeZone.getDefault();
                }
            }
            TimeZone timeZone = this.defaultTimeZone;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$216, Level.FINEST, OracleStatement.class, $$$methodRef$$$216, this, timeZone);
                ClioSupport.exiting($$$loggerRef$$$216, Level.FINEST, OracleStatement.class, $$$methodRef$$$216, this, null);
            }
            return timeZone;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$216, Level.FINEST, OracleStatement.class, $$$methodRef$$$216, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration databaseChangeRegistration) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void _registration;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$217, Level.FINEST, OracleStatement.class, $$$methodRef$$$217, this, databaseChangeRegistration);
            }
            this.registration = (NTFDCNRegistration)_registration;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$217, Level.FINEST, OracleStatement.class, $$$methodRef$$$217, this);
                ClioSupport.exiting($$$loggerRef$$$217, Level.FINEST, OracleStatement.class, $$$methodRef$$$217, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$217, Level.FINEST, OracleStatement.class, $$$methodRef$$$217, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$218, Level.FINEST, OracleStatement.class, $$$methodRef$$$218, this, new Object[0]);
            }
            String[] stringArray = this.dcnTableName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$218, Level.FINEST, OracleStatement.class, $$$methodRef$$$218, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$218, Level.FINEST, OracleStatement.class, $$$methodRef$$$218, this, null);
            }
            return this.dcnTableName;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$218, Level.FINEST, OracleStatement.class, $$$methodRef$$$218, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$219, Level.FINEST, OracleStatement.class, $$$methodRef$$$219, this, new Object[0]);
            }
            long l2 = this.dcnQueryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$219, Level.FINEST, OracleStatement.class, $$$methodRef$$$219, this, l2);
                ClioSupport.exiting($$$loggerRef$$$219, Level.FINEST, OracleStatement.class, $$$methodRef$$$219, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$219, Level.FINEST, OracleStatement.class, $$$methodRef$$$219, this, throwable2);
            }
            throw throwable;
        }
    }

    Calendar getDefaultCalendar() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$220, Level.FINEST, OracleStatement.class, $$$methodRef$$$220, this, new Object[0]);
            }
            if (this.defaultCalendar == null) {
                this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone(), Locale.US);
            }
            Calendar calendar = this.defaultCalendar;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$220, Level.FINEST, OracleStatement.class, $$$methodRef$$$220, this, calendar);
                ClioSupport.exiting($$$loggerRef$$$220, Level.FINEST, OracleStatement.class, $$$methodRef$$$220, this, null);
            }
            return calendar;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$220, Level.FINEST, OracleStatement.class, $$$methodRef$$$220, this, throwable2);
            }
            throw throwable;
        }
    }

    void releaseBuffers() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$221, Level.FINEST, OracleStatement.class, $$$methodRef$$$221, this, new Object[0]);
            }
            this.rowData.free();
            if (this.bindData != null && this.bindData != this.rowData) {
                this.bindData.free();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$221, Level.FINEST, OracleStatement.class, $$$methodRef$$$221, this);
                ClioSupport.exiting($$$loggerRef$$$221, Level.FINEST, OracleStatement.class, $$$methodRef$$$221, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$221, Level.FINEST, OracleStatement.class, $$$methodRef$$$221, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$222, Level.FINEST, OracleStatement.class, $$$methodRef$$$222, this, new Object[0]);
            }
            boolean bl2 = this.closed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$222, Level.FINEST, OracleStatement.class, $$$methodRef$$$222, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$222, Level.FINEST, OracleStatement.class, $$$methodRef$$$222, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$222, Level.FINEST, OracleStatement.class, $$$methodRef$$$222, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$223, Level.FINEST, OracleStatement.class, $$$methodRef$$$223, this, new Object[0]);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$223, Level.FINEST, OracleStatement.class, $$$methodRef$$$223, this, sQLException);
                }
                throw sQLException;
            }
            boolean bl3 = bl2 = this.cacheState != 3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$223, Level.FINEST, OracleStatement.class, $$$methodRef$$$223, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$223, Level.FINEST, OracleStatement.class, $$$methodRef$$$223, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$223, Level.FINEST, OracleStatement.class, $$$methodRef$$$223, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPoolable(boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void poolable;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$224, Level.FINEST, OracleStatement.class, $$$methodRef$$$224, this, bl);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$224, Level.FINEST, OracleStatement.class, $$$methodRef$$$224, this, sQLException);
                }
                throw sQLException;
            }
            this.cacheState = poolable != false ? 1 : 3;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$224, Level.FINEST, OracleStatement.class, $$$methodRef$$$224, this);
                ClioSupport.exiting($$$loggerRef$$$224, Level.FINEST, OracleStatement.class, $$$methodRef$$$224, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$224, Level.FINEST, OracleStatement.class, $$$methodRef$$$224, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$225, Level.FINEST, OracleStatement.class, $$$methodRef$$$225, this, clazz);
            }
            if (iface.isInterface()) {
                boolean bl2 = iface.isInstance(this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$225, Level.FINEST, OracleStatement.class, $$$methodRef$$$225, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$225, Level.FINEST, OracleStatement.class, $$$methodRef$$$225, this, null);
                }
                return bl2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$225, Level.FINEST, OracleStatement.class, $$$methodRef$$$225, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$225, Level.FINEST, OracleStatement.class, $$$methodRef$$$225, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$226, Level.FINEST, OracleStatement.class, $$$methodRef$$$226, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleStatement oracleStatement = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$226, Level.FINEST, OracleStatement.class, $$$methodRef$$$226, this, oracleStatement);
                    ClioSupport.exiting($$$loggerRef$$$226, Level.FINEST, OracleStatement.class, $$$methodRef$$$226, this, null);
                }
                return (T)oracleStatement;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$226, Level.FINEST, OracleStatement.class, $$$methodRef$$$226, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$226, Level.FINEST, OracleStatement.class, $$$methodRef$$$226, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    <T> T getObject(long l2, int n2, Class<T> clazz) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void rowIndex;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$227, Level.FINEST, OracleStatement.class, $$$methodRef$$$227, this, l2, n2, clazz);
            }
            this.lastIndex = columnIndex;
            if (this.streamList != null) {
                this.closeUsedStreams((int)columnIndex);
            }
            Object t2 = this.accessors[columnIndex + this.offsetOfFirstUserColumn].getObject(this.physicalRowIndex((long)rowIndex), type);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$227, Level.FINEST, OracleStatement.class, $$$methodRef$$$227, this, t2);
                ClioSupport.exiting($$$loggerRef$$$227, Level.FINEST, OracleStatement.class, $$$methodRef$$$227, this, null);
            }
            return t2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$227, Level.FINEST, OracleStatement.class, $$$methodRef$$$227, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getBytes(long l2, int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            int n4;
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$228, Level.FINEST, OracleStatement.class, $$$methodRef$$$228, this, l2, n2, byArray, n3);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    void offset;
                    void buffer;
                    void rowIndex;
                    void columnIndex;
                    this.lastIndex = columnIndex;
                    if (this.streamList != null) {
                        this.closeUsedStreams((int)columnIndex);
                    }
                    int n5 = this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBytes(this.physicalRowIndex((long)rowIndex), (byte[])buffer, (int)offset);
                    if (lock != null) {
                        lock.close();
                    }
                    n4 = n5;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$228, Level.FINEST, OracleStatement.class, $$$methodRef$$$228, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$228, Level.FINEST, OracleStatement.class, $$$methodRef$$$228, this, n4);
                ClioSupport.exiting($$$loggerRef$$$228, Level.FINEST, OracleStatement.class, $$$methodRef$$$228, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$228, Level.FINEST, OracleStatement.class, $$$methodRef$$$228, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    RowId getPrependedRowId(long l2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$229, Level.FINEST, OracleStatement.class, $$$methodRef$$$229, this, l2);
            }
            if (!$assertionsDisabled && !this.isRowidPrepended) {
                AssertionError assertionError = new AssertionError((Object)"no rowid");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$229, Level.FINEST, OracleStatement.class, $$$methodRef$$$229, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            ROWID rOWID = this.accessors[0].getROWID(this.physicalRowIndex((long)rowIndex));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$229, Level.FINEST, OracleStatement.class, $$$methodRef$$$229, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$229, Level.FINEST, OracleStatement.class, $$$methodRef$$$229, this, null);
            }
            return rOWID;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$229, Level.FINEST, OracleStatement.class, $$$methodRef$$$229, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(long l2, int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$230, Level.FINEST, OracleStatement.class, $$$methodRef$$$230, this, l2, n2);
            }
            this.lastIndex = columnIndex;
            if (this.streamList != null) {
                this.closeUsedStreams((int)columnIndex);
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.accessors[columnIndex - true].getAuthorizationIndicator(this.physicalRowIndex((long)rowIndex));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$230, Level.FINEST, OracleStatement.class, $$$methodRef$$$230, this, (Object)authorizationIndicator);
                ClioSupport.exiting($$$loggerRef$$$230, Level.FINEST, OracleStatement.class, $$$methodRef$$$230, this, null);
            }
            return authorizationIndicator;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$230, Level.FINEST, OracleStatement.class, $$$methodRef$$$230, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$231, Level.FINEST, OracleStatement.class, $$$methodRef$$$231, this, new Object[0]);
            }
            PhysicalConnection physicalConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$231, Level.FINEST, OracleStatement.class, $$$methodRef$$$231, this, physicalConnection);
                ClioSupport.exiting($$$loggerRef$$$231, Level.FINEST, OracleStatement.class, $$$methodRef$$$231, this, null);
            }
            return physicalConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$231, Level.FINEST, OracleStatement.class, $$$methodRef$$$231, this, throwable2);
            }
            throw throwable;
        }
    }

    Calendar getGMTCalendar() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$232, Level.FINEST, OracleStatement.class, $$$methodRef$$$232, this, new Object[0]);
            }
            if (this.gmtCalendar == null) {
                this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
            }
            Calendar calendar = this.gmtCalendar;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$232, Level.FINEST, OracleStatement.class, $$$methodRef$$$232, this, calendar);
                ClioSupport.exiting($$$loggerRef$$$232, Level.FINEST, OracleStatement.class, $$$methodRef$$$232, this, null);
            }
            return calendar;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$232, Level.FINEST, OracleStatement.class, $$$methodRef$$$232, this, throwable2);
            }
            throw throwable;
        }
    }

    void extractNioDefineBuffers(int n2) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$233, Level.FINEST, OracleStatement.class, $$$methodRef$$$233, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$233, Level.FINEST, OracleStatement.class, $$$methodRef$$$233, this);
                ClioSupport.exiting($$$loggerRef$$$233, Level.FINEST, OracleStatement.class, $$$methodRef$$$233, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$233, Level.FINEST, OracleStatement.class, $$$methodRef$$$233, this, throwable2);
            }
            throw throwable;
        }
    }

    void processLobPrefetchMetaData(Object[] objectArray) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$234, Level.FINEST, OracleStatement.class, $$$methodRef$$$234, this, new Object[]{objectArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$234, Level.FINEST, OracleStatement.class, $$$methodRef$$$234, this);
                ClioSupport.exiting($$$loggerRef$$$234, Level.FINEST, OracleStatement.class, $$$methodRef$$$234, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$234, Level.FINEST, OracleStatement.class, $$$methodRef$$$234, this, throwable2);
            }
            throw throwable;
        }
    }

    void internalClose() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$235, Level.FINEST, OracleStatement.class, $$$methodRef$$$235, this, new Object[0]);
            }
            this.closed = true;
            if (this.currentResultSet != null) {
                this.currentResultSet.closed = true;
            }
            this.cleanupDefines();
            this.bindBytes = null;
            this.bindChars = null;
            this.bindIndicators = null;
            this.outBindAccessors = null;
            this.parameterStream = null;
            this.userStream = null;
            this.ibtBindBytes = null;
            this.ibtBindChars = null;
            this.ibtBindIndicators = null;
            this.lobPrefetchMetaData = null;
            this.tmpByteArray = null;
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            if (this.wrapper != null) {
                this.wrapper.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$235, Level.FINEST, OracleStatement.class, $$$methodRef$$$235, this);
                ClioSupport.exiting($$$loggerRef$$$235, Level.FINEST, OracleStatement.class, $$$methodRef$$$235, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$235, Level.FINEST, OracleStatement.class, $$$methodRef$$$235, this, throwable2);
            }
            throw throwable;
        }
    }

    void calculateCheckSum() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this, new Object[0]);
            }
            if (!this.connection.checksumMode.needToCalculateFetchChecksum()) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this);
                    ClioSupport.exiting($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this, null);
                }
                return;
            }
            this.localCheckSum = this.checkSum;
            if (this.accessors != null && !this.isDmlReturning) {
                this.accessorChecksum(this.accessors);
            }
            if (this.outBindAccessors != null) {
                this.accessorChecksum(this.outBindAccessors);
            }
            if (this.accessors != null && this.returnParamsFetched && this.isDmlReturning) {
                this.accessorChecksum(this.accessors);
            }
            this.checkSum = this.localCheckSum = CRC64.updateChecksum(this.localCheckSum, this.validRows);
            this.localCheckSum = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this);
                ClioSupport.exiting($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$236, Level.FINEST, OracleStatement.class, $$$methodRef$$$236, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void accessorChecksum(Accessor[] accessorArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void _accessors;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$237, Level.FINEST, OracleStatement.class, $$$methodRef$$$237, this, new Object[]{accessorArray});
            }
            int count = 0;
            boolean areAllColumnsLobs = false;
            block6: for (void a2 : _accessors) {
                if (a2 == null) continue;
                switch (a2.internalType) {
                    case 112: 
                    case 113: 
                    case 114: 
                    case 119: {
                        if (count != 0) continue block6;
                        areAllColumnsLobs = true;
                        continue block6;
                    }
                    case 8: 
                    case 24: {
                        areAllColumnsLobs = false;
                        break block6;
                    }
                    default: {
                        areAllColumnsLobs = false;
                        ++count;
                        int row = 0;
                        while ((long)row < this.validRows) {
                            this.localCheckSum = a2.updateChecksum(this.localCheckSum, row);
                            ++row;
                        }
                        break block1;
                    }
                }
            }
            if (areAllColumnsLobs) {
                this.checkSumComputationFailure = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$237, Level.FINEST, OracleStatement.class, $$$methodRef$$$237, this);
                ClioSupport.exiting($$$loggerRef$$$237, Level.FINEST, OracleStatement.class, $$$methodRef$$$237, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$237, Level.FINEST, OracleStatement.class, $$$methodRef$$$237, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getChecksum() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$238, Level.FINEST, OracleStatement.class, $$$methodRef$$$238, this, new Object[0]);
            }
            if (this.checkSumComputationFailure) {
                SQLException sQLException = (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getChecksum").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$238, Level.FINEST, OracleStatement.class, $$$methodRef$$$238, this, sQLException);
                }
                throw sQLException;
            }
            long l2 = this.checkSum;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$238, Level.FINEST, OracleStatement.class, $$$methodRef$$$238, this, l2);
                ClioSupport.exiting($$$loggerRef$$$238, Level.FINEST, OracleStatement.class, $$$methodRef$$$238, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$238, Level.FINEST, OracleStatement.class, $$$methodRef$$$238, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerBindChecksumListener(OracleStatement.BindChecksumListener bindChecksumListener) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$239, Level.FINEST, OracleStatement.class, $$$methodRef$$$239, this, bindChecksumListener);
            }
            this.bindChecksumListener = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$239, Level.FINEST, OracleStatement.class, $$$methodRef$$$239, this);
                ClioSupport.exiting($$$loggerRef$$$239, Level.FINEST, OracleStatement.class, $$$methodRef$$$239, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$239, Level.FINEST, OracleStatement.class, $$$methodRef$$$239, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$240, Level.FINEST, OracleStatement.class, $$$methodRef$$$240, this, new Object[0]);
            }
            this.ensureOpen();
            this.isCloseOnCompletion = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$240, Level.FINEST, OracleStatement.class, $$$methodRef$$$240, this);
                ClioSupport.exiting($$$loggerRef$$$240, Level.FINEST, OracleStatement.class, $$$methodRef$$$240, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$240, Level.FINEST, OracleStatement.class, $$$methodRef$$$240, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$241, Level.FINEST, OracleStatement.class, $$$methodRef$$$241, this, new Object[0]);
            }
            this.ensureOpen();
            boolean bl2 = this.isCloseOnCompletion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$241, Level.FINEST, OracleStatement.class, $$$methodRef$$$241, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$241, Level.FINEST, OracleStatement.class, $$$methodRef$$$241, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$241, Level.FINEST, OracleStatement.class, $$$methodRef$$$241, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean closeByDependent() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, new Object[0]);
            }
            if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
                if (this.parent == null || !this.parent.closeByDependent()) {
                    this.close();
                }
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$242, Level.FINEST, OracleStatement.class, $$$methodRef$$$242, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSimpleIdentifier(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void identifier;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$243, Level.FINEST, OracleStatement.class, $$$methodRef$$$243, this, string);
            }
            boolean bl2 = this.connection.isSimpleIdentifier((String)identifier);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$243, Level.FINEST, OracleStatement.class, $$$methodRef$$$243, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$243, Level.FINEST, OracleStatement.class, $$$methodRef$$$243, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$243, Level.FINEST, OracleStatement.class, $$$methodRef$$$243, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String enquoteLiteral(String string) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$244, Level.FINEST, OracleStatement.class, $$$methodRef$$$244, this, string);
            }
            String string2 = this.connection.enquoteLiteral((String)val);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$244, Level.FINEST, OracleStatement.class, $$$methodRef$$$244, this, string2);
                ClioSupport.exiting($$$loggerRef$$$244, Level.FINEST, OracleStatement.class, $$$methodRef$$$244, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$244, Level.FINEST, OracleStatement.class, $$$methodRef$$$244, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String enquoteIdentifier(String string, boolean bl) throws SQLException {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void alwaysQuote;
            void identifier;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$245, Level.FINEST, OracleStatement.class, $$$methodRef$$$245, this, string, bl);
            }
            String string2 = this.connection.enquoteIdentifier((String)identifier, (boolean)alwaysQuote);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$245, Level.FINEST, OracleStatement.class, $$$methodRef$$$245, this, string2);
                ClioSupport.exiting($$$loggerRef$$$245, Level.FINEST, OracleStatement.class, $$$methodRef$$$245, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$245, Level.FINEST, OracleStatement.class, $$$methodRef$$$245, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setACProxy(Object object) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void w2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$246, Level.FINEST, OracleStatement.class, $$$methodRef$$$246, this, object);
            }
            this.acProxy = w2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$246, Level.FINEST, OracleStatement.class, $$$methodRef$$$246, this);
                ClioSupport.exiting($$$loggerRef$$$246, Level.FINEST, OracleStatement.class, $$$methodRef$$$246, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$246, Level.FINEST, OracleStatement.class, $$$methodRef$$$246, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object getACProxy() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$247, Level.FINEST, OracleStatement.class, $$$methodRef$$$247, this, new Object[0]);
            }
            Object object = this.acProxy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$247, Level.FINEST, OracleStatement.class, $$$methodRef$$$247, this, object);
                ClioSupport.exiting($$$loggerRef$$$247, Level.FINEST, OracleStatement.class, $$$methodRef$$$247, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$247, Level.FINEST, OracleStatement.class, $$$methodRef$$$247, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final long getQueryId() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$248, Level.FINEST, OracleStatement.class, $$$methodRef$$$248, this, new Object[0]);
            }
            long l2 = this.queryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$248, Level.FINEST, OracleStatement.class, $$$methodRef$$$248, this, l2);
                ClioSupport.exiting($$$loggerRef$$$248, Level.FINEST, OracleStatement.class, $$$methodRef$$$248, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$248, Level.FINEST, OracleStatement.class, $$$methodRef$$$248, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final byte[] getCompileKey() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$249, Level.FINEST, OracleStatement.class, $$$methodRef$$$249, this, new Object[0]);
            }
            byte[] byArray = this.querycacheCompileKey;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$249, Level.FINEST, OracleStatement.class, $$$methodRef$$$249, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$249, Level.FINEST, OracleStatement.class, $$$methodRef$$$249, this, null);
            }
            return this.querycacheCompileKey;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$249, Level.FINEST, OracleStatement.class, $$$methodRef$$$249, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setQueryCompileKey(byte[] byArray) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void dcbqcky;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$250, Level.FINEST, OracleStatement.class, $$$methodRef$$$250, this, new Object[]{byArray});
            }
            if (this.connection.isResultSetCacheEnabled && dcbqcky != null) {
                this.querycacheCompileKey = dcbqcky;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$250, Level.FINEST, OracleStatement.class, $$$methodRef$$$250, this);
                ClioSupport.exiting($$$loggerRef$$$250, Level.FINEST, OracleStatement.class, $$$methodRef$$$250, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$250, Level.FINEST, OracleStatement.class, $$$methodRef$$$250, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setQueryId(long l2) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void queryId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$251, Level.FINEST, OracleStatement.class, $$$methodRef$$$251, this, l2);
            }
            this.queryId = queryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$251, Level.FINEST, OracleStatement.class, $$$methodRef$$$251, this);
                ClioSupport.exiting($$$loggerRef$$$251, Level.FINEST, OracleStatement.class, $$$methodRef$$$251, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$251, Level.FINEST, OracleStatement.class, $$$methodRef$$$251, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getRuntimeKey() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$252, Level.FINEST, OracleStatement.class, $$$methodRef$$$252, this, new Object[0]);
            }
            byte[] byArray = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$252, Level.FINEST, OracleStatement.class, $$$methodRef$$$252, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$252, Level.FINEST, OracleStatement.class, $$$methodRef$$$252, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$252, Level.FINEST, OracleStatement.class, $$$methodRef$$$252, this, throwable2);
            }
            throw throwable;
        }
    }

    void clearCursorId() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$253, Level.FINEST, OracleStatement.class, $$$methodRef$$$253, this, new Object[0]);
            }
            this.cursorId = 0;
            this.needToParse = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$253, Level.FINEST, OracleStatement.class, $$$methodRef$$$253, this);
                ClioSupport.exiting($$$loggerRef$$$253, Level.FINEST, OracleStatement.class, $$$methodRef$$$253, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$253, Level.FINEST, OracleStatement.class, $$$methodRef$$$253, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract long allocateRowDataSpace(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShardingKeyRpnTokens(byte[] byArray) throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void shardingKeyRpnTokens;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$254, Level.FINEST, OracleStatement.class, $$$methodRef$$$254, this, new Object[]{byArray});
            }
            this.shardingKeyRpnTokens = shardingKeyRpnTokens;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$254, Level.FINEST, OracleStatement.class, $$$methodRef$$$254, this);
                ClioSupport.exiting($$$loggerRef$$$254, Level.FINEST, OracleStatement.class, $$$methodRef$$$254, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$254, Level.FINEST, OracleStatement.class, $$$methodRef$$$254, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getShardingKeyRpnTokens() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$255, Level.FINEST, OracleStatement.class, $$$methodRef$$$255, this, new Object[0]);
            }
            byte[] byArray = this.shardingKeyRpnTokens;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$255, Level.FINEST, OracleStatement.class, $$$methodRef$$$255, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$255, Level.FINEST, OracleStatement.class, $$$methodRef$$$255, this, null);
            }
            return this.shardingKeyRpnTokens;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$255, Level.FINEST, OracleStatement.class, $$$methodRef$$$255, this, throwable2);
            }
            throw throwable;
        }
    }

    protected final void awaitResultSetPublishing() throws SQLException {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this, new Object[0]);
            }
            if (this.currentResultSet == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this);
                    ClioSupport.exiting($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this, null);
                }
                return;
            }
            this.currentResultSet.awaitPublishing();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this);
                ClioSupport.exiting($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$256, Level.FINEST, OracleStatement.class, $$$methodRef$$$256, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isSqlRewritten() {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$257, Level.FINEST, OracleStatement.class, $$$methodRef$$$257, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.isAutoGeneratedKey || this.sqlObject.includeRowid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$257, Level.FINEST, OracleStatement.class, $$$methodRef$$$257, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$257, Level.FINEST, OracleStatement.class, $$$methodRef$$$257, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$257, Level.FINEST, OracleStatement.class, $$$methodRef$$$257, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$fetchMoreRowsAsync$5(long l2, long l3, BiConsumer biConsumer, Throwable throwable) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, l2, l3, biConsumer, throwable);
            }
            Long result = null;
            try {
                this.cancelLock.exitExecuting();
                if (error == null) {
                    void firstRow;
                    if (!$assertionsDisabled && this.validRows == -2L && this.rowPrefetch != 1) {
                        AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    this.checkValidRowsStatus();
                    this.updateRowStorageCountAfterFetchMoreRows();
                    this.updateIsAllFetchedAfterFetchMoreRows();
                    if (!$assertionsDisabled && this.physicalRowIndex((long)firstRow) < 0) {
                        AssertionError assertionError = new AssertionError((Object)("firstRow: " + (long)firstRow + " indexOfFirstRow: " + this.indexOfFirstRow));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.physicalRowIndex((long)firstRow) >= this.currentCapacity) {
                        AssertionError assertionError = new AssertionError((Object)("firstRow: " + (long)firstRow + " indexOfFirstRow: " + this.indexOfFirstRow + " currentCapacity: " + this.currentCapacity));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.validRows < 0L) {
                        AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (!$assertionsDisabled && this.validRows <= 0L && !this.isAllFetched) {
                        AssertionError assertionError = new AssertionError((Object)("validRows: " + this.validRows + ", isAllFetched: " + this.isAllFetched));
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    result = this.validRows;
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
                result = null;
            }
            try {
                if (this.dmsFetch != null) {
                    void startToken;
                    this.dmsFetch.stop((long)startToken);
                }
            }
            catch (Throwable throwable3) {
                error = CompletionStageUtil.suppress(throwable3, error);
                result = null;
            }
            callback.accept(result, error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this);
                ClioSupport.exiting($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, null);
            }
            return;
        }
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$259, Level.FINEST, OracleStatement.class, $$$methodRef$$$259, this, throwable5);
            }
            throw throwable4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$executeSQLStatementAsync$4(Consumer consumer, Throwable throwable) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$260, Level.FINEST, OracleStatement.class, $$$methodRef$$$260, this, consumer, throwable);
            }
            try {
                if (error instanceof SQLException) {
                    this.handleExecuteSQLStatementFailure((SQLException)error);
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
            }
            try {
                this.cancelLock.exitExecuting();
                this.handleExecuteSQLStatementCompletionAlways();
            }
            catch (Throwable throwable3) {
                error = CompletionStageUtil.suppress(throwable3, error);
            }
            callback.accept(error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$260, Level.FINEST, OracleStatement.class, $$$methodRef$$$260, this);
                ClioSupport.exiting($$$loggerRef$$$260, Level.FINEST, OracleStatement.class, $$$methodRef$$$260, this, null);
            }
            return;
        }
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$260, Level.FINEST, OracleStatement.class, $$$methodRef$$$260, this, throwable5);
            }
            throw throwable4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$executeSQLSelectAsync$3(Consumer consumer, Throwable throwable) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$261, Level.FINEST, OracleStatement.class, $$$methodRef$$$261, this, consumer, throwable);
            }
            try {
                this.resetConnectionAfterExecution();
                if (error == null) {
                    this.handleExecuteSQLSelectCompletion();
                    if (this.serverCursor) {
                        this.adjustGotLastBatch();
                    }
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
            }
            callback.accept(error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$261, Level.FINEST, OracleStatement.class, $$$methodRef$$$261, this);
                ClioSupport.exiting($$$loggerRef$$$261, Level.FINEST, OracleStatement.class, $$$methodRef$$$261, this, null);
            }
            return;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$261, Level.FINEST, OracleStatement.class, $$$methodRef$$$261, this, throwable4);
            }
            throw throwable3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$doExecuteWithTimeoutAsync$2(long l2, Consumer consumer, Throwable throwable) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$262, Level.FINEST, OracleStatement.class, $$$methodRef$$$262, this, l2, consumer, throwable);
            }
            try {
                if (error == null) {
                    this.updateDmsSystemAfterExecution();
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
            }
            try {
                if (error instanceof SQLException) {
                    this.connection.resetSystemContext();
                    this.resetOnExceptionDuringExecute();
                }
            }
            catch (Throwable throwable3) {
                error = CompletionStageUtil.suppress(throwable3, error);
            }
            try {
                void startToken;
                this.updateDmsAfterExecution((long)startToken);
            }
            catch (Throwable throwable4) {
                error = CompletionStageUtil.suppress(throwable4, error);
            }
            callback.accept(error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$262, Level.FINEST, OracleStatement.class, $$$methodRef$$$262, this);
                ClioSupport.exiting($$$loggerRef$$$262, Level.FINEST, OracleStatement.class, $$$methodRef$$$262, this, null);
            }
            return;
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$262, Level.FINEST, OracleStatement.class, $$$methodRef$$$262, this, throwable6);
            }
            throw throwable5;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$prepareDefineBufferAndExecuteAsync$1(boolean bl, Consumer consumer, Throwable throwable) {
        boolean bl2 = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            void executedForDescribe;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$263, Level.FINEST, OracleStatement.class, $$$methodRef$$$263, this, bl, consumer, throwable);
            }
            boolean needExplicitFetch = executedForDescribe == false || !this.aFetchWasDoneDuringDescribe;
            try {
                if (error == null) {
                    if (this.needToPrepareDefineBuffer) {
                        this.prepareAccessors();
                    }
                    this.markDanglingAccessors();
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
            }
            if (error == null && needExplicitFetch) {
                this.executeForRowsAsync((boolean)executedForDescribe, (Consumer<Throwable>)callback);
            } else {
                callback.accept(error);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$263, Level.FINEST, OracleStatement.class, $$$methodRef$$$263, this);
                ClioSupport.exiting($$$loggerRef$$$263, Level.FINEST, OracleStatement.class, $$$methodRef$$$263, this, null);
            }
            return;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$263, Level.FINEST, OracleStatement.class, $$$methodRef$$$263, this, throwable4);
            }
            throw throwable3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$executeMaybeDescribeAsync$0(Consumer consumer, Throwable throwable) {
        boolean bl = (0x4204L & TraceControllerImpl.feature) != 0L;
        try {
            void callback;
            Throwable error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$264, Level.FINEST, OracleStatement.class, $$$methodRef$$$264, this, consumer, throwable);
            }
            try {
                if (error == null) {
                    this.handleExecuteMaybeDescribeCompletion();
                }
            }
            catch (Throwable throwable2) {
                error = CompletionStageUtil.suppress(throwable2, error);
            }
            if (error instanceof SQLException) {
                this.needToParse = true;
            }
            try {
                this.cancelLock.exitExecuting();
            }
            catch (Throwable throwable3) {
                error = CompletionStageUtil.suppress(throwable3, error);
            }
            callback.accept(error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$264, Level.FINEST, OracleStatement.class, $$$methodRef$$$264, this);
                ClioSupport.exiting($$$loggerRef$$$264, Level.FINEST, OracleStatement.class, $$$methodRef$$$264, this, null);
            }
            return;
        }
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$264, Level.FINEST, OracleStatement.class, $$$methodRef$$$264, this, throwable5);
            }
            throw throwable4;
        }
    }

    static {
        try {
            $$$methodRef$$$267 = OracleStatement.class.getDeclaredConstructor(PhysicalConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$267 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$266 = OracleStatement.class.getDeclaredConstructor(PhysicalConnection.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$266 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$265 = OracleStatement.class.getDeclaredConstructor(PhysicalConnection.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$265 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$264 = OracleStatement.class.getDeclaredMethod("lambda$executeMaybeDescribeAsync$0", Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$264 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$263 = OracleStatement.class.getDeclaredMethod("lambda$prepareDefineBufferAndExecuteAsync$1", Boolean.TYPE, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$263 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$262 = OracleStatement.class.getDeclaredMethod("lambda$doExecuteWithTimeoutAsync$2", Long.TYPE, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$262 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$261 = OracleStatement.class.getDeclaredMethod("lambda$executeSQLSelectAsync$3", Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$261 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$260 = OracleStatement.class.getDeclaredMethod("lambda$executeSQLStatementAsync$4", Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$260 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$259 = OracleStatement.class.getDeclaredMethod("lambda$fetchMoreRowsAsync$5", Long.TYPE, Long.TYPE, BiConsumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$259 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$258 = OracleStatement.class.getDeclaredMethod("setWrapper", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$258 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$257 = OracleStatement.class.getDeclaredMethod("isSqlRewritten", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$257 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$256 = OracleStatement.class.getDeclaredMethod("awaitResultSetPublishing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$256 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$255 = OracleStatement.class.getDeclaredMethod("getShardingKeyRpnTokens", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$255 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$254 = OracleStatement.class.getDeclaredMethod("setShardingKeyRpnTokens", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$254 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$253 = OracleStatement.class.getDeclaredMethod("clearCursorId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$253 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$252 = OracleStatement.class.getDeclaredMethod("getRuntimeKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$252 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$251 = OracleStatement.class.getDeclaredMethod("setQueryId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$251 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$250 = OracleStatement.class.getDeclaredMethod("setQueryCompileKey", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$250 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$249 = OracleStatement.class.getDeclaredMethod("getCompileKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$249 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$248 = OracleStatement.class.getDeclaredMethod("getQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$248 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$247 = OracleStatement.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$247 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$246 = OracleStatement.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$246 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$245 = OracleStatement.class.getDeclaredMethod("enquoteIdentifier", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$245 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$244 = OracleStatement.class.getDeclaredMethod("enquoteLiteral", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$244 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$243 = OracleStatement.class.getDeclaredMethod("isSimpleIdentifier", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$243 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$242 = OracleStatement.class.getDeclaredMethod("closeByDependent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$242 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$241 = OracleStatement.class.getDeclaredMethod("isCloseOnCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$241 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$240 = OracleStatement.class.getDeclaredMethod("closeOnCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$240 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$239 = OracleStatement.class.getDeclaredMethod("registerBindChecksumListener", OracleStatement.BindChecksumListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$239 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$238 = OracleStatement.class.getDeclaredMethod("getChecksum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$238 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$237 = OracleStatement.class.getDeclaredMethod("accessorChecksum", Accessor[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$237 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$236 = OracleStatement.class.getDeclaredMethod("calculateCheckSum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$236 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$235 = OracleStatement.class.getDeclaredMethod("internalClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$235 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$234 = OracleStatement.class.getDeclaredMethod("processLobPrefetchMetaData", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$234 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$233 = OracleStatement.class.getDeclaredMethod("extractNioDefineBuffers", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$233 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$232 = OracleStatement.class.getDeclaredMethod("getGMTCalendar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$232 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$231 = OracleStatement.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$231 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$230 = OracleStatement.class.getDeclaredMethod("getAuthorizationIndicator", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$230 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$229 = OracleStatement.class.getDeclaredMethod("getPrependedRowId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$229 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$228 = OracleStatement.class.getDeclaredMethod("getBytes", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$228 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$227 = OracleStatement.class.getDeclaredMethod("getObject", Long.TYPE, Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$227 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$226 = OracleStatement.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$226 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$225 = OracleStatement.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$225 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$224 = OracleStatement.class.getDeclaredMethod("setPoolable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$224 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$223 = OracleStatement.class.getDeclaredMethod("isPoolable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$223 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$222 = OracleStatement.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$222 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$221 = OracleStatement.class.getDeclaredMethod("releaseBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$221 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$220 = OracleStatement.class.getDeclaredMethod("getDefaultCalendar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$220 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$219 = OracleStatement.class.getDeclaredMethod("getRegisteredQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$219 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$218 = OracleStatement.class.getDeclaredMethod("getRegisteredTableNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$218 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$217 = OracleStatement.class.getDeclaredMethod("setDatabaseChangeRegistration", DatabaseChangeRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$217 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$216 = OracleStatement.class.getDeclaredMethod("getDefaultTimeZone", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$216 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$215 = OracleStatement.class.getDeclaredMethod("getDefaultTimeZone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$215 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$214 = OracleStatement.class.getDeclaredMethod("cleanTempBlobs", ArrayList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$214 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$213 = OracleStatement.class.getDeclaredMethod("cleanTempClobs", ArrayList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$213 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$212 = OracleStatement.class.getDeclaredMethod("cleanOldTempLobs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$212 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$211 = OracleStatement.class.getDeclaredMethod("cleanAllRowLobs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$211 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$210 = OracleStatement.class.getDeclaredMethod("cleanAllTempLobs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$210 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$209 = OracleStatement.class.getDeclaredMethod("addToTempLobsToFree", BLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$209 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$208 = OracleStatement.class.getDeclaredMethod("addToTempLobsToFree", CLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$208 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$207 = OracleStatement.class.getDeclaredMethod("moveTempLobsToFree", BLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$207 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$206 = OracleStatement.class.getDeclaredMethod("moveTempLobsToFree", CLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$206 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$205 = OracleStatement.class.getDeclaredMethod("moveAllTempLobsToFree", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$205 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$204 = OracleStatement.class.getDeclaredMethod("checkTypeForAutoKey", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$204 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$203 = OracleStatement.class.getDeclaredMethod("cleanUpBeforeExecute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$203 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$202 = OracleStatement.class.getDeclaredMethod("autoKeyRegisterReturnParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$202 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$201 = OracleStatement.class.getDeclaredMethod("initializeIndicatorSubRange", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$201 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$200 = OracleStatement.class.getDeclaredMethod("getserverCursor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$200 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$199 = OracleStatement.class.getDeclaredMethod("getstatementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$199 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$198 = OracleStatement.class.getDeclaredMethod("getcacheState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$198 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$197 = OracleStatement.class.getDeclaredMethod("getResultSetHoldability", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$197 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$196 = OracleStatement.class.getDeclaredMethod("execute", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$196 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$195 = OracleStatement.class.getDeclaredMethod("execute", String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$195 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$194 = OracleStatement.class.getDeclaredMethod("execute", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$194 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$193 = OracleStatement.class.getDeclaredMethod("executeLargeUpdate", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$193 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$192 = OracleStatement.class.getDeclaredMethod("executeUpdate", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$192 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$191 = OracleStatement.class.getDeclaredMethod("executeLargeUpdate", String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$191 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$190 = OracleStatement.class.getDeclaredMethod("executeUpdate", String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$190 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$189 = OracleStatement.class.getDeclaredMethod("executeLargeUpdate", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$189 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$188 = OracleStatement.class.getDeclaredMethod("executeUpdate", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$188 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$187 = OracleStatement.class.getDeclaredMethod("getGeneratedKeys", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$187 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$186 = OracleStatement.class.getDeclaredMethod("getMoreResults", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$186 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$185 = OracleStatement.class.getDeclaredMethod("removeChild", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$185 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$184 = OracleStatement.class.getDeclaredMethod("addImplicitResultSetStmt", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$184 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$183 = OracleStatement.class.getDeclaredMethod("addChild", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$183 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$182 = OracleStatement.class.getDeclaredMethod("isNCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$182 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$181 = OracleStatement.class.getDeclaredMethod("isColumnSetNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$181 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$180 = OracleStatement.class.getDeclaredMethod("creationState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$180 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$179 = OracleStatement.class.getDeclaredMethod("registerReturnParameterInternal", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$179 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$178 = OracleStatement.class.getDeclaredMethod("fetchDmlReturnParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$178 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$177 = OracleStatement.class.getDeclaredMethod("allocateDmlReturnStorage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$177 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$176 = OracleStatement.class.getDeclaredMethod("processDmlReturningBind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$176 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$175 = OracleStatement.class.getDeclaredMethod("doScrollStmtExecuteQuery", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$175 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$174 = OracleStatement.class.getDeclaredMethod("allocateRowidAccessor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$174 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$173 = OracleStatement.class.getDeclaredMethod("doScrollExecuteCommon", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$173 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$172 = OracleStatement.class.getDeclaredMethod("computeOffsetOfFirstUserColumn", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$172 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$171 = OracleStatement.class.getDeclaredMethod("isRowidPrepended", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$171 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$170 = OracleStatement.class.getDeclaredMethod("getOriginalSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$170 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$169 = OracleStatement.class.getDeclaredMethod("notifyCloseRset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$169 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$168 = OracleStatement.class.getDeclaredMethod("copyBinds", Statement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$168 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$167 = OracleStatement.class.getDeclaredMethod("copyDefines", OracleStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$167 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$166 = OracleStatement.class.getDeclaredMethod("executeLargeBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$166 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$165 = OracleStatement.class.getDeclaredMethod("executeBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$165 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$164 = OracleStatement.class.getDeclaredMethod("toIntArray", long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$164 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$163 = OracleStatement.class.getDeclaredMethod("clearBatchCritical", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$163 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$162 = OracleStatement.class.getDeclaredMethod("clearBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$162 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$161 = OracleStatement.class.getDeclaredMethod("addBatch", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$161 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$160 = OracleStatement.class.getDeclaredMethod("checkIfBatchExists", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$160 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$159 = OracleStatement.class.getDeclaredMethod("clearBatchItems", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$159 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$158 = OracleStatement.class.getDeclaredMethod("getBatchItem", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$158 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$157 = OracleStatement.class.getDeclaredMethod("addBatchItem", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$157 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$156 = OracleStatement.class.getDeclaredMethod("getBatchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$156 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$155 = OracleStatement.class.getDeclaredMethod("initBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$155 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$154 = OracleStatement.class.getDeclaredMethod("isOracleBatchStyle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$154 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$153 = OracleStatement.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$153 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$152 = OracleStatement.class.getDeclaredMethod("getResultSetType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$152 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$151 = OracleStatement.class.getDeclaredMethod("getResultSetConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$151 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$150 = OracleStatement.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$150 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$149 = OracleStatement.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$149 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$148 = OracleStatement.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$148 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$147 = OracleStatement.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$147 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$146 = OracleStatement.class.getDeclaredMethod("allocateTmpByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$145 = OracleStatement.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$144 = OracleStatement.class.getDeclaredMethod("closeUsedStreams", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$143 = OracleStatement.class.getDeclaredMethod("freeLine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$142 = OracleStatement.class.getDeclaredMethod("describe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$141 = OracleStatement.class.getDeclaredMethod("getResultSetMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$140 = OracleStatement.class.getDeclaredMethod("getInternalType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$139 = OracleStatement.class.getDeclaredMethod("getJDBCType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$138 = OracleStatement.class.getDeclaredMethod("getColumnIndexPrimitive", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$137 = OracleStatement.class.getDeclaredMethod("getColumnIndex", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$136 = OracleStatement.class.getDeclaredMethod("isNull", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$135 = OracleStatement.class.getDeclaredMethod("wasNullValue", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$134 = OracleStatement.class.getDeclaredMethod("endOfResultSet", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$133 = OracleStatement.class.getDeclaredMethod("reopenStreams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$132 = OracleStatement.class.getDeclaredMethod("closeAllStreams", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$131 = OracleStatement.class.getDeclaredMethod("resetBindData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$130 = OracleStatement.class.getDeclaredMethod("prepareForNewResults", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$129 = OracleStatement.class.getDeclaredMethod("deleteRow", Accessor.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$128 = OracleStatement.class.getDeclaredMethod("removeRowFromCache", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$127 = OracleStatement.class.getDeclaredMethod("getRowKeys", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$126 = OracleStatement.class.getDeclaredMethod("refreshRowsInternal", Array.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$125 = OracleStatement.class.getDeclaredMethod("insertRow", Long.TYPE, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$124 = OracleStatement.class.getDeclaredMethod("refreshRows", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$123 = OracleStatement.class.getDeclaredMethod("storedRowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$122 = OracleStatement.class.getDeclaredMethod("updateIsAllFetchedAfterFetchMoreRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$121 = OracleStatement.class.getDeclaredMethod("updateRowStorageCountAfterFetchMoreRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$120 = OracleStatement.class.getDeclaredMethod("prepareAccessorsBeforeFetchMoreRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$119 = OracleStatement.class.getDeclaredMethod("cleanTempLobsBeforeFetchMoreRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$118 = OracleStatement.class.getDeclaredMethod("fetchMoreRowsAsync", Long.TYPE, BiConsumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$117 = OracleStatement.class.getDeclaredMethod("fetchMoreRows", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$116 = OracleStatement.class.getDeclaredMethod("physicalRowIndex", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$115 = OracleStatement.class.getDeclaredMethod("drainStreams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$114 = OracleStatement.class.getDeclaredMethod("increaseCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$113 = OracleStatement.class.getDeclaredMethod("sendBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$112 = OracleStatement.class.getDeclaredMethod("getMoreResults", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$111 = OracleStatement.class.getDeclaredMethod("getLargeUpdateCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$110 = OracleStatement.class.getDeclaredMethod("getUpdateCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$109 = OracleStatement.class.getDeclaredMethod("getResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$108 = OracleStatement.class.getDeclaredMethod("setCursorName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$107 = OracleStatement.class.getDeclaredMethod("foundPlsqlCompilerWarning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$106 = OracleStatement.class.getDeclaredMethod("clearWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$105 = OracleStatement.class.getDeclaredMethod("getWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$104 = OracleStatement.class.getDeclaredMethod("doCancel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$103 = OracleStatement.class.getDeclaredMethod("cancel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$102 = OracleStatement.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$101 = OracleStatement.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$100 = OracleStatement.class.getDeclaredMethod("setEscapeProcessing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$99 = OracleStatement.class.getDeclaredMethod("setLargeMaxRows", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$98 = OracleStatement.class.getDeclaredMethod("setMaxRows", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$97 = OracleStatement.class.getDeclaredMethod("getLargeMaxRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$96 = OracleStatement.class.getDeclaredMethod("getMaxRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$95 = OracleStatement.class.getDeclaredMethod("setMaxFieldSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$94 = OracleStatement.class.getDeclaredMethod("getMaxFieldSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$93 = OracleStatement.class.getDeclaredMethod("cleanupDefines", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$92 = OracleStatement.class.getDeclaredMethod("initializeCacheEntryIfApplicable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$91 = OracleStatement.class.getDeclaredMethod("checkValidRowsStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$90 = OracleStatement.class.getDeclaredMethod("printState", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$89 = OracleStatement.class.getDeclaredMethod("setDefinesInitialized", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$88 = OracleStatement.class.getDeclaredMethod("check_row_prefetch_changed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$87 = OracleStatement.class.getDeclaredMethod("getFixedString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = OracleStatement.class.getDeclaredMethod("setFixedString", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = OracleStatement.class.getDeclaredMethod("getRowPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = OracleStatement.class.getDeclaredMethod("getPrefetchInternal", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = OracleStatement.class.getDeclaredMethod("getLobPrefetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = OracleStatement.class.getDeclaredMethod("setLobPrefetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = OracleStatement.class.getDeclaredMethod("setRowPrefetch", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = OracleStatement.class.getDeclaredMethod("setPrefetchInternal", Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = OracleStatement.class.getDeclaredMethod("setCursorId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = OracleStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = OracleStatement.class.getDeclaredMethod("defineColumnTypeChars", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = OracleStatement.class.getDeclaredMethod("defineColumnTypeBytes", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = OracleStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = OracleStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = OracleStatement.class.getDeclaredMethod("defineColumnType", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = OracleStatement.class.getDeclaredMethod("setDriverSpecificData", Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = OracleStatement.class.getDeclaredMethod("allocateAccessor", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = OracleStatement.class.getDeclaredMethod("defineColumnTypeInternal", Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = OracleStatement.class.getDeclaredMethod("defineColumnTypeInternal", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OracleStatement.class.getDeclaredMethod("reparseOnRedefineIfNeeded", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OracleStatement.class.getDeclaredMethod("clearDefines", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OracleStatement.class.getDeclaredMethod("getSqlKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OracleStatement.class.getDeclaredMethod("getDescriptionWithNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OracleStatement.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleStatement.class.getDeclaredMethod("computeNumberOfUserColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleStatement.class.getDeclaredMethod("getNumberOfUserColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleStatement.class.getDeclaredMethod("createResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleStatement.class.getDeclaredMethod("executeInternal", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleStatement.class.getDeclaredMethod("execute", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleStatement.class.getDeclaredMethod("executeUpdateInternal", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleStatement.class.getDeclaredMethod("executeLargeUpdate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleStatement.class.getDeclaredMethod("executeUpdate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleStatement.class.getDeclaredMethod("closeLeaveCursorOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleStatement.class.getDeclaredMethod("alwaysOnClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleStatement.class.getDeclaredMethod("hardClose", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleStatement.class.getDeclaredMethod("hardClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleStatement.class.getDeclaredMethod("closeOrCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleStatement.class.getDeclaredMethod("closeWrapper", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleStatement.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleStatement.class.getDeclaredMethod("closeWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleStatement.class.getDeclaredMethod("executeQuery", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleStatement.class.getDeclaredMethod("open", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleStatement.class.getDeclaredMethod("resetCurrentRowBinders", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleStatement.class.getDeclaredMethod("resetOnExceptionDuringExecute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleStatement.class.getDeclaredMethod("createBatchUpdateException", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleStatement.class.getDeclaredMethod("handleExecuteSQLStatementCompletionAlways", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleStatement.class.getDeclaredMethod("handleExecuteSQLStatementFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleStatement.class.getDeclaredMethod("ensureJ2EE13ComplianceForNonSelectSQL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleStatement.class.getDeclaredMethod("executeSQLStatementAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleStatement.class.getDeclaredMethod("executeSQLStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleStatement.class.getDeclaredMethod("handleExecuteSQLSelectCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleStatement.class.getDeclaredMethod("resetConnectionAfterExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleStatement.class.getDeclaredMethod("prepareConnectionForExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleStatement.class.getDeclaredMethod("restoreRowDataFromBindData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleStatement.class.getDeclaredMethod("ensureJ2EE13ComplianceForSelectSQL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleStatement.class.getDeclaredMethod("executeSQLSelectAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleStatement.class.getDeclaredMethod("executeSQLSelect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleStatement.class.getDeclaredMethod("updateDmsSystemAfterExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleStatement.class.getDeclaredMethod("prepareDmsSystemForExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleStatement.class.getDeclaredMethod("updateDmsAfterExecution", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleStatement.class.getDeclaredMethod("prepareDmsForExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleStatement.class.getDeclaredMethod("prepareForExecuteWithTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleStatement.class.getDeclaredMethod("doExecuteWithTimeoutAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleStatement.class.getDeclaredMethod("doExecuteWithTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleStatement.class.getDeclaredMethod("useCachedQueryResult", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleStatement.class.getDeclaredMethod("cacheQueryResultIfAppropriate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleStatement.class.getDeclaredMethod("isQueryResultCached", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleStatement.class.getDeclaredMethod("adjustGotLastBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleStatement.class.getDeclaredMethod("handleExecuteMaybeDescribeCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleStatement.class.getDeclaredMethod("markDanglingAccessors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleStatement.class.getDeclaredMethod("prepareDefineBufferAndExecuteAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleStatement.class.getDeclaredMethod("prepareDefineBufferAndExecute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleStatement.class.getDeclaredMethod("isDefineBufferPreparedForExecute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleStatement.class.getDeclaredMethod("executeMaybeDescribeAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleStatement.class.getDeclaredMethod("executeMaybeDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleStatement.class.getDeclaredMethod("checkAccessorsUsable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleStatement.class.getDeclaredMethod("prepareAccessors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleStatement.class.getDeclaredMethod("destroyDMSSensors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleStatement.class.getDeclaredMethod("createDMSSensors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleStatement.class.getDeclaredMethod("doSetSnapshotSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleStatement.class.getDeclaredMethod("setSnapshotSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleStatement.class.getDeclaredMethod("setWrapper", OracleStatementWrapper.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleStatement.class.getDeclaredMethod("initStatement", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleStatement.class.getDeclaredMethod("convertSqlKindByteToEnum", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleStatement.class.getDeclaredMethod("convertSqlKindEnumToByte", OracleStatement.SqlKind.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleStatement.class.getDeclaredMethod("closeCursorOnPlainStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleStatement.class.getDeclaredMethod("continueReadRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleStatement.class.getDeclaredMethod("cursorIfRefCursor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEFAULT_ROW_PREFETCH_SIZE = Integer.parseInt("10");
        DEFAULT_RESULT_SET_TYPE = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
        COLUMN_NAME_CACHE_INITIAL_SIZE = 4;
        GLOBAL_STATEMENT_NUMBER = 1;
    }

    static final class QueryCacheState
    extends Enum<QueryCacheState> {
        public static final /* enum */ QueryCacheState UNKNOWN;
        public static final /* enum */ QueryCacheState CACHEABLE;
        public static final /* enum */ QueryCacheState UNCACHEABLE;
        private static final /* synthetic */ QueryCacheState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static QueryCacheState[] values() {
            return (QueryCacheState[])$VALUES.clone();
        }

        public static QueryCacheState valueOf(String name) {
            return Enum.valueOf(QueryCacheState.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = QueryCacheState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = QueryCacheState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = QueryCacheState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            UNKNOWN = new QueryCacheState();
            CACHEABLE = new QueryCacheState();
            UNCACHEABLE = new QueryCacheState();
            $VALUES = new QueryCacheState[]{UNKNOWN, CACHEABLE, UNCACHEABLE};
        }
    }

    static final class FetchMode
    extends Enum<FetchMode> {
        public static final /* enum */ FetchMode OVERWRITE;
        public static final /* enum */ FetchMode APPEND;
        private static final /* synthetic */ FetchMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static FetchMode[] values() {
            return (FetchMode[])$VALUES.clone();
        }

        public static FetchMode valueOf(String name) {
            return Enum.valueOf(FetchMode.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = FetchMode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = FetchMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = FetchMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            OVERWRITE = new FetchMode();
            APPEND = new FetchMode();
            $VALUES = new FetchMode[]{OVERWRITE, APPEND};
        }
    }
}

