/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ByteCopyingBinder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDirectPathPreparedStatement
extends T4CPreparedStatement {
    private int directPathCursor;
    static final int DPPSTMT_STATUS_UNKNOWN = 0;
    static final int DPPSTMT_STATUS_PREPARED = 1;
    static final int DPPSTMT_STATUS_LOAD_STREAM = 2;
    static final int DPPSTMT_STATUS_FINISH = 3;
    static final int DPPSTMT_STATUS_ABORT = 4;
    static final int DPPSTMT_STATUS_CLOSED = 5;
    private int directPathStatus;
    private final String schemaName;
    private final String tableName;
    private final String[] colNames;
    private final String partitionName;
    Properties dpStmtProps;
    private int rowInError;
    private boolean codePointCountingEnabled;
    private int[] maxCodePointCounts;
    private static final int DTYBRI_SIZE = 10;
    private static final String IS_DTYBRI_QUERY = "SELECT COUNT(*) FROM SYS.ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ? AND DATA_TYPE='ROWID'";
    private static final int QUERY_BIND_POS_SCHEMA = 1;
    private static final int QUERY_BIND_POS_TABLE = 2;
    private static final int QUERY_BIND_POS_COLUMN = 3;
    private int sdbaOfBits;
    private int sdbaBits;
    private int dbabBits;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    T4CDirectPathPreparedStatement(PhysicalConnection conn, String schemaName, String tableName, String[] colNames, String partitionName, @Blind(value=PropertiesBlinder.class) Properties stmtProps, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps, String sql) throws SQLException {
        super(conn, sql, stmtProps);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$57, null, conn, schemaName, tableName, colNames, partitionName, TraceControllerImpl.blind(PropertiesBlinder.class, stmtProps), TraceControllerImpl.blind(PropertiesBlinder.class, dpStmtProps), sql);
            }
            if (!this.bindUseDBA) {
                IllegalStateException illegalStateException = new IllegalStateException("Dynamic byte array storage of bind values must be enabled for direct path loads. (The oracle.jdbc.bindUseDBA connection property cannot be false)");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$57, null, illegalStateException);
                }
                throw illegalStateException;
            }
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.colNames = colNames;
            this.partitionName = partitionName;
            this.dpStmtProps = dpStmtProps;
            this.directPathStatus = 0;
            this.rowInError = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$57, null);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$57, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getOriginalSql() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$0, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$0, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void registerReturnParameter(int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$1, this, n2, n3);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$1, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void registerReturnParameter(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$2, this, n2, n3, n4);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void registerReturnParameter(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$3, this, n2, n3, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$3, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$4, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$4, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$5, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$5, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$6, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$6, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$7, this, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$7, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$8, this, string);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$8, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$9, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$9, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$10, this, string, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$11, this, string, nArray);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$11, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$12, this, string, stringArray);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$12, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$13, this, string, n2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$13, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$14, this, string, nArray);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$14, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$15, this, string, stringArray);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$15, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String getSQLStatement(String string, String string2, String[] stringArray, String string3, PhysicalConnection physicalConnection) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void partitionName;
            void colNames;
            void tableName;
            void conn;
            String schemaName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$16, null, string, string2, stringArray, string3, physicalConnection);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO ");
            if (schemaName != null && schemaName.length() != 0) {
                sql.append(conn.enquoteIdentifier(schemaName, true));
                sql.append(".");
            }
            sql.append(conn.enquoteIdentifier((String)tableName, true));
            sql.append("(");
            boolean firstCol = true;
            for (void colName : colNames) {
                if (!firstCol) {
                    sql.append(",");
                } else {
                    firstCol = false;
                }
                sql.append(conn.enquoteIdentifier((String)colName, true));
            }
            sql.append(")");
            sql.append(" VALUES ");
            sql.append("(");
            for (int iCol = 0; iCol < ((void)colNames).length; ++iCol) {
                if (iCol != 0) {
                    sql.append(",");
                }
                sql.append("?");
            }
            sql.append(")");
            if (partitionName != null) {
                sql.append("/* Partition Name:");
                sql.append((String)partitionName);
                sql.append(" */");
            }
            String string4 = sql.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$16, null, string4);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$16, null, null);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$17, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.checkForDirectPathReprepare();
                    boolean bl3 = super.execute();
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$17, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$17, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$17, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$17, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$18, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.checkForDirectPathReprepare();
                    int n3 = super.executeUpdate();
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$18, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$18, this, n2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$18, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$18, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int[] nArray;
            block11: {
                int[] nArray2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$19, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.checkForDirectPathReprepare();
                    nArray = super.executeBatch();
                    if (lock != null) {
                        lock.close();
                    }
                    nArray2 = nArray;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$19, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$19, this, nArray2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$19, this, null);
            }
            return nArray;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$19, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long[] lArray;
            block11: {
                long[] lArray2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$20, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                try {
                    this.checkForDirectPathReprepare();
                    lArray = super.executeLargeBatch();
                    if (lock != null) {
                        lock.close();
                    }
                    lArray2 = lArray;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$20, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$20, this, lArray2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$20, this, null);
            }
            return lArray;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$20, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) throws SQLException, IOException {
        boolean bl6 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl6) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$21, this, bl, bl2, bl3, bl4, bl5, n2);
            }
            int number_of_bound_rows = 0;
            int number_of_bind_positions = 0;
            int[] errorOffsets = new int[2];
            if (this.bindIndicators != null) {
                number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
                number_of_bind_positions = this.bindIndicators[this.bindIndicatorSubRange + 0] & 0xFFFF;
            }
            this.rowInError = 0;
            this.validateBindLengths();
            DirectPathBufferMarshaler.BufferPlanner bufferPlanner = DirectPathBufferMarshaler.createBufferPlanner(number_of_bound_rows, number_of_bind_positions, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.parameterStream, this.accessors, this.t4Connection);
            try {
                this.t4Connection.directPathLoadStream(bufferPlanner, this.directPathCursor, errorOffsets);
            }
            catch (SQLException sqe) {
                this.rowInError = bufferPlanner.getRowByOffset(errorOffsets[0], errorOffsets[1]);
                SQLException sQLException = sqe;
                if (bl6) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            this.setDirectPathStatus(2);
            if (bl6) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl6) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$22, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                if (this.isDirectPathUncommitted()) {
                    this.t4Connection.directPathAbort();
                }
                super.close();
                this.setDirectPathStatus(5);
                this.t4Connection.clearDirectPathState();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$22, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$22, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeWithKey(String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$23, this, string);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                void key;
                if (this.isDirectPathUncommitted()) {
                    this.t4Connection.directPathAbort();
                }
                super.closeWithKey((String)key);
                this.setDirectPathStatus(5);
                this.t4Connection.clearDirectPathState();
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$23, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$23, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDirectPathCursor(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void directPathCursor;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$24, this, n2);
            }
            this.directPathCursor = directPathCursor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    int getDirectPathCursor() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$25, this, new Object[0]);
            }
            int n2 = this.directPathCursor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$25, this, n2);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$25, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    int getDirectPathStatus() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$26, this, new Object[0]);
            }
            int n2 = this.directPathStatus;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$26, this, n2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$26, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isDirectPathUncommitted() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$27, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.directPathStatus == 1 || this.directPathStatus == 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$27, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$27, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isDirectPathCommitted() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$28, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.directPathStatus == 3 || this.directPathStatus == 4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$28, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$28, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isDirectPathClosed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$29, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.directPathStatus == 5;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$29, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$29, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDirectPathStatus(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void directPathStatus;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$30, this, n2);
            }
            this.directPathStatus = directPathStatus;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    void checkForDirectPathReprepare() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$31, this, new Object[0]);
            }
            try {
                if (this.isDirectPathCommitted()) {
                    this.t4Connection.odpp.doODPP(this.schemaName, this.tableName, this.colNames, this.partitionName, this.dpStmtProps);
                    int directPathCursor = (int)this.t4Connection.odpp.getO4Value(3);
                    this.setDirectPathCursor(directPathCursor);
                    this.setDirectPathStatus(1);
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(ex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$31, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    int getErrorRowNumber() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$32, this, new Object[0]);
            }
            int n2 = this.rowInError;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$32, this, n2);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$32, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setupBindBuffers(int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowCount;
            void firstRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$33, this, n2, n3);
            }
            this.updateCodePointCounts((int)firstRow, (int)rowCount);
            super.setupBindBuffers((int)firstRow, (int)rowCount);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getConversionCodeForAsciiStream(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$34, this, n2);
            }
            int n4 = n3 = this.bindRequiresUTF16((int)index) ? 13 : 15;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$34, this, n3);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$34, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int getConversionCodeForCharacterStream(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$35, this, n2);
            }
            int n4 = n3 = this.bindRequiresUTF16((int)index) ? 14 : 16;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$35, this, n3);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$35, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void adjustCharLensForSetCHAR(int n2, byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$36, this, n2, byArray);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowByteLens[index] = ((void)b2).length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void updateAccessors(Accessor[] accessorArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void describedAccessors;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$37, this, new Object[]{accessorArray});
            }
            if (!$assertionsDisabled && describedAccessors == null) {
                AssertionError assertionError = new AssertionError((Object)"describedAccessors is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$37, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.accessors = describedAccessors;
            this.initCodePointCounting();
            this.initRowIDAccessors();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final CharacterSet getCharacterSetForBind(int n2, short s2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            CharacterSet characterSet;
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$38, this, n2, s2);
            }
            DBConversion conversion = this.connection.conversion;
            CharacterSet characterSet2 = this.bindRequiresUTF16((int)index) ? CharacterSet.make(2000) : (characterSet = 2 == this.accessors[index].describeFormOfUse ? conversion.serverNCharSet : conversion.serverCharSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$38, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$38, this, null);
            }
            return characterSet2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Binder createRowidBinder(byte[] byArray) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowidBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, new Object[]{byArray});
            }
            if (rowidBytes == null || ((void)rowidBytes).length == 0) {
                Binder binder = this.createRowidNullBinder();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, binder);
                    ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, null);
                }
                return binder;
            }
            DirectPathRowIDBinder directPathRowIDBinder = new DirectPathRowIDBinder((byte[])rowidBytes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, directPathRowIDBinder);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, null);
            }
            return directPathRowIDBinder;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean bindRequiresUTF16(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, n2);
            }
            Accessor acc = this.accessors[pos];
            DBConversion conversion = this.connection.conversion;
            if (112 != acc.describeType) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, null);
                }
                return false;
            }
            if (2 == acc.describeFormOfUse) {
                boolean bl4;
                boolean bl5 = bl4 = !conversion.isServerNCharSetFixedWidth;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, null);
                }
                return bl5;
            }
            boolean bl6 = bl2 = conversion.isServerCSMultiByte && !conversion.isServerCharSetFixedWidth;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, null);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCharacterSetFixedWidth(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, n2);
            }
            Accessor acc = this.accessors[pos];
            DBConversion conversion = this.connection.conversion;
            if (this.bindRequiresUTF16((int)pos)) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, null);
                }
                return true;
            }
            if (2 == acc.describeFormOfUse) {
                boolean bl4 = conversion.isServerNCharSetFixedWidth;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, null);
                }
                return bl4;
            }
            boolean bl5 = bl2 = !conversion.isServerCSMultiByte || conversion.isServerCharSetFixedWidth;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void initCodePointCounting() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$42, this, new Object[0]);
            }
            this.codePointCountingEnabled = false;
            for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                if (!this.accessors[i2].isLengthSemanticChar() || this.isCharacterSetFixedWidth(i2)) continue;
                this.codePointCountingEnabled = true;
                break;
            }
            this.maxCodePointCounts = (int[])(this.codePointCountingEnabled ? new int[this.numberOfBindPositions] : null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateCodePointCounts(int n2, int n3) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowCount;
            void rowOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this, n2, n3);
            }
            if (!this.codePointCountingEnabled) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this);
                    ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this, null);
                }
                return;
            }
            void endRow = rowOffset + rowCount;
            for (int pos = 0; pos < this.numberOfBindPositions; ++pos) {
                int max = 0;
                for (void row = rowOffset; row < endRow; ++row) {
                    String bindVal = this.getStringBinderVal((int)row, pos);
                    if (bindVal == null) {
                        max = Integer.MAX_VALUE;
                        break;
                    }
                    int count = bindVal.codePointCount(0, bindVal.length());
                    if (count <= max) continue;
                    max = count;
                }
                this.maxCodePointCounts[pos] = max;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxCodePointCount(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void pos;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$44, this, n2);
            }
            int n4 = n3 = this.codePointCountingEnabled ? this.maxCodePointCounts[pos] : Integer.MAX_VALUE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$44, this, n3);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$44, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateBindLengths() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$45, this, new Object[0]);
            }
            block7: for (int pos = 0; pos < this.numberOfBindPositions; ++pos) {
                Accessor acc = this.accessors[pos];
                switch (acc.describeType) {
                    case 8: {
                        if (this.maxRawBytesSql <= Integer.MAX_VALUE) continue block7;
                        break;
                    }
                    case 24: {
                        if (this.maxRawBytesSql <= Integer.MAX_VALUE) continue block7;
                        break;
                    }
                    case 112: 
                    case 113: {
                        continue block7;
                    }
                }
                int maxBytes = acc.describeMaxLength;
                if (!acc.isLengthSemanticChar() || this.isCharacterSetFixedWidth(pos)) {
                    this.validateByteLengths(pos, maxBytes);
                    continue;
                }
                int maxChars = acc.describeMaxLengthChars;
                if (maxChars >= this.getMaxCodePointCount(pos)) {
                    this.validateByteLengths(pos, maxBytes);
                    continue;
                }
                this.validateByteAndCodePointLengths(pos, maxBytes, maxChars, this.getCharacterSetForBind(pos, (short)0));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateByteLengths(int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$46, this, n2, n3);
            }
            int nBinds = this.numberOfBindPositions * this.numberOfBoundRows;
            for (void index = pos; index < nBinds; index += this.numberOfBindPositions) {
                void max;
                int nBytes = this.bindDataLengths[index];
                if (nBytes <= max) continue;
                SQLException sQLException = T4CDirectPathPreparedStatement.newBindLengthException((int)(index / this.numberOfBindPositions + true), (int)(index % this.numberOfBindPositions + true), nBytes, (int)max, "BYTE");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$46, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$46, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateByteAndCodePointLengths(int n2, int n3, int n4, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this, n2, n3, n4, characterSet);
            }
            int nBinds = this.numberOfBindPositions * this.numberOfBoundRows;
            for (void index = pos; index < nBinds; index += this.numberOfBindPositions) {
                void encoder;
                long offset;
                int nCodePoints;
                void maxChars;
                void maxBytes;
                int nBytes = this.bindDataLengths[index];
                if (nBytes > maxBytes) {
                    SQLException sQLException = T4CDirectPathPreparedStatement.newBindLengthException((int)(index / this.numberOfBindPositions + true), (int)(index % this.numberOfBindPositions + true), nBytes, (int)maxBytes, "BYTE");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this, sQLException);
                    }
                    throw sQLException;
                }
                if (nBytes <= maxChars || (nCodePoints = this.getCodePointCount(offset = this.bindDataOffsets[index], nBytes, (CharacterSet)encoder)) <= maxChars) continue;
                SQLException sQLException = T4CDirectPathPreparedStatement.newBindLengthException((int)(index / this.numberOfBindPositions + true), (int)(index % this.numberOfBindPositions + true), nCodePoints, (int)maxChars, "CHAR");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getCodePointCount(long l2, int n2, CharacterSet characterSet) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            String decoded;
            void nBytes;
            void offset;
            void encoder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, l2, n2, characterSet);
            }
            switch (encoder.getOracleId()) {
                case 873: {
                    int n3 = this.getAL32UTF8CodePointCount((long)offset, (int)nBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, null);
                    }
                    return n3;
                }
                case 871: {
                    int n4 = this.getUTF8CodePointCount((long)offset, (int)nBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, null);
                    }
                    return n4;
                }
            }
            try {
                decoded = this.bindData.getString((long)offset, (int)nBytes, (CharacterSet)encoder);
            }
            catch (SQLException decodeErr) {
                byte[] encoded = this.bindData.get((long)offset, (int)nBytes);
                decoded = encoder.toStringWithReplacement(encoded, 0, encoded.length);
            }
            int n5 = decoded.codePointCount(0, decoded.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, n5);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getAL32UTF8CodePointCount(long l2, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            int nBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$49, this, l2, n2);
            }
            byte[] buf = this.connection.getByteBuffer(nBytes);
            this.bindData.get((long)offset, buf, 0, nBytes);
            int nCodePoints = 0;
            for (int pos = 0; pos < nBytes; ++pos) {
                ++nCodePoints;
                byte leadingByte = buf[pos];
                if (0 == (0x80 & leadingByte)) continue;
                if (192 == (0xE0 & leadingByte)) {
                    ++pos;
                    continue;
                }
                if (224 == (0xF0 & leadingByte)) {
                    pos += 2;
                    continue;
                }
                if (240 == (0xF8 & leadingByte)) {
                    pos += 3;
                    continue;
                }
                if ($assertionsDisabled) continue;
                AssertionError assertionError = new AssertionError((Object)("Detected invalid AL32UTF8 code point at buffer position " + (long)(offset + (long)pos) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(leadingByte))));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$49, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.connection.cacheBuffer(buf);
            int n3 = nCodePoints;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$49, this, n3);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$49, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getUTF8CodePointCount(long l2, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            int nBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$50, this, l2, n2);
            }
            byte[] buf = this.connection.getByteBuffer(nBytes);
            this.bindData.get((long)offset, buf, 0, nBytes);
            int nCodePoints = 0;
            for (int pos = 0; pos < nBytes; ++pos) {
                ++nCodePoints;
                byte leadingByte = buf[pos];
                if (0 == (0x80 & leadingByte)) continue;
                if (192 == (0xE0 & leadingByte)) {
                    ++pos;
                    continue;
                }
                if (237 == (0xFF & leadingByte)) {
                    if (pos + 1 >= nBytes) continue;
                    int next4Bits = 0xF & buf[pos + 1] >> 2;
                    if (8 == next4Bits) {
                        --nCodePoints;
                    }
                    pos += 2;
                    continue;
                }
                if (224 == (0xF0 & leadingByte)) {
                    pos += 2;
                    continue;
                }
                if ($assertionsDisabled) continue;
                AssertionError assertionError = new AssertionError((Object)("Detected invalid UTF8 code point at buffer position " + (long)(offset + (long)pos) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(leadingByte))));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$50, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$50, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.connection.cacheBuffer(buf);
            int n3 = nCodePoints;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$50, this, n3);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$50, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static SQLException newBindLengthException(int n2, int n3, int n4, int n5, String string) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void pos;
            int row;
            void semantic;
            void max;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$51, null, n2, n3, n4, n5, string);
            }
            String info = "Maximum Length: " + (int)max + " " + (String)semantic + ". Bind at row " + row + ", position " + (int)pos + ": " + (int)length + " " + (String)semantic;
            SQLException sQLException = DatabaseError.createSqlException(72, info);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$51, null, sQLException);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$51, null, null);
            }
            return sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setSDBAOfBits(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void sdbaOfBits;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$52, this, n2);
            }
            this.sdbaOfBits = sdbaOfBits;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$52, this);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$52, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setSDBABits(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void sdbaBits;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$53, this, n2);
            }
            this.sdbaBits = sdbaBits;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$53, this);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$53, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDBABBits(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void dbabBits;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$54, this, n2);
            }
            this.dbabBits = dbabBits;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$54, this);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$54, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initRowIDAccessors() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$55, this, new Object[0]);
            }
            for (Accessor acc : this.accessors) {
                if (acc.describeType != 208 || acc.describeMaxLength != 10 || !this.columnIsRowID(acc.columnName)) continue;
                acc.describeType = 104;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean columnIsRowID(String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$56, this, string);
                }
                PreparedStatement ps = this.t4Connection.prepareStatement(IS_DTYBRI_QUERY);
                try {
                    void columnName;
                    ps.setString(1, this.schemaName.toUpperCase());
                    ps.setString(2, this.tableName.toUpperCase());
                    ps.setString(3, columnName.toUpperCase());
                    ResultSet rs = ps.executeQuery();
                    rs.next();
                    boolean bl3 = bl2 = 0 != rs.getInt(1);
                    if (ps == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$56, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$56, this, throwable3);
                    }
                    throw throwable3;
                }
                ps.close();
            }
            boolean bl4 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$56, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$56, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, T4CDirectPathPreparedStatement.class, $$$methodRef$$$56, this, throwable4);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$57 = T4CDirectPathPreparedStatement.class.getDeclaredConstructor(PhysicalConnection.class, String.class, String.class, String[].class, String.class, Properties.class, Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("columnIsRowID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("initRowIDAccessors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setDBABBits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setSDBABits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setSDBAOfBits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("newBindLengthException", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getUTF8CodePointCount", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getAL32UTF8CodePointCount", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getCodePointCount", Long.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("validateByteAndCodePointLengths", Integer.TYPE, Integer.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("validateByteLengths", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("validateBindLengths", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getMaxCodePointCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("updateCodePointCounts", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("initCodePointCounting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("isCharacterSetFixedWidth", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("bindRequiresUTF16", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("createRowidBinder", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getCharacterSetForBind", Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("updateAccessors", Accessor[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("adjustCharLensForSetCHAR", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getConversionCodeForCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getConversionCodeForAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setupBindBuffers", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getErrorRowNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("checkForDirectPathReprepare", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setDirectPathStatus", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("isDirectPathClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("isDirectPathCommitted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("isDirectPathUncommitted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getDirectPathStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getDirectPathCursor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("setDirectPathCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("closeWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("doOall8", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeLargeBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeBatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("execute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getSQLStatement", String.class, String.class, String[].class, String.class, PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("execute", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("execute", String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("execute", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeUpdate", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeUpdate", String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeUpdate", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("execute", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeUpdate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("executeQuery", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getReturnResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CDirectPathPreparedStatement.class.getDeclaredMethod("getOriginalSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private class DirectPathRowIDBinder
    extends Binder {
        private Binder copyingBinder;
        private final long[] riddef;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private DirectPathRowIDBinder(byte[] rowIDChars) throws SQLException {
            this.riddef = T4CRowidAccessor.isRestricted(rowIDChars) ? T4CRowidAccessor.rcToRowid(rowIDChars, 0, rowIDChars.length) : T4CRowidAccessor.stringToRowid(rowIDChars, 0, rowIDChars.length);
            this.type = (short)104;
            this.bytelen = 10;
        }

        @Override
        Binder copyingBinder() {
            if (this.copyingBinder == null) {
                this.copyingBinder = new ByteCopyingBinder(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;

                    static {
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredConstructor(DirectPathRowIDBinder.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                };
                this.copyingBinder.type = this.type;
                this.copyingBinder.bytelen = this.bytelen;
            }
            return this.copyingBinder;
        }

        @Override
        long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
            int len;
            long pos;
            assert (bindUseDBA) : "bindUseDBA is false";
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            byte[] encoding = 104 == T4CDirectPathPreparedStatement.this.accessors[bindPosition].describeType ? T4CRowidAccessor.rowidToDTYBRI(this.riddef, T4CDirectPathPreparedStatement.this.sdbaOfBits, T4CDirectPathPreparedStatement.this.sdbaBits, T4CDirectPathPreparedStatement.this.dbabBits) : T4CRowidAccessor.rowidToDTYBURI(this.riddef);
            T4CDirectPathPreparedStatement.this.rowData.put(encoding);
            bindDataLengths[bindDataIndex] = len = encoding.length;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindIndicators[lenoffset] = (short)len;
            if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
                if (bindIndicators[indoffset] == -1) {
                    return CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
                }
                return CRC64.updateChecksum(localCheckSum, encoding, 0, len);
            }
            return localCheckSum;
        }

        static {
            try {
                $$$methodRef$$$2 = DirectPathRowIDBinder.class.getDeclaredConstructor(T4CDirectPathPreparedStatement.class, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DirectPathRowIDBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DirectPathRowIDBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

