/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CXAResource
extends OracleXAResource {
    int[] applicationValueArr;
    boolean isTransLoose;
    byte[] context;
    int errorNumber;
    private OpaqueString password;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    T4CXAResource(OracleConnection _physicalConn, OracleXAConnection xaconn, boolean _isTransLoose) throws XAException {
        super(_physicalConn, xaconn);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CXAResource.class, $$$methodRef$$$10, null, _physicalConn, xaconn, _isTransLoose);
            }
            this.applicationValueArr = new int[1];
            this.isTransLoose = false;
            this.password = null;
            this.isTransLoose = _isTransLoose;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CXAResource.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CXAResource.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CXAResource.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block43: {
                block44: {
                    void xid2;
                    int flag;
                    int returnVal;
                    T4CConnection physicalConn;
                    block39: {
                        int n4;
                        block40: {
                            block41: {
                                int swtch;
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, xid, n2);
                                }
                                physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                                lock = physicalConn.acquireCloseableLock();
                                throwable = null;
                                returnVal = -1;
                                if (this.isTransLoose) {
                                    flag |= 0x10000;
                                }
                                if ((swtch = flag & 0x8200000) != 0x8000000 || !OracleXid.isLocalTransaction((Xid)xid2)) break block39;
                                n4 = 0;
                                if (lock == null) break block40;
                                if (throwable == null) break block41;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block40;
                            }
                            lock.close();
                        }
                        int n5 = n4;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, n5);
                            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, null);
                        }
                        return n5;
                    }
                    this.applicationValueArr[0] = 0;
                    try {
                        try {
                            T4CTTIOtxse otxse = physicalConn.otxse;
                            byte[] xidxid = null;
                            byte[] gtrid = xid2.getGlobalTransactionId();
                            byte[] bqual = xid2.getBranchQualifier();
                            int gtrid_l = 0;
                            int bqual_l = 0;
                            if (gtrid != null && bqual != null) {
                                gtrid_l = Math.min(gtrid.length, 64);
                                bqual_l = Math.min(bqual.length, 64);
                                xidxid = new byte[128];
                                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                            }
                            int t4cflag = 0;
                            t4cflag = (flag & 8) != 0 ? (t4cflag |= 8) : ((flag & 0x200000) != 0 || (flag & 0x8000000) != 0 ? (t4cflag |= 4) : (t4cflag |= 1));
                            if ((flag & 0x100) != 0) {
                                t4cflag |= 0x100;
                            }
                            if ((flag & 0x200) != 0) {
                                t4cflag |= 0x200;
                            }
                            if ((flag & 0x400) != 0) {
                                t4cflag |= 0x400;
                            }
                            if ((flag & 0x10000) != 0) {
                                t4cflag |= 0x10000;
                            }
                            physicalConn.updateSystemContext();
                            physicalConn.needLine();
                            otxse.doOTXSE(1, null, xidxid, xid2.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = otxse.getApplicationValue();
                            byte[] ctx = otxse.getContext();
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                            physicalConn.currentlyInTransaction = true;
                        }
                        catch (IOException ioe) {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "T4CXAResource.do_start: IOException caught:" + ioe.getMessage());
                            }
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    catch (SQLException s2) {
                        if (bl) {
                            this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "T4CXAResource.do_start: SQLException caught:" + s2.getMessage());
                        }
                        if ((returnVal = s2.getErrorCode()) == 0) {
                            XAException xAException = new XAException(-6);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, xAException);
                            }
                            throw xAException;
                        }
                        SQLException sQLException = s2;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, sQLException);
                        }
                        throw sQLException;
                    }
                    n3 = returnVal;
                    if (lock == null) break block43;
                    if (throwable == null) break block44;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block43;
                }
                lock.close();
            }
            int n6 = n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, n6);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, null);
            }
            return n6;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    Throwable throwable5 = throwable4;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, throwable5);
                    }
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable8 = throwable6;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, throwable8);
                    }
                    throw throwable8;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CXAResource.class, $$$methodRef$$$0, this, throwable9);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block42: {
                block43: {
                    int bqual_l;
                    int gtrid_l;
                    void xid2;
                    byte[] xidxid;
                    T4CTTIOtxse otxse;
                    int returnVal;
                    T4CConnection physicalConn;
                    block38: {
                        int n4;
                        block39: {
                            block40: {
                                if (bl2) {
                                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, xid, n2, bl);
                                }
                                physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                                lock = physicalConn.acquireCloseableLock();
                                throwable = null;
                                returnVal = -1;
                                otxse = physicalConn.otxse;
                                xidxid = null;
                                byte[] gtrid = xid2.getGlobalTransactionId();
                                byte[] bqual = xid2.getBranchQualifier();
                                gtrid_l = 0;
                                bqual_l = 0;
                                if (gtrid != null && bqual != null) {
                                    gtrid_l = Math.min(gtrid.length, 64);
                                    bqual_l = Math.min(bqual.length, 64);
                                    xidxid = new byte[128];
                                    System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                    System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                                }
                                if (this.context != null || (returnVal = this.doStart((Xid)xid2, 0x8000000)) == 0) break block38;
                                n4 = returnVal;
                                if (lock == null) break block39;
                                if (throwable == null) break block40;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block39;
                            }
                            lock.close();
                        }
                        int n5 = n4;
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, n5);
                            ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, null);
                        }
                        return n5;
                    }
                    try {
                        try {
                            void flag;
                            byte[] txctx = this.context;
                            int t4cflag = 0;
                            if ((flag & 2) == 2) {
                                t4cflag = 0x100000;
                            } else if ((flag & 0x2000000) == 0x2000000 && (flag & 0x100000) != 0x100000) {
                                t4cflag = 0x100000;
                            }
                            this.applicationValueArr[0] = this.applicationValueArr[0] >> 16;
                            physicalConn.updateSystemContext();
                            physicalConn.needLine();
                            otxse.doOTXSE(2, txctx, xidxid, xid2.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = otxse.getApplicationValue();
                            byte[] ctx = otxse.getContext();
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                            physicalConn.currentlyInTransaction = false;
                        }
                        catch (IOException ioe) {
                            if (bl2) {
                                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "T4CXAResource.do_end: IOException caught:" + ioe.getMessage());
                            }
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    catch (SQLException s2) {
                        if (bl2) {
                            this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "T4CXAResource.do_end: SQLException caught:" + s2.getMessage());
                        }
                        if ((returnVal = s2.getErrorCode()) == 0) {
                            XAException xAException = new XAException(-6);
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, xAException);
                            }
                            throw xAException;
                        }
                        SQLException sQLException = s2;
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    n3 = returnVal;
                    if (lock == null) break block42;
                    if (throwable == null) break block43;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block42;
                }
                lock.close();
            }
            int n6 = n3;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, n6);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, null);
            }
            return n6;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    Throwable throwable5 = throwable4;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, throwable5);
                    }
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable8 = throwable6;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, throwable8);
                    }
                    throw throwable8;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CXAResource.class, $$$methodRef$$$1, this, throwable9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doCommit(Xid xid, boolean bl) throws SQLException, XAException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            block43: {
                Monitor.CloseableLock lock;
                block44: {
                    if (bl2) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, xid, bl);
                    }
                    T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                    lock = physicalConn.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void xid2;
                        void onePhaseCommit;
                        int inTransactionState = onePhaseCommit != false ? 4 : 2;
                        try {
                            int outState = this.doTransaction((Xid)xid2, 1, inTransactionState);
                            if (bl2) {
                                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CXAResource.doCommit: server returns " + outState);
                            }
                            if ((onePhaseCommit == false || outState != 2 && outState != 4) && (onePhaseCommit != false || outState != 5)) {
                                if (outState == 8) {
                                    XAException xAException = new XAException(106);
                                    if (bl2) {
                                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, xAException);
                                    }
                                    throw xAException;
                                }
                                XAException xAException = new XAException(-6);
                                if (bl2) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, xAException);
                                }
                                throw xAException;
                            }
                            physicalConn.currentlyInTransaction = false;
                        }
                        catch (SQLException sqlex) {
                            int errorCode = sqlex.getErrorCode();
                            if (errorCode == 24756) {
                                if (bl2) {
                                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CXAResource.do_commit: got a 24756. Will try to recover.");
                                }
                                this.kputxrec((Xid)xid2, 1, this.timeout + 120, sqlex);
                            }
                            if (errorCode == 24780) {
                                if (bl2) {
                                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CXAResource.do_commit: got a 24780. Will try to commit from a different connection.");
                                }
                                OracleXADataSource oxds = null;
                                PooledConnection pc = null;
                                try {
                                    oxds = new OracleXADataSource();
                                    oxds.setURL(physicalConn.url);
                                    oxds.setUser(physicalConn.userName);
                                    physicalConn.getPasswordInternal(this);
                                    oxds.setPassword(this.password.get());
                                    pc = oxds.getXAConnection();
                                    XAResource oxar2332 = pc.getXAResource();
                                    oxar2332.commit((Xid)xid2, (boolean)onePhaseCommit);
                                    physicalConn.currentlyInTransaction = false;
                                }
                                catch (SQLException e2) {
                                    try {
                                        if (bl2) {
                                            this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CXAResource.do_commit: Got a SQLException while processing a 24780." + e2.getMessage());
                                        }
                                        XAException xaex = new XAException(-6);
                                        xaex.initCause(e2);
                                        XAException xAException = xaex;
                                        if (bl2) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, xAException);
                                        }
                                        throw xAException;
                                    }
                                    catch (Throwable throwable2) {
                                        try {
                                            if (pc != null) {
                                                pc.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        Throwable throwable3 = throwable2;
                                        if (bl2) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, throwable3);
                                        }
                                        throw throwable3;
                                    }
                                }
                                try {
                                    if (pc != null) {
                                        pc.close();
                                    }
                                }
                                catch (Exception oxar2332) {}
                            }
                            SQLException sQLException = sqlex;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (lock == null) break block43;
                        if (throwable == null) break block44;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable = throwable5;
                            Throwable throwable6 = throwable5;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, throwable6);
                            }
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable9 = throwable7;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, throwable9);
                            }
                            throw throwable9;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block43;
                }
                lock.close();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable10 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CXAResource.class, $$$methodRef$$$2, this, throwable10);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block36: {
                Monitor.CloseableLock lock;
                block37: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, xid);
                    }
                    T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                    lock = physicalConn.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int returnVal;
                        block35: {
                            returnVal = -1;
                            try {
                                void xid2;
                                int outState = this.doTransaction((Xid)xid2, 3, 0);
                                if (outState == 8) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "T4CXAResource.do_prepare: server returns K2CMDtimeout");
                                    }
                                    XAException xAException = new XAException(106);
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, xAException);
                                    }
                                    throw xAException;
                                }
                                if (outState == 4) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "T4CXAResource.do_prepare: server returns K2CMDrdonly");
                                    }
                                    returnVal = 3;
                                    break block35;
                                }
                                if (outState == 1) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "T4CXAResource.do_prepare: server returns K2CMDrqcommit");
                                    }
                                    returnVal = 0;
                                    break block35;
                                }
                                if (outState == 3) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "T4CXAResource.do_prepare: server returns K2CMDabort");
                                    }
                                    XAException xAException = new XAException(100);
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, xAException);
                                    }
                                    throw xAException;
                                }
                                if (bl) {
                                    this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "T4CXAResource.do_prepare: server returns " + outState);
                                }
                                XAException xAException = new XAException(-6);
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, xAException);
                                }
                                throw xAException;
                            }
                            catch (SQLException sqlex) {
                                int errorCode = sqlex.getErrorCode();
                                if (errorCode == 25351) {
                                    XAException xae = new XAException(-6);
                                    xae.initCause(sqlex);
                                    XAException xAException = xae;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, xAException);
                                    }
                                    throw xAException;
                                }
                                SQLException sQLException = sqlex;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, sQLException);
                                }
                                throw sQLException;
                            }
                        }
                        n2 = returnVal;
                        if (lock == null) break block36;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block36;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, n3);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CXAResource.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    protected int doForget(Xid xid) throws XAException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block43: {
                block44: {
                    void xid2;
                    int returnVal;
                    block39: {
                        int n3;
                        block41: {
                            block42: {
                                int resumeReturn;
                                SQLException sqlException;
                                block40: {
                                    block36: {
                                        int n4;
                                        block37: {
                                            block38: {
                                                if (bl) {
                                                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, xid);
                                                }
                                                T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                                                lock = physicalConn.acquireCloseableLock();
                                                throwable = null;
                                                returnVal = 0;
                                                sqlException = null;
                                                if (!OracleXid.isLocalTransaction((Xid)xid2)) break block36;
                                                n4 = 24771;
                                                if (lock == null) break block37;
                                                if (throwable == null) break block38;
                                                try {
                                                    lock.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                break block37;
                                            }
                                            lock.close();
                                        }
                                        int n5 = n4;
                                        if (bl) {
                                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, n5);
                                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, null);
                                        }
                                        return n5;
                                    }
                                    try {
                                        resumeReturn = this.doStart((Xid)xid2, 0x8000000);
                                    }
                                    catch (SQLException sqlex) {
                                        resumeReturn = sqlex.getErrorCode();
                                        sqlException = sqlex;
                                    }
                                    if (resumeReturn == 24756) break block39;
                                    if (bl) {
                                        this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "T4CXAResource.do_forget : resume returned : " + resumeReturn);
                                    }
                                    if (resumeReturn == 0) {
                                        try {
                                            this.doEnd((Xid)xid2, 0, false);
                                        }
                                        catch (Exception e2) {
                                            if (!bl) break block40;
                                            this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "T4CXAResource.do_forget : end txn that existsts throws exception : " + e2.getMessage());
                                        }
                                    }
                                }
                                if (resumeReturn == 0 || resumeReturn == 2079 || resumeReturn == 24754 || resumeReturn == 24761 || resumeReturn == 24774 || resumeReturn == 24776 || resumeReturn == 25351) {
                                    this.checkError(24769, sqlException);
                                } else if (resumeReturn == 24752) {
                                    this.checkError(24771, sqlException);
                                } else {
                                    this.checkError(resumeReturn, sqlException);
                                }
                                n3 = returnVal;
                                if (lock == null) break block41;
                                if (throwable == null) break block42;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block41;
                            }
                            lock.close();
                        }
                        int n6 = n3;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, n6);
                            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, null);
                        }
                        return n6;
                    }
                    this.kputxrec((Xid)xid2, 4, 1, null);
                    n2 = returnVal;
                    if (lock == null) break block43;
                    if (throwable == null) break block44;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block43;
                }
                lock.close();
            }
            int n7 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, n7);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, null);
            }
            return n7;
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    Throwable throwable6 = throwable5;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, throwable6);
                    }
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable9 = throwable7;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, throwable9);
                    }
                    throw throwable9;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable10 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CXAResource.class, $$$methodRef$$$4, this, throwable10);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doRollback(Xid xid) throws XAException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            block43: {
                Monitor.CloseableLock lock;
                block44: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, xid);
                    }
                    T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
                    lock = physicalConn.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        block42: {
                            void xid2;
                            try {
                                int outState = this.doTransaction((Xid)xid2, 2, 3);
                                if (bl) {
                                    this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "T4CXAResource.do_rollback: server returns " + outState);
                                }
                                if (outState == 8) {
                                    XAException xAException = new XAException(106);
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, xAException);
                                    }
                                    throw xAException;
                                }
                                if (outState != 3) {
                                    XAException xAException = new XAException(-6);
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, xAException);
                                    }
                                    throw xAException;
                                }
                                physicalConn.currentlyInTransaction = false;
                            }
                            catch (SQLException sqle) {
                                int errorCode = sqle.getErrorCode();
                                if (errorCode == 24756) {
                                    this.kputxrec((Xid)xid2, 2, this.timeout + 120, sqle);
                                }
                                if (errorCode == 24780) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "T4CXAResource.do_rollback: got a 24780.");
                                    }
                                    OracleXADataSource oxds = null;
                                    PooledConnection pc = null;
                                    try {
                                        oxds = new OracleXADataSource();
                                        oxds.setURL(physicalConn.url);
                                        oxds.setUser(physicalConn.userName);
                                        physicalConn.getPasswordInternal(this);
                                        oxds.setPassword(this.password.get());
                                        pc = oxds.getXAConnection();
                                        XAResource oxar2332 = pc.getXAResource();
                                        oxar2332.rollback((Xid)xid2);
                                        physicalConn.currentlyInTransaction = false;
                                    }
                                    catch (SQLException e2) {
                                        try {
                                            if (bl) {
                                                this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "T4CXAResource.do_rollback: Got a SQLException while processing a 24780." + e2.getMessage());
                                            }
                                            XAException xaex = new XAException(-6);
                                            xaex.initCause(e2);
                                            XAException xAException = xaex;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, xAException);
                                            }
                                            throw xAException;
                                        }
                                        catch (Throwable throwable2) {
                                            try {
                                                if (pc != null) {
                                                    pc.close();
                                                }
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            Throwable throwable3 = throwable2;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, throwable3);
                                            }
                                            throw throwable3;
                                        }
                                    }
                                    try {
                                        if (pc != null) {
                                            pc.close();
                                        }
                                    }
                                    catch (Exception oxar2332) {}
                                }
                                if (errorCode == 25402) break block42;
                                SQLException sQLException = sqle;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, sQLException);
                                }
                                throw sQLException;
                            }
                        }
                        if (lock == null) break block43;
                        if (throwable == null) break block44;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable = throwable5;
                            Throwable throwable6 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, throwable6);
                            }
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable9 = throwable7;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, throwable9);
                            }
                            throw throwable9;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block43;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable10 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CXAResource.class, $$$methodRef$$$5, this, throwable10);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int doTransaction(Xid xid, int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CXAResource.class, $$$methodRef$$$6, this, xid, n2, n3);
            }
            T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
            int transactionOutState = -1;
            try {
                void inTransactionState;
                void mode;
                void xid2;
                T4CTTIOtxen otxen = physicalConn.otxen;
                byte[] xidxid = null;
                byte[] gtrid = xid2.getGlobalTransactionId();
                byte[] bqual = xid2.getBranchQualifier();
                int gtrid_l = 0;
                int bqual_l = 0;
                if (gtrid != null && bqual != null) {
                    gtrid_l = Math.min(gtrid.length, 64);
                    bqual_l = Math.min(bqual.length, 64);
                    xidxid = new byte[128];
                    System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                    System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                }
                byte[] txctx = this.context;
                physicalConn.needLine();
                otxen.doOTXEN((int)mode, txctx, xidxid, xid2.getFormatId(), gtrid_l, bqual_l, this.timeout, (int)inTransactionState, 0);
                transactionOutState = otxen.getOutStateFromServer();
                if (bl) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "T4CXAResource.do_transaction: transactionOutState=" + transactionOutState);
                }
            }
            catch (IOException ioe) {
                if (bl) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "T4CXAResource.do_transaction: IOException caught:" + ioe.getMessage());
                }
                physicalConn.handleIOException(ioe);
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, T4CXAResource.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            int n4 = transactionOutState;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CXAResource.class, $$$methodRef$$$6, this, n4);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CXAResource.class, $$$methodRef$$$6, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CXAResource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void kputxrec(Xid xid, int n2, int n3, SQLException sQLException) throws XAException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int incmd;
            void xid2;
            void tries;
            int inTransactionMode;
            void opcode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, xid, n2, n3, sQLException);
            }
            T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
            switch (opcode) {
                case 1: {
                    inTransactionMode = 3;
                    break;
                }
                case 4: {
                    inTransactionMode = 2;
                    break;
                }
                default: {
                    inTransactionMode = 0;
                }
            }
            int endstate = 0;
            while (--tries > 0 && (endstate = this.doTransaction((Xid)xid2, 5, inTransactionMode)) == 7) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            if (endstate == 7) {
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "T4CXAResource.kputxrec: Try to recover but transaction operation cannot be completed now. Transaction not ready for recovery.");
                }
                XAException xAException = new XAException(-6);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, xAException);
                }
                throw xAException;
            }
            int xaErrorCode = -1;
            switch (endstate) {
                case 3: {
                    if (opcode == true) {
                        incmd = 7;
                        break;
                    }
                    incmd = 8;
                    xaErrorCode = -3;
                    break;
                }
                case 0: {
                    if (opcode == 4) {
                        incmd = 8;
                        xaErrorCode = -3;
                        break;
                    }
                    incmd = 7;
                    if (opcode != true) break;
                    xaErrorCode = -4;
                    break;
                }
                case 2: {
                    if (opcode == 4) {
                        incmd = 8;
                        xaErrorCode = -6;
                        break;
                    }
                }
                case 5: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 7;
                    incmd = 8;
                    break;
                }
                case 4: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 6;
                    incmd = 8;
                    break;
                }
                case 6: {
                    if (opcode == 4) {
                        incmd = 7;
                        break;
                    }
                    xaErrorCode = 5;
                    incmd = 8;
                    break;
                }
                default: {
                    xaErrorCode = -3;
                    incmd = 8;
                }
            }
            T4CTTIk2rpc k2rpc = physicalConn.k2rpc;
            try {
                k2rpc.doOK2RPC(3, incmd);
            }
            catch (IOException ioe) {
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "T4CXAResource.kputxrec: IOException caught:" + ioe.getMessage());
                }
                XAException xae = new XAException(-7);
                xae.initCause(ioe);
                XAException xAException = xae;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, xAException);
                }
                throw xAException;
            }
            catch (SQLException s2) {
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "T4CXAResource.kputxrec: SQLException caught:" + s2.getMessage());
                }
                XAException xar = new XAException(-6);
                xar.initCause(s2);
                XAException xAException = xar;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, xAException);
                }
                throw xAException;
            }
            if (xaErrorCode != -1) {
                void sqlexCause;
                OracleXAException xae = null;
                if (sqlexCause != null) {
                    xae = new OracleXAException(sqlexCause.getErrorCode(), xaErrorCode);
                    xae.initCause((Throwable)sqlexCause);
                } else {
                    xae = new OracleXAException(0, xaErrorCode);
                }
                OracleXAException oracleXAException = xae;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, oracleXAException);
                }
                throw oracleXAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CXAResource.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPasswordInternal(OpaqueString opaqueString) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void p2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CXAResource.class, $$$methodRef$$$8, this, opaqueString);
            }
            this.password = p2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CXAResource.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CXAResource.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CXAResource.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CXAResource.class, $$$methodRef$$$9, this, new Object[0]);
            }
            OracleConnection oracleConnection = (OracleConnection)this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CXAResource.class, $$$methodRef$$$9, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CXAResource.class, $$$methodRef$$$9, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CXAResource.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$10 = T4CXAResource.class.getDeclaredConstructor(OracleConnection.class, OracleXAConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CXAResource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CXAResource.class.getDeclaredMethod("setPasswordInternal", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CXAResource.class.getDeclaredMethod("kputxrec", Xid.class, Integer.TYPE, Integer.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CXAResource.class.getDeclaredMethod("doTransaction", Xid.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CXAResource.class.getDeclaredMethod("doRollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CXAResource.class.getDeclaredMethod("doForget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CXAResource.class.getDeclaredMethod("doPrepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CXAResource.class.getDeclaredMethod("doCommit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CXAResource.class.getDeclaredMethod("doEnd", Xid.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CXAResource.class.getDeclaredMethod("doStart", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

