/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.jdbc.diagnostics.AbstractDiagnosable;
import oracle.jdbc.internal.Monitor;

public class Metrics {
    private static final Map<String, ConsolidatedMetric> consolidatedMetricsMap = Collections.synchronizedMap(new HashMap());
    private static final String PRINT_FORMAT = "%s : occurrences %d / min duration %d / max duration %d / avg duration %d" + System.lineSeparator();

    public static void enable(boolean isEnabled) {
        AbstractDiagnosable.enableMetrics(isEnabled);
    }

    public void begin(ConnectionEvent event) {
    }

    public void begin(ConnectionEvent event, int retryIdentifier) {
    }

    public void end(ConnectionEvent event) {
    }

    public void end(ConnectionEvent event, int retryIdentifier) {
    }

    public void close() {
    }

    protected void add(Map<String, long[]> connectionMetricsMap) {
        connectionMetricsMap.forEach((key, value) -> {
            ConsolidatedMetric consolidatedMetric = consolidatedMetricsMap.computeIfAbsent((String)key, v -> new ConsolidatedMetric());
            long duration = value[1] - value[0];
            assert (duration > 0L) : "Assertion failure : duration is not > 0 for the event " + key;
            consolidatedMetric.add(duration);
        });
    }

    public static void clear() {
        consolidatedMetricsMap.clear();
    }

    private static String getFormattedMetricReport(String spacePrefix, ConnectionEvent connectionEvent, TimeUnit timeUnit) {
        int occurrenceCount;
        StringBuilder stringBuilder = new StringBuilder();
        Object eventName = connectionEvent.getName();
        int retryIdentifier = 1;
        do {
            occurrenceCount = 0;
            ConsolidatedMetric consolidatedMetric = consolidatedMetricsMap.get(eventName);
            if (consolidatedMetric == null || (occurrenceCount = consolidatedMetric.getOccurrencesCount()) <= 0) continue;
            long minDuration = timeUnit.convert(consolidatedMetric.getMinDuration(), TimeUnit.NANOSECONDS);
            long maxDuration = timeUnit.convert(consolidatedMetric.getMaxDuration(), TimeUnit.NANOSECONDS);
            long avgDuration = timeUnit.convert(consolidatedMetric.getAverageDuration(), TimeUnit.NANOSECONDS);
            stringBuilder.append(spacePrefix);
            stringBuilder.append(String.format(PRINT_FORMAT, eventName, occurrenceCount, minDuration, maxDuration, avgDuration));
            eventName = connectionEvent.getName() + " " + retryIdentifier++;
        } while (occurrenceCount > 0);
        return stringBuilder.toString();
    }

    public static String getReport(TimeUnit timeUnit) {
        if (!consolidatedMetricsMap.isEmpty()) {
            return "Printing metrics in time units " + timeUnit + System.lineSeparator() + Metrics.getFormattedMetricReport("", ConnectionEvent.CONNECT, timeUnit) + Metrics.getFormattedMetricReport(" ", ConnectionEvent.NET_SESSION_ESTABLISHMENT, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SOCKET_ESTABLISHMENT, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_CONNECT_SEND1, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_CONNECT_RECEIVE1, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_CONNECT_SEND2, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_CONNECT_RECEIVE2, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_ACCEPT, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.NS_REDIRECT, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.ASO_NEGOTIATION, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_BEGIN_HANDSHAKE, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_HANDSHAKE, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_CONTEXT_INIT, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_HS_ROUND_TRIP_RUNTASKS, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_HS_ROUND_TRIP_WRAP, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_HS_ROUND_TRIP_UNWRAP, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_HS_ROUND_TRIP_RECEIVE, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_HS_ROUND_TRIP_SEND, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_BEGIN_HANDSHAKE_RENEGOTIATION, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SSL_RENEGOTIATION, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_RENEGO_ROUND_TRIP_RUNTASKS, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_RENEGO_ROUND_TRIP_WRAP, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_RENEGO_ROUND_TRIP_UNWRAP, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_RENEGO_ROUND_TRIP_RECEIVE, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.SSL_RENEGO_ROUND_TRIP_SEND, timeUnit) + Metrics.getFormattedMetricReport(" ", ConnectionEvent.TTC_NEGOTIATION, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.TTC_TTIPRO, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.TTC_TTIDTY, timeUnit) + Metrics.getFormattedMetricReport(" ", ConnectionEvent.AUTH, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SEND_OSESS, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.RECEIVE_OSESS, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.SEND_OAUTH, timeUnit) + Metrics.getFormattedMetricReport("    ", ConnectionEvent.AUTH_GEN_PK, timeUnit) + Metrics.getFormattedMetricReport("  ", ConnectionEvent.RECEIVE_OAUTH, timeUnit) + Metrics.getFormattedMetricReport(" ", ConnectionEvent.OVERSION, timeUnit);
        }
        return "Metrics are either cleared or not collected.";
    }

    public static void print(OutputStream outputStream, TimeUnit timeUnit) throws IOException {
        outputStream.write(Metrics.getReport(timeUnit).getBytes());
    }

    private static class ConsolidatedMetric {
        private int occurrences = 0;
        private long minDuration = Long.MAX_VALUE;
        private long maxDuration = Long.MIN_VALUE;
        private long aggregateDuration = 0L;
        private final Monitor monitor = Monitor.newInstance();

        private ConsolidatedMetric() {
        }

        private void setMinDuration(long minDuration) {
            if (minDuration < this.minDuration) {
                this.minDuration = minDuration;
            }
        }

        private void setMaxDuration(long maxDuration) {
            if (maxDuration > this.maxDuration) {
                this.maxDuration = maxDuration;
            }
        }

        private void aggregateDuration(long duration) {
            this.aggregateDuration += duration;
        }

        public void add(long duration) {
            try (Monitor.CloseableLock ignore = this.monitor.acquireCloseableLock();){
                if (duration >= 0L) {
                    ++this.occurrences;
                    this.setMinDuration(duration);
                    this.setMaxDuration(duration);
                    this.aggregateDuration(duration);
                }
            }
        }

        public int getOccurrencesCount() {
            return this.occurrences;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public long getAverageDuration() {
            if (this.occurrences > 0) {
                return this.aggregateDuration / (long)this.occurrences;
            }
            return 0L;
        }
    }

    public static enum ConnectionEvent {
        CONNECT("Connection Time"),
        NET_SESSION_ESTABLISHMENT("NS session time"),
        SOCKET_ESTABLISHMENT("Socket Connect"),
        NS_CONNECT_SEND1("Send NS_CONNECT_1"),
        NS_CONNECT_RECEIVE1("Receive NS_CONNECT_1"),
        NS_CONNECT_SEND2("Send NS_CONNECT_2"),
        NS_CONNECT_RECEIVE2("Receive NS_CONNECT_2"),
        NS_ACCEPT("Process NS_ACCEPT"),
        NS_REDIRECT("Receive NS_REDIRECT"),
        ASO_NEGOTIATION("Complete ASO roundtrip"),
        SSL_BEGIN_HANDSHAKE("Begin Handshake"),
        SSL_HANDSHAKE("SSL session"),
        SSL_CONTEXT_INIT("SSL Context Initialization"),
        SSL_HS_ROUND_TRIP_RUNTASKS("SSL Handshake RunTasks"),
        SSL_HS_ROUND_TRIP_WRAP("SSL Handshake Wrap"),
        SSL_HS_ROUND_TRIP_UNWRAP("SSL Handshake UnWrap"),
        SSL_HS_ROUND_TRIP_RECEIVE("SSL Handshake Receive"),
        SSL_HS_ROUND_TRIP_SEND("SSL Handshake Send"),
        SSL_BEGIN_HANDSHAKE_RENEGOTIATION("Renegotiation Begin Handshake"),
        SSL_RENEGOTIATION("SSL Renegotiation"),
        SSL_RENEGO_ROUND_TRIP_RUNTASKS("SSL Renegotiation RunTasks"),
        SSL_RENEGO_ROUND_TRIP_WRAP("SSL Renegotiation Wrap"),
        SSL_RENEGO_ROUND_TRIP_UNWRAP("SSL Renegotiation UnWrap"),
        SSL_RENEGO_ROUND_TRIP_RECEIVE("SSL Renegotiation Receive"),
        SSL_RENEGO_ROUND_TRIP_SEND("SSL Renegotiation Send"),
        TTC_NEGOTIATION("TTC negotiation"),
        TTC_TTIPRO("TTIPRO roundtrip"),
        TTC_TTIDTY("TTIDTY roundtrip"),
        AUTH("Authentication"),
        SEND_OSESS("Send OSESSKEY"),
        RECEIVE_OSESS("Receive OSESSKEY"),
        SEND_OAUTH("Send OAUTH"),
        AUTH_GEN_PK("Generate PK"),
        RECEIVE_OAUTH("Receive OAUTH"),
        OVERSION("OVERSION roundtrip");

        private final String name;

        private ConnectionEvent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

