/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.CharacterSet;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected OracleClob clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    protected boolean asciiStrictConversion;
    boolean internalClob = false;

    public OracleClobInputStream(OracleClob clob, int chunkSize) throws SQLException {
        this(clob, chunkSize, 1L, false);
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, boolean isInternal) throws SQLException {
        this(clob, chunkSize, 1L, isInternal);
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, long beginOffset) throws SQLException {
        this(clob, chunkSize, beginOffset, false);
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, long beginOffset, boolean isInternal) throws SQLException {
        super(chunkSize, ((PhysicalConnection)clob.getInternalConnection())::getByteBufferSync, ((PhysicalConnection)clob.getInternalConnection())::cacheBufferSync);
        if (clob == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException();
        }
        this.lobOffset = beginOffset;
        this.clob = clob;
        this.markedByte = -1L;
        this.endOfStream = false;
        this.internalClob = isInternal;
        this.asciiStrictConversion = ((PhysicalConnection)clob.getInternalConnection()).isStrictAsciiConversion;
    }

    @Override
    public boolean needBytes(int howMany) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    if (howMany > this.currentBufferSize || howMany == 0) {
                        this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                        PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                        this.charBuf = pConnection.getCharBufferSync(this.currentBufferSize);
                    }
                    this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                    byte[] buffer = this.getBuffer(this.currentBufferSize);
                    CharacterSet.convertJavaCharsToASCIIBytes(this.charBuf, 0, buffer, 0, this.count, this.asciiStrictConversion);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        if (readLimit < 0) {
            throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException(DatabaseError.findMessage(195, null));
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n) {
            this.pos = (int)((long)this.pos + n);
            start += n;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = 0L;
                remainLen = this.clob.length() - this.lobOffset + 1L;
                if (remainLen >= n - start) {
                    this.lobOffset += n - start;
                    start += n - start;
                } else {
                    this.lobOffset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
        return start;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.charBuf != null) {
                PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                pConnection.cacheBufferSync(this.charBuf);
                this.charBuf = null;
            }
            this.currentBufferSize = 0;
            if (this.clob != null && this.internalClob) {
                this.clob.free();
                this.internalClob = false;
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
        finally {
            super.close();
        }
    }

    @Override
    public int available() throws IOException {
        int prefetchSize;
        this.ensureOpen();
        OracleLargeObject.PrefetchData prefetchData = this.clob.getPrefetchData();
        if (this.clob.isActivePrefetch() && prefetchData != null && (prefetchSize = prefetchData.length()) > 0) {
            if (this.lobOffset == 1L) {
                return prefetchSize;
            }
            if (this.lobOffset - 1L < (long)prefetchSize) {
                return prefetchSize - this.pos;
            }
        }
        return super.available();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exc) {
            return null;
        }
    }
}

