/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.PrintStream;
import java.security.AccessController;
import java.util.Vector;
import oracle.net.jdbc.nl.InvalidSyntaxException;

public final class NVPair {
    public static int RHS_NONE = 0;
    public static int RHS_ATOM = 1;
    public static int RHS_LIST = 2;
    public static int LIST_REGULAR = 3;
    public static int LIST_COMMASEP = 4;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    static final String LINE_SEPARATOR = NVPair.getLineSeparatorProperty();

    public NVPair(String name) {
        this._name = name;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String name, String atom) throws InvalidSyntaxException {
        this(name);
        this.setAtom(atom);
    }

    public NVPair(String name, NVPair child) {
        this(name);
        this.addListElement(child);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair parent) {
        this._parent = parent;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int type) {
        this._listType = type;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String atom) throws InvalidSyntaxException {
        if (this._name.indexOf("COMMENT") == -1 && this.containsComment(atom)) {
            Object[] local = new Object[]{"#", this.getName()};
            throw new InvalidSyntaxException("UnexpectedChar-04603", local);
        }
        this._rhsType = RHS_ATOM;
        this._atom = atom;
        this._list = null;
    }

    private boolean containsComment(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '#') continue;
            if (i != 0) {
                if (str.charAt(i - 1) == '\\') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int pos) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(pos);
    }

    public void addListElement(NVPair pair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(pair);
        pair._setParent(this);
    }

    public void removeListElement(int pos) {
        if (this._list != null) {
            this._list.removeElementAt(pos);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int count) {
        Object blank_str = new String("");
        for (int i = 0; i < count; ++i) {
            blank_str = (String)blank_str + " ";
        }
        return blank_str;
    }

    public String trimValueToString() {
        String tmpStr = this.valueToString().trim();
        return tmpStr.substring(1, tmpStr.length() - 1);
    }

    public String valueToString() {
        Object out;
        block3: {
            block4: {
                block2: {
                    out = "";
                    if (this._rhsType != RHS_ATOM) break block2;
                    out = (String)out + this._atom;
                    break block3;
                }
                if (this._rhsType != RHS_LIST) break block3;
                if (this._listType != LIST_REGULAR) break block4;
                for (int i = 0; i < this.getListSize(); ++i) {
                    out = (String)out + this.getListElement(i).toString();
                }
                break block3;
            }
            if (this._listType != LIST_COMMASEP) break block3;
            for (int i = 0; i < this.getListSize(); ++i) {
                NVPair listElem = this.getListElement(i);
                out = (String)out + listElem.getName();
                if (i == this.getListSize() - 1) continue;
                out = (String)out + ", ";
            }
        }
        return out;
    }

    public String toString() {
        String out = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            out = out + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                for (int i = 0; i < this.getListSize(); ++i) {
                    out = out + this.getListElement(i).toString();
                }
            } else if (this._listType == LIST_COMMASEP) {
                out = out + " (";
                for (int i = 0; i < this.getListSize(); ++i) {
                    NVPair listElem = this.getListElement(i);
                    out = out + listElem.getName();
                    if (i == this.getListSize() - 1) continue;
                    out = out + ", ";
                }
                out = out + ")";
            }
        }
        out = out + ")";
        return out;
    }

    public String toString(int level, boolean enable) {
        Object out = "";
        String temp = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                Object rhs = "";
                for (int i = 0; i < this.getListSize(); ++i) {
                    rhs = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? (String)rhs + this.getListElement(i).toString(level + 1, false) : (String)rhs + this.getListElement(i).toString(level + 1, true);
                }
                if (!((String)rhs).equals("")) {
                    out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? (String)out + this.space(level * 2) + "(" + this._name + " = " : (String)out + this.space(level * 2) + "(" + this._name + " =" + LINE_SEPARATOR;
                    out = (String)out + (String)rhs;
                    out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? (String)out + ")" + LINE_SEPARATOR : (level == 0 ? (String)out + ")" : (level == 1 ? (String)out + this.space(level * 2) + ")" : (String)out + this.space(level * 2) + ")" + LINE_SEPARATOR));
                }
            } else if (this._listType == LIST_COMMASEP) {
                out = (String)out + "(" + this._name + "= (";
                for (int i = 0; i < this.getListSize(); ++i) {
                    NVPair listElem = this.getListElement(i);
                    out = (String)out + listElem.getName();
                    if (i == this.getListSize() - 1) continue;
                    out = (String)out + ", ";
                }
                out = (String)out + "))";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (level == 0) {
                if (temp.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    out = (String)out + "(" + this._atom + ")";
                } else {
                    out = (String)out + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (temp.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                out = (String)out + this._atom + LINE_SEPARATOR;
            } else if (!enable) {
                out = (String)out + "(" + this._name + " = " + this._atom + ")";
            } else {
                out = (String)out + this.space(level * 2) + "(" + this._name + " = " + this._atom + ")";
                out = (String)out + LINE_SEPARATOR;
            }
        }
        return out;
    }

    public String modifyCommentString(String str) {
        Object str1 = "";
        for (int offset = 0; offset < str.length(); ++offset) {
            char current_char = str.charAt(offset);
            switch (current_char) {
                case '\\': {
                    if (str.charAt(offset + 1) != '(' && str.charAt(offset + 1) != '=' && str.charAt(offset + 1) != ')' && str.charAt(offset + 1) != ',' && str.charAt(offset + 1) != '\\') break;
                }
            }
            int n = ++offset;
            str1 = (String)str1 + str.charAt(n);
        }
        return str1;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream pout) {
        if (this._rhsType == RHS_ATOM) {
            pout.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            for (int i = 0; i < this.getListSize(); ++i) {
                this.getListElement(i).println(pout);
            }
        }
    }

    private static String getLineSeparatorProperty() {
        return AccessController.doPrivileged(() -> System.getProperty("line.separator"));
    }
}

