/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobWriter
extends Writer {
    private final OracleClobWriterLock lock;
    DBConversion dbConversion;
    OracleClob clob;
    long lobOffset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;

    public OracleClobWriter(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
    }

    public OracleClobWriter(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
    }

    public OracleClobWriter(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
    }

    public OracleClobWriter(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        super(new OracleClobWriterLock());
        this.lock = (OracleClobWriterLock)((Writer)this).lock;
        if (clob == null || bufferSize <= 0 || clob.getJavaSqlConnection() == null || beginOffset < 1L) {
            throw new IllegalArgumentException();
        }
        this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
        this.clob = clob;
        this.lobOffset = beginOffset;
        this.charBuf = new char[bufferSize];
        this.nativeBuf = new byte[bufferSize * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = bufferSize;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        OracleClobWriterLock oracleClobWriterLock = this.lock;
        synchronized (oracleClobWriterLock) {
            int charsWritten;
            int start;
            this.ensureOpen();
            int lengthToWrite = Math.min(len, cbuf.length - off);
            if (lengthToWrite >= 2 * this.chunkSize) {
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, cbuf, off, lengthToWrite);
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
                return;
            }
            int end = start + lengthToWrite;
            for (start = off; start < end; start += charsWritten) {
                charsWritten = Math.min(this.chunkSize - this.count, end - start);
                System.arraycopy(cbuf, start, this.charBuf, this.count, charsWritten);
                this.count += charsWritten;
                if (this.count < this.chunkSize) continue;
                char lastChar = this.charBuf[this.count - 1];
                if (Character.isHighSurrogate(lastChar)) {
                    --this.count;
                    this.flushBuffer();
                    this.charBuf[0] = lastChar;
                    this.count = 1;
                    continue;
                }
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        OracleClobWriterLock oracleClobWriterLock = this.lock;
        synchronized (oracleClobWriterLock) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        OracleClobWriterLock oracleClobWriterLock = this.lock;
        synchronized (oracleClobWriterLock) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        OracleClobWriterLock oracleClobWriterLock = this.lock;
        synchronized (oracleClobWriterLock) {
            if (this.count < 1) {
                return;
            }
            try {
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, this.charBuf, 0, this.count);
                this.count = 0;
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static final class OracleClobWriterLock {
        private OracleClobWriterLock() {
        }
    }
}

