/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionAlgorithm;
import oracle.net.aso.EncryptionEngine;
import oracle.net.aso.PaddedCipher;

public class DESEncryption
implements EncryptionAlgorithm {
    static int DES_KEY_SIZE = 8;
    static final byte[] naedmfb = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
    static final byte[] naedmm1 = new byte[]{-2, -2, -2, -2, -2, -2, -2, -2};
    static final byte[] naedmk1 = new byte[]{88, -46, 26, -119, 7, 0, -59, -68};
    static final byte[] naedmk2 = new byte[]{103, 98, -82, -38, 116, -21, -92, -87};
    static final byte[] naedmm2 = new byte[]{14, -2, 14, -2, 14, -2, 14, -2};
    public static final int DES_UNIT_SIZE = 8;
    protected int paddingMode = 1;
    protected byte[] key;
    protected byte[] iv;
    private String algId = "DES40C";
    private PaddedCipher cipher;
    private boolean isCBCEnabled = true;
    private int blockMode = 1;

    public DESEncryption(String algoID, int cipherBlockMode, int padding) {
        this.algId = algoID;
        this.blockMode = cipherBlockMode;
        this.paddingMode = padding;
    }

    DESEncryption() {
    }

    @Override
    public void init(byte[] key, byte[] iv) throws AsoException {
        this.isCBCEnabled = this.blockMode == 1;
        this.key = new byte[8];
        System.arraycopy(key, 0, this.key, 0, 8);
        this.initializeCiphers();
    }

    private void initializeCiphers() throws AsoException {
        if (this.algId == "DES40C") {
            DESEncryption.shrinkKey(this.key);
        }
        this.iv = (byte[])naedmfb.clone();
        DESJCEEngine coreEngine = new DESJCEEngine();
        coreEngine.init(this.key, this.iv);
        CipherBlockProcessor cipherBlockProcessor = CipherBlockProcessor.newInstance(this.isCBCEnabled ? 1 : 0, this.iv, coreEngine, 8);
        this.cipher = PaddedCipher.newInstance(this.paddingMode, coreEngine, 8, cipherBlockProcessor);
    }

    @Override
    public byte[] decrypt(byte[] ebuf) throws AsoException {
        return this.cipher.decrypt(ebuf);
    }

    @Override
    public byte[] encrypt(byte[] buffer) throws AsoException {
        return this.cipher.encrypt(buffer);
    }

    @Override
    public int maxDelta() {
        return 8;
    }

    @Override
    public void setSessionKey(byte[] key, byte[] iv) throws AsoException {
        if (key != null && iv != null) {
            this.init(key, iv);
        } else {
            this.initializeCiphers();
        }
    }

    @Override
    public String getProviderName() {
        return this.cipher.getEncryptionEngine().getProviderName();
    }

    private static void shrinkKey(byte[] desKey) {
        byte[] i0 = new byte[8];
        byte[] di1 = new byte[8];
        byte[] di2 = new byte[8];
        int[] skey = new int[32];
        EncryptionAlgorithm.byteOperation(i0, desKey, naedmm1, 1, DES_KEY_SIZE);
        DESEncryption.applyDES(naedmk2, i0, di2);
        DESEncryption.applyDES(naedmk1, i0, di1);
        EncryptionAlgorithm.byteOperation(i0, di2, di1, 2, DES_KEY_SIZE);
        EncryptionAlgorithm.byteOperation(desKey, i0, naedmm2, 1, DES_KEY_SIZE);
    }

    private static void applyDES(byte[] key, byte[] in, byte[] out) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = skf.generateSecret(dks);
            cipher.init(1, secretKey);
            cipher.doFinal(in, 0, in.length, out, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DESJCEEngine
    implements EncryptionEngine {
        private byte[] desKey = null;
        private Cipher cipher = null;
        private int keySize;

        DESJCEEngine() {
        }

        @Override
        public void init(byte[] key, byte[] iv) throws AsoException {
            this.keySize = key.length;
            this.desKey = key;
            this.cipher = null;
        }

        private void initializeCipher(boolean isEncryptionMode) {
            try {
                DESKeySpec dks = new DESKeySpec(this.desKey);
                SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
                SecretKey secretKey = skf.generateSecret(dks);
                this.cipher = Cipher.getInstance("DES/ECB/NoPadding");
                if (isEncryptionMode) {
                    this.cipher.init(1, secretKey);
                } else {
                    this.cipher.init(2, secretKey);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] decrypt(byte[] ebuf) throws AsoException {
            if (this.cipher == null) {
                this.initializeCipher(false);
            }
            try {
                return this.cipher.doFinal(ebuf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] encrypt(byte[] buffer) throws AsoException {
            if (this.cipher == null) {
                this.initializeCipher(true);
            }
            try {
                return this.cipher.doFinal(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int encrypt(byte[] plainData, int offset, int length, byte[] resultBuffer) throws AsoException {
            throw new RuntimeException("Unsupported Operation");
        }

        @Override
        public int decrypt(byte[] encryptedData, int offset, int length, byte[] resultBuffer) throws AsoException {
            throw new RuntimeException("Unsupported Operation");
        }

        @Override
        public boolean canProcessBulk(int srcLength) {
            return false;
        }

        @Override
        public String getProviderName() {
            if (this.cipher != null) {
                return this.cipher.getProvider().getName();
            }
            return null;
        }

        @Override
        public int getKeySize() {
            return this.keySize;
        }
    }
}

