/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntryKey;

final class ResultSetCacheEntry {
    private final AtomicReference<QueryResultState> queryResultState = new AtomicReference<QueryResultState>(QueryResultState.FETCHING);
    private int numRows = -1;
    private ByteArray rowData = null;
    private AccessorPrototype[] accessorPrototypes = null;
    String userName;
    ResultSetCacheEntryKey key;
    long queryId;
    long sizeInMemory;

    ResultSetCacheEntry(ResultSetCacheEntryKey key, long queryId) {
        assert (queryId != 0L);
        this.key = key;
        this.queryId = queryId;
    }

    ResultSetCacheEntryKey getResultSetCacheEntryKey() {
        return this.key;
    }

    void initialize(int _numRows, ByteArray _rowData, Accessor[] _accessors, long sizeInMemory) throws SQLException {
        assert (this.queryResultState.get() != QueryResultState.VALID) : "queryResultState: " + String.valueOf(this.queryResultState);
        assert (_numRows >= 0) : "_numRows: " + _numRows;
        assert (_rowData != null) : "null _rowData";
        assert (_accessors != null) : "null _accessors";
        if (this.queryResultState.get() == QueryResultState.INVALID) {
            return;
        }
        this.numRows = _numRows;
        this.rowData = _rowData;
        this.accessorPrototypes = new AccessorPrototype[_accessors.length];
        for (int i = 0; i < _accessors.length; ++i) {
            assert (_accessors[i] != null) : "null _accessor: " + i;
            this.accessorPrototypes[i] = _accessors[i].newPrototype(this.numRows);
        }
        this.sizeInMemory = sizeInMemory;
        this.queryResultState.compareAndSet(QueryResultState.FETCHING, QueryResultState.VALID);
    }

    boolean isFetching() {
        return this.queryResultState.get() == QueryResultState.FETCHING;
    }

    boolean isValid() {
        return this.queryResultState.get() == QueryResultState.VALID;
    }

    boolean isInvalid() {
        return this.queryResultState.get() == QueryResultState.INVALID;
    }

    void invalidate() {
        this.queryResultState.set(QueryResultState.INVALID);
    }

    int getNumberOfRows() {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + String.valueOf(this.queryResultState);
        return this.numRows;
    }

    ByteArray getRowData() {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + String.valueOf(this.queryResultState);
        return this.rowData;
    }

    long getQueryId() {
        return this.queryId;
    }

    long getSizeInMemory() {
        return this.sizeInMemory;
    }

    Accessor[] newAccessors(OracleStatement stmt) throws SQLException {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + String.valueOf(this.queryResultState);
        assert (stmt != null) : "null stmt";
        Accessor[] acc = new Accessor[this.accessorPrototypes.length];
        for (int i = 0; i < this.accessorPrototypes.length; ++i) {
            acc[i] = this.accessorPrototypes[i].newAccessor(stmt);
        }
        return acc;
    }

    static enum QueryResultState {
        FETCHING,
        VALID,
        INVALID;

    }
}

