/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import oracle.jdbc.driver.utils.CheckedExceptionHandler;
import oracle.jdbc.driver.utils.ThrowingRunnable;

public interface AutoCloseableAdapter<E extends Exception>
extends AutoCloseable {
    public static <E extends Exception> AutoCloseableAdapter<E> adapt(ThrowingRunnable<E> throwingRunnable) {
        return throwingRunnable::runOrThrow;
    }

    public static <E extends Exception> AutoCloseableAdapter<E> adapt(Iterable<? extends ThrowingRunnable<E>> autoCloseables, Class<E> exceptionClass) {
        return () -> AutoCloseableAdapter.closeAll(autoCloseables, exceptionClass);
    }

    @Override
    public void close() throws E;

    public static <E extends Exception> void closeAll(Iterable<? extends ThrowingRunnable<E>> throwingRunnables, Class<E> exceptionClass) throws E {
        Exception exception = null;
        for (ThrowingRunnable<E> throwingRunnable : throwingRunnables) {
            try {
                throwingRunnable.runOrThrow();
            }
            catch (Exception thrown) {
                if (exception == null) {
                    exception = thrown;
                    continue;
                }
                exception.addSuppressed(thrown);
            }
        }
        if (exception == null) {
            return;
        }
        if (exceptionClass.isInstance(exception)) {
            throw (Exception)exceptionClass.cast(exception);
        }
        throw CheckedExceptionHandler.toRuntimeException(exception);
    }
}

