/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSet12Byte
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter12Byte";
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;

    CharacterSet12Byte(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
    }

    static CharacterSet12Byte getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        if (charConverter.getGroupId() == 1) {
            return new CharacterSet12Byte(oracleId, charConverter);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker walker) throws SQLException {
        int c = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        if (c > 127) {
            if (walker.bytes.length > walker.next) {
                c = c << 8 | walker.bytes[walker.next];
                ++walker.next;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182).fillInStackTrace();
            }
        }
        return c;
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        int bytesToShift = 0;
        int bytesNeeded = 1;
        while (c >> bytesToShift != 0) {
            bytesToShift = (short)(bytesToShift + 8);
            bytesNeeded = (short)(bytesNeeded + 1);
        }
        CharacterSet12Byte.need(buffer, bytesNeeded);
        while (bytesToShift >= 0) {
            buffer.bytes[buffer.next++] = (byte)(c >> bytesToShift & 0xFF);
            bytesToShift = (short)(bytesToShift - 8);
        }
    }
}

