/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleConnectionStringBuilder;

class OracleConnectionStringBuilderImpl
implements OracleConnectionStringBuilder {
    private static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s%s%s)";
    private static final String DESCRIPTION_FORMAT_THIN_STYLE = "jdbc:oracle:thin:@(DESCRIPTION=%s%s%s%s)";
    private static final String ADDRESS_LIST_FORMAT = "(ADDRESS_LIST=(LOAD_BALANCE=%s)%s)";
    private static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s)%s%s)";
    private static final String HTTPS_PROXY_FORMAT = "(HTTPS_PROXY=%s)";
    private static final String HTTPS_PROXY_PORT_FORMAT = "(HTTPS_PROXY_PORT=%s)";
    private static final String WEBSOCKET_URI_FORMAT = "(WEBSOCK_URI=%s)";
    private static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s)";
    private static final String SERVICE_NAME_FORMAT = "(SERVICE_NAME=%s)";
    private static final String SERVER_MODE_FORMAT = "(SERVER=%s)";
    private static final String INSTANCE_NAME_FORMAT = "(INSTANCE_NAME=%s)";
    private static final String SECURITY_FORMAT = "(SECURITY=(SSL_SERVER_DN_MATCH=%s)%s%s)";
    private static final String SERVER_DN_FORMAT = "(SSL_SERVER_CERT_DN=%s)";
    private static final String MY_WALLET_DIR_FORMAT = "(MY_WALLET_DIRECTORY=%s)";
    private static final String EMPTY_STRING = "";
    private static final String KEY_VALUE_FORMAT = "(%s=%s)";
    private List<OracleConnectionStringBuilder.ConnectInfo> addressInfoList = new ArrayList<OracleConnectionStringBuilder.ConnectInfo>();
    private String serviceName;
    private String serverMode;
    private String instanceName;
    private String serverDN;
    private String walletDirectory;
    private int connectTimeout;
    private int transportConnectTimeout;
    private int retryCount;
    private int retryDelay;
    private boolean loadBalance = true;

    OracleConnectionStringBuilderImpl() {
    }

    @Override
    public OracleConnectionStringBuilder addConnectInfo(OracleConnectionStringBuilder.ConnectInfo addressInfo) {
        this.addressInfoList.add(addressInfo);
        return this;
    }

    @Override
    public OracleConnectionStringBuilder addConnectInfo(String host, int port) {
        this.addressInfoList.add(new OracleConnectionStringBuilder.ConnectInfo().host(host).port(port));
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serverMode(String serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serverDN(String serverDN) {
        this.serverDN = serverDN;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder walletDirectory(String walletDirectory) {
        this.walletDirectory = walletDirectory;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder loadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder transportConnectTimeout(int transportConnectTimeout) {
        this.transportConnectTimeout = transportConnectTimeout;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder retryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    @Override
    public String build() throws IllegalStateException {
        this.validateParams();
        return this.buildConnectionString();
    }

    @Override
    public String buildThinStyleURL() throws IllegalStateException {
        return String.format(DESCRIPTION_FORMAT_THIN_STYLE, this.getDescriptionParams(), this.getAddressListInfo(), this.getConnectData(), this.getSecurityInfo());
    }

    private String buildConnectionString() {
        return String.format(DESCRIPTION_FORMAT, this.getDescriptionParams(), this.getAddressListInfo(), this.getConnectData(), this.getSecurityInfo());
    }

    private String getAddressListInfo() {
        if (this.addressInfoList.size() == 1) {
            return this.getAddressInfo(this.addressInfoList.get(0));
        }
        StringBuilder addressListInfo = new StringBuilder();
        for (OracleConnectionStringBuilder.ConnectInfo addrInfo : this.addressInfoList) {
            addressListInfo.append(this.getAddressInfo(addrInfo));
        }
        return String.format(ADDRESS_LIST_FORMAT, this.loadBalance ? "ON" : "OFF", addressListInfo.toString());
    }

    private String getAddressInfo(OracleConnectionStringBuilder.ConnectInfo addressInfo) {
        String proxyInfo = EMPTY_STRING;
        if (addressInfo.getProxyHost() != null && addressInfo.getProxyPort() != -1) {
            proxyInfo = String.format(HTTPS_PROXY_FORMAT, addressInfo.getProxyHost()) + String.format(HTTPS_PROXY_PORT_FORMAT, addressInfo.getProxyPort());
        }
        String webSocketUri = EMPTY_STRING;
        if (addressInfo.getWebSocketURI() != null) {
            webSocketUri = String.format(WEBSOCKET_URI_FORMAT, addressInfo.getWebSocketURI());
        }
        return String.format(ADDRESS_FORMAT, addressInfo.getProtocol(), addressInfo.getDbHostName(), addressInfo.getDbPort(), webSocketUri, proxyInfo);
    }

    private String getConnectData() {
        return String.format(CONNECT_DATA_FORMAT, String.format(SERVICE_NAME_FORMAT, this.serviceName == null ? EMPTY_STRING : this.serviceName), this.serverMode == null ? EMPTY_STRING : String.format(SERVER_MODE_FORMAT, this.serverMode), this.instanceName == null ? EMPTY_STRING : String.format(INSTANCE_NAME_FORMAT, this.instanceName));
    }

    private String getSecurityInfo() {
        if (this.serverDN == null && this.walletDirectory == null) {
            return EMPTY_STRING;
        }
        String serverDNMatch = this.serverDN == null ? "FALSE" : "TRUE";
        return String.format(SECURITY_FORMAT, serverDNMatch, this.serverDN == null ? EMPTY_STRING : String.format(SERVER_DN_FORMAT, this.serverDN), this.walletDirectory == null ? EMPTY_STRING : String.format(MY_WALLET_DIR_FORMAT, this.walletDirectory));
    }

    private String getDescriptionParams() {
        StringBuilder descriptionParamsStr = new StringBuilder();
        if (this.connectTimeout > 0) {
            descriptionParamsStr.append(String.format(KEY_VALUE_FORMAT, "CONNECT_TIMEOUT", this.connectTimeout));
        }
        if (this.transportConnectTimeout > 0) {
            descriptionParamsStr.append(String.format(KEY_VALUE_FORMAT, "TRANSPORT_CONNECT_TIMEOUT", this.transportConnectTimeout));
        }
        if (this.retryCount > 0) {
            descriptionParamsStr.append(String.format(KEY_VALUE_FORMAT, "RETRY_COUNT", this.retryCount));
        }
        if (this.retryDelay > 0) {
            descriptionParamsStr.append(String.format(KEY_VALUE_FORMAT, "RETRY_DELAY", this.retryDelay));
        }
        return descriptionParamsStr.toString();
    }

    private void validateParams() throws IllegalStateException {
        if (this.addressInfoList == null || this.addressInfoList.size() == 0) {
            throw new IllegalStateException("AddressInfo cannot be empty");
        }
        for (OracleConnectionStringBuilder.ConnectInfo addrInfo : this.addressInfoList) {
            addrInfo.validate();
        }
        if (this.serviceName == null) {
            throw new IllegalStateException("ServiceName can not be null");
        }
        if (this.connectTimeout < 0) {
            throw new IllegalStateException("Invalid ConnectTimeout value : " + this.connectTimeout);
        }
        if (this.transportConnectTimeout < 0) {
            throw new IllegalStateException("Invalid TransportConnectTimeout value : " + this.transportConnectTimeout);
        }
        if (this.retryCount < 0) {
            throw new IllegalStateException("Invalid RetryCount value : " + this.retryCount);
        }
        if (this.retryDelay < 0) {
            throw new IllegalStateException("Invalid RetryDelay value : " + this.retryDelay);
        }
    }
}

