/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CompletionStageUtil {
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler handler) {
        try {
            handler.handle();
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T> T handleCompletion(T result, Throwable throwable, CompletionHandler handler) {
        CompletionStageUtil.acceptCompletion(handler);
        if (throwable == null) {
            return result;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler handler) {
        return (r, e) -> CompletionStageUtil.handleCompletion(r, e, handler);
    }

    public static <T, U> U handleNormalCompletion(T result, NormalCompletionHandler<T, U> handler) {
        try {
            return handler.handle(result);
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T, U> U handleNormalCompletion(T result, Throwable throwable, NormalCompletionHandler<T, U> handler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(result, handler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> handler) {
        return r -> CompletionStageUtil.handleNormalCompletion(r, handler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> handledType, ExceptionalCompletionHandler<? super E, ? extends T> handler) {
        if (throwable == null) {
            return null;
        }
        Throwable unwrappedThrowable = CompletionStageUtil.unwrapCompletionException(throwable);
        if (handledType.isInstance(unwrappedThrowable)) {
            try {
                return handler.handle(unwrappedThrowable);
            }
            catch (Exception unhandledException) {
                throw new CompletionException(unhandledException);
            }
        }
        throw new CompletionException(unwrappedThrowable);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> handledType, ExceptionalCompletionHandler<? super E, T> handler) {
        return e -> CompletionStageUtil.handleExceptionalCompletion(e, handledType, handler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T result, NormalCompletionHandler<? super T, U> normalHandler, Throwable throwable, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, ? extends U> errorHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(result, normalHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, handledErrorType, errorHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalHandler, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, U> errorHandler) {
        return (t, e) -> CompletionStageUtil.handleCompletion(t, normalHandler, e, handledErrorType, errorHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T value) {
        return CompletableFuture.completedFuture(value);
    }

    public static <T> CompletionStage<T> failedStage(Throwable failure) {
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(failure);
        return failedFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> callback) {
        CompletionStageUtil.callOnComplete(completionStage, (T nil, Throwable error) -> callback.accept((Throwable)error));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> callback) {
        CompletableFuture<T> future = completionStage.toCompletableFuture();
        if (future.isDone() && !future.isCompletedExceptionally()) {
            callback.accept(future.join(), null);
        } else {
            future.whenComplete((BiConsumer)callback);
        }
    }

    public static <T extends Throwable> T suppress(T throwable, Throwable suppressed) {
        if (suppressed != null) {
            throwable.addSuppressed(suppressed);
        }
        return throwable;
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

