/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dcn;

import java.util.EventObject;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;

public abstract class DatabaseChangeEvent
extends EventObject {
    protected DatabaseChangeEvent(Object source) {
        super(source);
    }

    public abstract EventType getEventType();

    public abstract AdditionalEventType getAdditionalEventType();

    public abstract TableChangeDescription[] getTableChangeDescription();

    public abstract QueryChangeDescription[] getQueryChangeDescription();

    public abstract String getConnectionInformation();

    public abstract String getDatabaseName();

    public abstract int getRegistrationId();

    public abstract long getRegId();

    public abstract byte[] getTransactionId();

    public abstract String getTransactionId(boolean var1);

    @Override
    public abstract String toString();

    public static enum AdditionalEventType {
        NONE(0),
        TIMEOUT(1),
        GROUPING(2);

        private final int code;

        private AdditionalEventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final AdditionalEventType getEventType(int code) {
            if (code == TIMEOUT.getCode()) {
                return TIMEOUT;
            }
            if (code == GROUPING.getCode()) {
                return GROUPING;
            }
            return NONE;
        }
    }

    public static enum EventType {
        NONE(0),
        STARTUP(1),
        SHUTDOWN(2),
        SHUTDOWN_ANY(3),
        DEREG(5),
        OBJCHANGE(6),
        QUERYCHANGE(7);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final EventType getEventType(int code) {
            if (code == STARTUP.getCode()) {
                return STARTUP;
            }
            if (code == SHUTDOWN.getCode()) {
                return SHUTDOWN;
            }
            if (code == SHUTDOWN_ANY.getCode()) {
                return SHUTDOWN_ANY;
            }
            if (code == DEREG.getCode()) {
                return DEREG;
            }
            if (code == OBJCHANGE.getCode()) {
                return OBJCHANGE;
            }
            if (code == QUERYCHANGE.getCode()) {
                return QUERYCHANGE;
            }
            return NONE;
        }
    }
}

