/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    OracleClob clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;

    public OracleClobOutputStream(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
    }

    public OracleClobOutputStream(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
    }

    public OracleClobOutputStream(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
    }

    public OracleClobOutputStream(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        if (clob == null || bufferSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException();
        }
        this.clob = clob;
        this.lobOffset = beginOffset;
        PhysicalConnection pConnection = (PhysicalConnection)clob.getInternalConnection();
        try (Monitor.CloseableLock lock = pConnection.acquireCloseableLock();){
            this.buf = pConnection.getByteBuffer(bufferSize);
        }
        this.count = 0;
        this.bufSize = bufferSize;
        this.isClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (this.count >= this.bufSize) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        int start = off;
        int lengthToWrite = Math.min(len, b.length - off);
        if (lengthToWrite >= 2 * this.bufSize) {
            if (this.count > 0) {
                this.flushBuffer();
            }
            try {
                char[] charArr = new char[lengthToWrite];
                for (int i = 0; i < lengthToWrite; ++i) {
                    charArr[i] = (char)b[i + off];
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
            return;
        }
        int end = start + lengthToWrite;
        while (start < end) {
            int bytesWritten = Math.min(this.bufSize - this.count, end - start);
            System.arraycopy(b, start, this.buf, this.count, bytesWritten);
            start += bytesWritten;
            this.count += bytesWritten;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.flushBuffer();
            return;
        }
        finally {
            try {
                PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                try (Monitor.CloseableLock lock = pConnection.acquireCloseableLock();){
                    if (this.buf != null) {
                        pConnection.cacheBuffer(this.buf);
                        this.buf = null;
                    }
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                char[] charArr = new char[this.count];
                for (int i = 0; i < this.count; ++i) {
                    charArr[i] = (char)this.buf[i];
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
                this.count = 0;
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exc) {
            return null;
        }
    }
}

