/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolMBeanBase;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.diagnostics.DiagnosticsCollector;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionPool;

public class PoolMBeans {
    static final String CLASS_NAME = PoolMBeans.class.getName();
    private static final DiagnosticsCollector diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private static volatile Map<String, UniversalConnectionPoolMBean> map = new HashMap<String, UniversalConnectionPoolMBean>();
    private static final UniversalConnectionPoolManagerMBean managerBean = PoolMBeans.getManagerMBean();
    private static final UniversalConnectionPoolManager manager = PoolMBeans.getManager();
    private static final ReentrantLock lock = new ReentrantLock(false);

    private static UniversalConnectionPoolManagerMBean getManagerMBean() {
        try {
            return UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
        }
        catch (Throwable e) {
            diagnosticsCollector.trace(Level.SEVERE, CLASS_NAME, "<clinit>", "failed to start pool manager and pool MBean manager", null, null, new Object[0]);
            return null;
        }
    }

    private static UniversalConnectionPoolManager getManager() {
        try {
            return UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(diagnosticsCollector);
        }
        catch (Throwable e) {
            diagnosticsCollector.trace(Level.SEVERE, CLASS_NAME, "<clinit>", "failed to start pool manager and pool MBean manager", null, null, new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniversalConnectionPoolMBean getOrCreateBean(UniversalConnectionPool pool) {
        UniversalConnectionPoolMBean bean;
        block6: {
            Objects.requireNonNull(pool);
            String poolName = pool.getName();
            Objects.requireNonNull(poolName);
            bean = map.get(poolName);
            if (null == bean) {
                Function<String, UniversalConnectionPoolMBean> mappingFunction = p -> {
                    UniversalConnectionPoolMBeanBase newBean = null;
                    try {
                        newBean = pool instanceof JDBCConnectionPool ? new JDBCUniversalConnectionPoolMBeanImpl(pool) : new UniversalConnectionPoolMBeanBase(pool);
                    }
                    catch (UniversalConnectionPoolException e) {
                        diagnosticsCollector.trace(Level.SEVERE, CLASS_NAME, "getOrCreateBean", "unable to start pool MBean", null, null, new Object[0]);
                    }
                    try {
                        Objects.requireNonNull(newBean);
                        managerBean.registerUniversalConnectionPoolMBean(newBean);
                    }
                    catch (UniversalConnectionPoolException e) {
                        diagnosticsCollector.trace(Level.WARNING, CLASS_NAME, "getOrCreateBean", "unable to register pool MBean", null, null, new Object[0]);
                    }
                    return newBean;
                };
                try {
                    lock.lock();
                    bean = map.get(poolName);
                    if (null != bean) break block6;
                    try {
                        manager.setConnectionPool(pool);
                    }
                    catch (UniversalConnectionPoolException e) {
                        diagnosticsCollector.trace(Level.WARNING, CLASS_NAME, "getOrCreateBean", "unable to set pool", null, null, new Object[0]);
                    }
                    HashMap<String, UniversalConnectionPoolMBean> newMap = new HashMap<String, UniversalConnectionPoolMBean>(map);
                    bean = newMap.computeIfAbsent(poolName, mappingFunction);
                    map = newMap;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return bean;
    }

    public static void destroyBean(String poolName) {
        HashMap<String, UniversalConnectionPoolMBean> newMap = new HashMap<String, UniversalConnectionPoolMBean>(map);
        newMap.remove(poolName);
        map = newMap;
        try {
            managerBean.unregisterUniversalConnectionPoolMBean(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            diagnosticsCollector.trace(Level.WARNING, CLASS_NAME, "destroyBean", "unable to unregister pool MBean", null, null, new Object[0]);
        }
    }
}

