/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import oracle.ucp.proxy.HashUtil;

class MethodSignature {
    private final String name;
    private final Class<?>[] parameterTypes;
    private final int hashCode;

    MethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    MethodSignature(String name, Class<?>[] parameterTypes) {
        this.name = Objects.requireNonNull(name);
        this.parameterTypes = Objects.requireNonNull(parameterTypes);
        this.hashCode = HashUtil.hash(HashUtil.hash((int)new Integer(23), name), parameterTypes);
    }

    public boolean equals(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature that = (MethodSignature)obj;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Arrays.deepEquals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name + Arrays.toString(this.parameterTypes);
    }

    String getName() {
        return this.name;
    }

    Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }
}

