/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.jdbc.AccessToken;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.jdbc.ConnectionConnectionPool;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DatasourceConfigManager;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.JDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.other.OtherConnectionProxyFactory;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Log;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PoolDataSourceImpl
implements PoolDataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    private static final long serialVersionUID = 4343640747507L;
    static final String loggerName = "oracle.ucp.jdbc";
    private static final Logger logger;
    public static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    public static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    public static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
    public static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    public static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    private static final String AC_POOL_NAME = "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool";
    private static final String AC_PROXY_CLASS_NAME_KEYWORD = "replay";
    private final AtomicBoolean fcfExplicitlySet = new AtomicBoolean(false);
    private final List<AutoProperty<?>> autoProperties = new ArrayList();
    private String username = null;
    private OpaqueString password = OpaqueString.NULL;
    private String url = null;
    private String serverName = null;
    private int portNumber = 0;
    private String databaseName = null;
    private String serviceName = null;
    private Properties pdbRoles = null;
    private SSLContext sslContext = null;
    private AtomicBoolean isXmlUsed = new AtomicBoolean(false);
    private boolean disableAPI = false;
    private AtomicBoolean isConfigureNewDS = new AtomicBoolean(false);
    volatile transient JDBCConnectionPool connectionPool = null;
    private String roleName = null;
    private final Properties connectionProperties = new Properties();
    private final Properties connectionFactoryProperties = new Properties();
    String connectionFactoryClassName = "";
    private AtomicBoolean connectionPoolFactoryClassNameWasSet = new AtomicBoolean(false);
    private boolean isDriverFactory = false;
    private AtomicReference<String> connectionPoolName = new AtomicReference();
    Object connectionFactory = null;
    private Boolean acActive = null;
    private transient AtomicBoolean poolCreated = new AtomicBoolean(false);
    private transient AtomicBoolean poolStarted = new AtomicBoolean(false);
    private String onsConfiguration = null;
    private transient UniversalConnectionPoolManager manager = null;
    private Supplier<? extends AccessToken> tokenSupplier;
    private final AutoProperty<String> dataSourceName = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 52;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "dataSourceName", p, true, true);
    });
    private final AutoProperty<String> dataSourceDescription = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 53;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "description", p, true, true);
    });
    private final AutoProperty<String> networkProtocol = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 54;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "networkProtocol", p, true, true);
    });
    private final AutoProperty<Boolean> validateConnectionOnBorrow = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setValidateConnectionOnBorrow((boolean)p);
    }, ap -> this.connectionPool.getValidateConnectionOnBorrow());
    private final AutoProperty<String> sqlForValidateConnection = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setSQLForValidateConnection((String)p);
    }, ap -> this.connectionPool.getSQLForValidateConnection());
    private final AutoProperty<Integer> initialPoolSize = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setInitialPoolSize((int)p);
    }, ap -> this.connectionPool.getInitialPoolSize());
    private final AutoProperty<Integer> minPoolSize = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 2;
        this.connectionPool.setMinPoolSize((int)p);
    }, ap -> this.connectionPool.getMinPoolSize());
    private final AutoProperty<Integer> maxPoolSize = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 3;
        this.connectionPool.setMaxPoolSize((int)p);
    }, ap -> this.connectionPool.getMaxPoolSize());
    private final AutoProperty<Integer> maxConnectionsPerService = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 77;
        this.connectionPool.setMaxConnectionsPerService((int)p);
    }, ap -> this.connectionPool.getMaxConnectionsPerService());
    private final AutoProperty<Integer> abandonedConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 7;
        this.connectionPool.setAbandonedConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getAbandonedConnectionTimeout());
    private final AutoProperty<Integer> timeToLiveConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setTimeToLiveConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getTimeToLiveConnectionTimeout());
    private final AutoProperty<Integer> inactiveConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 4;
        this.connectionPool.setInactiveConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getInactiveConnectionTimeout());
    private final AutoProperty<Integer> timeoutCheckInterval = this.newAutoProperty(30, (ap, p) -> {
        ap.errcode = 8;
        this.connectionPool.setTimeoutCheckInterval((int)p);
    }, ap -> this.connectionPool.getTimeoutCheckInterval());
    private final AutoProperty<Integer> maxStatements = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 10;
        this.connectionPool.setMaxStatements((int)p);
    }, ap -> this.connectionPool.getMaxStatements(), p -> p >= 0);
    private final AutoProperty<Integer> connectionWaitTimeout = this.newAutoProperty(3, (ap, p) -> {
        ap.errcode = 5;
        this.connectionPool.setConnectionWaitTimeout((int)p);
    }, ap -> this.connectionPool.getConnectionWaitTimeout());
    private final AutoProperty<Long> maxConnectionReuseTime = this.newAutoProperty(0L, (ap, p) -> {
        ap.errcode = 56;
        this.connectionPool.setMaxConnectionReuseTime((long)p);
    }, ap -> this.connectionPool.getMaxConnectionReuseTime());
    private final AutoProperty<Integer> maxConnectionReuseCount = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 57;
        this.connectionPool.setMaxConnectionReuseCount((int)p);
    }, ap -> this.connectionPool.getMaxConnectionReuseCount());
    private final AutoProperty<oracle.ucp.ConnectionLabelingCallback> connectionLabelingCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 18;
            this.ilogFinest(null, null, null, null, "registering labeling callback");
            this.connectionPool.registerConnectionLabelingCallback((oracle.ucp.ConnectionLabelingCallback)p);
        } else {
            ap.errcode = 19;
            this.ilogFinest(null, null, null, null, "removing labeling callback");
            this.connectionPool.removeConnectionLabelingCallback();
        }
    }, ap -> {
        oracle.ucp.ConnectionLabelingCallback cbk;
        oracle.ucp.ConnectionLabelingCallback connectionLabelingCallback = cbk = null != this.connectionPool ? this.connectionPool.getConnectionLabelingCallback() : (oracle.ucp.ConnectionLabelingCallback)ap.value;
        if (logger.getLevel() == Level.FINEST) {
            this.ilogFinest(null, null, null, null, "obtained labeling callback " + cbk);
        }
        return cbk;
    });
    private final AutoProperty<ConnectionAffinityCallback> connectionAffinityCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 20;
            this.ilogFinest(null, null, null, null, "registering affinity callback");
            this.connectionPool.registerConnectionAffinityCallback((ConnectionAffinityCallback)p);
        } else {
            ap.errcode = 21;
            this.ilogFinest(null, null, null, null, "removing affinity callback");
            this.connectionPool.removeConnectionAffinityCallback();
        }
    }, ap -> {
        ConnectionAffinityCallback cbk = null != this.connectionPool ? this.connectionPool.getConnectionAffinityCallback() : (ConnectionAffinityCallback)ap.value;
        this.ilogFinest(null, null, null, null, "obtained affinity callback " + cbk);
        return cbk;
    });
    private final AutoProperty<Integer> connectionHarvestTriggerCount = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 12;
        this.connectionPool.setConnectionHarvestTriggerCount((int)p);
    }, ap -> this.connectionPool.getConnectionHarvestTriggerCount());
    private final AutoProperty<Integer> connectionHarvestMaxCount = this.newAutoProperty(1, (ap, p) -> {
        ap.errcode = 13;
        this.connectionPool.setConnectionHarvestMaxCount((int)p);
    }, ap -> this.connectionPool.getConnectionHarvestMaxCount());
    private final AutoProperty<Integer> queryTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setQueryTimeout((int)p);
    }, ap -> this.connectionPool.getQueryTimeout());
    private final AutoProperty<Integer> maxConnectionsPerShard = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setMaxConnectionsPerShard((Integer)p);
    }, ap -> this.connectionPool.getMaxConnectionsPerShard());
    private final AutoProperty<Boolean> shardingMode = this.newAutoProperty(true, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setShardingMode((boolean)p);
    }, ap -> this.connectionPool.getShardingMode());
    private final AutoProperty<Boolean> fastConnectionFailoverEnabled = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 9;
        if (this.fcfExplicitlySet.get() || ap.get() != p) {
            this.connectionPool.setFailoverEnabled((boolean)p);
        } else {
            this.ilogFine(null, null, null, null, "FCF-Enabled not explicitly set, skip internal setting to: " + p);
        }
    }, ap -> this.connectionPool.isFailoverEnabled());
    private final AutoProperty<ConnectionInitializationCallback> connectionInitializationCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 60;
            this.ilogFinest(null, null, null, null, "registering initialization callback");
            this.connectionPool.registerConnectionInitializationCallback((ConnectionInitializationCallback)p);
        } else {
            ap.errcode = 61;
            this.ilogFinest(null, null, null, null, "removing initialization callback");
            this.connectionPool.unregisterConnectionInitializationCallback();
        }
    }, ap -> this.connectionPool.getConnectionInitializationCallback());
    private final AutoProperty<Integer> connectionLabelingHighCost = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 63;
        this.connectionPool.setConnectionLabelingHighCost((int)p);
    }, ap -> this.connectionPool.getConnectionLabelingHighCost());
    private final AutoProperty<Integer> highCostConnectionReuseThreshold = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 64;
        this.connectionPool.setHighCostConnectionReuseThreshold((int)p);
    }, ap -> this.connectionPool.getHighCostConnectionReuseThreshold());
    private final AutoProperty<Boolean> isPoolShareable = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setShareable((boolean)p);
    }, ap -> this.connectionPool.isShareable());
    private final AutoProperty<Integer> repurposeThreshold = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setConnectionRepurposeThreshold((Integer)p);
    }, ap -> this.connectionPool.getConnectionRepurposeThreshold());
    private final AutoProperty<Integer> secondsToTrustIdleConnection = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 68;
        this.connectionPool.setSecondsToTrustIdleConnection((int)p);
    }, ap -> this.connectionPool.getSecondsToTrustIdleConnection());
    private final AutoProperty<Integer> loginTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setLoginTimeout((int)p);
        PoolDataSourceImpl.setProperty(this.connectionFactory, "loginTimeout", this.getLoginTimeout(), true, true);
        if (this.connectionFactory instanceof Driver) {
            this.connectionFactoryProperties.setProperty("oracle.net.CONNECT_TIMEOUT", new Integer(this.getLoginTimeout()).toString());
        }
    }, ap -> this.connectionPool.getLoginTimeout());
    private final AutoProperty<Integer> connectionValidationTimeout = this.newAutoProperty(15, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setConnectionValidationTimeout((int)p);
    }, ap -> this.connectionPool.getConnectionValidationTimeout());
    private final AutoProperty<Boolean> readOnlyInstanceAllowed = this.newAutoProperty(false, (ap, p) -> this.connectionPool.setReadOnlyInstanceAllowed((boolean)p), ap -> this.connectionPool.isReadOnlyInstanceAllowed());
    private transient UniversalConnectionPoolManagerMBean managerMBean = null;
    private static final String UCP_IS_XML_USED_FOR_POOL_CONFIGURATION = "isXmlUsed";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;
    private static Executable $$$methodRef$$$147;
    private static Logger $$$loggerRef$$$147;
    private static Executable $$$methodRef$$$148;
    private static Logger $$$loggerRef$$$148;
    private static Executable $$$methodRef$$$149;
    private static Logger $$$loggerRef$$$149;
    private static Executable $$$methodRef$$$150;
    private static Logger $$$loggerRef$$$150;
    private static Executable $$$methodRef$$$151;
    private static Logger $$$loggerRef$$$151;
    private static Executable $$$methodRef$$$152;
    private static Logger $$$loggerRef$$$152;
    private static Executable $$$methodRef$$$153;
    private static Logger $$$loggerRef$$$153;
    private static Executable $$$methodRef$$$154;
    private static Logger $$$loggerRef$$$154;
    private static Executable $$$methodRef$$$155;
    private static Logger $$$loggerRef$$$155;
    private static Executable $$$methodRef$$$156;
    private static Logger $$$loggerRef$$$156;
    private static Executable $$$methodRef$$$157;
    private static Logger $$$loggerRef$$$157;
    private static Executable $$$methodRef$$$158;
    private static Logger $$$loggerRef$$$158;
    private static Executable $$$methodRef$$$159;
    private static Logger $$$loggerRef$$$159;
    private static Executable $$$methodRef$$$160;
    private static Logger $$$loggerRef$$$160;
    private static Executable $$$methodRef$$$161;
    private static Logger $$$loggerRef$$$161;
    private static Executable $$$methodRef$$$162;
    private static Logger $$$loggerRef$$$162;
    private static Executable $$$methodRef$$$163;
    private static Logger $$$loggerRef$$$163;
    private static Executable $$$methodRef$$$164;
    private static Logger $$$loggerRef$$$164;
    private static Executable $$$methodRef$$$165;
    private static Logger $$$loggerRef$$$165;
    private static Executable $$$methodRef$$$166;
    private static Logger $$$loggerRef$$$166;
    private static Executable $$$methodRef$$$167;
    private static Logger $$$loggerRef$$$167;
    private static Executable $$$methodRef$$$168;
    private static Logger $$$loggerRef$$$168;
    private static Executable $$$methodRef$$$169;
    private static Logger $$$loggerRef$$$169;
    private static Executable $$$methodRef$$$170;
    private static Logger $$$loggerRef$$$170;
    private static Executable $$$methodRef$$$171;
    private static Logger $$$loggerRef$$$171;
    private static Executable $$$methodRef$$$172;
    private static Logger $$$loggerRef$$$172;
    private static Executable $$$methodRef$$$173;
    private static Logger $$$loggerRef$$$173;
    private static Executable $$$methodRef$$$174;
    private static Logger $$$loggerRef$$$174;
    private static Executable $$$methodRef$$$175;
    private static Logger $$$loggerRef$$$175;
    private static Executable $$$methodRef$$$176;
    private static Logger $$$loggerRef$$$176;
    private static Executable $$$methodRef$$$177;
    private static Logger $$$loggerRef$$$177;
    private static Executable $$$methodRef$$$178;
    private static Logger $$$loggerRef$$$178;
    private static Executable $$$methodRef$$$179;
    private static Logger $$$loggerRef$$$179;
    private static Executable $$$methodRef$$$180;
    private static Logger $$$loggerRef$$$180;
    private static Executable $$$methodRef$$$181;
    private static Logger $$$loggerRef$$$181;
    private static Executable $$$methodRef$$$182;
    private static Logger $$$loggerRef$$$182;
    private static Executable $$$methodRef$$$183;
    private static Logger $$$loggerRef$$$183;
    private static Executable $$$methodRef$$$184;
    private static Logger $$$loggerRef$$$184;
    private static Executable $$$methodRef$$$185;
    private static Logger $$$loggerRef$$$185;
    private static Executable $$$methodRef$$$186;
    private static Logger $$$loggerRef$$$186;
    private static Executable $$$methodRef$$$187;
    private static Logger $$$loggerRef$$$187;
    private static Executable $$$methodRef$$$188;
    private static Logger $$$loggerRef$$$188;
    private static Executable $$$methodRef$$$189;
    private static Logger $$$loggerRef$$$189;
    private static Executable $$$methodRef$$$190;
    private static Logger $$$loggerRef$$$190;
    private static Executable $$$methodRef$$$191;
    private static Logger $$$loggerRef$$$191;
    private static Executable $$$methodRef$$$192;
    private static Logger $$$loggerRef$$$192;
    private static Executable $$$methodRef$$$193;
    private static Logger $$$loggerRef$$$193;
    private static Executable $$$methodRef$$$194;
    private static Logger $$$loggerRef$$$194;
    private static Executable $$$methodRef$$$195;
    private static Logger $$$loggerRef$$$195;
    private static Executable $$$methodRef$$$196;
    private static Logger $$$loggerRef$$$196;
    private static Executable $$$methodRef$$$197;
    private static Logger $$$loggerRef$$$197;
    private static Executable $$$methodRef$$$198;
    private static Logger $$$loggerRef$$$198;
    private static Executable $$$methodRef$$$199;
    private static Logger $$$loggerRef$$$199;
    private static Executable $$$methodRef$$$200;
    private static Logger $$$loggerRef$$$200;
    private static Executable $$$methodRef$$$201;
    private static Logger $$$loggerRef$$$201;
    private static Executable $$$methodRef$$$202;
    private static Logger $$$loggerRef$$$202;
    private static Executable $$$methodRef$$$203;
    private static Logger $$$loggerRef$$$203;
    private static Executable $$$methodRef$$$204;
    private static Logger $$$loggerRef$$$204;
    private static Executable $$$methodRef$$$205;
    private static Logger $$$loggerRef$$$205;
    private static Executable $$$methodRef$$$206;
    private static Logger $$$loggerRef$$$206;
    private static Executable $$$methodRef$$$207;
    private static Logger $$$loggerRef$$$207;
    private static Executable $$$methodRef$$$208;
    private static Logger $$$loggerRef$$$208;
    private static Executable $$$methodRef$$$209;
    private static Logger $$$loggerRef$$$209;
    private static Executable $$$methodRef$$$210;
    private static Logger $$$loggerRef$$$210;
    private static Executable $$$methodRef$$$211;
    private static Logger $$$loggerRef$$$211;
    private static Executable $$$methodRef$$$212;
    private static Logger $$$loggerRef$$$212;
    private static Executable $$$methodRef$$$213;
    private static Logger $$$loggerRef$$$213;
    private static Executable $$$methodRef$$$214;
    private static Logger $$$loggerRef$$$214;
    private static Executable $$$methodRef$$$215;
    private static Logger $$$loggerRef$$$215;
    private static Executable $$$methodRef$$$216;
    private static Logger $$$loggerRef$$$216;
    private static Executable $$$methodRef$$$217;
    private static Logger $$$loggerRef$$$217;
    private static Executable $$$methodRef$$$218;
    private static Logger $$$loggerRef$$$218;
    private static Executable $$$methodRef$$$219;
    private static Logger $$$loggerRef$$$219;
    private static Executable $$$methodRef$$$220;
    private static Logger $$$loggerRef$$$220;
    private static Executable $$$methodRef$$$221;
    private static Logger $$$loggerRef$$$221;
    private static Executable $$$methodRef$$$222;
    private static Logger $$$loggerRef$$$222;
    private static Executable $$$methodRef$$$223;
    private static Logger $$$loggerRef$$$223;
    private static Executable $$$methodRef$$$224;
    private static Logger $$$loggerRef$$$224;
    private static Executable $$$methodRef$$$225;
    private static Logger $$$loggerRef$$$225;
    private static Executable $$$methodRef$$$226;
    private static Logger $$$loggerRef$$$226;
    private static Executable $$$methodRef$$$227;
    private static Logger $$$loggerRef$$$227;
    private static Executable $$$methodRef$$$228;
    private static Logger $$$loggerRef$$$228;
    private static Executable $$$methodRef$$$229;
    private static Logger $$$loggerRef$$$229;
    private static Executable $$$methodRef$$$230;
    private static Logger $$$loggerRef$$$230;

    @DisableTrace
    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter, AutoPropertyValidator<T> validator) {
        return new AutoProperty<T>(value, setter, getter, validator);
    }

    @DisableTrace
    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter) {
        return new AutoProperty<Object>(value, setter, getter, p -> true);
    }

    @DisableTrace
    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter) {
        return new AutoProperty<Object>(value, setter, ap -> ap.value, p -> true);
    }

    void setConfigureNewDataSource(boolean isNewDatasource) {
        this.isConfigureNewDS.set(isNewDatasource);
    }

    private UniversalConnectionPoolManager getManager() {
        if (null != this.manager) {
            return this.manager;
        }
        try {
            this.manager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        }
        catch (UniversalConnectionPoolException e) {
            this.ilogThrowing(null, null, null, null, e);
            this.ilogSevere(null, null, null, null, "\"pool manager was not initialized\"");
        }
        return this.manager;
    }

    private UniversalConnectionPoolManagerMBean getManagerMBean() {
        if (null != this.managerMBean) {
            return this.managerMBean;
        }
        try {
            this.managerMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
        }
        catch (UniversalConnectionPoolException e) {
            this.ilogThrowing(null, null, null, null, e);
            this.ilogSevere(null, null, null, null, "pool manager MBean was not initialized");
        }
        return this.managerMBean;
    }

    public PoolDataSourceImpl() {
    }

    PoolDataSourceImpl(String poolName, String dsName, Map<String, Object> config) throws UniversalConnectionPoolException, Exception {
        this();
        this.createSharedPoolFromXml(poolName, dsName, config);
    }

    public void startPool() throws SQLException {
        this.startPool(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPool(boolean keepMetadataConn) throws SQLException {
        AtomicBoolean atomicBoolean = this.poolStarted;
        synchronized (atomicBoolean) {
            if (this.connectionPool != null && this.connectionPool.isShareable()) {
                return;
            }
            if (!this.poolStarted.get()) {
                try {
                    if (this.connectionPool == null) {
                        this.createPool();
                    }
                    if (this.connectionPool.isLifecycleStopped() || this.connectionPool.isLifecycleFailed()) {
                        this.connectionPool.start(keepMetadataConn);
                    }
                    this.ilogFine(null, null, null, null, "connection pool is started");
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(0, e);
                }
                this.poolStarted.set(true);
            }
        }
    }

    protected void createPoolWithDefaultProperties() throws SQLException {
        try {
            if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.startsWith("oracle.jdbc")) {
                if (!this.isDriverFactory) {
                    if (!this.connectionFactoryClassName.startsWith("oracle.jdbc.replay") && !this.connectionFactoryClassName.startsWith("oracle.jdbc.datasource.impl")) {
                        OracleDataSourceConnectionFactoryAdapter ocfa = new OracleDataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory);
                        this.connectionPool = new OracleConnectionConnectionPool(ocfa);
                        ocfa.setUniversalConnectionPool(this.connectionPool);
                    } else {
                        ReplayDataSourceConnectionFactoryAdapter ocfa = new ReplayDataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory);
                        try {
                            Class<?> cls = Class.forName(AC_POOL_NAME);
                            this.ilogFinest(null, null, null, null, "OracleReplayableConnectionConnectionPool loaded");
                            Constructor<?> c = cls.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
                            this.ilogFinest(null, null, null, null, "OracleReplayableConnectionConnectionPool constructor found");
                            this.connectionPool = (JDBCConnectionPool)c.newInstance(ocfa);
                            this.ilogFinest(null, null, null, null, "OracleReplayableConnectionConnectionPool instantiated");
                            ocfa.setUniversalConnectionPool(this.connectionPool);
                        }
                        catch (Throwable t) {
                            UCPErrorHandler.throwSQLException(1, t);
                        }
                    }
                } else {
                    OracleDriverConnectionFactoryAdapter odcfa = new OracleDriverConnectionFactoryAdapter((Driver)this.connectionFactory, this.url, this.connectionFactoryProperties, this.connectionProperties);
                    this.connectionPool = new OracleConnectionConnectionPool(odcfa);
                    odcfa.setUniversalConnectionPool(this.connectionPool);
                }
                this.connectionPool.setOraclePool(true);
            } else {
                if (!this.isDriverFactory) {
                    DataSourceConnectionFactoryAdapter cfa = new DataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory);
                    this.connectionPool = new ConnectionConnectionPool(cfa){
                        private final ConnectionProxyFactory cpf;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.cpf = new OtherConnectionProxyFactory();
                        }

                        @Override
                        protected ConnectionProxyFactory getProxyFactory() {
                            return this.cpf;
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(PoolDataSourceImpl.class, JDBCConnectionFactoryAdapter.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getProxyFactory", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    };
                    cfa.setUniversalConnectionPool(this.connectionPool);
                } else {
                    DriverConnectionFactoryAdapter dcfa = new DriverConnectionFactoryAdapter((Driver)this.connectionFactory, this.url, this.connectionFactoryProperties, this.connectionProperties);
                    this.connectionPool = new ConnectionConnectionPool(dcfa){
                        private final ConnectionProxyFactory cpf;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.cpf = new OtherConnectionProxyFactory();
                        }

                        @Override
                        protected ConnectionProxyFactory getProxyFactory() {
                            return this.cpf;
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 2.class.getDeclaredConstructor(PoolDataSourceImpl.class, JDBCConnectionFactoryAdapter.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 2.class.getDeclaredMethod("getProxyFactory", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    };
                    dcfa.setUniversalConnectionPool(this.connectionPool);
                }
                this.connectionPool.setOraclePool(false);
            }
            assert (this.connectionPool != null);
            this.connectionPool.setConnectionFactory(this.connectionFactory);
            this.ilogFine(null, null, null, null, "Connection pool instance is created with default properties");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(1, e);
        }
    }

    private void useExistingPool() throws UniversalConnectionPoolException {
        this.connectionPool = (JDBCConnectionPool)this.getManager().getConnectionPool(this.connectionPoolName.get());
        this.connectionFactory = this.connectionPool.getConnectionFactory();
        this.poolCreated.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniversalConnectionPool createUniversalConnectionPool() throws SQLException {
        AtomicBoolean atomicBoolean = this.poolStarted;
        synchronized (atomicBoolean) {
            try {
                if (!this.poolCreated.get()) {
                    boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(this.connectionPoolName.get());
                    if (poolExists) {
                        if (Util.isDestroyOnReloadEnabled()) {
                            if (this.getManager().isJmxEnabled()) {
                                this.getManagerMBean().destroyConnectionPool(this.connectionPoolName.get());
                            } else {
                                this.getManager().destroyConnectionPool(this.connectionPoolName.get());
                            }
                        } else {
                            UCPErrorHandler.throwUniversalConnectionPoolException(350);
                        }
                    }
                    if (this.connectionPool == null) {
                        this.initConnectionFactory();
                        this.createPoolWithDefaultProperties();
                        assert (this.connectionPool != null);
                        String poolName = this.connectionPoolName.get();
                        if (poolName != null && !poolName.equals("")) {
                            this.connectionPool.setName(poolName);
                        }
                        this.poolCreated.set(true);
                        for (AutoProperty<?> param : this.autoProperties) {
                            param.set();
                        }
                        if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.startsWith("oracle.jdbc")) {
                            ((OracleJDBCConnectionPool)this.connectionPool).setONSConfiguration(this.onsConfiguration);
                        }
                        if (this.connectionFactoryClassName != null) {
                            try {
                                boolean needToRemoveConnectionClass = false;
                                boolean needToRemoveConnectionPurity = false;
                                if (!this.connectionProperties.containsKey("oracle.jdbc.DRCPConnectionClass")) {
                                    if (this.connectionPoolName != null) {
                                        if (this.connectionPoolName.get() != null) {
                                            this.connectionProperties.put("oracle.jdbc.DRCPConnectionClass", this.connectionPoolName.get());
                                        }
                                    } else {
                                        this.connectionProperties.put("oracle.jdbc.DRCPConnectionClass", this.connectionPool.getName());
                                    }
                                    needToRemoveConnectionClass = true;
                                }
                                if (!this.connectionProperties.containsKey("oracle.jdbc.DRCPConnectionPurity")) {
                                    this.connectionProperties.put("oracle.jdbc.DRCPConnectionPurity", "SELF");
                                    needToRemoveConnectionPurity = true;
                                }
                                PoolDataSourceImpl.setProperty(this.connectionFactory, "connectionProperties", this.connectionProperties, true, true);
                                if (needToRemoveConnectionClass) {
                                    this.connectionProperties.remove("oracle.jdbc.DRCPConnectionClass");
                                }
                                if (needToRemoveConnectionPurity) {
                                    this.connectionProperties.remove("oracle.jdbc.DRCPConnectionPurity");
                                }
                                this.ilogFinest(null, null, null, null, "Connection properties are set");
                            }
                            catch (Exception e) {
                                UCPErrorHandler.throwSQLException(48, e);
                            }
                        }
                        this.ilogFinest(null, null, null, null, "connection pool is configured");
                        assert (this.connectionPool != null);
                        this.connectionPool.setConnectionRetrievalInfo(JDBCConnectionRetrievalInfo.createBuilder().user(this.username).password(this.password).pdbRoles(this.pdbRoles).sslContext(this.sslContext).readOnlyInstanceAllowed(this.readOnlyInstanceAllowed.get()).build());
                    }
                }
                if (UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager().isJmxEnabled()) {
                    this.getManagerMBean();
                    this.createUniversalConnectionPoolMBean();
                }
            }
            catch (Exception exc) {
                this.connectionPool = null;
                UCPErrorHandler.throwSQLException(22, exc);
            }
        }
        return this.connectionPool;
    }

    private void createSharedPoolFromXml(String poolName, String dataSourceName, Map<String, Object> poolPropertiesMap) throws Exception {
        this.isXmlUsed.set(true);
        this.applyPoolProperties(poolPropertiesMap);
        this.setDataSourceName(dataSourceName);
        this.applyDataSourcProperties(poolPropertiesMap);
        this.setConnectionPoolName(poolName);
        if (Boolean.parseBoolean((String)poolPropertiesMap.get("shared"))) {
            boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(poolName);
            if (poolExists) {
                if (this.getManager().getConnectionPool(poolName).isShareable()) {
                    this.useExistingPool();
                } else if (Util.isDestroyOnReloadEnabled()) {
                    if (this.getManager().isJmxEnabled()) {
                        this.getManagerMBean().destroyConnectionPool(poolName);
                    } else {
                        this.getManager().destroyConnectionPool(poolName);
                    }
                    this.startPool();
                } else {
                    UCPErrorHandler.throwUniversalConnectionPoolException(350);
                }
            } else {
                this.startPool();
            }
            this.disableAPI = true;
        }
    }

    private void createPool() throws UniversalConnectionPoolException {
        if (this.getManager().isJmxEnabled()) {
            this.getManagerMBean().createConnectionPool(this);
        } else {
            this.getManager().createConnectionPool(this);
        }
        this.ilogFine(null, null, null, null, "Connection pool instance is created");
    }

    private boolean allowSetter() {
        boolean allowedSetter;
        boolean bl = allowedSetter = !this.disableAPI;
        if (!allowedSetter) {
            this.ilogWarning(null, null, null, null, "setters are blocked, use reconfiguration APIs to modify pool/datasource properties.");
        }
        return allowedSetter;
    }

    private void applyDataSourcProperties(Map<? extends String, ? extends Object> poolPropertiesMap) throws UniversalConnectionPoolException, Exception {
        String dataSourceName = this.dataSourceName.get();
        HashMap selectedDatasourceMap = new HashMap();
        String datasourceTag = "data-source-" + dataSourceName;
        if (poolPropertiesMap.containsKey(datasourceTag)) {
            selectedDatasourceMap.putAll((Map)poolPropertiesMap.get(datasourceTag));
        }
        try {
            if (selectedDatasourceMap.containsKey("service")) {
                this.setServiceName((String)selectedDatasourceMap.get("service"));
            }
            if (selectedDatasourceMap.containsKey("pdb-role")) {
                this.setPdbRoles((Properties)selectedDatasourceMap.get("pdb-role"));
            }
            if (selectedDatasourceMap.containsKey("description")) {
                this.dataSourceDescription.set((String)selectedDatasourceMap.get("description"));
            }
            String user = null;
            OpaqueString password = OpaqueString.NULL;
            String walletFile = null;
            if (poolPropertiesMap.containsKey("user")) {
                user = (String)poolPropertiesMap.get("user");
            }
            if (selectedDatasourceMap.containsKey("user")) {
                user = (String)selectedDatasourceMap.get("user");
            }
            if (null != user) {
                this.username = user;
            }
            password = this.getPasswordFromPoolElement(poolPropertiesMap);
            if (selectedDatasourceMap.containsKey("password")) {
                password = (OpaqueString)selectedDatasourceMap.get("password");
            }
            if (selectedDatasourceMap.containsKey("wallet-file")) {
                walletFile = (String)selectedDatasourceMap.get("wallet-file");
                OpaqueString walletFilePassword = OpaqueString.NULL;
                if (selectedDatasourceMap.containsKey("wallet-password")) {
                    walletFilePassword = (OpaqueString)selectedDatasourceMap.get("wallet-password");
                }
                try {
                    password = this.getPasswordFromWallet(this.url, walletFile, walletFilePassword);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid Wallet location/Wrong Wallet password");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Exception while accessing Oracle Wallet", e);
                }
            }
            if (OpaqueString.NULL != password) {
                this.password = password;
            }
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("invalid property type set ");
        }
    }

    private void applyPoolProperties(Map<String, Object> poolPropertiesMap) throws UniversalConnectionPoolException, Exception {
        try {
            block82: for (String property : poolPropertiesMap.keySet()) {
                if (property.startsWith("data-source-")) continue;
                switch (property) {
                    case "user": 
                    case "password": 
                    case "wallet-file": 
                    case "wallet-password": 
                    case "connection-pool-name": {
                        continue block82;
                    }
                    case "shared": {
                        this.isPoolShareable.set(Boolean.parseBoolean((String)poolPropertiesMap.get("shared")));
                        continue block82;
                    }
                    case "url": {
                        this.url = (String)poolPropertiesMap.get("url");
                        continue block82;
                    }
                    case "max-pool-size": {
                        this.maxPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("max-pool-size")));
                        continue block82;
                    }
                    case "initial-pool-size": {
                        this.initialPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("initial-pool-size")));
                        continue block82;
                    }
                    case "min-pool-size": {
                        this.minPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("min-pool-size")));
                        continue block82;
                    }
                    case "fast-connection-failover-enabled": {
                        this.fastConnectionFailoverEnabled.set(Boolean.parseBoolean((String)poolPropertiesMap.get("fast-connection-failover-enabled")));
                        continue block82;
                    }
                    case "max-connection-reuse-count": {
                        this.maxConnectionReuseCount.set(Integer.parseInt((String)poolPropertiesMap.get("max-connection-reuse-count")));
                        continue block82;
                    }
                    case "max-connection-reuse-time": {
                        this.maxConnectionReuseTime.set(Long.parseLong((String)poolPropertiesMap.get("max-connection-reuse-time")));
                        continue block82;
                    }
                    case "max-idle-time": {
                        this.inactiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("max-idle-time")));
                        continue block82;
                    }
                    case "max-statements": {
                        this.maxStatements.set(Integer.parseInt((String)poolPropertiesMap.get("max-statements")));
                        continue block82;
                    }
                    case "abandoned-connection-timeout": {
                        this.abandonedConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("abandoned-connection-timeout")));
                        continue block82;
                    }
                    case "connection-harvest-max-count": {
                        this.connectionHarvestMaxCount.set(Integer.parseInt((String)poolPropertiesMap.get("connection-harvest-max-count")));
                        continue block82;
                    }
                    case "connection-harvest-trigger-count": {
                        this.connectionHarvestTriggerCount.set(Integer.parseInt((String)poolPropertiesMap.get("connection-harvest-trigger-count")));
                        continue block82;
                    }
                    case "inactive-connection-timeout": {
                        this.inactiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("inactive-connection-timeout")));
                        continue block82;
                    }
                    case "connection-wait-timeout": {
                        this.connectionWaitTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("connection-wait-timeout")));
                        continue block82;
                    }
                    case "validate-connection-on-borrow": {
                        this.validateConnectionOnBorrow.set(Boolean.parseBoolean((String)poolPropertiesMap.get("validate-connection-on-borrow")));
                        continue block82;
                    }
                    case "sql-for-validate-connection": {
                        this.sqlForValidateConnection.set((String)poolPropertiesMap.get("sql-for-validate-connection"));
                        continue block82;
                    }
                    case "timeout-check-interval": {
                        this.timeoutCheckInterval.set(Integer.parseInt((String)poolPropertiesMap.get("timeout-check-interval")));
                        continue block82;
                    }
                    case "property-cycle": {
                        this.timeoutCheckInterval.set(Integer.parseInt((String)poolPropertiesMap.get("property-cycle")));
                        continue block82;
                    }
                    case "time-to-live-connection-timeout": {
                        this.timeToLiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("time-to-live-connection-timeout")));
                        continue block82;
                    }
                    case "high-cost-connection-reuse-threshold": {
                        this.highCostConnectionReuseThreshold.set(Integer.parseInt((String)poolPropertiesMap.get("high-cost-connection-reuse-threshold")));
                        continue block82;
                    }
                    case "connection-labeling-high-cost": {
                        this.connectionLabelingHighCost.set(Integer.parseInt((String)poolPropertiesMap.get("connection-labeling-high-cost")));
                        continue block82;
                    }
                    case "ons-configuration": {
                        this.setONSConfiguration((String)poolPropertiesMap.get("ons-configuration"));
                        continue block82;
                    }
                    case "connection-labeling-callback": {
                        Class<?> labelingClass = Class.forName((String)poolPropertiesMap.get("connection-labeling-callback"));
                        oracle.ucp.ConnectionLabelingCallback labelingObject = (oracle.ucp.ConnectionLabelingCallback)labelingClass.newInstance();
                        if (labelingObject == null) {
                            throw new IllegalArgumentException("callback has to be non-null");
                        }
                        this.connectionLabelingCallback.set(labelingObject);
                        continue block82;
                    }
                    case "connection-affinity-callback": {
                        Class<?> affinityClass = Class.forName((String)poolPropertiesMap.get("connection-affinity-callback"));
                        ConnectionAffinityCallback affinityObject = (ConnectionAffinityCallback)affinityClass.newInstance();
                        if (affinityObject == null) {
                            throw new IllegalArgumentException("callback has to be non-null");
                        }
                        this.connectionAffinityCallback.set(affinityObject);
                        continue block82;
                    }
                    case "connection-initialization-callback": {
                        Class<?> initializationClass = Class.forName((String)poolPropertiesMap.get("connection-initialization-callback"));
                        ConnectionInitializationCallback initializationObject = (ConnectionInitializationCallback)initializationClass.newInstance();
                        if (initializationObject == null) {
                            throw new IllegalArgumentException("callback has to be non-null");
                        }
                        this.connectionInitializationCallback.set(initializationObject);
                        continue block82;
                    }
                    case "login-timeout": {
                        this.loginTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("login-timeout")));
                        continue block82;
                    }
                    case "seconds-to-trust-idle-connection": {
                        this.secondsToTrustIdleConnection.set(Integer.parseInt((String)poolPropertiesMap.get("seconds-to-trust-idle-connection")));
                        continue block82;
                    }
                    case "connection-repurpose-threshold": {
                        this.repurposeThreshold.set(Integer.parseInt((String)poolPropertiesMap.get("connection-repurpose-threshold")));
                        continue block82;
                    }
                    case "connection-factory-class-name": {
                        this.setConnectionFactoryClassName((String)poolPropertiesMap.get("connection-factory-class-name"));
                        continue block82;
                    }
                    case "connection-factory-property": {
                        this.setConnectionFactoryProperties((Properties)poolPropertiesMap.get("connection-factory-property"));
                        continue block82;
                    }
                    case "connection-property": {
                        this.setConnectionProperties((Properties)poolPropertiesMap.get("connection-property"));
                        continue block82;
                    }
                    case "is-xa-pool": {
                        continue block82;
                    }
                    case "max-connections-per-service": {
                        this.maxConnectionsPerService.set(Integer.parseInt((String)poolPropertiesMap.get("max-connections-per-service")));
                        continue block82;
                    }
                    case "max-connections-per-shard": {
                        this.maxConnectionsPerShard.set(Integer.parseInt((String)poolPropertiesMap.get("max-connections-per-shard")));
                        continue block82;
                    }
                }
                throw new IllegalArgumentException("Invalid property name " + property);
            }
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("invalid property type set ");
        }
    }

    @Override
    public void reconfigureDataSource(Properties configuration) throws SQLException {
        String configPoolName;
        if (configuration == null) {
            throw new IllegalArgumentException("Invalid datasource input configuration");
        }
        if (this.connectionPool == null && !this.isConfigureNewDS.get()) {
            UCPErrorHandler.throwSQLException(76, null);
        }
        if ((configPoolName = configuration.getProperty("connectionPoolName")) == null) {
            configPoolName = this.getConnectionPoolName();
        }
        try {
            boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(configPoolName);
            if (!poolExists) {
                throw new UniversalConnectionPoolException("Invalid configuration attempt, pool " + configPoolName + " does not exist, datasource can be configured on existing pools only");
            }
            JDBCConnectionPool pool = (JDBCConnectionPool)this.getManager().getConnectionPool(configPoolName);
            if (this.connectionPool != null && !configPoolName.equals(this.getConnectionPoolName())) {
                throw new UniversalConnectionPoolException("Invalid configuration input, Pool name " + configPoolName + " for the datasource in the configuration input does not match the actual pool name of the datasource which is " + this.getConnectionPoolName());
            }
            if (!pool.isShareable() && this.connectionPool == null) {
                throw new UniversalConnectionPoolException("Pool  " + configPoolName + " is not shareable, hence cannot configure a new  datasource on it");
            }
            if (!pool.isLifecycleRunning()) {
                throw new UniversalConnectionPoolException("Cannot confiure datasource as underlying pool : " + pool.getName() + " is not running");
            }
            for (Map.Entry<Object, Object> prop : configuration.entrySet()) {
                String name;
                switch (name = (String)prop.getKey()) {
                    case "connectionPoolName": {
                        this.connectionPoolName.set((String)prop.getValue());
                        break;
                    }
                    case "user": {
                        this.username = (String)prop.getValue();
                        break;
                    }
                    case "password": {
                        this.password = OpaqueString.newOpaqueString((String)prop.getValue());
                        break;
                    }
                    case "serviceName": {
                        this.serviceName = (String)prop.getValue();
                        break;
                    }
                    case "pdbRoles": {
                        Properties roles = (Properties)prop.getValue();
                        this.pdbRoles = new Properties();
                        if (roles == null) break;
                        this.pdbRoles.putAll((Map<?, ?>)roles);
                        break;
                    }
                    case "description": {
                        this.dataSourceDescription.internalSet((String)prop.getValue());
                    }
                }
            }
            if (this.connectionPool == null) {
                Map<String, Object> poolProperties = DatasourceConfigManager.getPoolConfigFromXML(this.getConnectionPoolName());
                this.url = (String)poolProperties.get("url");
                this.setConnectionFactoryClassName((String)poolProperties.get("connection-factory-class-name"));
                Properties connectionFactoryProps = (Properties)poolProperties.get("connection-factory-property");
                if (connectionFactoryProps != null && connectionFactoryProps.size() > 0) {
                    this.setConnectionFactoryProperties(connectionFactoryProps);
                }
                this.setConnectionProperties((Properties)poolProperties.get("connection-property"));
                if (this.username == null) {
                    this.username = (String)poolProperties.get("user");
                }
                if (this.password == OpaqueString.NULL) {
                    this.password = OpaqueString.newOpaqueString((String)poolProperties.get("password"));
                }
                this.useExistingPool();
            }
            if (pool.isShareable()) {
                this.disableAPI = true;
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(72, e);
        }
    }

    @Blind
    private OpaqueString getPasswordFromPoolElement(Map<? extends String, ? extends Object> propertiesMap) {
        if (propertiesMap.containsKey("wallet-file")) {
            String walletFile = (String)propertiesMap.get("wallet-file");
            OpaqueString walletFilePassword = OpaqueString.NULL;
            if (propertiesMap.containsKey("wallet-password")) {
                walletFilePassword = (OpaqueString)propertiesMap.get("wallet-password");
            }
            if (null == this.url || "".equals(this.url)) {
                throw new IllegalArgumentException("Invalid Arguments, url is required to access password from wallet");
            }
            OpaqueString passwordFromWallet = OpaqueString.NULL;
            try {
                passwordFromWallet = this.getPasswordFromWallet(this.url, walletFile, walletFilePassword);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid Wallet location/Wrong Wallet password");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while accessing Oracle Wallet", e);
            }
            return passwordFromWallet;
        }
        if (propertiesMap.containsKey("password")) {
            return (OpaqueString)propertiesMap.get("password");
        }
        return OpaqueString.NULL;
    }

    @Blind
    private OpaqueString getPasswordFromWallet(String connectString, String walletFileLocation, @Blind OpaqueString walletFilePassword) throws Exception {
        String user = null;
        OpaqueString password = OpaqueString.NULL;
        OracleWallet wallet = new OracleWallet();
        if (wallet.exists((String)(walletFileLocation = "file:" + (String)walletFileLocation))) {
            OracleSecretStore secretStore;
            char[] walletPasswordInChars = null;
            if (walletFilePassword != OpaqueString.NULL) {
                walletPasswordInChars = walletFilePassword.getChars();
            }
            wallet.open((String)walletFileLocation, walletPasswordInChars);
            if (walletPasswordInChars != null) {
                Arrays.fill(walletPasswordInChars, '\u0000');
            }
            if ((secretStore = wallet.getSecretStore()).containsAlias(SECRET_STORE_DEFAULT_USERNAME)) {
                user = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
            }
            if (secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD));
            }
            Enumeration list = wallet.getSecretStore().internalAliases();
            String alias = null;
            while (list.hasMoreElements()) {
                alias = (String)list.nextElement();
                if (!alias.contains(SECRET_STORE_CONNECT) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                String idx = alias.substring(SECRET_STORE_CONNECT.length());
                user = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_PASSWORD + idx));
                break;
            }
        }
        return password;
    }

    @Override
    public UniversalConnectionPoolMBean createUniversalConnectionPoolMBean() throws SQLException {
        JDBCUniversalConnectionPoolMBeanImpl poolMBean = null;
        try {
            assert (this.connectionPool != null);
            poolMBean = new JDBCUniversalConnectionPoolMBeanImpl(this.connectionPool);
        }
        catch (Exception exc) {
            UCPErrorHandler.throwSQLException(1, exc);
        }
        return poolMBean;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, null);
    }

    @Override
    public Connection getConnection(Properties labels) throws SQLException {
        return this.getConnection(null, null, labels);
    }

    @Override
    public Connection getConnection(String username, String password, Properties labels) throws SQLException {
        if (null == this.getUser()) {
            this.setUser(username);
        }
        if (null == this.getPasswordReal()) {
            this.setPassword(password);
        }
        return this.createConnectionBuilder().user(username).password(password).labels(labels).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection getConnection(UCPConnectionBuilderImpl builder) throws SQLException {
        oracle.ucp.ConnectionLabelingCallback labelingCbk = this.connectionLabelingCallback.get();
        if (labelingCbk != null && labelingCbk instanceof ConnectionLabelingCallback) {
            this.ilogFinest(null, null, null, null, "labeling callback is oracle.ucp.jdbc.ConnectionLabelingCallback");
            ConnectionLabelingCallback newLabelingCbk = (ConnectionLabelingCallback)labelingCbk;
            if (builder.labels == null) {
                builder.labels(newLabelingCbk.getRequestedLabels());
            }
        }
        this.startPool(Objects.equals(this.getUser(), builder.user) && Objects.equals(this.getPasswordReal(), builder.password.get()));
        Connection conn = null;
        JDBCUniversalPooledConnection jdbcPooledConnection = null;
        if (builder.serviceName == null) {
            builder.serviceName(this.serviceName);
        }
        if (builder.user == null) {
            builder.user(this.getUser());
        }
        if (builder.password == OpaqueString.NULL) {
            builder.internalPassword(this.getPasswordInternal());
        }
        if (builder.pdbRoles == null) {
            builder.pdbRoles(this.getPdbRoles());
        }
        if (builder.sslContext == null) {
            builder.sslContext(this.sslContext);
        }
        if (!builder.readOnlyInstanceAllowed) {
            builder.readOnlyInstanceAllowed(this.readOnlyInstanceAllowed.get());
        }
        JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(builder);
        jdbcPooledConnection = (JDBCUniversalPooledConnection)this.connectionPool.borrowConnection(cri);
        conn = this.connectionPool.getProxyFactory().proxyForConnection(this.connectionPool, jdbcPooledConnection);
        if (this.acActive == null) {
            this.acActive = jdbcPooledConnection.getPhysicalConnection().getClass().getName().indexOf(AC_PROXY_CLASS_NAME_KEYWORD) >= 0;
        }
        if (this.acActive.booleanValue()) {
            ReplayableConnection rconn = (ReplayableConnection)jdbcPooledConnection.getPhysicalConnection();
            rconn.setProxyObject((Object)conn, builder.getUpdatedBuilderForAC(rconn.getConnectionBuilder()));
        }
        if (conn != null || jdbcPooledConnection == null) return conn;
        try {
            this.connectionPool.returnConnection(jdbcPooledConnection);
            return conn;
        }
        catch (UniversalConnectionPoolException e) {
            this.ilogFine(null, null, null, null, "returnConnection() failed for " + jdbcPooledConnection);
            this.ilogThrowing(null, null, null, null, e);
        }
        return conn;
        catch (NoAvailableConnectionsException e) {
            UCPErrorHandler.throwSQLException(28, e);
            return conn;
        }
        catch (UniversalConnectionPoolException e2) {
            UCPErrorHandler.throwSQLException(29, e2);
            return conn;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (conn == null && jdbcPooledConnection != null) {
                try {
                    this.connectionPool.returnConnection(jdbcPooledConnection);
                }
                catch (UniversalConnectionPoolException e) {
                    this.ilogFine(null, null, null, null, "returnConnection() failed for " + jdbcPooledConnection);
                    this.ilogThrowing(null, null, null, null, e);
                }
            }
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        JDBCConnectionPool pool = this.connectionPool;
        if (null == pool) {
            UCPErrorHandler.throwSQLException(30, null);
        }
        return pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        JDBCConnectionPool pool = this.connectionPool;
        if (null == pool) {
            UCPErrorHandler.throwSQLException(30, null);
        }
        pool.setLogWriter(logWriter);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout.set(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout.get();
    }

    @Override
    public String getUser() {
        return this.username;
    }

    @Override
    public void setUser(String username) throws SQLException {
        if (!this.allowSetter()) {
            return;
        }
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "user", username, true, true);
                PoolDataSourceImpl.setProperty(this.connectionFactory, "userName", username, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(24, e);
            }
        }
        this.username = username;
    }

    @Blind
    final String getPasswordReal() {
        return this.password.get();
    }

    OpaqueString getPasswordInternal() {
        return this.password;
    }

    @Override
    public void setPassword(@Blind String password) throws SQLException {
        if (!this.allowSetter()) {
            return;
        }
        if (this.poolCreated.get()) {
            try {
                assert (this.connectionFactory != null);
                PoolDataSourceImpl.setProperty(this.connectionFactory, "password", password, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(25, e);
            }
        }
        this.password = OpaqueString.newOpaqueString(password);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) throws SQLException {
        if (!this.allowSetter()) {
            return;
        }
        if (this.poolCreated.get()) {
            try {
                this.setURLProperties(url);
                try {
                    this.connectionPool.refresh();
                }
                catch (Exception e) {
                    this.setURLProperties(this.url);
                    this.connectionPool.stop();
                    this.connectionPool.start();
                    UCPErrorHandler.throwSQLException(22, e);
                }
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(26, e);
            }
        }
        this.url = url;
    }

    @Override
    public void setServerName(String serverName) throws SQLException {
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "serverName", serverName, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(49, e);
            }
        }
        this.serverName = serverName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setPortNumber(int portNumber) throws SQLException {
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "portNumber", portNumber, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(50, e);
            }
        }
        this.portNumber = portNumber;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setDatabaseName(String databaseName) throws SQLException {
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "databaseName", databaseName, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(51, e);
            }
        }
        this.databaseName = databaseName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDataSourceName(String dataSourceName) throws SQLException {
        this.dataSourceName.set(dataSourceName);
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName.get();
    }

    @Override
    public void setDescription(String dataSourceDescription) throws SQLException {
        this.dataSourceDescription.set(dataSourceDescription);
    }

    @Override
    public String getDescription() {
        return this.dataSourceDescription.get();
    }

    @Override
    public void setNetworkProtocol(String networkProtocol) throws SQLException {
        this.networkProtocol.set(networkProtocol);
    }

    @Override
    public String getNetworkProtocol() {
        return this.networkProtocol.get();
    }

    @Override
    public void setRoleName(String roleName) throws SQLException {
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "roleName", roleName, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(55, e);
            }
        }
        this.roleName = roleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws SQLException {
        this.initialPoolSize.set(initialPoolSize);
    }

    @Override
    public int getInitialPoolSize() {
        return this.initialPoolSize.get();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws SQLException {
        this.minPoolSize.set(minPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize.get();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws SQLException {
        this.maxPoolSize.set(maxPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize.get();
    }

    private void setMaxConnectionsPerService(int maxPerService) throws SQLException {
        this.maxConnectionsPerService.set(maxPerService);
    }

    @Override
    public int getMaxConnectionsPerService() {
        return this.maxConnectionsPerService.get();
    }

    @Override
    public void setInactiveConnectionTimeout(int inactivityTimeout) throws SQLException {
        this.inactiveConnectionTimeout.set(inactivityTimeout);
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.inactiveConnectionTimeout.get();
    }

    @Override
    public void setConnectionWaitTimeout(int waitTimeout) throws SQLException {
        this.connectionWaitTimeout.set(waitTimeout);
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.connectionWaitTimeout.get();
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws SQLException {
        this.timeToLiveConnectionTimeout.set(timeToLiveConnectionTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.timeToLiveConnectionTimeout.get();
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.abandonedConnectionTimeout.get();
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws SQLException {
        this.abandonedConnectionTimeout.set(abandonedConnectionTimeout);
    }

    @Override
    public void setTimeoutCheckInterval(int timeInterval) throws SQLException {
        this.timeoutCheckInterval.set(timeInterval);
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.timeoutCheckInterval.get();
    }

    @Override
    public void setFastConnectionFailoverEnabled(boolean failoverEnabled) throws SQLException {
        this.fastConnectionFailoverEnabled.set(failoverEnabled);
        this.fcfExplicitlySet.set(true);
        this.ilogFine(null, null, null, null, "explicitly set FCF-Enabled=" + failoverEnabled);
    }

    @Override
    public boolean getFastConnectionFailoverEnabled() {
        return this.fastConnectionFailoverEnabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionFactoryClassName() {
        String string = this.connectionFactoryClassName;
        synchronized (string) {
            return this.connectionFactoryClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionFactoryClassName(String factoryClassName) throws SQLException {
        if (!this.allowSetter()) {
            return;
        }
        if (factoryClassName == null) {
            UCPErrorHandler.throwSQLException(22, null);
        }
        String string = this.connectionFactoryClassName;
        synchronized (string) {
            this.connectionFactoryClassName = factoryClassName;
        }
        if (this.connectionPoolFactoryClassNameWasSet.compareAndSet(false, true) && this.poolCreated.get()) {
            try {
                this.connectionPool.refresh();
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwSQLException(22, e);
            }
        }
    }

    @Override
    public void setMaxStatements(int maxStatements) throws SQLException {
        this.maxStatements.set(maxStatements);
    }

    @Override
    public int getMaxStatements() {
        return this.maxStatements.get();
    }

    @Override
    public void setMaxIdleTime(int idleTime) throws SQLException {
        this.setInactiveConnectionTimeout(idleTime);
    }

    @Override
    public int getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    @Override
    public void setPropertyCycle(int propertyCycle) throws SQLException {
        this.setTimeoutCheckInterval(propertyCycle);
    }

    @Override
    public int getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    @Override
    public void setConnectionPoolName(String connectionPoolName) throws SQLException {
        if (!this.allowSetter()) {
            return;
        }
        if (connectionPoolName != null && !connectionPoolName.equals("") && this.poolCreated.get()) {
            try {
                UniversalConnectionPoolManagerHelper umh = new UniversalConnectionPoolManagerHelper(this.connectionPool);
                umh.setManagerPoolID(connectionPoolName);
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwSQLException(45, e);
            }
            this.connectionPool.setName(connectionPoolName);
        }
        this.connectionPoolName.set(connectionPoolName);
    }

    @Override
    public String getConnectionPoolName() {
        return this.poolCreated.get() ? this.connectionPool.getName() : this.connectionPoolName.get();
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) throws SQLException {
        this.validateConnectionOnBorrow.set(validateConnectionOnBorrow);
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.validateConnectionOnBorrow.get();
    }

    @Override
    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        if (SQLString != null && SQLString.equals("")) {
            UCPErrorHandler.throwSQLException(22, null);
        }
        this.sqlForValidateConnection.set(SQLString);
    }

    @Override
    public String getSQLForValidateConnection() {
        return this.sqlForValidateConnection.get();
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.connectionHarvestTriggerCount.get();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws SQLException {
        this.connectionHarvestTriggerCount.set(connectionHarvestTriggerCount);
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.connectionHarvestMaxCount.get();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws SQLException {
        this.connectionHarvestMaxCount.set(connectionHarvestMaxCount);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws SQLException {
        this.maxConnectionReuseTime.set(maxConnectionReuseTime);
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws SQLException {
        this.maxConnectionReuseCount.set(maxConnectionReuseCount);
    }

    @Override
    public int getAvailableConnectionsCount() {
        if (this.connectionPool == null) {
            return 0;
        }
        return this.connectionPool.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        if (this.connectionPool == null) {
            return 0;
        }
        return this.connectionPool.getBorrowedConnectionsCount();
    }

    @Override
    public String getONSConfiguration() {
        if (this.poolCreated.get()) {
            return this.connectionPool.getONSConfiguration();
        }
        return this.onsConfiguration;
    }

    @Override
    public void setONSConfiguration(String onsConfigStr) {
        if (!this.allowSetter()) {
            return;
        }
        this.ilogFinest(null, null, null, null, "onsConfigStr: " + Util.maskONSConfigurationString(onsConfigStr));
        if (this.poolCreated.get()) {
            this.connectionPool.setONSConfiguration(onsConfigStr);
        }
        this.onsConfiguration = onsConfigStr;
    }

    @Override
    public void registerConnectionLabelingCallback(oracle.ucp.ConnectionLabelingCallback cbk) throws SQLException {
        if (cbk == null) {
            throw new IllegalArgumentException("callback has to be non-null");
        }
        this.connectionLabelingCallback.set(cbk);
    }

    @Override
    public void removeConnectionLabelingCallback() throws SQLException {
        this.connectionLabelingCallback.set(null);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws SQLException {
        if (cbk == null) {
            throw new IllegalArgumentException("callback has to be non-null");
        }
        this.connectionAffinityCallback.set(cbk);
    }

    @Override
    public void removeConnectionAffinityCallback() throws SQLException {
        this.connectionAffinityCallback.set(null);
    }

    @Override
    public JDBCConnectionPoolStatistics getStatistics() {
        JDBCConnectionPool cp = this.connectionPool;
        if (cp == null) {
            return null;
        }
        if (cp instanceof OracleJDBCConnectionPool) {
            return new OracleJDBCConnectionPoolStatisticsImpl((OracleJDBCConnectionPool)this.connectionPool);
        }
        return new JDBCConnectionPoolStatisticsImpl(cp);
    }

    private void setServiceName(String serviceName) {
        if (!this.allowSetter()) {
            return;
        }
        this.serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public String getConnectionProperty(String propertyName) {
        return this.connectionProperties.getProperty(propertyName);
    }

    @Override
    public void setConnectionProperty(String name, String value) throws SQLException {
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        Properties connProps = new Properties();
        connProps.setProperty(name, value);
        this.setConnectionProperties(connProps);
    }

    @Override
    public void setConnectionProperties(Properties connectionProperties) throws SQLException {
        boolean doRefresh = false;
        if (!this.allowSetter()) {
            return;
        }
        if (connectionProperties == null || connectionProperties.size() == 0) {
            this.connectionProperties.clear();
            return;
        }
        for (Map.Entry<Object, Object> prop : connectionProperties.entrySet()) {
            String key = (String)prop.getKey();
            if (null != this.connectionProperties.getProperty(key) && PoolDataSourceImpl.isSetOnceProperty(key)) {
                doRefresh = true;
            }
            this.connectionProperties.setProperty(key, (String)prop.getValue());
        }
        if (this.poolCreated.get()) {
            if (this.connectionFactoryClassName != null) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "connectionProperties", this.connectionProperties, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(48, e);
                }
            }
            if (doRefresh) {
                try {
                    this.connectionPool.refresh();
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(22, e);
                }
            }
        }
    }

    @Override
    public Properties getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    @Override
    public String getConnectionFactoryProperty(String propertyName) {
        return this.connectionFactoryProperties.getProperty(propertyName);
    }

    @Override
    public void setConnectionFactoryProperty(String name, String value) throws SQLException {
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        Properties connFactoryProps = new Properties();
        connFactoryProps.setProperty(name, value);
        this.setConnectionFactoryProperties(connFactoryProps);
    }

    @Override
    public void setConnectionFactoryProperties(Properties factoryProperties) throws SQLException {
        boolean doRefresh = false;
        if (!this.allowSetter()) {
            return;
        }
        if (factoryProperties.size() <= 0) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<Object, Object> prop : factoryProperties.entrySet()) {
            String key = (String)prop.getKey();
            String value = (String)prop.getValue();
            if (null != this.connectionFactoryProperties.getProperty(key) && PoolDataSourceImpl.isSetOnceProperty(key)) {
                doRefresh = true;
            }
            if (this.poolCreated.get() && !this.isDriverFactory) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, key, value, true, false);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(59, e);
                }
            }
            this.connectionFactoryProperties.setProperty(key, value);
        }
        if (this.username == null || this.username.equals("")) {
            this.username = this.connectionFactoryProperties.getProperty("user");
            if (this.username == null || this.username.equals("")) {
                this.username = this.connectionFactoryProperties.getProperty("username");
            }
        }
        if (this.password == OpaqueString.NULL || this.password == OpaqueString.EMPTY) {
            this.password = OpaqueString.newOpaqueString(this.connectionFactoryProperties.getProperty("password"));
        }
        if (this.url == null || this.url.equals("")) {
            this.url = this.connectionFactoryProperties.getProperty("url");
        }
        if (this.poolCreated.get() && doRefresh) {
            try {
                this.connectionPool.refresh();
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwSQLException(22, e);
            }
        }
    }

    public static boolean isSetOnceProperty(String key) {
        for (String authKey : new String[]{"oracle.net.wallet_location", "oracle.net.wallet_password", "oracle.net.ssl_version", "oracle.net.ssl_cipher_suites", "oracle.net.ssl_server_dn_match", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "oracle.net.encryption_client", "oracle.net.encryption_types_client", "oracle.net.crypto_checksum_client", "oracle.net.crypto_checksum_types_client", "javax.net.ssl.keyStore", "javax.net.ssl.keyStoreType", "javax.net.ssl.keyStorePassword", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreType", "javax.net.ssl.trustStorePassword", "oracle.jdbc.tokenAuthentication", "oracle.jdbc.tokenLocation", "oracle.jdbc.passwordAuthentication", "oracle.jdbc.ociIamUrl", "oracle.jdbc.ociTenancy", "oracle.jdbc.ociCompartment", "oracle.jdbc.ociDatabase"}) {
            if (!authKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionFactory() throws SQLException {
        String className = this.getClass().getName();
        try {
            String string = this.connectionFactoryClassName;
            synchronized (string) {
                this.connectionFactory = Util.getClassForName(this.connectionFactoryClassName, true, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.isDriverFactory = this.connectionFactory instanceof Driver;
            }
            this.ilogFinest(null, null, null, null, "factory class created");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(23, e);
        }
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "loginTimeout", this.getLoginTimeout(), true, true);
            if (this.isDriverFactory) {
                this.connectionFactoryProperties.setProperty("oracle.net.CONNECT_TIMEOUT", new Integer(this.getLoginTimeout() * 1000).toString());
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(69, e);
        }
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "user", this.username, true, true);
            PoolDataSourceImpl.setProperty(this.connectionFactory, "userName", this.username, true, true);
            if (this.isDriverFactory && this.username != null && !this.username.equals("")) {
                this.connectionFactoryProperties.setProperty("user", this.username);
            }
            this.ilogFinest(null, null, null, null, "user is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(24, e);
        }
        try {
            String password = this.password.get();
            PoolDataSourceImpl.setProperty(this.connectionFactory, "password", password, true, true);
            if (this.isDriverFactory && password != null && !password.equals("")) {
                this.connectionFactoryProperties.setProperty("password", password);
            }
            this.ilogFinest(null, null, null, null, "password is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(25, e);
        }
        try {
            this.setURLProperties(this.url);
            this.ilogFinest(null, null, null, null, "URL is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(26, e);
        }
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "serverName", this.serverName, true, true);
            if (this.isDriverFactory && this.serverName != null && !this.serverName.equals("")) {
                this.connectionFactoryProperties.setProperty("serverName", this.serverName);
            }
            this.ilogFinest(null, null, null, null, "Database Server Name is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(49, e);
        }
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "portNumber", this.portNumber, true, true);
            if (this.isDriverFactory && this.portNumber != 0) {
                this.connectionFactoryProperties.setProperty("portNumber", "" + this.portNumber);
            }
            this.ilogFinest(null, null, null, null, "Port Number is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(50, e);
        }
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "databaseName", this.databaseName, true, true);
            if (this.isDriverFactory && this.databaseName != null && !this.databaseName.equals("")) {
                this.connectionFactoryProperties.setProperty("databaseName", this.databaseName);
            }
            this.ilogFinest(null, null, null, null, "Database name is set");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(51, e);
        }
        this.dataSourceName.set();
        this.ilogFinest(null, null, null, null, "DataSource name is set");
        this.dataSourceDescription.set();
        this.ilogFinest(null, null, null, null, "DataSource description is set");
        AutoProperty<String> e = this.networkProtocol;
        synchronized (e) {
            this.networkProtocol.set();
            if (this.isDriverFactory && this.networkProtocol.get() != null && !this.networkProtocol.get().equals("")) {
                try {
                    this.connectionFactoryProperties.setProperty("networkProtocol", this.networkProtocol.get());
                }
                catch (Exception exception) {
                    UCPErrorHandler.throwSQLException(54, exception);
                }
            }
        }
        this.ilogFinest(null, null, null, null, "DataSource network protocol is set");
        try {
            PoolDataSourceImpl.setProperty(this.connectionFactory, "roleName", this.roleName, true, true);
            if (this.isDriverFactory && this.roleName != null && !this.roleName.equals("")) {
                this.connectionFactoryProperties.setProperty("roleName", this.roleName);
            }
            this.ilogFinest(null, null, null, null, "DataSource role name is set");
        }
        catch (Exception e2) {
            UCPErrorHandler.throwSQLException(55, e2);
        }
        if (this.tokenSupplier != null) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "tokenSupplier", this.tokenSupplier, true, false);
                this.ilogFinest(null, null, null, null, "Token supplier is set");
            }
            catch (Exception e3) {
                UCPErrorHandler.throwSQLException(81, e3);
            }
        }
        if (!this.isDriverFactory && this.connectionFactoryProperties.size() > 0) {
            for (Map.Entry entry : this.connectionFactoryProperties.entrySet()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, (String)entry.getKey(), (String)entry.getValue(), true, false);
                }
                catch (Exception e4) {
                    UCPErrorHandler.throwSQLException(59, e4);
                }
            }
        }
    }

    private static void setProperty(Object object, String name, Object value, boolean caseSensitive, boolean lenient) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        Object loggedValue = "password".equalsIgnoreCase(name) ? "*****" : value;
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getWriteMethod() == null) continue;
            if (caseSensitive && descriptors[i].getName().equals(name) || !caseSensitive && descriptors[i].getName().equalsIgnoreCase(name)) {
                Method method = descriptors[i].getWriteMethod();
                Class<?> paramType = method.getParameterTypes()[0];
                if (value instanceof String) {
                    value = PoolDataSourceImpl.toBasicType(value.toString(), paramType.getName());
                }
                method.invoke(object, value);
                return;
            }
            names.add(descriptors[i].getName());
        }
        if (!lenient) {
            throw new IllegalArgumentException("No such property: " + name + ", existing writable properties are: " + names);
        }
    }

    private void setSpecialProperty(String propertyName, String url) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (url == null) {
            throw new NullPointerException("no url");
        }
        StringTokenizer tokens = new StringTokenizer(url, ";");
        while (tokens.hasMoreTokens()) {
            String currToken = tokens.nextToken();
            if (!currToken.startsWith(propertyName + "=")) continue;
            PoolDataSourceImpl.setProperty(this.connectionFactory, propertyName, currToken.substring(currToken.indexOf("=") + 1), true, true);
            return;
        }
    }

    private void setURLProperties(String url) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (Objects.isNull(url) || "".equals(url)) {
            throw new IllegalArgumentException("attempt to set an empty or null database URL in a connection factory");
        }
        PoolDataSourceImpl.setProperty(this.connectionFactory, "url", url, true, true);
        PoolDataSourceImpl.setProperty(this.connectionFactory, "URL", url, true, true);
        if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.endsWith("ias.jdbcx.informix.InformixDataSource")) {
            this.setSpecialProperty("informixServer", url);
        }
    }

    public static Object toBasicType(String value, String type) {
        Object retVal = null;
        Object eMsg = null;
        try {
            if (value == null) {
                retVal = null;
            } else if (type == null || type.equals("java.lang.String")) {
                retVal = value;
            } else if (type.equals("java.lang.Character") || type.equals("char")) {
                if (value.length() == 1) {
                    retVal = new Character(value.charAt(0));
                } else {
                    eMsg = "Invalid Character value";
                }
            } else if (type.equals("java.lang.Integer") || type.equals("int")) {
                retVal = Integer.valueOf(value);
            } else if (type.equals("java.lang.Float") || type.equals("float")) {
                retVal = Float.valueOf(value);
            } else if (type.equals("java.lang.Long") || type.equals("long")) {
                retVal = Long.valueOf(value);
            } else if (type.equals("java.lang.Double") || type.equals("double")) {
                retVal = Double.valueOf(value);
            } else if (type.equals("java.lang.Byte") || type.equals("byte")) {
                retVal = Byte.valueOf(value);
            } else if (type.equals("java.lang.Short") || type.equals("short")) {
                retVal = Short.valueOf(value);
            } else if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
                retVal = Boolean.valueOf(value);
            } else {
                eMsg = "Invalid attribute type" + type;
            }
        }
        catch (NumberFormatException e) {
            eMsg = "Invalid " + type + " value";
        }
        if (null != eMsg) {
            throw new IllegalArgumentException((String)eMsg);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference() {
        Reference ref = new Reference(this.getClass().getName(), "oracle.ucp.jdbc.PoolDataSourceImpl", null);
        if (this.username != null) {
            ref.add(new StringRefAddr("user", this.username));
        }
        if (this.password != OpaqueString.NULL) {
            ref.add(new StringRefAddr("password", this.password.get()));
        }
        if (this.serviceName != null) {
            ref.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr("serverName", this.serverName));
        }
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        if (this.databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName.get() != null) {
            ref.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
        }
        if (this.dataSourceDescription.get() != null) {
            ref.add(new StringRefAddr("description", this.dataSourceDescription.toString()));
        }
        if (this.networkProtocol.get() != null) {
            ref.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
        }
        if (this.roleName != null) {
            ref.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.connectionFactoryClassName != null) {
            ref.add(new StringRefAddr("connectionFactoryClassName", this.connectionFactoryClassName));
        }
        if (this.connectionProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.pdbRoles != null && this.pdbRoles.size() > 0) {
            ref.add(new StringRefAddr("pdbRoles", this.pdbRoles.toString()));
        }
        if (this.connectionFactoryProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionFactoryProperties", this.connectionFactoryProperties.toString()));
        }
        if (this.validateConnectionOnBorrow.get().booleanValue()) {
            ref.add(new StringRefAddr("validateConnectionOnBorrow", "true"));
        }
        AutoProperty<String> autoProperty = this.sqlForValidateConnection;
        synchronized (autoProperty) {
            String str = this.sqlForValidateConnection.get();
            if (str != null) {
                ref.add(new StringRefAddr("sqlForValidateConnection", str));
            }
        }
        if (this.connectionPoolName != null) {
            ref.add(new StringRefAddr("connectionPoolName", this.connectionPoolName.get()));
        }
        ref.add(new StringRefAddr("initialPoolSize", this.initialPoolSize.toString()));
        ref.add(new StringRefAddr("minPoolSize", this.minPoolSize.toString()));
        ref.add(new StringRefAddr("maxPoolSize", this.maxPoolSize.toString()));
        ref.add(new StringRefAddr("abandonedConnectionTimeout", this.abandonedConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeToLiveConnectionTimeout", this.timeToLiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("inactiveConnectionTimeout", this.inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("maxIdleTime", this.inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeoutCheckInterval", this.timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("propertyCycle", this.timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("maxStatements", this.maxStatements.toString()));
        ref.add(new StringRefAddr("connectionWaitTimeout", this.connectionWaitTimeout.toString()));
        ref.add(new StringRefAddr("maxConnectionReuseTime", this.maxConnectionReuseTime.toString()));
        ref.add(new StringRefAddr("maxConnectionReuseCount", this.maxConnectionReuseCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestTriggerCount", this.connectionHarvestTriggerCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestMaxCount", this.connectionHarvestMaxCount.toString()));
        if (this.fastConnectionFailoverEnabled.get().booleanValue()) {
            ref.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        ref.add(new StringRefAddr("secondsToTrustIdleConnection", this.secondsToTrustIdleConnection.toString()));
        ref.add(new StringRefAddr("maxConnectionsPerService", String.valueOf(this.maxConnectionsPerService.toString())));
        ref.add(new StringRefAddr("loginTimeout", this.loginTimeout.toString()));
        ref.add(new StringRefAddr("maxConnectionsPerShard", this.maxConnectionsPerShard.toString()));
        ref.add(new StringRefAddr("connectionRepurposeThreshold", this.repurposeThreshold.toString()));
        if (this.onsConfiguration != null) {
            ref.add(new StringRefAddr("onsConfiguration", this.onsConfiguration));
        }
        if (this.isXmlUsed.get()) {
            ref.add(new StringRefAddr(UCP_IS_XML_USED_FOR_POOL_CONFIGURATION, "true"));
        }
        if (!this.shardingMode.get().booleanValue()) {
            ref.add(new StringRefAddr("shardingMode", "false"));
        }
        ref.add(new StringRefAddr("connectionValidationTimeout", this.connectionValidationTimeout.toString()));
        if (this.readOnlyInstanceAllowed.get().booleanValue()) {
            ref.add(new StringRefAddr("readOnlyInstanceAllowed", "true"));
        }
        return ref;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            this.getManager().destroyConnectionPool(this.connectionPoolName.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
        this.poolCreated = new AtomicBoolean(false);
        this.poolStarted = new AtomicBoolean(false);
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        String[] nvPair;
        String[] propStrs;
        Reference ref = (Reference)refObj;
        String cn = ref.getClassName();
        PoolDataSourceImpl pd = null;
        StringRefAddr ra = (StringRefAddr)ref.get("dataSourceFromConfiguration");
        if (cn.equals("oracle.ucp.jdbc.PoolDataSource") || cn.equals("oracle.ucp.jdbc.PoolDataSourceImpl")) {
            if (ra != null) {
                return PoolDataSourceFactory.getPoolDataSource((String)ra.getContent());
            }
            pd = new PoolDataSourceImpl();
        } else if (cn.equals("oracle.ucp.jdbc.PoolXADataSource") || cn.equals("oracle.ucp.jdbc.PoolXADataSourceImpl")) {
            if (ra != null) {
                return PoolDataSourceFactory.getPoolXADataSource((String)ra.getContent());
            }
            pd = new PoolXADataSourceImpl();
        }
        if (pd == null) {
            return null;
        }
        ra = (StringRefAddr)ref.get("user");
        if (ra != null) {
            pd.setUser((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("password")) != null) {
            pd.setPassword((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serviceName")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setServiceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("url")) != null) {
            pd.setURL((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serverName")) != null) {
            pd.setServerName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("portNumber")) != null) {
            pd.setPortNumber(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("databaseName")) != null) {
            pd.setDatabaseName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("dataSourceName")) != null) {
            pd.setDataSourceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("description")) != null) {
            pd.setDescription((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("networkProtocol")) != null) {
            pd.setNetworkProtocol((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("roleName")) != null) {
            pd.setRoleName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryClassName")) != null) {
            pd.setConnectionFactoryClassName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("pdbRoles")) != null && pd instanceof PoolDataSourceImpl) {
            String pdbRolesStr = (String)ra.getContent();
            Properties pdbRoleProps = new Properties();
            for (String onePropStr : propStrs = pdbRolesStr.substring(1, pdbRolesStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                pdbRoleProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setPdbRoles(pdbRoleProps);
        }
        if ((ra = (StringRefAddr)ref.get("connectionProperties")) != null) {
            String connPropsStr = (String)ra.getContent();
            Properties connProps = new Properties();
            for (String onePropStr : propStrs = connPropsStr.substring(1, connPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                connProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionProperties(connProps);
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryProperties")) != null) {
            String cfPropsStr = (String)ra.getContent();
            Properties cfProps = new Properties();
            for (String onePropStr : propStrs = cfPropsStr.substring(1, cfPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                cfProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionFactoryProperties(cfProps);
        }
        if ((ra = (StringRefAddr)ref.get("validateConnectionOnBorrow")) != null) {
            pd.setValidateConnectionOnBorrow(Boolean.parseBoolean((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("sqlForValidateConnection")) != null) {
            pd.setSQLForValidateConnection((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionPoolName")) != null) {
            pd.setConnectionPoolName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("initialPoolSize")) != null) {
            pd.setInitialPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("minPoolSize")) != null) {
            pd.setMinPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxPoolSize")) != null) {
            pd.setMaxPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("abandonedConnectionTimeout")) != null) {
            pd.setAbandonedConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeToLiveConnectionTimeout")) != null) {
            pd.setTimeToLiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("inactiveConnectionTimeout")) != null) {
            pd.setInactiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeoutCheckInterval")) != null) {
            pd.setTimeoutCheckInterval(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxStatements")) != null) {
            pd.setMaxStatements(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionWaitTimeout")) != null) {
            pd.setConnectionWaitTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseTime")) != null) {
            pd.setMaxConnectionReuseTime(Long.parseLong((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseCount")) != null) {
            pd.setMaxConnectionReuseCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestTriggerCount")) != null) {
            pd.setConnectionHarvestTriggerCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestMaxCount")) != null) {
            pd.setConnectionHarvestMaxCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("fastConnectionFailoverEnabled")) != null) {
            pd.setFastConnectionFailoverEnabled(Boolean.parseBoolean((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("onsConfiguration")) != null) {
            pd.setONSConfiguration((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("secondsToTrustIdleConnection")) != null) {
            pd.setSecondsToTrustIdleConnection(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionsPerService")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setMaxConnectionsPerService(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionsPerShard")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setMaxConnectionsPerShard(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionRepurposeThreshold")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setConnectionRepurposeThreshold(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("loginTimeout")) != null) {
            pd.setLoginTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("shardingMode")) != null) {
            pd.setShardingMode(Boolean.parseBoolean((String)ra.getContent()));
        }
        ra = (StringRefAddr)ref.get(UCP_IS_XML_USED_FOR_POOL_CONFIGURATION);
        boolean xmlUsed = false;
        if (ra != null && pd instanceof PoolDataSourceImpl) {
            xmlUsed = Boolean.parseBoolean((String)ra.getContent());
            pd.setXmlUsed(xmlUsed);
            UniversalConnectionPoolManager ucpMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
            boolean poolExists = Arrays.asList(ucpMgr.getConnectionPoolNames()).contains(pd.getConnectionPoolName());
            if (poolExists && ucpMgr.getConnectionPool(pd.getConnectionPoolName()).isShareable()) {
                pd.useExistingPool();
            }
        }
        if ((ra = (StringRefAddr)ref.get("connectionValidationTimeout")) != null) {
            pd.setConnectionValidationTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("readOnlyInstanceAllowed")) != null) {
            pd.setReadOnlyInstanceAllowed(Boolean.parseBoolean((String)ra.getContent()));
        }
        return pd;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        UCPErrorHandler.throwSQLException(62, null);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws SQLException {
        if (cbk == null) {
            throw new IllegalArgumentException("callback has to be non-null");
        }
        this.connectionInitializationCallback.set(cbk);
    }

    @Override
    public void unregisterConnectionInitializationCallback() throws SQLException {
        this.connectionInitializationCallback.set(null);
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        return this.connectionInitializationCallback.get();
    }

    @Override
    public int getConnectionLabelingHighCost() {
        return this.connectionLabelingHighCost.get();
    }

    @Override
    public void setConnectionLabelingHighCost(int highCost) throws SQLException {
        this.connectionLabelingHighCost.set(highCost);
    }

    @Override
    public int getConnectionRepurposeThreshold() {
        return this.repurposeThreshold.get();
    }

    @Override
    public void setConnectionRepurposeThreshold(int threshold) throws SQLException {
        this.repurposeThreshold.set(threshold);
    }

    @Override
    public int getHighCostConnectionReuseThreshold() {
        return this.highCostConnectionReuseThreshold.get();
    }

    @Override
    public void setHighCostConnectionReuseThreshold(int threshold) throws SQLException {
        this.highCostConnectionReuseThreshold.set(threshold);
    }

    private void setPdbRoles(Properties roles) {
        if (!this.allowSetter()) {
            return;
        }
        this.pdbRoles = new Properties();
        if (roles != null) {
            this.pdbRoles.putAll((Map<?, ?>)roles);
        }
    }

    @Override
    public Properties getPdbRoles() {
        if (this.pdbRoles == null) {
            return null;
        }
        Properties lPdbRoles = new Properties();
        lPdbRoles.putAll((Map<?, ?>)this.pdbRoles);
        return lPdbRoles;
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.secondsToTrustIdleConnection.get();
    }

    @Override
    public void setSecondsToTrustIdleConnection(int secondsToTrustIdleConnection) throws SQLException {
        this.secondsToTrustIdleConnection.set(secondsToTrustIdleConnection);
    }

    @Override
    public UCPConnectionBuilder createConnectionBuilder() {
        return new UCPConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Connection build() throws SQLException {
                return PoolDataSourceImpl.this.getConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(PoolDataSourceImpl.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getCanonicalName());
    }

    private void setXmlUsed(boolean isXmlUsed) {
        if (!this.allowSetter()) {
            return;
        }
        this.isXmlUsed.set(isXmlUsed);
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout.get();
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.queryTimeout.set(queryTimeout);
    }

    @Override
    public int getMaxConnectionsPerShard() {
        return this.maxConnectionsPerShard.get();
    }

    @Override
    public void setMaxConnectionsPerShard(int maxConnectionsPerShard) throws SQLException {
        this.maxConnectionsPerShard.set(maxConnectionsPerShard);
    }

    @Override
    public void setShardingMode(boolean shardingMode) throws SQLException {
        this.shardingMode.set(shardingMode);
    }

    @Override
    public boolean getShardingMode() {
        return this.shardingMode.get();
    }

    @Override
    public void setConnectionValidationTimeout(int connectionValidationTimeout) throws SQLException {
        this.connectionValidationTimeout.set(connectionValidationTimeout);
    }

    @Override
    public int getConnectionValidationTimeout() {
        return this.connectionValidationTimeout.get();
    }

    @Override
    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed.get();
    }

    @Override
    public void setReadOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) throws SQLException {
        this.readOnlyInstanceAllowed.set(readOnlyInstanceAllowed);
    }

    @Override
    public final void setTokenSupplier(Supplier<? extends AccessToken> tokenSupplier) throws SQLException {
        Objects.requireNonNull(tokenSupplier, "tokenSuplier is null");
        if (this.poolCreated.get()) {
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "tokenSupplier", tokenSupplier, true, true);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(81, e);
            }
            if (this.tokenSupplier != tokenSupplier) {
                this.refreshConnectionPool();
            }
        }
        this.tokenSupplier = tokenSupplier;
    }

    private void refreshConnectionPool() throws SQLException {
        assert (this.poolCreated.get()) : "poolCreated is false";
        try {
            this.connectionPool.refresh();
        }
        catch (UniversalConnectionPoolException e) {
            this.ilogFinest(null, null, null, null, "refresh pool failed with error : " + e.getMessage());
            try {
                this.connectionPool.stop();
                this.connectionPool.start();
            }
            catch (UniversalConnectionPoolException ex) {
                UCPErrorHandler.throwSQLException(22, ex);
            }
        }
    }

    @Log
    protected void ilogFinest(Logger logger, Class<?> cls, Executable method, Object receiver, String message) {
        PrintWriter writer;
        ClioSupport.ilogFinest(logger, cls, method, receiver, message);
        JDBCConnectionPool pool = this.connectionPool;
        if (null != pool && null != (writer = pool.getLogWriter())) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogFine(Logger logger, Class<?> cls, Executable method, Object receiver, String message) {
        PrintWriter writer;
        ClioSupport.ilogFine(logger, cls, method, receiver, message);
        JDBCConnectionPool pool = this.connectionPool;
        if (null != pool && null != (writer = pool.getLogWriter())) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogWarning(Logger logger, Class<?> cls, Executable method, Object receiver, String message) {
        PrintWriter writer;
        ClioSupport.ilogWarning(logger, cls, method, receiver, message);
        JDBCConnectionPool pool = this.connectionPool;
        if (null != pool && null != (writer = pool.getLogWriter())) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogSevere(Logger logger, Class<?> cls, Executable method, Object receiver, String message) {
        PrintWriter writer;
        ClioSupport.ilogSevere(logger, cls, method, receiver, message);
        JDBCConnectionPool pool = this.connectionPool;
        if (null != pool && null != (writer = pool.getLogWriter())) {
            writer.print(message);
        }
    }

    @Log
    protected void ilogThrowing(Logger logger, Class<?> cls, Executable method, Object receiver, Throwable throwable) {
        PrintWriter writer;
        ClioSupport.ilogThrowing(logger, cls, method, receiver, throwable);
        JDBCConnectionPool pool = this.connectionPool;
        if (null != pool && null != (writer = pool.getLogWriter())) {
            writer.print(throwable.getMessage());
        }
    }

    static {
        try {
            $$$methodRef$$$230 = PoolDataSourceImpl.class.getDeclaredConstructor(String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$230 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$229 = PoolDataSourceImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$229 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$228 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$newAutoProperty$30b58e8f$1", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$228 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$227 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$newAutoProperty$9a6ea6c8$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$227 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$226 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$newAutoProperty$ea73ebdb$1", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$226 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$225 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$b0fd7d42$1", AutoProperty.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$225 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$224 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$f4eaff91$1", AutoProperty.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$224 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$223 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$e8051522$1", AutoProperty.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$223 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$222 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$c528cfea$1", AutoProperty.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$222 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$221 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$e7ab9e76$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$221 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$220 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$70f6cf63$1", AutoProperty.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$220 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$219 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$eb3d0ef$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$219 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$218 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$c4ef75c7$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$218 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$217 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$4a9c46bb$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$217 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$216 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$decf73f9$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$216 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$215 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$3ad2deed$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$215 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$214 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$c2884927$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$214 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$213 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$1e8bb41b$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$213 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$212 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$80577fa9$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$212 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$211 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$1e148135$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$211 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$210 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$bf424903$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$210 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$209 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$e1c5178f$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$209 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$208 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$64a748d9$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$208 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$207 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$927e4bcd$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$207 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$206 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$e727dd10$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$206 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$205 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$10b0d04$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$205 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$204 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$58f8eb86$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$204 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$203 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$f2c9312$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$203 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$202 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$a6e3d1a0$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$202 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$201 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$fb84f94$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$201 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$200 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$25629a19$1", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$200 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$199 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$7599485a$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$199 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$198 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$85da924e$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$198 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$197 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$1e2e8c93$1", AutoProperty.class, Long.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$197 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$196 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$1616811f$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$196 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$195 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$8af8fbeb$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$195 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$194 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$900f98df$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$194 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$193 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$5f36bca1$1", AutoProperty.class, oracle.ucp.ConnectionLabelingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$193 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$192 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$81b98b2d$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$192 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$191 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$c6348927$1", AutoProperty.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$191 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$190 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$e8b757b3$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$190 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$189 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$2593fc6$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$189 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$188 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$167b55ba$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$188 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$187 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$4dfe8e72$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$187 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$186 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$67e1be66$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$186 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$185 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$aa9070b9$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$185 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$184 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$cefa6445$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$184 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$183 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$a16f07e0$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$183 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$182 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$9956fc6c$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$182 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$181 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$28c97eeb$1", AutoProperty.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$181 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$180 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$4d337277$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$180 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$179 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$41ec0c73$1", AutoProperty.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$179 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$178 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$560e2267$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$178 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$177 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$eb6ee36f$1", AutoProperty.class, ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$177 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$176 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$d60798fb$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$176 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$175 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$72958597$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$175 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$174 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$95185423$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$174 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$173 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$4db9a8e$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$173 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$172 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$ef74501a$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$172 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$171 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$536ed9b5$1", AutoProperty.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$171 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$170 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$d91baaa9$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$170 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$169 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$b131c32$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$169 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$168 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$f4e336be$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$168 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$167 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$bae79e82$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$167 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$166 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$47f0fa0e$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$166 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$165 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$81b165a$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$165 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$164 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$2c8509e6$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$164 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$163 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$7cae409e$1", AutoProperty.class, Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$163 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$162 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$aa854392$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$162 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$161 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$971275d7$1", AutoProperty.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$161 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$160 = PoolDataSourceImpl.class.getDeclaredMethod("lambda$new$9c2912cb$1", AutoProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$160 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$159 = PoolDataSourceImpl.class.getDeclaredMethod("$deserializeLambda$", SerializedLambda.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$159 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$158 = PoolDataSourceImpl.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$158 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$157 = PoolDataSourceImpl.class.getDeclaredMethod("ilogThrowing", Logger.class, Class.class, Executable.class, Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$157 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$156 = PoolDataSourceImpl.class.getDeclaredMethod("ilogSevere", Logger.class, Class.class, Executable.class, Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$156 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$155 = PoolDataSourceImpl.class.getDeclaredMethod("ilogWarning", Logger.class, Class.class, Executable.class, Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$155 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$154 = PoolDataSourceImpl.class.getDeclaredMethod("ilogFine", Logger.class, Class.class, Executable.class, Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$154 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$153 = PoolDataSourceImpl.class.getDeclaredMethod("ilogFinest", Logger.class, Class.class, Executable.class, Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$153 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$152 = PoolDataSourceImpl.class.getDeclaredMethod("refreshConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$152 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$151 = PoolDataSourceImpl.class.getDeclaredMethod("setTokenSupplier", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$151 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$150 = PoolDataSourceImpl.class.getDeclaredMethod("setReadOnlyInstanceAllowed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$150 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$149 = PoolDataSourceImpl.class.getDeclaredMethod("isReadOnlyInstanceAllowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$149 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$148 = PoolDataSourceImpl.class.getDeclaredMethod("getSSLContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$148 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$147 = PoolDataSourceImpl.class.getDeclaredMethod("setSSLContext", SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$147 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$146 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionValidationTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$145 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionValidationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$144 = PoolDataSourceImpl.class.getDeclaredMethod("getShardingMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$143 = PoolDataSourceImpl.class.getDeclaredMethod("setShardingMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$142 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxConnectionsPerShard", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$141 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxConnectionsPerShard", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$140 = PoolDataSourceImpl.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$139 = PoolDataSourceImpl.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$138 = PoolDataSourceImpl.class.getDeclaredMethod("setXmlUsed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$137 = PoolDataSourceImpl.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$136 = PoolDataSourceImpl.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$135 = PoolDataSourceImpl.class.getDeclaredMethod("setSecondsToTrustIdleConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$134 = PoolDataSourceImpl.class.getDeclaredMethod("getSecondsToTrustIdleConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$133 = PoolDataSourceImpl.class.getDeclaredMethod("getPdbRoles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$132 = PoolDataSourceImpl.class.getDeclaredMethod("setPdbRoles", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$131 = PoolDataSourceImpl.class.getDeclaredMethod("setHighCostConnectionReuseThreshold", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$130 = PoolDataSourceImpl.class.getDeclaredMethod("getHighCostConnectionReuseThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$129 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionRepurposeThreshold", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$128 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionRepurposeThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$127 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionLabelingHighCost", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$126 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionLabelingHighCost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$125 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$124 = PoolDataSourceImpl.class.getDeclaredMethod("unregisterConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$123 = PoolDataSourceImpl.class.getDeclaredMethod("registerConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$122 = PoolDataSourceImpl.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$121 = PoolDataSourceImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$120 = PoolDataSourceImpl.class.getDeclaredMethod("getObjectInstance", Object.class, Name.class, Context.class, Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$119 = PoolDataSourceImpl.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$118 = PoolDataSourceImpl.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$117 = PoolDataSourceImpl.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$116 = PoolDataSourceImpl.class.getDeclaredMethod("toBasicType", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$115 = PoolDataSourceImpl.class.getDeclaredMethod("setURLProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$114 = PoolDataSourceImpl.class.getDeclaredMethod("setSpecialProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$113 = PoolDataSourceImpl.class.getDeclaredMethod("setProperty", Object.class, String.class, Object.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$112 = PoolDataSourceImpl.class.getDeclaredMethod("initConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$111 = PoolDataSourceImpl.class.getDeclaredMethod("isSetOnceProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$110 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionFactoryProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$109 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionFactoryProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$108 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionFactoryProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$107 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionFactoryProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$106 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$105 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$104 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$103 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$102 = PoolDataSourceImpl.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$101 = PoolDataSourceImpl.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$100 = PoolDataSourceImpl.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$99 = PoolDataSourceImpl.class.getDeclaredMethod("removeConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$98 = PoolDataSourceImpl.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$97 = PoolDataSourceImpl.class.getDeclaredMethod("removeConnectionLabelingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$96 = PoolDataSourceImpl.class.getDeclaredMethod("registerConnectionLabelingCallback", oracle.ucp.ConnectionLabelingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$95 = PoolDataSourceImpl.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$94 = PoolDataSourceImpl.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$93 = PoolDataSourceImpl.class.getDeclaredMethod("getBorrowedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$92 = PoolDataSourceImpl.class.getDeclaredMethod("getAvailableConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$91 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxConnectionReuseCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$90 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxConnectionReuseCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$89 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxConnectionReuseTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$88 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxConnectionReuseTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$87 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionHarvestMaxCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$86 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionHarvestMaxCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$85 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionHarvestTriggerCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$84 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionHarvestTriggerCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$83 = PoolDataSourceImpl.class.getDeclaredMethod("getSQLForValidateConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$82 = PoolDataSourceImpl.class.getDeclaredMethod("setSQLForValidateConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$81 = PoolDataSourceImpl.class.getDeclaredMethod("getValidateConnectionOnBorrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$80 = PoolDataSourceImpl.class.getDeclaredMethod("setValidateConnectionOnBorrow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$79 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionPoolName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$78 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionPoolName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$77 = PoolDataSourceImpl.class.getDeclaredMethod("getPropertyCycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$76 = PoolDataSourceImpl.class.getDeclaredMethod("setPropertyCycle", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$75 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxIdleTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$74 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxIdleTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$73 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$72 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$71 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionFactoryClassName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$70 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionFactoryClassName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$69 = PoolDataSourceImpl.class.getDeclaredMethod("getFastConnectionFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$68 = PoolDataSourceImpl.class.getDeclaredMethod("setFastConnectionFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$67 = PoolDataSourceImpl.class.getDeclaredMethod("getTimeoutCheckInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$66 = PoolDataSourceImpl.class.getDeclaredMethod("setTimeoutCheckInterval", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$65 = PoolDataSourceImpl.class.getDeclaredMethod("setAbandonedConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$64 = PoolDataSourceImpl.class.getDeclaredMethod("getAbandonedConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$63 = PoolDataSourceImpl.class.getDeclaredMethod("getTimeToLiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$62 = PoolDataSourceImpl.class.getDeclaredMethod("setTimeToLiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$61 = PoolDataSourceImpl.class.getDeclaredMethod("getConnectionWaitTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$60 = PoolDataSourceImpl.class.getDeclaredMethod("setConnectionWaitTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$59 = PoolDataSourceImpl.class.getDeclaredMethod("getInactiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$58 = PoolDataSourceImpl.class.getDeclaredMethod("setInactiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$57 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxConnectionsPerService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$56 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxConnectionsPerService", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$55 = PoolDataSourceImpl.class.getDeclaredMethod("getMaxPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$54 = PoolDataSourceImpl.class.getDeclaredMethod("setMaxPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$53 = PoolDataSourceImpl.class.getDeclaredMethod("getMinPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$52 = PoolDataSourceImpl.class.getDeclaredMethod("setMinPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$51 = PoolDataSourceImpl.class.getDeclaredMethod("getInitialPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = PoolDataSourceImpl.class.getDeclaredMethod("setInitialPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = PoolDataSourceImpl.class.getDeclaredMethod("getRoleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = PoolDataSourceImpl.class.getDeclaredMethod("setRoleName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = PoolDataSourceImpl.class.getDeclaredMethod("getNetworkProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = PoolDataSourceImpl.class.getDeclaredMethod("setNetworkProtocol", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = PoolDataSourceImpl.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = PoolDataSourceImpl.class.getDeclaredMethod("setDescription", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = PoolDataSourceImpl.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = PoolDataSourceImpl.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = PoolDataSourceImpl.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = PoolDataSourceImpl.class.getDeclaredMethod("setDatabaseName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = PoolDataSourceImpl.class.getDeclaredMethod("getPortNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = PoolDataSourceImpl.class.getDeclaredMethod("setPortNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = PoolDataSourceImpl.class.getDeclaredMethod("getServerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = PoolDataSourceImpl.class.getDeclaredMethod("setServerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = PoolDataSourceImpl.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = PoolDataSourceImpl.class.getDeclaredMethod("getURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = PoolDataSourceImpl.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = PoolDataSourceImpl.class.getDeclaredMethod("getPasswordInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = PoolDataSourceImpl.class.getDeclaredMethod("getPasswordReal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = PoolDataSourceImpl.class.getDeclaredMethod("setUser", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = PoolDataSourceImpl.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = PoolDataSourceImpl.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = PoolDataSourceImpl.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = PoolDataSourceImpl.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = PoolDataSourceImpl.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = PoolDataSourceImpl.class.getDeclaredMethod("getConnection", UCPConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = PoolDataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = PoolDataSourceImpl.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = PoolDataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = PoolDataSourceImpl.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = PoolDataSourceImpl.class.getDeclaredMethod("createUniversalConnectionPoolMBean", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = PoolDataSourceImpl.class.getDeclaredMethod("getPasswordFromWallet", String.class, String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = PoolDataSourceImpl.class.getDeclaredMethod("getPasswordFromPoolElement", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = PoolDataSourceImpl.class.getDeclaredMethod("reconfigureDataSource", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = PoolDataSourceImpl.class.getDeclaredMethod("applyPoolProperties", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = PoolDataSourceImpl.class.getDeclaredMethod("applyDataSourcProperties", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = PoolDataSourceImpl.class.getDeclaredMethod("allowSetter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = PoolDataSourceImpl.class.getDeclaredMethod("createPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = PoolDataSourceImpl.class.getDeclaredMethod("createSharedPoolFromXml", String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = PoolDataSourceImpl.class.getDeclaredMethod("createUniversalConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = PoolDataSourceImpl.class.getDeclaredMethod("useExistingPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = PoolDataSourceImpl.class.getDeclaredMethod("createPoolWithDefaultProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = PoolDataSourceImpl.class.getDeclaredMethod("startPool", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = PoolDataSourceImpl.class.getDeclaredMethod("startPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = PoolDataSourceImpl.class.getDeclaredMethod("getManagerMBean", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = PoolDataSourceImpl.class.getDeclaredMethod("getManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = PoolDataSourceImpl.class.getDeclaredMethod("setConfigureNewDataSource", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = PoolDataSourceImpl.class.getDeclaredMethod("newAutoProperty", Object.class, AutoPropertySetter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = PoolDataSourceImpl.class.getDeclaredMethod("newAutoProperty", Object.class, AutoPropertySetter.class, AutoPropertyGetter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = PoolDataSourceImpl.class.getDeclaredMethod("newAutoProperty", Object.class, AutoPropertySetter.class, AutoPropertyGetter.class, AutoPropertyValidator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
    }

    @DisableTrace
    class AutoProperty<T>
    implements Serializable {
        private static final long serialVersionUID = 4343640747504L;
        private T value;
        private Integer errcode = 22;
        private final AutoPropertySetter<T> setter;
        private final AutoPropertyGetter<T> getter;
        private final AutoPropertyValidator<T> validator;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        AutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter, AutoPropertyValidator<T> validator) {
            this.value = value;
            this.errcode = this.errcode;
            this.setter = setter;
            this.getter = getter;
            this.validator = validator;
            PoolDataSourceImpl.this.autoProperties.add(this);
        }

        synchronized void set(T value) throws SQLException {
            if (!PoolDataSourceImpl.this.allowSetter()) {
                return;
            }
            this.internalSet(value);
        }

        synchronized void internalSet(T value) throws SQLException {
            if (!this.validator.test(value)) {
                UCPErrorHandler.throwSQLException(22, null);
            }
            try {
                if (PoolDataSourceImpl.this.poolCreated.get()) {
                    this.setter.set(this, value);
                }
                this.value = value;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(this.errcode, e);
            }
        }

        synchronized void set() throws SQLException {
            this.set(this.value);
        }

        synchronized T get() {
            return PoolDataSourceImpl.this.poolCreated.get() ? this.getter.get(this) : this.value;
        }

        @DisableTrace
        public String toString() {
            return null != this.value ? this.value.toString() : "null";
        }

        static {
            try {
                $$$methodRef$$$5 = AutoProperty.class.getDeclaredConstructor(PoolDataSourceImpl.class, Object.class, AutoPropertySetter.class, AutoPropertyGetter.class, AutoPropertyValidator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = AutoProperty.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = AutoProperty.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = AutoProperty.class.getDeclaredMethod("set", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = AutoProperty.class.getDeclaredMethod("internalSet", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = AutoProperty.class.getDeclaredMethod("set", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    @FunctionalInterface
    private static interface AutoPropertyValidator<T>
    extends Serializable {
        public boolean test(T var1);
    }

    @FunctionalInterface
    private static interface AutoPropertyGetter<T>
    extends Serializable {
        public T get(AutoProperty<T> var1);
    }

    @FunctionalInterface
    private static interface AutoPropertySetter<T>
    extends Serializable {
        public void set(AutoProperty<T> var1, T var2) throws Exception;
    }
}

