/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public final class SelectorsUtil {
    static final String CLASS_NAME = SelectorsUtil.class.getName();
    public static final Predicate<CoreConnection> availableSelector = conn -> conn.available();
    public static final Predicate<CoreConnection> notAvailableSelector = availableSelector.negate();
    public static final Predicate<CoreConnection> normalSelector = conn -> conn.normal();
    public static final Predicate<CoreConnection> notNormalSelector = normalSelector.negate();
    public static final Predicate<CoreConnection> badSelector = conn -> conn.closed() || conn.bad();
    public static final Predicate<CoreConnection> notBadSelector = badSelector.negate();
    public static final Predicate<CoreConnection> reconnectingSelector = conn -> conn.reconnecting();
    public static final Predicate<CoreConnection> notReconnectingSelector = reconnectingSelector.negate();

    public static Predicate<CoreConnection> criMatchSelector(ConnectionRetrievalInfo cri) {
        return conn -> conn.cri().equalsIncludingPassword(cri);
    }

    public static Predicate<CoreConnection> criUnmatchSelector(ConnectionRetrievalInfo cri) {
        return SelectorsUtil.criMatchSelector(cri).negate();
    }

    public static Predicate<CoreConnection> physicalSelector(Object physicalConn) {
        return conn -> physicalConn == ((UniversalPooledConnection)conn.getDelegate()).getPhysicalConnection();
    }

    public static Predicate<CoreConnection> perfectCostSelector(Properties labels) {
        return conn -> 0 == ((UniversalPooledConnection)conn.getDelegate()).labelingCost(labels);
    }

    public static Predicate<CoreConnection> wrongCostSelector(Properties labels) {
        return conn -> Integer.MAX_VALUE == ((UniversalPooledConnection)conn.getDelegate()).labelingCost(labels);
    }

    public static Predicate<CoreConnection> harvestableSelector() {
        return conn -> ((UniversalPooledConnection)conn.getDelegate()).isConnectionHarvestable();
    }

    public static Predicate<CoreConnection> inactiveSelector(long inactivityTimeout) {
        Predicate<CoreConnection> inactive = conn -> {
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            return Clock.clock() - inactivityTimeout >= upc.getAvailableStartTime();
        };
        return availableSelector.and(inactive);
    }

    public static Predicate<CoreConnection> abandonedSelector(long abandonedTimeout) {
        Predicate<CoreConnection> abandoned = conn -> {
            AbandonedConnectionTimeoutCallback cbkOnThisConn;
            long now = Clock.clock();
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                return false;
            }
            if (upc.getLastAccessedTime() > now - abandonedTimeout || upc.isSqlWithQueryTimeoutInProgress()) {
                return false;
            }
            try {
                cbkOnThisConn = upc.getAbandonedConnectionTimeoutCallback();
            }
            catch (UniversalConnectionPoolException e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "abandonedConnectionsSelector", "unable to get abandoned connection timeout callback", null, null, new Object[0]);
                return false;
            }
            return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
        };
        return notAvailableSelector.and(SelectorsUtil.harvestableSelector()).and(abandoned);
    }

    public static Predicate<CoreConnection> ttlSelector(long TTLTimeout) {
        Predicate<CoreConnection> abandoned = conn -> {
            TimeToLiveConnectionTimeoutCallback cbkOnThisConn;
            long now = Clock.clock();
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                return false;
            }
            if (upc.getBorrowedStartTime() > now - TTLTimeout) {
                return false;
            }
            try {
                cbkOnThisConn = upc.getTimeToLiveConnectionTimeoutCallback();
            }
            catch (UniversalConnectionPoolException e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ttlConnectionsSelector", "unable to get time-to-live connection timeout callback", null, null, new Object[0]);
                return false;
            }
            return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
        };
        return notAvailableSelector.and(SelectorsUtil.harvestableSelector()).and(abandoned);
    }
}

