/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.util.concurrent.atomic.AtomicReference;
import oracle.ucp.common.waitfreepool.PoolIterator;

final class PoolIteratorQueue<T> {
    private final AtomicReference<Element> listHead = new AtomicReference<Element>(new Element(null));
    private final AtomicReference<Element> listTail = new AtomicReference<Element>(this.listHead.get());

    PoolIteratorQueue() {
    }

    void enqueue(PoolIterator<T> poolIterator) {
        this.skipToFirstActive();
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element newElement = new Element(poolIterator);
        Element element = this.listTail.get();
        while (true) {
            if (element.next.compareAndSet(null, newElement)) {
                this.listTail.set(newElement);
                return;
            }
            element = element.next.get();
        }
    }

    boolean peek(PoolIterator<T> poolIterator) {
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = this.skipToFirstActive();
        PoolIterator pi = element.poolIterator.get();
        if (null == pi) {
            return true;
        }
        return poolIterator == pi;
    }

    void disable(PoolIterator<T> poolIterator) {
        Element elm = this.listHead.get();
        while (null != elm) {
            if (elm.poolIterator.compareAndSet(poolIterator, null)) {
                return;
            }
            elm = elm.next.get();
        }
        throw new IllegalArgumentException("no poolIterator in a queue");
    }

    private Element skipToFirstActive() {
        Element nextElement;
        PoolIterator i;
        Element element = this.listHead.get();
        while (true) {
            if ((i = element.poolIterator.get()) != null) {
                if (i.isAlive()) break;
                element.poolIterator.set(null);
            }
            if ((nextElement = element.next.get()) == null) break;
            element = nextElement;
        }
        this.listHead.set(element);
        while (((i = element.poolIterator.get()) == null || i.isSleeping()) && (nextElement = element.next.get()) != null) {
            element = nextElement;
        }
        return element;
    }

    private final class Element {
        final AtomicReference<PoolIterator<T>> poolIterator;
        final AtomicReference<Element> next = new AtomicReference<Object>(null);

        Element(PoolIterator<T> poolIterator) {
            this.poolIterator = new AtomicReference(poolIterator);
        }
    }
}

