/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import oracle.ucp.util.Chain;

public class MapChain<T>
implements Chain<T> {
    private final ConcurrentMap<Long, Atom> map = new ConcurrentHashMap<Long, Atom>();
    private final AtomicLong index = new AtomicLong();

    public Atom add(T data) {
        long key = this.index.incrementAndGet();
        Atom atom = new Atom(key, data);
        this.map.put(key, atom);
        return atom;
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        this.map.values().forEach((? super T p) -> consumer.accept(p.data));
    }

    @Override
    public List<T> toList() {
        ArrayList list = new ArrayList();
        this.map.values().forEach((? super T p) -> list.add(p.data));
        return list;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public class Atom
    implements Chain.Atom<T> {
        private final long key;
        private final T data;

        private Atom(long key, T data) {
            this.key = key;
            this.data = data;
        }

        private Atom(long key) {
            this(key, null);
        }

        @Override
        public T getData() {
            return this.data;
        }

        @Override
        public void remove() {
            MapChain.this.map.remove(this.key);
        }
    }
}

