/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlException;

public class AQxmlError {
    private SimpleDateFormat printdateformat;
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ResourceBundle bundle;
    public static final int START_AQXML_ERROR = 400;
    public static final int DEST_NAME_NULL = 400;
    public static final int INTERNAL_ERROR = 401;
    public static final int CLASS_NOT_FOUND = 402;
    public static final int IO_EXCEPTION = 403;
    public static final int XMLPARSE_EXCEPTION = 404;
    public static final int SAX_EXCEPTION = 405;
    public static final int JMS_EXCEPTION = 406;
    public static final int INVALID_OPERATION = 407;
    public static final int CONVERSION_FAILED = 408;
    public static final int NO_SUCH_ELEMENT = 409;
    public static final int SQL_EXCEPTION = 410;
    public static final int INVALID_BODY = 411;
    public static final int BYTE_CONV_FAILED = 412;
    public static final int AUTOCOM_NOT_ALLOWED = 413;
    public static final int DEST_OWNER_NULL = 414;
    public static final int INVALID_VISIBILITY = 415;
    public static final int INVALID_DEQ_MODE = 416;
    public static final int INVALID_NAVIG_MODE = 417;
    public static final int INVALID_WAIT_TIME = 418;
    public static final int INVALID_POOL_DS = 419;
    public static final int INVALID_CACHE_SIZE = 420;
    public static final int INVALID_CACHE_SCHEME = 421;
    public static final int INVALID_TAG = 422;
    public static final int INVALID_VALUE = 423;
    public static final int INVALID_MSG_HEADER = 424;
    public static final int PROP_NAME_NULL = 425;
    public static final int INVALID_PROPERTY = 426;
    public static final int INVALID_CONSUMER = 427;
    public static final int MESSAGE_NULL = 428;
    public static final int REGISTER_OPTION_NULL = 429;
    public static final int DBLINK_NULL = 430;
    public static final int SEQ_NUM_NULL = 431;
    public static final int STATUS_NULL = 432;
    public static final int USER_NOT_AUTHENTICATED = 433;
    public static final int INVALID_DATA_SRC = 434;
    public static final int INVALID_SCHEMA_LOC = 435;
    public static final int AQ_EXCEPTION = 436;
    public static final int INVALID_DESTINATION = 437;
    public static final int AGENT_NOT_MAPPED = 438;
    public static final int INVALID_SCHEMA = 439;
    public static final int MULTI_DB_USER = 440;
    public static final int NULL_VALUE = 441;
    public static final int NAMEADDRESS_NULL = 442;
    public static final int IMMED_VISIB_NOT_ALLOWED = 443;
    public static final int FEATURE_NOT_SUPPORTED = 444;
    public static final int DEST_ALIAS_NULL = 445;
    public static final int AGENT_ALIAS_NULL = 446;
    public static final int NAMING_EXCEPTION = 447;
    public static final int INVALID_CONTENT_TYPE = 448;

    public AQxmlError() {
        this.printdateformat = new SimpleDateFormat("EE MMM dd HH:mm:ss.SSS zz yyyy  ");
    }

    static String getMessage(int error_num, Object[] args) {
        if (error_num < 400) {
            return AQxmlError.getJmsMessage(Integer.toString(error_num), args);
        }
        return AQxmlError.getXmlMessage(Integer.toString(error_num), args);
    }

    static String getJmsMessage(String key, Object[] args) {
        Object ret_str = null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.jakarta.jms.AQjmsMessages");
        }
        try {
            if (args == null) {
                args = new String[]{"", ""};
            }
            ret_str = MessageFormat.format(bundle.getString(key), args);
            ret_str = "JMS-" + key + ": " + (String)ret_str;
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(5, "AQxmlError.getMessage", ex);
            ret_str = "Message [" + key + "] not found in 'AQjmsMessages'.";
        }
        return ret_str;
    }

    static String getXmlMessage(String key, Object[] args) {
        Object ret_str = null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.jakarta.AQ.xml.AQxmlMessages");
        }
        try {
            if (args == null) {
                args = new String[]{"", ""};
            }
            ret_str = MessageFormat.format(bundle.getString(key), args);
            ret_str = "JMS-" + key + ": " + (String)ret_str;
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(5, "AQxmlError.getMessage", ex);
            ret_str = "Message [" + key + "] not found in 'AQjmsMessages'.";
        }
        return ret_str;
    }

    public static void throwAQEx(int aq_error_code) throws AQxmlException {
        String msg = null;
        msg = AQxmlError.getMessage(aq_error_code, null);
        throw new AQxmlException(aq_error_code, msg);
    }

    public static void throwAQEx(int aq_error_code, Exception linked_ex) throws AQxmlException {
        String msg = null;
        msg = AQxmlError.getMessage(aq_error_code, null);
        throw new AQxmlException(aq_error_code, msg, linked_ex);
    }

    public static void throwAQEx(int aq_error_code, String arg1) throws AQxmlException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1};
        msg = AQxmlError.getMessage(aq_error_code, args);
        throw new AQxmlException(aq_error_code, msg);
    }

    public static void throwAQEx(int aq_error_code, String arg1, Exception linked_ex) throws AQxmlException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1};
        msg = AQxmlError.getMessage(aq_error_code, args);
        throw new AQxmlException(aq_error_code, msg, linked_ex);
    }

    static void throwXMLEx(String reason, String sqlstate, int vendorcode) throws AQxmlException {
        SQLException sql_ex = new SQLException(reason, sqlstate, vendorcode);
        AQxmlError.throwAQEx(410, sql_ex);
    }

    static void throwAQEx(int aq_error_code, String arg1, String arg2, Exception linked_ex) throws AQxmlException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, arg2 == null ? "" : arg2};
        msg = AQxmlError.getMessage(aq_error_code, args);
        throw new AQxmlException(aq_error_code, msg, linked_ex);
    }
}

