/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import oracle.jakarta.AQ.xml.AQxmlAdtMessage;
import oracle.jakarta.AQ.xml.AQxmlAgent;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitResponse;
import oracle.jakarta.AQ.xml.AQxmlConsumerOption;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlEnqueueRequest;
import oracle.jakarta.AQ.xml.AQxmlEnqueueResponse;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlGenUtil;
import oracle.jakarta.AQ.xml.AQxmlJmsBytesMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMapMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsObjectMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsTextMessage;
import oracle.jakarta.AQ.xml.AQxmlMessage;
import oracle.jakarta.AQ.xml.AQxmlMessageHeader;
import oracle.jakarta.AQ.xml.AQxmlMessagePropertyList;
import oracle.jakarta.AQ.xml.AQxmlProducerOption;
import oracle.jakarta.AQ.xml.AQxmlPublishRequest;
import oracle.jakarta.AQ.xml.AQxmlPublishResponse;
import oracle.jakarta.AQ.xml.AQxmlPushRequest;
import oracle.jakarta.AQ.xml.AQxmlPushResponse;
import oracle.jakarta.AQ.xml.AQxmlRawMessage;
import oracle.jakarta.AQ.xml.AQxmlReceiveRequest;
import oracle.jakarta.AQ.xml.AQxmlReceiveResponse;
import oracle.jakarta.AQ.xml.AQxmlRegisterOption;
import oracle.jakarta.AQ.xml.AQxmlRegisterRequest;
import oracle.jakarta.AQ.xml.AQxmlRegisterResponse;
import oracle.jakarta.AQ.xml.AQxmlRollbackRequest;
import oracle.jakarta.AQ.xml.AQxmlRollbackResponse;
import oracle.jakarta.AQ.xml.AQxmlSendRequest;
import oracle.jakarta.AQ.xml.AQxmlSendResponse;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumRequest;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumResponse;
import oracle.jakarta.AQ.xml.AQxmlServerResponse;
import oracle.jakarta.AQ.xml.AQxmlStatusResponse;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoRequest;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoResponse;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesResponse;
import oracle.jakarta.AQ.xml.StreamsSetupQueueResponse;
import oracle.jakarta.AQ.xml.StreamsStartApplyResponse;
import oracle.jakarta.AQ.xml.StreamsStartCaptureResponse;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class AQxmlGenerator {
    AQxmlGenerator() {
    }

    void generateDOMDocument(Document response_doc, AQxmlDocument aqxml_doc, Node body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.generateDOMDocument", "entry");
        Node idap_body_node = body_node;
        if (aqxml_doc instanceof AQxmlClientRequest) {
            if (aqxml_doc instanceof AQxmlEnqueueRequest) {
                if (aqxml_doc instanceof AQxmlPublishRequest) {
                    this.genPublishRequestXml(response_doc, (AQxmlPublishRequest)aqxml_doc, idap_body_node);
                } else if (aqxml_doc instanceof AQxmlSendRequest) {
                    this.genSendRequestXml(response_doc, (AQxmlSendRequest)aqxml_doc, idap_body_node);
                } else if (aqxml_doc instanceof AQxmlPushRequest) {
                    this.genPushRequestXml(response_doc, (AQxmlPushRequest)aqxml_doc, idap_body_node);
                }
            } else if (aqxml_doc instanceof AQxmlReceiveRequest) {
                this.genReceiveRequestXml(response_doc, (AQxmlReceiveRequest)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlRegisterRequest) {
                this.genRegisterRequestXml(response_doc, (AQxmlRegisterRequest)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlCommitRequest) {
                this.genCommitRequestXml(response_doc, (AQxmlCommitRequest)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlRollbackRequest) {
                this.genRollbackRequestXml(response_doc, (AQxmlRollbackRequest)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlSequenceNumRequest) {
                this.genSequenceNumRequestXml(response_doc, (AQxmlSequenceNumRequest)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlTypeInfoRequest) {
                this.genTypeInfoRequestXml(response_doc, (AQxmlTypeInfoRequest)aqxml_doc, idap_body_node);
            }
        } else if (aqxml_doc instanceof AQxmlServerResponse) {
            if (aqxml_doc instanceof AQxmlCommitResponse) {
                this.genCommitResponseXml(response_doc, (AQxmlCommitResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlEnqueueResponse) {
                if (aqxml_doc instanceof AQxmlPublishResponse) {
                    this.genPublishResponseXml(response_doc, (AQxmlPublishResponse)aqxml_doc, idap_body_node);
                } else if (aqxml_doc instanceof AQxmlPushResponse) {
                    this.genPushResponseXml(response_doc, (AQxmlPushResponse)aqxml_doc, idap_body_node);
                } else if (aqxml_doc instanceof AQxmlSendResponse) {
                    this.genSendResponseXml(response_doc, (AQxmlSendResponse)aqxml_doc, idap_body_node);
                }
            } else if (aqxml_doc instanceof AQxmlReceiveResponse) {
                this.genReceiveResponseXml(response_doc, (AQxmlReceiveResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlRegisterResponse) {
                this.genRegisterResponseXml(response_doc, (AQxmlRegisterResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlRollbackResponse) {
                this.genRollbackResponseXml(response_doc, (AQxmlRollbackResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlSequenceNumResponse) {
                this.genSequenceNumResponseXml(response_doc, (AQxmlSequenceNumResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof AQxmlTypeInfoResponse) {
                this.genTypeInfoResponseXml(response_doc, (AQxmlTypeInfoResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof StreamsSetupQueueResponse) {
                this.genSetupQueueResponseXml(response_doc, (StreamsSetupQueueResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof StreamsStartCaptureResponse) {
                this.genStartCaptureResponseXml(response_doc, (StreamsStartCaptureResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof StreamsStartApplyResponse) {
                this.genStartApplyResponseXml(response_doc, (StreamsStartApplyResponse)aqxml_doc, idap_body_node);
            } else if (aqxml_doc instanceof StreamsAddTableRulesResponse) {
                this.genAddTableRulesResponseXml(response_doc, (StreamsAddTableRulesResponse)aqxml_doc, idap_body_node);
            }
        } else {
            AQxmlDebug.trace(3, "AQxmlGenerator.generateDOMDocument", "Invalid class: " + aqxml_doc.getClass().getName());
            AQxmlError.throwAQEx(401, "Invalid class: " + aqxml_doc.getClass().getName());
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.generateDOMDocument", "exit");
    }

    Node genClientRequestXml(Document doc, AQxmlClientRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        XMLElement elem = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genClientRequestXml", "entry");
        if (aqxml_doc.tag_name == null) {
            AQxmlError.throwAQEx(401, "Tag name: null");
        }
        elem = new XMLElement(aqxml_doc.tag_name, "", "http://ns.oracle.com/AQ/schemas/access");
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ns.oracle.com/AQ/schemas/access");
        if (idap_body_node == null) {
            AQxmlError.throwAQEx(401, "Idap Body Node: Null");
        }
        idap_body_node.appendChild((Node)elem);
        AQxmlDebug.trace(4, "AQxmlGenerator.genClientRequestXml", "exit");
        return elem;
    }

    void genEnqueueRequestXml(Document doc, AQxmlEnqueueRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node er_root_node = null;
        Element mset_node = null;
        Element mcount_node = null;
        Text mcount_text = null;
        int num = 0;
        Object nl = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genEnqueueRequestXml", "entry");
        er_root_node = this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        this.genProducerOptionXml(doc, aqxml_doc.prod_opt, er_root_node);
        mset_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_set");
        er_root_node.appendChild(mset_node);
        mcount_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_count");
        mset_node.appendChild(mcount_node);
        num = aqxml_doc.xml_msg_set.size();
        mcount_text = doc.createTextNode(String.valueOf(num));
        mcount_node.appendChild(mcount_text);
        for (int i = 0; i < num; ++i) {
            this.genCompleteMessageXml(doc, (AQxmlMessage)aqxml_doc.xml_msg_set.elementAt(i), mset_node, i + 1);
        }
        if (aqxml_doc.getAutoCommit()) {
            this.genAutoCommitXml(doc, er_root_node);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genEnqueueRequestXml", "exit");
    }

    void genSendRequestXml(Document doc, AQxmlSendRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genSendRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlSend");
        this.genEnqueueRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genSendRequestXml", "exit");
    }

    void genPublishRequestXml(Document doc, AQxmlPublishRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genPublishRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlPublish");
        this.genEnqueueRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genPublishRequestXml", "exit");
    }

    void genPushRequestXml(Document doc, AQxmlPushRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlError.throwAQEx(401, "not implemented yet...");
    }

    void genReceiveRequestXml(Document doc, AQxmlReceiveRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node recv_node = null;
        AQxmlDebug.trace(4, "AQxmlConverter.genReceiveRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlReceive");
        recv_node = this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        this.genConsumerOptionXml(doc, aqxml_doc.getConsumerOption(), recv_node);
        if (aqxml_doc.getAutoCommit()) {
            this.genAutoCommitXml(doc, recv_node);
        }
        AQxmlDebug.trace(4, "AQxmlConverter.genReceiveRequestXml", "exit");
    }

    void genRegisterRequestXml(Document doc, AQxmlRegisterRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node reg_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlRegister");
        reg_node = this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        this.genRegisterOptionXml(doc, aqxml_doc.getRegisterOption(), reg_node);
        if (aqxml_doc.getAutoCommit()) {
            this.genAutoCommitXml(doc, reg_node);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterRequestXml", "exit");
    }

    void genCommitRequestXml(Document doc, AQxmlCommitRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genCommitRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlCommit");
        this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genCommitRequestXml", "exit");
    }

    void genRollbackRequestXml(Document doc, AQxmlRollbackRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genRollbackRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlRollback");
        this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genRollbackRequestXml", "exit");
    }

    void genSequenceNumRequestXml(Document doc, AQxmlSequenceNumRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Object com_elem = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genSequenceNumRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlSequenceNumber");
        Node seqNumNode = this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        Element queueNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        seqNumNode.appendChild(queueNode);
        Text queueTextNode = doc.createTextNode(aqxml_doc.getDestination());
        queueNode.appendChild(queueTextNode);
        Element dbNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "database_link");
        seqNumNode.appendChild(dbNode);
        Text dbTextNode = doc.createTextNode(aqxml_doc.getDatabaseLink());
        dbNode.appendChild(dbTextNode);
        Element qidNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "source_qid");
        seqNumNode.appendChild(qidNode);
        String qid = aqxml_doc.getQid();
        Text qidTextNode = doc.createTextNode(String.valueOf(qid));
        qidNode.appendChild(qidTextNode);
        if (aqxml_doc.getAutoCommit()) {
            this.genAutoCommitXml(doc, seqNumNode);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genSequenceNumRequestXml", "exit");
    }

    void genTypeInfoRequestXml(Document doc, AQxmlTypeInfoRequest aqxml_doc, Node idap_body_node) throws AQxmlException {
        Object com_elem = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genTypeInfoRequestXml", "entry");
        aqxml_doc.setTagName("AQXmlQueueTypeInfo");
        Node queueTypeReqNode = this.genClientRequestXml(doc, aqxml_doc, idap_body_node);
        Element destinationNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        queueTypeReqNode.appendChild(destinationNode);
        Text destTextNode = doc.createTextNode(aqxml_doc.getQueue());
        destinationNode.appendChild(destTextNode);
        if (aqxml_doc.getAutoCommit()) {
            this.genAutoCommitXml(doc, queueTypeReqNode);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genTypeInfoRequestXml", "exit");
    }

    Node genServerResponseXml(Document doc, AQxmlServerResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        XMLElement elem = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genServerResponseXml", "entry");
        if (aqxml_doc.tag_name == null) {
            AQxmlError.throwAQEx(401, "Tag name: null");
        }
        elem = new XMLElement(aqxml_doc.tag_name, "", "http://ns.oracle.com/AQ/schemas/access");
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ns.oracle.com/AQ/schemas/access");
        if (idap_body_node == null) {
            AQxmlError.throwAQEx(401, "Idap Body Node: Null");
        }
        idap_body_node.appendChild((Node)elem);
        this.genStatusResponseXml(doc, aqxml_doc.getStatusResponse(), (Node)elem);
        AQxmlDebug.trace(4, "AQxmlGenerator.genServerResponseXml", "exit");
        return elem;
    }

    void genCommitResponseXml(Document doc, AQxmlCommitResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genCommitResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlCommitResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genCommitResponseXml", "exit");
    }

    void genRollbackResponseXml(Document doc, AQxmlRollbackResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genRollbackResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlRollbackResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genRollbackResponseXml", "exit");
    }

    void genEnqueueResponseXml(Document doc, AQxmlEnqueueResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node er_root_node = null;
        Element sendRespNode = null;
        Element destNode = null;
        XMLText destText = null;
        XMLNode[] msgIdElement = null;
        XMLText[] msgIdString = null;
        String sub_tag_name = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genEnqueueResponseXml", "entry");
        er_root_node = this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        if (aqxml_doc.tag_name.equalsIgnoreCase("aqxmlsendresponse")) {
            sub_tag_name = "send_result";
        } else if (aqxml_doc.tag_name.equalsIgnoreCase("aqxmlpublishresponse")) {
            sub_tag_name = "publish_result";
        } else if (aqxml_doc.tag_name.equalsIgnoreCase("aqxmlpushresponse")) {
            sub_tag_name = "push_result";
        } else {
            AQxmlError.throwAQEx(401, "Invalid tag:" + aqxml_doc.tag_name);
        }
        sendRespNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", sub_tag_name);
        er_root_node.appendChild(sendRespNode);
        destNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        sendRespNode.appendChild(destNode);
        destText = (XMLText)doc.createTextNode(aqxml_doc.getDestination());
        destNode.appendChild((Node)destText);
        msgIdElement = new XMLNode[aqxml_doc.msg_idVector.size()];
        msgIdString = new XMLText[aqxml_doc.msg_idVector.size()];
        for (int i = 0; i < aqxml_doc.msg_idVector.size(); ++i) {
            msgIdElement[i] = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_id");
            sendRespNode.appendChild((Node)msgIdElement[i]);
            msgIdString[i] = doc.createTextNode(aqxml_doc.getMessageId(i));
            msgIdElement[i].appendChild((Node)msgIdString[i]);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genEnqueueResponseXml", "exit");
    }

    void genPublishResponseXml(Document doc, AQxmlPublishResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genPublishResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlPublishResponse");
        this.genEnqueueResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genPublishResponseXml", "exit");
    }

    void genPushResponseXml(Document doc, AQxmlPushResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genPushResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlPushResponse");
        this.genEnqueueResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genPushResponseXml", "exit");
    }

    void genSendResponseXml(Document doc, AQxmlSendResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genSendResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlSendResponse");
        this.genEnqueueResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genSendResponseXml", "exit");
    }

    void genReceiveResponseXml(Document doc, AQxmlReceiveResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node rr_root_node = null;
        Element receiveRespNode = null;
        Element destNode = null;
        Text destText = null;
        Element messageSetNode = null;
        Element messageCountNode = null;
        Text messageCountText = null;
        AQxmlMessage message = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genReceiveResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlReceiveResponse");
        rr_root_node = this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        receiveRespNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "receive_result");
        rr_root_node.appendChild(receiveRespNode);
        destNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        receiveRespNode.appendChild(destNode);
        destText = doc.createTextNode(aqxml_doc.getDestination());
        destNode.appendChild(destText);
        messageSetNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_set");
        receiveRespNode.appendChild(messageSetNode);
        messageCountNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_count");
        messageSetNode.appendChild(messageCountNode);
        messageCountText = doc.createTextNode(String.valueOf(aqxml_doc.msgVector.size()));
        messageCountNode.appendChild(messageCountText);
        for (int i = 0; i < aqxml_doc.msgVector.size(); ++i) {
            message = aqxml_doc.getMessage(i);
            this.genCompleteMessageXml(doc, message, messageSetNode, i + 1);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genReceiveResponseXml", "exit");
    }

    void genRegisterResponseXml(Document doc, AQxmlRegisterResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterResponseXml", "entry");
        aqxml_doc.setTagName("AQXxmlRegisterResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterResponseXml", "exit");
    }

    void genSequenceNumResponseXml(Document doc, AQxmlSequenceNumResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node sn_root_node = null;
        Object destNode = null;
        Object destText = null;
        Element dblinkNode = null;
        Text dblinkText = null;
        Element srcQidNode = null;
        Text srcQidText = null;
        Element respNode = null;
        Element sequenceNode = null;
        Text sequenceText = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genSequenceNumResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlSequenceNumberResponse");
        sn_root_node = this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        respNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "sequence_num_result");
        sn_root_node.appendChild(respNode);
        srcQidNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "source_qid");
        respNode.appendChild(srcQidNode);
        srcQidText = doc.createTextNode(aqxml_doc.getSourceQid());
        srcQidNode.appendChild(srcQidText);
        dblinkNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "database_link");
        respNode.appendChild(dblinkNode);
        dblinkText = doc.createTextNode(aqxml_doc.getDatabaseLink());
        dblinkNode.appendChild(dblinkText);
        sequenceNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "sequence_number");
        respNode.appendChild(sequenceNode);
        sequenceText = doc.createTextNode(aqxml_doc.getSequenceNumber());
        sequenceNode.appendChild(sequenceText);
        AQxmlDebug.trace(4, "AQxmlGenerator.genSequenceNumResponseXml", "exit");
    }

    void genTypeInfoResponseXml(Document doc, AQxmlTypeInfoResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        Node sn_root_node = null;
        Element destNode = null;
        Text destText = null;
        Element respNode = null;
        Element rcNode = null;
        Text rcText = null;
        Element toidNode = null;
        Text toidText = null;
        Element versionNode = null;
        Text versionText = null;
        Element typedesNode = null;
        Text typedesText = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genTypeInfoResponseXml", "entry");
        aqxml_doc.setTagName("AQXmlQueueTypeResponse");
        sn_root_node = this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        respNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "queue_type_result");
        sn_root_node.appendChild(respNode);
        AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "setting destination");
        destNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        respNode.appendChild(destNode);
        destText = doc.createTextNode(aqxml_doc.getDestination());
        destNode.appendChild(destText);
        AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "setting return code");
        rcNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "returncode");
        respNode.appendChild(rcNode);
        rcText = doc.createTextNode(aqxml_doc.getReturnCode());
        rcNode.appendChild(rcText);
        AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "setting version");
        versionNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "version");
        respNode.appendChild(versionNode);
        versionText = doc.createTextNode(aqxml_doc.getVersion());
        versionNode.appendChild(versionText);
        AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "setting typedescriptor");
        typedesNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "typedescriptor");
        respNode.appendChild(typedesNode);
        typedesText = doc.createTextNode(aqxml_doc.getTypeDescriptor());
        typedesNode.appendChild(typedesText);
        AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "setting typeid");
        toidNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "typeid");
        if (toidNode == null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genTypeInfoResponseXml", "typeid null");
        }
        respNode.appendChild(toidNode);
        toidText = doc.createTextNode(aqxml_doc.getTypeId());
        toidNode.appendChild(toidText);
    }

    void genSetupQueueResponseXml(Document doc, StreamsSetupQueueResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genSetupQueueResponseXml", "entry");
        aqxml_doc.setTagName("StreamsSetupQueueResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genSetupQueueResponseXml", "exit");
    }

    void genStartCaptureResponseXml(Document doc, StreamsStartCaptureResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genStartCaptureResponseXml", "entry");
        aqxml_doc.setTagName("StreamsStartCaptureResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genStartCaptureResponseXml", "exit");
    }

    void genStartApplyResponseXml(Document doc, StreamsStartApplyResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genStartApplyResponseXml", "entry");
        aqxml_doc.setTagName("StreamsStartApplyResponse");
        this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        AQxmlDebug.trace(4, "AQxmlGenerator.genStartApplyResponseXml", "exit");
    }

    void genAddTableRulesResponseXml(Document doc, StreamsAddTableRulesResponse aqxml_doc, Node idap_body_node) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genAddTableRulesResponseXml", "entry");
        aqxml_doc.setTagName("StreamsAddTableRulesResponse");
        Node root = this.genServerResponseXml(doc, aqxml_doc, idap_body_node);
        Element result = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "add_table_rules_result");
        root.appendChild(result);
        Element dml_rule_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "dml_rule_name");
        result.appendChild(dml_rule_node);
        Text dml_rule_text = doc.createTextNode(aqxml_doc.getDmlRuleName());
        dml_rule_node.appendChild(dml_rule_text);
        Element ddl_rule_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "ddl_rule_name");
        result.appendChild(ddl_rule_node);
        Text ddl_rule_text = doc.createTextNode(aqxml_doc.getDdlRuleName());
        ddl_rule_node.appendChild(ddl_rule_text);
    }

    void genCompleteMessageXml(Document doc, AQxmlMessage message, Node node, int msg_number) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genCompleteMessageXml", "entry");
        if (message instanceof AQxmlAdtMessage) {
            this.genAdtMessageXml(doc, (AQxmlAdtMessage)message, node, msg_number);
        } else if (message instanceof AQxmlRawMessage) {
            this.genRawMessageXml(doc, (AQxmlRawMessage)message, node, msg_number);
        } else if (message instanceof AQxmlJmsTextMessage) {
            this.genJmsTextMessageXml(doc, (AQxmlJmsTextMessage)message, node, msg_number);
        } else if (message instanceof AQxmlJmsBytesMessage) {
            this.genJmsBytesMessageXml(doc, (AQxmlJmsBytesMessage)message, node, msg_number);
        } else if (message instanceof AQxmlJmsObjectMessage) {
            this.genJmsObjectMessageXml(doc, (AQxmlJmsObjectMessage)message, node, msg_number);
        } else if (message instanceof AQxmlJmsMapMessage) {
            this.genJmsMapMessageXml(doc, (AQxmlJmsMapMessage)message, node, msg_number);
        } else {
            AQxmlError.throwAQEx(401, "invalid message type: " + message.getClass().getName());
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genCompleteMessageXml", "exit");
    }

    void genMessageXml(Document doc, AQxmlMessage message, Node n, int msg_number) throws AQxmlException {
        Element msg_node = null;
        Element msg_num_node = null;
        Text msg_num_text = null;
        Element msg_payload_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessageXml", "entry");
        msg_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message");
        n.appendChild(msg_node);
        msg_num_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_number");
        msg_node.appendChild(msg_num_node);
        msg_num_text = doc.createTextNode(String.valueOf(msg_number));
        msg_num_node.appendChild(msg_num_text);
        this.genMessageHeaderXml(doc, message.getHeader(), msg_node);
        msg_payload_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_payload");
        msg_node.appendChild(msg_payload_node);
        message.payload_node = msg_payload_node;
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessageXml", "exit");
    }

    void genMessageHeaderXml(Document doc, AQxmlMessageHeader msg_hdr, Node node) throws AQxmlException {
        Element msg_header_node = null;
        Element msg_id_node = null;
        Text msg_id_text = null;
        Element corrid_node = null;
        Text corrid_text = null;
        Element exp_node = null;
        Text exp_text = null;
        Element delay_node = null;
        Text delay_text = null;
        Element priority_node = null;
        Text priority_text = null;
        Element del_count_node = null;
        Text del_count_text = null;
        Object recpt_list_node = null;
        Object recpt_list_text = null;
        Element msg_state_node = null;
        Text msg_state_text = null;
        Element sender_id_node = null;
        Element excep_q_node = null;
        Text excep_q_text = null;
        Element rcpt_list_head = null;
        Element rcpt = null;
        Element agent_name = null;
        Element agent_address = null;
        Element agent_protocol = null;
        Text agent_name_text = null;
        Text agent_address_text = null;
        Text agent_protocol_text = null;
        Object sender_name = null;
        Object sender_name_text = null;
        Object sender_address = null;
        Object sender_addr_text = null;
        Object sender_protocol = null;
        Object sender_proto_text = null;
        String exp_str = null;
        String delay_str = null;
        String prty_str = null;
        String msg_state = null;
        Object exception_queue = null;
        String del_cnt = null;
        AQxmlAgent[] recp_list = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessageHeaderXml", "entry");
        msg_header_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_header");
        node.appendChild(msg_header_node);
        if (msg_hdr.getMessageID() != null) {
            msg_id_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_id");
            msg_header_node.appendChild(msg_id_node);
            msg_id_text = doc.createTextNode(msg_hdr.getMessageID());
            msg_id_node.appendChild(msg_id_text);
        }
        if (msg_hdr.getCorrelationID() != null) {
            corrid_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "correlation");
            msg_header_node.appendChild(corrid_node);
            corrid_text = doc.createTextNode(msg_hdr.getCorrelationID());
            corrid_node.appendChild(corrid_text);
        }
        delay_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "delay");
        msg_header_node.appendChild(delay_node);
        delay_str = String.valueOf(msg_hdr.getDelay());
        delay_text = doc.createTextNode(delay_str);
        delay_node.appendChild(delay_text);
        exp_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "expiration");
        msg_header_node.appendChild(exp_node);
        exp_str = String.valueOf(msg_hdr.getExpiration());
        exp_text = doc.createTextNode(exp_str);
        exp_node.appendChild(exp_text);
        priority_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "priority");
        msg_header_node.appendChild(priority_node);
        prty_str = String.valueOf(msg_hdr.getPriority());
        priority_text = doc.createTextNode(prty_str);
        priority_node.appendChild(priority_text);
        del_count_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "delivery_count");
        msg_header_node.appendChild(del_count_node);
        del_cnt = String.valueOf(msg_hdr.getDeliveryCount());
        del_count_text = doc.createTextNode(del_cnt);
        del_count_node.appendChild(del_count_text);
        if (msg_hdr.getSenderId() != null) {
            sender_id_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "sender_id");
            msg_header_node.appendChild(sender_id_node);
            this.genAgentXml(doc, msg_hdr.getSenderId(), sender_id_node);
        }
        if ((recp_list = msg_hdr.getRecipientList()) != null) {
            rcpt_list_head = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "recipient_list");
            msg_header_node.appendChild(rcpt_list_head);
            for (int i = 0; i < recp_list.length; ++i) {
                rcpt = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "recipient");
                if (recp_list[i].getName() != null) {
                    agent_name = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "agent_name");
                    agent_name_text = doc.createTextNode(recp_list[i].getName());
                    agent_name.appendChild(agent_name_text);
                    rcpt.appendChild(agent_name);
                }
                if (recp_list[i].getAddress() != null) {
                    agent_address = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "address");
                    agent_address_text = doc.createTextNode(recp_list[i].getAddress());
                    agent_address.appendChild(agent_address_text);
                    rcpt.appendChild(agent_address);
                }
                if (recp_list[i].getProtocol() != 0) {
                    agent_protocol = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "protocol");
                    agent_protocol_text = doc.createTextNode(String.valueOf(recp_list[i].getProtocol()));
                    agent_protocol.appendChild(agent_protocol_text);
                    rcpt.appendChild(agent_protocol);
                }
                rcpt_list_head.appendChild(rcpt);
            }
        }
        msg_state_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_state");
        msg_header_node.appendChild(msg_state_node);
        msg_state = String.valueOf(msg_hdr.getState());
        msg_state_text = doc.createTextNode(msg_state);
        msg_state_node.appendChild(msg_state_text);
        if (msg_hdr.getExceptionQueue() != null) {
            excep_q_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "exception_queue");
            msg_header_node.appendChild(excep_q_node);
            excep_q_text = doc.createTextNode(msg_hdr.getExceptionQueue());
            excep_q_node.appendChild(excep_q_text);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessageHeaderXml", "exit");
    }

    void genMessagePropertyListXml(Document doc, AQxmlMessagePropertyList prop_list, Node node) throws AQxmlException {
        int groupseq;
        String appid;
        String userid;
        Element oracle_jms_prop_node = null;
        Element user_prop_node = null;
        Enumeration my_enum = null;
        Object key = null;
        Object value = null;
        Element name_node = null;
        Text name_text = null;
        Element value_node = null;
        Text value_text = null;
        Element prop_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessagePropertyListXml", "entry");
        oracle_jms_prop_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "oracle_jms_properties");
        node.appendChild(oracle_jms_prop_node);
        String m_type = prop_list.getMessageType();
        if (m_type != null) {
            Element m_type_node = null;
            Text m_type_text = null;
            m_type_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "type");
            oracle_jms_prop_node.appendChild(m_type_node);
            m_type_text = doc.createTextNode(m_type);
            m_type_node.appendChild(m_type_text);
        }
        if (prop_list.getReplyTo() != null) {
            Element reply_to_node = null;
            Object reply_to_text = null;
            reply_to_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "reply_to");
            oracle_jms_prop_node.appendChild(reply_to_node);
            this.genAgentXml(doc, prop_list.getReplyTo(), reply_to_node);
        }
        if ((userid = prop_list.getUserId()) != null) {
            Element userid_node = null;
            Text userid_text = null;
            userid_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "userid");
            oracle_jms_prop_node.appendChild(userid_node);
            userid_text = doc.createTextNode(userid);
            userid_node.appendChild(userid_text);
        }
        if ((appid = prop_list.getAppId()) != null) {
            Element appid_node = null;
            Text appid_text = null;
            appid_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "appid");
            oracle_jms_prop_node.appendChild(appid_node);
            appid_text = doc.createTextNode(appid);
            appid_node.appendChild(appid_text);
        }
        if (prop_list.getGroupId() != null) {
            Element groupid_node = null;
            Text groupid_text = null;
            groupid_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "groupid");
            oracle_jms_prop_node.appendChild(groupid_node);
            groupid_text = doc.createTextNode(prop_list.getGroupId());
            groupid_node.appendChild(groupid_text);
        }
        if ((groupseq = prop_list.getGroupSeq()) != 0) {
            Element groupseq_node = null;
            Text groupseq_text = null;
            groupseq_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "group_sequence");
            oracle_jms_prop_node.appendChild(groupseq_node);
            groupseq_text = doc.createTextNode(String.valueOf(groupseq));
            groupseq_node.appendChild(groupseq_text);
        }
        if (prop_list.recv_time != null) {
            Element recv_time_node = null;
            Text recv_time_text = null;
            String recv_time_str = null;
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            recv_time_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "recv_timestamp");
            oracle_jms_prop_node.appendChild(recv_time_node);
            recv_time_str = formatter.format(prop_list.recv_time);
            recv_time_text = doc.createTextNode(recv_time_str);
            recv_time_node.appendChild(recv_time_text);
        }
        user_prop_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "user_properties");
        node.appendChild(user_prop_node);
        my_enum = prop_list.user_properties.keys();
        while (my_enum.hasMoreElements()) {
            prop_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "property");
            user_prop_node.appendChild(prop_node);
            key = my_enum.nextElement();
            value = prop_list.user_properties.get(key);
            name_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "name");
            prop_node.appendChild(name_node);
            name_text = doc.createTextNode(key.toString());
            name_node.appendChild(name_text);
            if (value instanceof String) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "string_value");
            } else if (value instanceof Integer) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "int_value");
            } else if (value instanceof Long) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "long_value");
            } else if (value instanceof Double) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "double_value");
            } else if (value instanceof Boolean) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "boolean_value");
            } else if (value instanceof Float) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "float_value");
            } else if (value instanceof Short) {
                value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "short_value");
            } else {
                AQxmlError.throwAQEx(401, "invalid value");
            }
            prop_node.appendChild(value_node);
            value_text = doc.createTextNode(value.toString());
            value_node.appendChild(value_text);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genMessagePropertyListXml", "exit");
    }

    void genAdtMessageXml(Document doc, AQxmlAdtMessage adt_msg, Node node, int msg_number) throws AQxmlException {
        Object xml_payload_text = null;
        Object body_text = null;
        Document tmpdoc = null;
        StringReader data_stream = null;
        DOMParser parser = null;
        Object tmp_node = null;
        Node body_node = null;
        Node payload_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genAdtMessageXml", "entry");
        this.genMessageXml(doc, adt_msg, node, msg_number);
        payload_node = adt_msg.payload_node;
        AQxmlDebug.trace(5, "AQxmlGenerator.genAdtMessageXml", "Body: " + adt_msg.getBody());
        body_node = adt_msg.getBodyNode();
        if (body_node == null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genAdtMessageXml", "body_node==null");
            try {
                parser = new DOMParser();
                parser.setSecureProcessing();
                parser.setValidationMode(false);
                parser.setSchemaValidationMode(true);
                parser.setPreserveWhitespace(false);
                parser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
                parser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)12);
                Object body = adt_msg.getBody();
                body = "<?xml version = '1.0'?>\n" + (String)body;
                data_stream = new StringReader((String)body);
                parser.parse((Reader)data_stream);
                tmpdoc = parser.getDocument();
            }
            catch (IOException io_ex) {
                AQxmlDebug.traceEx(3, "AQxmlGenerator.genAdtMessageXml", io_ex);
                AQxmlError.throwAQEx(403, io_ex);
            }
            catch (XMLParseException p_ex) {
                AQxmlDebug.traceEx(3, "AQxmlGenerator.genAdtMessageXml", (Exception)((Object)p_ex));
                AQxmlError.throwAQEx(404, (Exception)((Object)p_ex));
            }
            catch (SAXException sax_ex) {
                AQxmlDebug.traceEx(3, "AQxmlGenerator.genAdtMessageXml", sax_ex);
                AQxmlError.throwAQEx(405, sax_ex);
            }
            XMLDocument node_doc = null;
            node_doc = (XMLDocument)payload_node.getOwnerDocument();
            body_node = node_doc.importNode((Node)tmpdoc.getDocumentElement(), true);
            payload_node.appendChild(body_node);
            adt_msg.setBodyNode(body_node);
        } else if (body_node.getNodeName().equalsIgnoreCase("_AQ_ADT_BODY")) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genAdtMessageXml", "node==_AQ_ADT_BODY");
            Node clone_node = null;
            if (body_node.getFirstChild() == null) {
                AQxmlError.throwAQEx(401, "First Child is Null");
            }
            XMLDocument payload_doc = null;
            payload_doc = (XMLDocument)payload_node.getOwnerDocument();
            clone_node = payload_doc.importNode(body_node.getFirstChild(), true);
            payload_node.appendChild(clone_node);
        } else {
            AQxmlDebug.trace(5, "AQxmlGenerator.genAdtMessageXml", "body_node != _AQ_ADT_BODY");
            Node clone_node = null;
            XMLDocument payload_doc = null;
            payload_doc = (XMLDocument)payload_node.getOwnerDocument();
            clone_node = payload_doc.importNode(body_node, true);
            payload_node.appendChild(clone_node);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genAdtMessageXml", "exit");
    }

    void genJmsMessageXml(Document doc, AQxmlJmsMessage jms_msg, Node node, String payload_type, int msg_number) throws AQxmlException {
        Object msg_node = null;
        Object msg_num_node = null;
        Object msg_num_text = null;
        Object msg_pay_node = null;
        Element msg_ptype_node = null;
        Node payload_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsMessageXml", "entry");
        this.genMessageXml(doc, jms_msg, node, msg_number);
        payload_node = jms_msg.payload_node;
        if (payload_type == null) {
            AQxmlError.throwAQEx(401, "payload_type: null");
        }
        msg_ptype_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", payload_type);
        payload_node.appendChild(msg_ptype_node);
        jms_msg.setJmsPayloadNode(msg_ptype_node);
        AQxmlMessagePropertyList props = jms_msg.getPropertyList();
        if (props != null) {
            this.genMessagePropertyListXml(doc, props, msg_ptype_node);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsMessageXml", "exit");
    }

    void genJmsTextMessageXml(Document doc, AQxmlJmsTextMessage jms_text_msg, Node node, int msg_number) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsTextMessageXml", "entry");
        if (jms_text_msg.getJmsMessage() != null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsTextMessageXml", "jms format");
            AQxmlGenUtil.genXmlJmsTextMessage(jms_text_msg.getJmsMessage(), doc, node, msg_number);
        } else {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsTextMessageXml", "aqxml format");
            Element text_node = null;
            Text body_text = null;
            this.genJmsMessageXml(doc, jms_text_msg, node, "jms_text_message", msg_number);
            Node jms_payload_node = jms_text_msg.getJmsPayloadNode();
            if (jms_payload_node == null) {
                AQxmlError.throwAQEx(401, "jms_payload_node:null");
            }
            text_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "text_data");
            jms_payload_node.appendChild(text_node);
            if (jms_text_msg.getText() != null) {
                body_text = doc.createTextNode(jms_text_msg.getText());
                text_node.appendChild(body_text);
            }
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsTextMessageXml", "exit");
    }

    void genJmsBytesMessageXml(Document doc, AQxmlJmsBytesMessage jms_bytes_msg, Node node, int msg_number) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsBytesMessageXml", "entry");
        if (jms_bytes_msg.getJmsMessage() != null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsBytesMessageXml", "jms format");
            AQxmlGenUtil.genXmlJmsBytesMessage(jms_bytes_msg.getJmsMessage(), doc, node, msg_number);
        } else {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsBytesMessageXml", "aqxml format");
            Element byte_node = null;
            String hexString = null;
            Text byte_text = null;
            this.genJmsMessageXml(doc, jms_bytes_msg, node, "jms_bytes_message", msg_number);
            Node jms_payload_node = jms_bytes_msg.getJmsPayloadNode();
            if (jms_payload_node == null) {
                AQxmlError.throwAQEx(401, "jms_payload_node:null");
            }
            byte_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "bytes_data");
            jms_payload_node.appendChild(byte_node);
            byte[] bytes_data = jms_bytes_msg.getBytes();
            if (bytes_data != null) {
                hexString = AQxmlRawMessage.bArray2String(bytes_data);
                byte_text = doc.createTextNode(hexString);
                byte_node.appendChild(byte_text);
            }
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsBytesMessageXml", "exit");
    }

    void genJmsObjectMessageXml(Document doc, AQxmlJmsObjectMessage jms_obj_msg, Node node, int msg_number) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsObjectMessageXml", "entry");
        if (jms_obj_msg.getJmsMessage() != null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsObjectMessageXml", "jms format");
            AQxmlGenUtil.genXmlJmsObjectMessage(jms_obj_msg.getJmsMessage(), doc, node, msg_number);
        } else {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsObjectMessageXml", "aqxml format");
            Element obj_node = null;
            String hexString = null;
            Text obj_text = null;
            byte[] ser_bytes = null;
            this.genJmsMessageXml(doc, jms_obj_msg, node, "jms_object_message", msg_number);
            Node jms_payload_node = jms_obj_msg.getJmsPayloadNode();
            if (jms_payload_node == null) {
                AQxmlError.throwAQEx(401, "jms_payload_node:null");
            }
            obj_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "ser_object_data");
            jms_payload_node.appendChild(obj_node);
            Serializable serial_obj = jms_obj_msg.getObject();
            if (serial_obj != null) {
                ser_bytes = AQxmlJmsObjectMessage.convertSerializableToByteArray(serial_obj);
                AQxmlDebug.trace(5, "AQxmlJmsObjectMessage.genXml", "ser_bytes - len=" + ser_bytes.length);
                hexString = AQxmlRawMessage.bArray2String(ser_bytes);
                obj_text = doc.createTextNode(hexString);
                obj_node.appendChild(obj_text);
            }
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsObjectMessageXml", "exit");
    }

    void genJmsMapMessageXml(Document doc, AQxmlJmsMapMessage jms_map_msg, Node node, int msg_number) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsMapMessageXml", "entry");
        if (jms_map_msg.getJmsMessage() != null) {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsMapMessageXml", "jms format");
            AQxmlGenUtil.genXmlJmsMapMessage(jms_map_msg.getJmsMessage(), doc, node, msg_number);
        } else {
            AQxmlDebug.trace(5, "AQxmlGenerator.genJmsMapMessageXml", "aqxml format");
            Element map_node = null;
            Element item_node = null;
            Enumeration my_enum = null;
            Object key = null;
            Object value = null;
            Element name_node = null;
            Text name_text = null;
            Element value_node = null;
            Text value_text = null;
            this.genJmsMessageXml(doc, jms_map_msg, node, "jms_map_message", msg_number);
            Node jms_payload_node = jms_map_msg.getJmsPayloadNode();
            if (jms_payload_node == null) {
                AQxmlError.throwAQEx(401, "jms_payload_node:null");
            }
            map_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "map_data");
            jms_payload_node.appendChild(map_node);
            my_enum = jms_map_msg.mapItemHash.keys();
            while (my_enum.hasMoreElements()) {
                item_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "item");
                map_node.appendChild(item_node);
                key = my_enum.nextElement();
                value = jms_map_msg.mapItemHash.get(key);
                name_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "name");
                item_node.appendChild(name_node);
                name_text = doc.createTextNode(key.toString());
                name_node.appendChild(name_text);
                if (value instanceof String) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "string_value");
                } else if (value instanceof Integer) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "int_value");
                } else if (value instanceof Long) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "long_value");
                } else if (value instanceof Double) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "double_value");
                } else if (value instanceof Boolean) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "boolean_value");
                } else if (value instanceof Float) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "float_value");
                } else if (value instanceof Short) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "short_value");
                } else if (value instanceof Byte) {
                    value_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "byte_value");
                } else {
                    AQxmlError.throwAQEx(423);
                }
                item_node.appendChild(value_node);
                value_text = doc.createTextNode(value.toString());
                value_node.appendChild(value_text);
            }
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genJmsMapMessageXml", "exit");
    }

    void genRawMessageXml(Document doc, AQxmlRawMessage raw_msg, Node node, int msg_number) throws AQxmlException {
        Element rawDataNode = null;
        Text rawData = null;
        String hexString = null;
        Node payload_node = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genRawMessageXml", "entry");
        this.genMessageXml(doc, raw_msg, node, msg_number);
        payload_node = raw_msg.payload_node;
        if (payload_node == null) {
            AQxmlError.throwAQEx(401, "payload_node:null");
        }
        rawDataNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "raw");
        payload_node.appendChild(rawDataNode);
        byte[] raw_data = raw_msg.getBytes();
        if (raw_data != null) {
            hexString = AQxmlRawMessage.bArray2String(raw_data);
            rawData = doc.createTextNode(hexString);
            rawDataNode.appendChild(rawData);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genRawMessageXml", "exit");
    }

    void genAgentXml(Document doc, AQxmlAgent agt, Node node) throws AQxmlException {
        Element name_node = null;
        Text name_text = null;
        Element addr_node = null;
        Text addr_text = null;
        Element prot_node = null;
        Text prot_text = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genAgentXml", "entry");
        if (agt.getName() != null) {
            name_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "agent_name");
            node.appendChild(name_node);
            name_text = doc.createTextNode(agt.getName());
            name_node.appendChild(name_text);
        }
        if (agt.getAddress() != null) {
            addr_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "address");
            node.appendChild(addr_node);
            addr_text = doc.createTextNode(agt.getAddress());
            addr_node.appendChild(addr_text);
        }
        if (agt.getProtocol() != 0) {
            prot_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "protocol");
            node.appendChild(prot_node);
            prot_text = doc.createTextNode(String.valueOf(agt.getProtocol()));
            prot_node.appendChild(prot_text);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genAgentXml", "exit");
    }

    void genStatusResponseXml(Document doc, AQxmlStatusResponse stat_resp, Node node) throws AQxmlException {
        Element statusRespNode = null;
        Element statusCodeNode = null;
        Text statusCodeText = null;
        Element errorCodeNode = null;
        Text errorCodeText = null;
        Element errorMessageNode = null;
        Text errorMessageText = null;
        String err_msg = null;
        AQxmlDebug.trace(5, "AQxmlGenerator.genStatusResponseXml", "entry ");
        statusRespNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "status_response");
        node.appendChild(statusRespNode);
        statusCodeNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "status_code");
        statusRespNode.appendChild(statusCodeNode);
        statusCodeText = doc.createTextNode(Integer.toString(stat_resp.getStatusCode()));
        statusCodeNode.appendChild(statusCodeText);
        if (stat_resp.getStatusCode() != 0) {
            errorCodeNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "error_code");
            statusRespNode.appendChild(errorCodeNode);
            errorCodeText = doc.createTextNode(Integer.toString(stat_resp.getErrorCode()));
            errorCodeNode.appendChild(errorCodeText);
            err_msg = stat_resp.getErrorMessage();
            if (err_msg != null) {
                errorMessageNode = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "error_message");
                statusRespNode.appendChild(errorMessageNode);
                errorMessageText = doc.createTextNode(err_msg);
                errorMessageNode.appendChild(errorMessageText);
            }
        }
        AQxmlDebug.trace(5, "AQxmlGenerator.genStatusResponseXml", "exit");
    }

    void genProducerOptionXml(Document doc, AQxmlProducerOption prod_opt, Node node) {
        Element po_root = null;
        Element dest_node = null;
        Text dest_text = null;
        Object prty_node = null;
        Object prty_text = null;
        Object expr_node = null;
        Object expr_text = null;
        Element visi_node = null;
        Text visi_text = null;
        Element trans_node = null;
        Text trans_text = null;
        int m_visibility = 0;
        AQxmlDebug.trace(4, "AQxmlGenerator.genProducerOptionXml", "entry");
        po_root = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "producer_options");
        node.appendChild(po_root);
        dest_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        po_root.appendChild(dest_node);
        dest_text = doc.createTextNode(prod_opt.getCompleteDestName());
        dest_node.appendChild(dest_text);
        m_visibility = prod_opt.getVisibility();
        if (m_visibility != 2) {
            visi_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "visibility");
            po_root.appendChild(visi_node);
            if (m_visibility == 1) {
                visi_text = doc.createTextNode("IMMEDIATE");
            } else if (m_visibility == 2) {
                visi_text = doc.createTextNode("ON_COMMIT");
            }
            visi_node.appendChild(visi_text);
        }
        if (prod_opt.getTransformation() != null) {
            trans_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "transformation");
            po_root.appendChild(trans_node);
            trans_text = doc.createTextNode(prod_opt.getTransformation());
            trans_node.appendChild(trans_text);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genProducerOptionXml", "exit");
    }

    void genConsumerOptionXml(Document doc, AQxmlConsumerOption cons_opt, Node node) throws AQxmlException {
        String cnsmr_txfm;
        int navig_mode;
        int deq_mode;
        Object body_node = null;
        Object nl = null;
        Object root_node = null;
        Element dest_node = null;
        Text dest_text = null;
        Element cons_node = null;
        Text cons_text = null;
        Element wait_node = null;
        Text wait_text = null;
        Element condition_node = null;
        Text condition_text = null;
        Element corr_node = null;
        Text corr_text = null;
        Element msgid_node = null;
        Text msgid_text = null;
        Element batch_node = null;
        Text batch_text = null;
        Element visi_node = null;
        Text visi_text = null;
        Element deq_mode_node = null;
        Text deq_mode_text = null;
        Element navig_node = null;
        Text navig_text = null;
        Element co_root = null;
        Element selector_node = null;
        Element trans_node = null;
        Text trans_text = null;
        String condition = null;
        String corr = null;
        byte[] msgid = null;
        int visib = 0;
        AQxmlDebug.trace(4, "AQxmlGenerator.genConsumerOptionXml", "entry");
        co_root = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "consumer_options");
        if (node == null) {
            AQxmlError.throwAQEx(401, "Idap Body Node cannot be null");
        }
        node.appendChild(co_root);
        dest_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        co_root.appendChild(dest_node);
        dest_text = doc.createTextNode(cons_opt.getCompleteName());
        dest_node.appendChild(dest_text);
        if (cons_opt.getConsumerName() != null) {
            cons_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "consumer_name");
            co_root.appendChild(cons_node);
            cons_text = doc.createTextNode(cons_opt.getConsumerName());
            cons_node.appendChild(cons_text);
        }
        if (cons_opt.getWaitTime() != 0) {
            wait_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "wait_time");
            co_root.appendChild(wait_node);
            wait_text = doc.createTextNode(String.valueOf(cons_opt.getWaitTime()));
            wait_node.appendChild(wait_text);
        }
        condition = cons_opt.getCondition();
        corr = cons_opt.getCorrelation();
        msgid = cons_opt.getMessageId();
        if (condition != null || msgid != null || corr != null) {
            selector_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "selector");
            co_root.appendChild(selector_node);
            if (msgid != null) {
                msgid_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "message_id");
                selector_node.appendChild(msgid_node);
                msgid_text = doc.createTextNode(AQxmlRawMessage.bArray2String(msgid));
                msgid_node.appendChild(msgid_text);
            } else if (condition != null) {
                condition_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "condition");
                selector_node.appendChild(condition_node);
                condition_text = doc.createTextNode(condition);
                condition_node.appendChild(condition_text);
            } else if (corr != null) {
                corr_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "correlation");
                selector_node.appendChild(corr_node);
                corr_text = doc.createTextNode(corr);
                corr_node.appendChild(corr_text);
            } else {
                AQxmlError.throwAQEx(401, "Invalid selector condition");
            }
        }
        batch_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "batch_size");
        co_root.appendChild(batch_node);
        batch_text = doc.createTextNode(String.valueOf(cons_opt.getBatchSize()));
        batch_node.appendChild(batch_text);
        visib = cons_opt.getVisibility();
        if (visib != 2) {
            visi_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "visibility");
            co_root.appendChild(visi_node);
            if (visib == 1) {
                visi_text = doc.createTextNode("IMMEDIATE");
            } else if (visib == 2) {
                visi_text = doc.createTextNode("ON_COMMIT");
            }
            visi_node.appendChild(visi_text);
        }
        if ((deq_mode = cons_opt.getDequeueMode()) != 3) {
            deq_mode_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "dequeue_mode");
            co_root.appendChild(deq_mode_node);
            if (deq_mode == 1) {
                deq_mode_text = doc.createTextNode("BROWSE");
            } else if (deq_mode == 2) {
                deq_mode_text = doc.createTextNode("LOCKED");
            } else if (deq_mode == 3) {
                deq_mode_text = doc.createTextNode("REMOVE");
            } else if (deq_mode == 4) {
                deq_mode_text = doc.createTextNode("REMOVE_NODATA");
            } else if (deq_mode == 5) {
                deq_mode_text = doc.createTextNode("GET_SIGNATURE");
            }
            deq_mode_node.appendChild(deq_mode_text);
        }
        if ((navig_mode = cons_opt.getNavigationMode()) != 3) {
            navig_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "navigation_mode");
            co_root.appendChild(navig_node);
            if (navig_mode == 1) {
                navig_text = doc.createTextNode("FIRST_MESSAGE");
            } else if (navig_mode == 3) {
                navig_text = doc.createTextNode("NEXT_MESSAGE");
            }
            if (navig_mode == 2) {
                navig_text = doc.createTextNode("NEXT_TRANSACTION");
            }
            navig_node.appendChild(navig_text);
        }
        if ((cnsmr_txfm = cons_opt.getTransformation()) != null) {
            trans_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "transformation");
            co_root.appendChild(trans_node);
            trans_text = doc.createTextNode(cnsmr_txfm);
            trans_node.appendChild(trans_text);
        }
        AQxmlDebug.trace(4, "AQxmlGenerator.genConsumerOptionXml", "exit");
    }

    void genRegisterOptionXml(Document doc, AQxmlRegisterOption reg_opt, Node node) throws AQxmlException {
        String register_url;
        Element reg_node = null;
        Element dest_node = null;
        Text dest_text = null;
        Element cons_node = null;
        Text cons_text = null;
        Element ntfy_node = null;
        Text ntfy_text = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterOptionXml", "entry");
        reg_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "register_options");
        node.appendChild(reg_node);
        dest_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "destination");
        reg_node.appendChild(dest_node);
        dest_text = doc.createTextNode(reg_opt.getCompleteDestName());
        dest_node.appendChild(dest_text);
        if (reg_opt.getConsumerName() != null) {
            cons_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "consumer_name");
            reg_node.appendChild(cons_node);
            cons_text = doc.createTextNode(reg_opt.getConsumerName());
            cons_node.appendChild(cons_text);
        }
        if ((register_url = reg_opt.getUrl()) == null || register_url.equals("")) {
            AQxmlError.throwAQEx(441, "url");
        }
        ntfy_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "notify_url");
        reg_node.appendChild(ntfy_node);
        ntfy_text = doc.createTextNode(register_url);
        ntfy_node.appendChild(ntfy_text);
        AQxmlDebug.trace(4, "AQxmlGenerator.genRegisterOptionXml", "exit");
    }

    void genAutoCommitXml(Document doc, Node node) {
        Element com_node = null;
        com_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "AQXmlCommit");
        node.appendChild(com_node);
    }

    static byte[] convertSerializableToByteArray(Serializable s_obj) throws AQxmlException {
        ByteArrayOutputStream baostream = null;
        ObjectOutputStream oostream = null;
        AQxmlDebug.trace(4, "AQxmlGenerator.convertSerializableToByteArray", "entry");
        try {
            baostream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(s_obj);
            AQxmlDebug.trace(4, "AQxmlGenerator.convertSerializableToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQxmlDebug.traceEx(3, "AQxmlGenerator.convertSerializableToByteArray-ioexp-1", io_exp);
            AQxmlError.throwAQEx(403, io_exp.getMessage());
            return null;
        }
    }
}

