/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlMessageHeader;
import oracle.jakarta.AQ.xml.AQxmlMessagePropertyList;

public class AQxmlJmsObjectMessage
extends AQxmlJmsMessage {
    Object jms_message;
    Serializable serial_obj;

    public AQxmlJmsObjectMessage(AQxmlMessageHeader header, AQxmlMessagePropertyList props, Serializable body) throws AQxmlException {
        super(header, props);
        this.serial_obj = body;
    }

    AQxmlJmsObjectMessage(Object jms_object_message) throws AQxmlException {
        if (jms_object_message == null) {
            AQxmlError.throwAQEx(401, "jms_object_message cannot be null");
        }
        this.header = new AQxmlMessageHeader();
        this.jms_message = jms_object_message;
    }

    @Override
    Object getJmsMessage() {
        return this.jms_message;
    }

    public Serializable getObject() {
        return this.serial_obj;
    }

    public void setObject(Serializable object) {
        this.serial_obj = object;
    }

    static byte[] convertSerializableToByteArray(Serializable s_obj) throws AQxmlException {
        ByteArrayOutputStream baostream = null;
        ObjectOutputStream oostream = null;
        AQxmlDebug.trace(4, "AQxmlJmsObjectMessage.convertSerializableToByteArray", "entry");
        try {
            baostream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(s_obj);
            AQxmlDebug.trace(4, "AQxmlJmsObjectMessage.convertSerializableToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQxmlDebug.traceEx(3, "AQjmsObjectMessage.ioexp-1", io_exp);
            AQxmlError.throwAQEx(403, io_exp.getMessage());
            return null;
        }
    }
}

