/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ;

import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQMessage;
import oracle.jakarta.AQ.AQMessageProperty;
import oracle.jakarta.AQ.AQObjectPayload;
import oracle.jakarta.AQ.AQOracleObjectPayload;
import oracle.jakarta.AQ.AQOracleRawPayload;
import oracle.jakarta.AQ.AQRawPayload;
import oracle.jakarta.AQ.AQUtil;

public class AQOracleMessage
implements AQMessage {
    private byte[] msg_id;
    private int pload_type;
    private AQOracleRawPayload r_payload;
    private AQOracleObjectPayload o_payload;
    private AQMessageProperty m_property;

    AQOracleMessage(int payload_type, AQOracleRawPayload raw_payload, AQMessageProperty property) throws AQException {
        if (payload_type != 2) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.RAW_TYPE_PAYLOAD");
        }
        this.pload_type = payload_type;
        this.r_payload = raw_payload;
        this.o_payload = null;
        this.m_property = property;
        this.msg_id = null;
    }

    AQOracleMessage(int payload_type, AQOracleObjectPayload obj_payload, AQMessageProperty property) throws AQException {
        if (payload_type != 1) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.OBJECT_TYPE_PAYLOAD");
        }
        this.pload_type = payload_type;
        this.o_payload = obj_payload;
        this.r_payload = null;
        this.m_property = property;
        this.msg_id = null;
    }

    AQOracleMessage(int payload_type) throws AQException {
        if (payload_type != 1 && payload_type != 2) {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = payload_type;
        this.o_payload = null;
        this.r_payload = null;
        this.m_property = null;
        this.msg_id = null;
    }

    @Override
    public byte[] getMessageId() throws AQException {
        return this.msg_id;
    }

    void setMessageId(byte[] message_id) throws AQException {
        this.msg_id = message_id;
    }

    @Override
    public AQRawPayload getRawPayload() throws AQException {
        return this.r_payload;
    }

    @Override
    public void setRawPayload(AQRawPayload message_payload) throws AQException {
        Class<?> cl = null;
        if (this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if (message_payload != null) {
            try {
                cl = Class.forName("oracle.jakarta.AQ.AQOracleRawPayload");
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(109);
            }
            if (cl.isInstance(message_payload)) {
                this.r_payload = (AQOracleRawPayload)message_payload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.r_payload = null;
        }
    }

    @Override
    public AQObjectPayload getObjectPayload() throws AQException {
        return this.o_payload;
    }

    @Override
    public void setObjectPayload(AQObjectPayload message_payload) throws AQException {
        Class<?> cl = null;
        if (this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if (message_payload != null) {
            try {
                cl = Class.forName("oracle.jakarta.AQ.AQOracleObjectPayload");
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(109);
            }
            if (cl.isInstance(message_payload)) {
                this.o_payload = (AQOracleObjectPayload)message_payload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.o_payload = null;
        }
    }

    @Override
    public AQMessageProperty getMessageProperty() throws AQException {
        return this.m_property;
    }

    @Override
    public void setMessageProperty(AQMessageProperty property) throws AQException {
        this.m_property = property;
    }
}

