/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jakarta.AQ.AQOracleDebug;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsEnableDebug;
import oracle.jakarta.jms.AQjmsUtil;

public class AQjmsOracleDebug {
    static OutputStream logstream = null;
    static PrintWriter pstream = null;
    public static boolean DEBUG = false;
    private static int TRACE_LEVEL = Integer.getInteger("oracle.jakarta.jms.traceLevel", 0);
    public static final int AQ_ORA_TR0 = 0;
    public static final int AQ_ORA_TR1 = 1;
    public static final int AQ_ORA_TR2 = 2;
    public static final int AQ_ORA_TR3 = 3;
    public static final int AQ_ORA_TR4 = 4;
    public static final int AQ_ORA_TR5 = 5;
    public static final int AQ_ORA_TR6 = 6;

    private AQjmsOracleDebug() {
    }

    public static void setDebug(boolean val) {
        DEBUG = val;
        AQOracleDebug.setDebug(val);
    }

    public static void setTraceLevel(int level) {
        TRACE_LEVEL = level > 6 ? 6 : (level < 0 ? 0 : level);
        AQOracleDebug.setTraceLevel(level);
    }

    public static int getTraceLevel() {
        return TRACE_LEVEL;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream output_stream) {
        logstream = output_stream;
        pstream = new PrintWriter(logstream);
    }

    static void trace(int trace_level, String component, String message) {
        if (TRACE_LEVEL >= trace_level || trace_level == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (String)(TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + component + ":  " + message);
            pstream.flush();
        }
    }

    static void traceEx(int trace_level, String message, Throwable ex) {
        if (TRACE_LEVEL >= trace_level || trace_level == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (String)(TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + message + ": Exception: " + ex);
            if (TRACE_LEVEL >= 5 && ex != null) {
                ex.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void traceErr(int trace_level, String message, Error err) {
        if (TRACE_LEVEL >= trace_level || trace_level == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (String)(TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + message + ": Error: " + err);
            if (TRACE_LEVEL >= 5 && err != null) {
                err.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void print(String message) {
        if (DEBUG) {
            pstream.print(message);
            pstream.flush();
        }
    }

    static void println(String message) {
        if (DEBUG) {
            pstream.println(Thread.currentThread().getName() + "  " + message);
            pstream.flush();
        }
    }

    static {
        try {
            String tracefile = AQjmsUtil.getSystemProperty("oracle.jakarta.jms.traceFile");
            logstream = tracefile != null ? new FileOutputStream(tracefile) : System.out;
        }
        catch (Exception e) {
            logstream = System.out;
        }
        pstream = new PrintWriter(logstream);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            AQjmsEnableDebug debugBean = new AQjmsEnableDebug();
            ObjectName name = new ObjectName("oracle.jakarta.jms:type=AQjmsEnableDebugMBean");
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(debugBean, name);
            }
        }
        catch (Exception e) {
            System.out.println("Exception while registering AQjmsEnableDebugMBean: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

