/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGenMessage_C;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsStreamMessage_C;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jdbc.OracleData;

public class AQjmsStreamMessage
extends AQjmsMessage
implements StreamMessage {
    private byte[] m_bytesData = new byte[0];
    private ByteArrayInputStream m_byteArrayFieldStream;
    private Object m_pushbackObject = null;
    private boolean m_pushbackFlag = false;
    private ObjectInputStream m_inObjectStream;
    private ByteArrayOutputStream m_outByteArrayStream;
    private ObjectOutputStream m_outObjectStream;
    private boolean m_dirty = false;

    AQjmsStreamMessage() throws JMSException {
        super(true);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
        this.access_mode = 1;
    }

    AQjmsStreamMessage(AQjmsSession session) throws JMSException {
        super(session, true);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
        this.access_mode = 1;
    }

    AQjmsStreamMessage(AQjmsMessage headerMsg) throws JMSException {
        super(headerMsg);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    AQjmsStreamMessage(AQjmsSession session, AQjmsStreamMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readStreamMessageContainer(msgCont);
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession session, AQjmsGenMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readGenMessageContainer(msgCont);
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession session, byte[] bdata) throws JMSException {
        super(session, true);
        if (bdata != null) {
            this.m_bytesData = bdata;
        }
        try {
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession session, byte[] bdata, boolean isStreamingDequeue) throws JMSException {
        super(session, true);
        this.access_mode = 0;
    }

    byte[] getBytesData() {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }

    public boolean readBoolean() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readBoolean");
        }
        Object value = this.readObject();
        boolean data = false;
        if (value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Boolean) {
            data = (Boolean)value;
        } else if (value == null || value instanceof String) {
            data = Boolean.valueOf((String)value);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public byte readByte() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readByte");
        }
        Object value = this.readObject();
        byte data = 0;
        if (value instanceof Boolean || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Byte) {
            data = (Byte)value;
        } else if (value == null || value instanceof String) {
            try {
                data = Byte.valueOf((String)value);
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public short readShort() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readShort");
        }
        Object value = this.readObject();
        short data = 0;
        if (value instanceof Boolean || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Short) {
            data = (Short)value;
        } else if (value instanceof Byte) {
            data = ((Byte)value).shortValue();
        } else if (value == null || value instanceof String) {
            try {
                data = Short.valueOf((String)value);
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public char readChar() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readChar");
        }
        Object value = this.readObject();
        char data = '\u0000';
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else {
            if (value == null) {
                this.pushback(value);
                throw new NullPointerException("reading a null value as a char");
            }
            if (value instanceof Character) {
                data = ((Character)value).charValue();
            } else {
                AQjmsError.throwMsgFormatEx(161, "invalid type");
            }
        }
        return data;
    }

    public int readInt() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readInt");
        }
        Object value = this.readObject();
        int data = 0;
        if (value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Byte) {
            data = ((Byte)value).intValue();
        } else if (value instanceof Short) {
            data = ((Short)value).intValue();
        } else if (value instanceof Integer) {
            data = (Integer)value;
        } else if (value == null || value instanceof String) {
            try {
                data = Integer.valueOf((String)value);
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public long readLong() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readLong");
        }
        Object value = this.readObject();
        long data = 0L;
        if (value instanceof Boolean || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Byte) {
            data = ((Byte)value).longValue();
        } else if (value instanceof Short) {
            data = ((Short)value).longValue();
        } else if (value instanceof Integer) {
            data = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            data = (Long)value;
        } else if (value == null || value instanceof String) {
            try {
                data = Long.valueOf((String)value);
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public float readFloat() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readFloat");
        }
        Object value = this.readObject();
        float data = 0.0f;
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Float) {
            data = ((Float)value).floatValue();
        } else if (value == null || value instanceof String) {
            try {
                data = Float.valueOf((String)value).floatValue();
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public double readDouble() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readDouble");
        }
        Object value = this.readObject();
        double data = 0.0;
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (value instanceof Float) {
            data = ((Float)value).doubleValue();
        } else if (value instanceof Double) {
            data = (Double)value;
        } else if (value == null || value instanceof String) {
            try {
                data = Double.valueOf((String)value);
            }
            catch (RuntimeException e) {
                this.pushback(value);
                throw e;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public String readString() throws JMSException {
        Object value;
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readString");
        }
        if ((value = this.readObject()) == null) {
            return (String)value;
        }
        String data = null;
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            data = value.toString();
        } else if (value instanceof String) {
            data = (String)value;
        } else if (value instanceof byte[]) {
            this.pushback(value);
            AQjmsError.throwMsgFormatEx(161, null);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return data;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readBytes");
        }
        if (this.m_byteArrayFieldStream == null) {
            Object fieldValue = this.readObject();
            if (fieldValue == null) {
                return -1;
            }
            if (fieldValue instanceof Boolean || fieldValue instanceof Byte || fieldValue instanceof Short || fieldValue instanceof Character || fieldValue instanceof Integer || fieldValue instanceof Long || fieldValue instanceof Float || fieldValue instanceof Double || fieldValue instanceof String) {
                this.pushback(fieldValue);
                AQjmsError.throwMsgFormatEx(161, null);
            } else if (!(fieldValue instanceof byte[])) {
                AQjmsError.throwMsgFormatEx(161, "invalid type");
            }
            this.m_byteArrayFieldStream = new ByteArrayInputStream((byte[])fieldValue);
        }
        if (value == null) {
            return -1;
        }
        int length = 0;
        try {
            length = this.m_byteArrayFieldStream.read(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        if (length == -1) {
            this.clearByteArrayFieldStream();
        }
        return length;
    }

    public Object readObject() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readObject");
        }
        if (this.isReadingByteArrayField()) {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        if (this.m_pushbackFlag) {
            Object obj = this.m_pushbackObject;
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            return obj;
        }
        try {
            return this.m_inObjectStream.readObject();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsError.throwEx(109, (Throwable)cnf_exp);
        }
        catch (IOException io_exp) {
            AQjmsError.throwEx(157, (Throwable)io_exp);
        }
        return null;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Boolean(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeByte(byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Byte(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeShort(short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Short(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeChar(char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Character(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeInt(int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Integer(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeLong(long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Long(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeFloat(float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Float(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeDouble(double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Double(value));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeString(String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        byte[] newValue = new byte[length];
        System.arraycopy(value, offset, newValue, 0, length);
        try {
            this.m_outObjectStream.writeObject(newValue);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeObject(Object value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value == null || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[]) {
            try {
                this.m_outObjectStream.writeObject(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, (Throwable)io_ex);
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    @Override
    public void setInputStream(InputStream inputStream) throws JMSException {
        super.setInputStream(inputStream);
    }

    public OutputStream getBody(OutputStream outputStream) throws JMSException {
        return this.getBody(outputStream, 0, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, int chunkSize) throws JMSException {
        return this.getBody(outputStream, chunkSize, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, long timeout) throws JMSException {
        return this.getBody(outputStream, 0, timeout);
    }

    @Override
    public OutputStream getBody(OutputStream outputStream, int chunkSize, long timeout) throws JMSException {
        return super.getBody(outputStream, chunkSize, timeout);
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        AQjmsError.throwEx(161);
        return null;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return false;
    }

    public void reset() throws JMSException {
        if (this.access_mode == 1) {
            this.updateBytesDataFromStream();
            this.m_outByteArrayStream = null;
            this.m_outObjectStream = null;
            this.m_dirty = false;
        } else {
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            this.clearByteArrayFieldStream();
        }
        try {
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.setAccessMode(0);
    }

    @Override
    public void clearBody() throws JMSException {
        if (this.access_mode == 0) {
            this.m_inObjectStream = null;
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            this.clearByteArrayFieldStream();
        }
        this.m_bytesData = new byte[0];
        this.m_dirty = false;
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        try {
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.setAccessMode(1);
    }

    @Override
    OracleData getMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsStreamMessage_C cont = new AQjmsStreamMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 2, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getMessageCont", "exit");
        return cont;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsGenMessage_C cont = new AQjmsGenMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 2, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getGenMessageCont", "exit");
        return cont;
    }

    @Override
    void writeLob(AQjmsSession sess, AQjmsDestination dest, byte[] msgid, boolean isAnydataDest) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, sess, dest, msgid, isAnydataDest);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.writeLob", "exit");
    }

    private void readStreamMessageContainer(AQjmsStreamMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromStream() {
        if (this.m_dirty) {
            this.m_bytesData = this.m_outByteArrayStream.toByteArray();
            this.m_dirty = false;
        }
    }

    private void pushback(Object obj) {
        this.m_pushbackObject = obj;
        this.m_pushbackFlag = true;
    }

    private void clearByteArrayFieldStream() {
        if (this.m_byteArrayFieldStream != null) {
            try {
                this.m_byteArrayFieldStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_byteArrayFieldStream = null;
        }
    }

    private boolean isReadingByteArrayField() {
        return this.m_byteArrayFieldStream != null;
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }
}

