/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms.plsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jakarta.jms.plsql.MapTooLargeException;
import oracle.jakarta.jms.plsql.MsgEntity;
import oracle.jakarta.jms.plsql.TypeConversion;
import oracle.jakarta.jms.plsql.TypeConversionException;

class MapMsgEntity
extends MsgEntity {
    private HashMap map;
    private String[] names = null;
    private boolean namesDirty = false;

    MapMsgEntity() {
        this.map = new HashMap();
    }

    MapMsgEntity(byte[] data) throws IOException, ClassNotFoundException {
        final ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        MapMsgEntity.this.map = (HashMap)ois.readObject();
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            System.out.println("PrivilegedActionException : " + e);
            throw (IOException)e.getCause();
        }
        ois.close();
    }

    @Override
    void clean() throws IOException {
        this.map = null;
    }

    byte[] flush() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.map);
        oos.close();
        return bos.toByteArray();
    }

    int size() {
        return this.map.size();
    }

    String[] getNames() throws MapTooLargeException {
        if (this.map.size() > 1024) {
            throw new MapTooLargeException();
        }
        if (this.names == null || this.namesDirty) {
            this.populateNames();
        }
        return this.names;
    }

    String[] getNames(int offset, int length, int[] retrieved) throws MapTooLargeException {
        if (length > 1024) {
            throw new MapTooLargeException();
        }
        if (this.names == null || this.namesDirty) {
            this.populateNames();
        }
        if (offset >= this.names.length) {
            retrieved[0] = 0;
            return new String[0];
        }
        length = length > this.names.length - offset ? this.names.length - offset : length;
        String[] newArray = new String[length];
        System.arraycopy(newArray, 0, this.names, offset, length);
        retrieved[0] = length;
        return newArray;
    }

    boolean itemExists(String name) {
        return this.map.containsKey(name);
    }

    Object get(String name, int type) throws TypeConversionException {
        Object objData = this.map.get(name);
        if (objData == null) {
            return null;
        }
        return TypeConversion.jmsConvert(objData, type);
    }

    Object get(String name) {
        return this.map.get(name);
    }

    void set(String name, Object obj) {
        this.map.put(name, obj);
        this.namesDirty = true;
    }

    private void populateNames() {
        this.names = new String[this.map.size()];
        Iterator iterator = this.map.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.names[i++] = (String)iterator.next();
        }
        this.namesDirty = false;
    }
}

