/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.analytics.Analytics;
import com.oracle.bmc.analytics.model.AnalyticsInstanceSummary;
import com.oracle.bmc.analytics.model.WorkRequestError;
import com.oracle.bmc.analytics.model.WorkRequestLog;
import com.oracle.bmc.analytics.model.WorkRequestSummary;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class AnalyticsPaginators {
    private final Analytics client;

    public Iterable<ListAnalyticsInstancesResponse> listAnalyticsInstancesResponseIterator(final ListAnalyticsInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnalyticsInstancesRequest.Builder>(){

            public ListAnalyticsInstancesRequest.Builder get() {
                return ListAnalyticsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnalyticsInstancesResponse, String>(){

            public String apply(ListAnalyticsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnalyticsInstancesRequest.Builder>, ListAnalyticsInstancesRequest>(){

            public ListAnalyticsInstancesRequest apply(RequestBuilderAndToken<ListAnalyticsInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAnalyticsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnalyticsInstancesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse>(){

            public ListAnalyticsInstancesResponse apply(ListAnalyticsInstancesRequest request) {
                return AnalyticsPaginators.this.client.listAnalyticsInstances(request);
            }
        });
    }

    public Iterable<AnalyticsInstanceSummary> listAnalyticsInstancesRecordIterator(final ListAnalyticsInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnalyticsInstancesRequest.Builder>(){

            public ListAnalyticsInstancesRequest.Builder get() {
                return ListAnalyticsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnalyticsInstancesResponse, String>(){

            public String apply(ListAnalyticsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnalyticsInstancesRequest.Builder>, ListAnalyticsInstancesRequest>(){

            public ListAnalyticsInstancesRequest apply(RequestBuilderAndToken<ListAnalyticsInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAnalyticsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnalyticsInstancesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse>(){

            public ListAnalyticsInstancesResponse apply(ListAnalyticsInstancesRequest request) {
                return AnalyticsPaginators.this.client.listAnalyticsInstances(request);
            }
        }, (Function)new Function<ListAnalyticsInstancesResponse, List<AnalyticsInstanceSummary>>(){

            public List<AnalyticsInstanceSummary> apply(ListAnalyticsInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AnalyticsPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public AnalyticsPaginators(Analytics client) {
        this.client = client;
    }
}

