/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.analytics.model.SortOrder;
import com.oracle.bmc.analytics.model.WorkRequestResourceType;
import com.oracle.bmc.analytics.model.WorkRequestSortBy;
import com.oracle.bmc.analytics.model.WorkRequestStatus;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceId;
    private WorkRequestResourceType resourceType;
    private List<WorkRequestStatus> status;
    private Integer limit;
    private String page;
    private WorkRequestSortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "resourceId", "resourceType", "status", "limit", "page", "sortBy", "sortOrder", "opcRequestId"})
    ListWorkRequestsRequest(String compartmentId, String resourceId, WorkRequestResourceType resourceType, List<WorkRequestStatus> status, Integer limit, String page, WorkRequestSortBy sortBy, SortOrder sortOrder, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.status = status;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public WorkRequestResourceType getResourceType() {
        return this.resourceType;
    }

    public List<WorkRequestStatus> getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public WorkRequestSortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private String compartmentId;
        private String resourceId;
        private WorkRequestResourceType resourceType;
        private List<WorkRequestStatus> status;
        private Integer limit;
        private String page;
        private WorkRequestSortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceId(o.getResourceId());
            this.resourceType(o.getResourceType());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(WorkRequestResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder status(List<WorkRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(WorkRequestSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestsRequest(this.compartmentId, this.resourceId, this.resourceType, this.status, this.limit, this.page, this.sortBy, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListWorkRequestsRequest.Builder(compartmentId=" + this.compartmentId + ", resourceId=" + this.resourceId + ", resourceType=" + (Object)((Object)this.resourceType) + ", status=" + this.status + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

