/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.announcementsservice.model.AnnouncementUserStatusDetails;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementUserStatusResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnnouncementUserStatusConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAnnouncementUserStatusConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAnnouncementUserStatusRequest interceptRequest(GetAnnouncementUserStatusRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAnnouncementUserStatusRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAnnouncementId(), (String)"announcementId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180904").path("announcements").path(HttpUtils.encodePathSegment((String)request.getAnnouncementId())).path("userStatus");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAnnouncementUserStatusResponse> fromResponse() {
        Function<Response, GetAnnouncementUserStatusResponse> transformer = new Function<Response, GetAnnouncementUserStatusResponse>(){

            public GetAnnouncementUserStatusResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.announcementsservice.responses.GetAnnouncementUserStatusResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AnnouncementUserStatusDetails.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetAnnouncementUserStatusResponse.Builder builder = GetAnnouncementUserStatusResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.announcementUserStatusDetails((AnnouncementUserStatusDetails)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetAnnouncementUserStatusResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

