/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.announcementsservice.model.AnnouncementsPreferences;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementsPreferenceRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementsPreferenceResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnnouncementsPreferenceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAnnouncementsPreferenceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAnnouncementsPreferenceRequest interceptRequest(GetAnnouncementsPreferenceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAnnouncementsPreferenceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPreferenceId(), (String)"preferenceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180904").path("announcementsPreferences").path(HttpUtils.encodePathSegment((String)request.getPreferenceId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAnnouncementsPreferenceResponse> fromResponse() {
        Function<Response, GetAnnouncementsPreferenceResponse> transformer = new Function<Response, GetAnnouncementsPreferenceResponse>(){

            public GetAnnouncementsPreferenceResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.announcementsservice.responses.GetAnnouncementsPreferenceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(AnnouncementsPreferences.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetAnnouncementsPreferenceResponse.Builder builder = GetAnnouncementsPreferenceResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.announcementsPreferences((AnnouncementsPreferences)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetAnnouncementsPreferenceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

