/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.DeploymentAsync;
import com.oracle.bmc.apigateway.internal.http.ChangeDeploymentCompartmentConverter;
import com.oracle.bmc.apigateway.internal.http.CreateDeploymentConverter;
import com.oracle.bmc.apigateway.internal.http.DeleteDeploymentConverter;
import com.oracle.bmc.apigateway.internal.http.GetDeploymentConverter;
import com.oracle.bmc.apigateway.internal.http.ListDeploymentsConverter;
import com.oracle.bmc.apigateway.internal.http.UpdateDeploymentConverter;
import com.oracle.bmc.apigateway.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateDeploymentRequest;
import com.oracle.bmc.apigateway.requests.DeleteDeploymentRequest;
import com.oracle.bmc.apigateway.requests.GetDeploymentRequest;
import com.oracle.bmc.apigateway.requests.ListDeploymentsRequest;
import com.oracle.bmc.apigateway.requests.UpdateDeploymentRequest;
import com.oracle.bmc.apigateway.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateDeploymentResponse;
import com.oracle.bmc.apigateway.responses.DeleteDeploymentResponse;
import com.oracle.bmc.apigateway.responses.GetDeploymentResponse;
import com.oracle.bmc.apigateway.responses.ListDeploymentsResponse;
import com.oracle.bmc.apigateway.responses.UpdateDeploymentResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAsyncClient
implements DeploymentAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEPLOYMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DeploymentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DeploymentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DeploymentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DeploymentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DeploymentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DeploymentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DeploymentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DeploymentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeDeploymentCompartmentResponse> changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request, AsyncHandler<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse> handler) {
        LOG.trace("Called async changeDeploymentCompartment");
        ChangeDeploymentCompartmentRequest interceptedRequest = ChangeDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDeploymentCompartmentResponse> transformer = ChangeDeploymentCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDeploymentCompartmentRequest, ChangeDeploymentCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request, AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handler) {
        LOG.trace("Called async createDeployment");
        CreateDeploymentRequest interceptedRequest = CreateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentResponse> transformer = CreateDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeploymentRequest, CreateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest request, AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResponse> handler) {
        LOG.trace("Called async deleteDeployment");
        DeleteDeploymentRequest interceptedRequest = DeleteDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeploymentResponse> transformer = DeleteDeploymentConverter.fromResponse();
        AsyncHandler<DeleteDeploymentRequest, DeleteDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeploymentRequest, DeleteDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeploymentResponse> getDeployment(GetDeploymentRequest request, AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handler) {
        LOG.trace("Called async getDeployment");
        GetDeploymentRequest interceptedRequest = GetDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentResponse> transformer = GetDeploymentConverter.fromResponse();
        AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeploymentRequest, GetDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request, AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handler) {
        LOG.trace("Called async listDeployments");
        ListDeploymentsRequest interceptedRequest = ListDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentsResponse> transformer = ListDeploymentsConverter.fromResponse();
        AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeploymentsRequest, ListDeploymentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request, AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handler) {
        LOG.trace("Called async updateDeployment");
        UpdateDeploymentRequest interceptedRequest = UpdateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentResponse> transformer = UpdateDeploymentConverter.fromResponse();
        AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeploymentRequest, UpdateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DeploymentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DeploymentAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DeploymentAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

