/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apigateway.Deployment;
import com.oracle.bmc.apigateway.model.DeploymentSummary;
import com.oracle.bmc.apigateway.requests.ListDeploymentsRequest;
import com.oracle.bmc.apigateway.responses.ListDeploymentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DeploymentPaginators {
    private final Deployment client;

    public Iterable<ListDeploymentsResponse> listDeploymentsResponseIterator(final ListDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DeploymentPaginators.this.client.listDeployments(request);
            }
        });
    }

    public Iterable<DeploymentSummary> listDeploymentsRecordIterator(final ListDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return DeploymentPaginators.this.client.listDeployments(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, List<DeploymentSummary>>(){

            public List<DeploymentSummary> apply(ListDeploymentsResponse response) {
                return response.getDeploymentCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DeploymentPaginators(Deployment client) {
        this.client = client;
    }
}

