/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetApiContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetApiContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetApiContentRequest interceptRequest(GetApiContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetApiContentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190501").path("apis").path(HttpUtils.encodePathSegment((String)request.getApiId())).path("content");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, GetApiContentResponse> fromResponse() {
        Function<Response, GetApiContentResponse> transformer = new Function<Response, GetApiContentResponse>(){

            public GetApiContentResponse apply(Response rawResponse) {
                Optional xContentSha256Header;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.apigateway.responses.GetApiContentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetApiContentResponse.Builder builder = GetApiContentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((xContentSha256Header = HeaderUtils.get((MultivaluedMap)headers, (String)"x-content-sha256")).isPresent()) {
                    builder.xContentSha256((String)HeaderUtils.toValue((String)"x-content-sha256", (String)((String)((List)xContentSha256Header.get()).get(0)), String.class));
                }
                GetApiContentResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

