/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.StaticPublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="format")
@JsonFilter(value="explicitlySetFilter")
public final class JsonWebKey
extends StaticPublicKey {
    @JsonProperty(value="kty")
    private final Kty kty;
    @JsonProperty(value="use")
    private final Use use;
    @JsonProperty(value="key_ops")
    private final List<KeyOps> keyOps;
    @JsonProperty(value="alg")
    private final String alg;
    @JsonProperty(value="n")
    private final String n;
    @JsonProperty(value="e")
    private final String e;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public JsonWebKey(String kid, Kty kty, Use use, List<KeyOps> keyOps, String alg, String n, String e) {
        super(kid);
        this.kty = kty;
        this.use = use;
        this.keyOps = keyOps;
        this.alg = alg;
        this.n = n;
        this.e = e;
    }

    public Builder toBuilder() {
        return new Builder().kty(this.kty).use(this.use).keyOps(this.keyOps).alg(this.alg).n(this.n).e(this.e);
    }

    public Kty getKty() {
        return this.kty;
    }

    public Use getUse() {
        return this.use;
    }

    public List<KeyOps> getKeyOps() {
        return this.keyOps;
    }

    public String getAlg() {
        return this.alg;
    }

    public String getN() {
        return this.n;
    }

    public String getE() {
        return this.e;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "JsonWebKey(super=" + super.toString() + ", kty=" + (Object)((Object)this.getKty()) + ", use=" + (Object)((Object)this.getUse()) + ", keyOps=" + this.getKeyOps() + ", alg=" + this.getAlg() + ", n=" + this.getN() + ", e=" + this.getE() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonWebKey)) {
            return false;
        }
        JsonWebKey other = (JsonWebKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Kty this$kty = this.getKty();
        Kty other$kty = other.getKty();
        if (this$kty == null ? other$kty != null : !((Object)((Object)this$kty)).equals((Object)other$kty)) {
            return false;
        }
        Use this$use = this.getUse();
        Use other$use = other.getUse();
        if (this$use == null ? other$use != null : !((Object)((Object)this$use)).equals((Object)other$use)) {
            return false;
        }
        List<KeyOps> this$keyOps = this.getKeyOps();
        List<KeyOps> other$keyOps = other.getKeyOps();
        if (this$keyOps == null ? other$keyOps != null : !((Object)this$keyOps).equals(other$keyOps)) {
            return false;
        }
        String this$alg = this.getAlg();
        String other$alg = other.getAlg();
        if (this$alg == null ? other$alg != null : !this$alg.equals(other$alg)) {
            return false;
        }
        String this$n = this.getN();
        String other$n = other.getN();
        if (this$n == null ? other$n != null : !this$n.equals(other$n)) {
            return false;
        }
        String this$e = this.getE();
        String other$e = other.getE();
        if (this$e == null ? other$e != null : !this$e.equals(other$e)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonWebKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Kty $kty = this.getKty();
        result = result * 59 + ($kty == null ? 43 : ((Object)((Object)$kty)).hashCode());
        Use $use = this.getUse();
        result = result * 59 + ($use == null ? 43 : ((Object)((Object)$use)).hashCode());
        List<KeyOps> $keyOps = this.getKeyOps();
        result = result * 59 + ($keyOps == null ? 43 : ((Object)$keyOps).hashCode());
        String $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : $alg.hashCode());
        String $n = this.getN();
        result = result * 59 + ($n == null ? 43 : $n.hashCode());
        String $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum KeyOps {
        Verify("verify"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyOps> map;

        private KeyOps(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyOps create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyOps', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyOps.class);
            map = new HashMap<String, KeyOps>();
            for (KeyOps v : KeyOps.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Use {
        Sig("sig"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Use> map;

        private Use(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Use create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Use', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Use.class);
            map = new HashMap<String, Use>();
            for (Use v : Use.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Kty {
        Rsa("RSA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Kty> map;

        private Kty(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Kty create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Kty', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Kty.class);
            map = new HashMap<String, Kty>();
            for (Kty v : Kty.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kid")
        private String kid;
        @JsonProperty(value="kty")
        private Kty kty;
        @JsonProperty(value="use")
        private Use use;
        @JsonProperty(value="key_ops")
        private List<KeyOps> keyOps;
        @JsonProperty(value="alg")
        private String alg;
        @JsonProperty(value="n")
        private String n;
        @JsonProperty(value="e")
        private String e;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kid(String kid) {
            this.kid = kid;
            this.__explicitlySet__.add("kid");
            return this;
        }

        public Builder kty(Kty kty) {
            this.kty = kty;
            this.__explicitlySet__.add("kty");
            return this;
        }

        public Builder use(Use use) {
            this.use = use;
            this.__explicitlySet__.add("use");
            return this;
        }

        public Builder keyOps(List<KeyOps> keyOps) {
            this.keyOps = keyOps;
            this.__explicitlySet__.add("keyOps");
            return this;
        }

        public Builder alg(String alg) {
            this.alg = alg;
            this.__explicitlySet__.add("alg");
            return this;
        }

        public Builder n(String n) {
            this.n = n;
            this.__explicitlySet__.add("n");
            return this;
        }

        public Builder e(String e) {
            this.e = e;
            this.__explicitlySet__.add("e");
            return this;
        }

        public JsonWebKey build() {
            JsonWebKey __instance__ = new JsonWebKey(this.kid, this.kty, this.use, this.keyOps, this.alg, this.n, this.e);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(JsonWebKey o) {
            Builder copiedBuilder = this.kid(o.getKid()).kty(o.getKty()).use(o.getUse()).keyOps(o.getKeyOps()).alg(o.getAlg()).n(o.getN()).e(o.getE());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "JsonWebKey.Builder(kty=" + (Object)((Object)this.kty) + ", use=" + (Object)((Object)this.use) + ", keyOps=" + this.keyOps + ", alg=" + this.alg + ", n=" + this.n + ", e=" + this.e + ")";
        }
    }
}

