/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteCertificateRequest
extends BmcRequest<Void> {
    private String certificateId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"certificateId", "ifMatch", "opcRequestId"})
    DeleteCertificateRequest(String certificateId, String ifMatch, String opcRequestId) {
        this.certificateId = certificateId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCertificateRequest, Void> {
        private String certificateId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCertificateRequest o) {
            this.certificateId(o.getCertificateId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCertificateRequest build() {
            DeleteCertificateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteCertificateRequest buildWithoutInvocationCallback() {
            return new DeleteCertificateRequest(this.certificateId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteCertificateRequest.Builder(certificateId=" + this.certificateId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

